/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SignedLongAttribute;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSafePrivateGEMRRelated
extends TestCase {
    public TestSafePrivateGEMRRelated(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestSafePrivateGEMRRelated");
        testSuite.addTest((Test)new TestSafePrivateGEMRRelated("TestSafePrivateGEMRRelated_FromTag"));
        testSuite.addTest((Test)new TestSafePrivateGEMRRelated("TestSafePrivateGEMRRelated_CreatorFromList"));
        testSuite.addTest((Test)new TestSafePrivateGEMRRelated("TestSafePrivateGEMRRelated_AddedToList"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestSafePrivateGEMRRelated_FromTag() throws Exception {
        TestSafePrivateGEMRRelated.assertTrue((String)"Internal Pulse Sequence Name", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("GEMS_ACQU_01", new AttributeTag(25, 4254)));
        TestSafePrivateGEMRRelated.assertTrue((String)"Images In Series", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("GEMS_SERS_01", new AttributeTag(37, 4103)));
        TestSafePrivateGEMRRelated.assertTrue((String)"Scanner Table Entry + Gradient Coil Selected", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute("GEMS_PARM_01", new AttributeTag(67, 4207)));
    }

    public void TestSafePrivateGEMRRelated_CreatorFromList() throws Exception {
        AttributeList attributeList = new AttributeList();
        LongStringAttribute longStringAttribute = new LongStringAttribute(new AttributeTag(25, 16));
        ((Attribute)longStringAttribute).addValue("GEMS_ACQU_01");
        attributeList.put(longStringAttribute);
        TestSafePrivateGEMRRelated.assertTrue((String)"Internal Pulse Sequence Name is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(25, 4254), attributeList));
        attributeList = new AttributeList();
        longStringAttribute = new LongStringAttribute(new AttributeTag(37, 16));
        ((Attribute)longStringAttribute).addValue("GEMS_SERS_01");
        attributeList.put(longStringAttribute);
        TestSafePrivateGEMRRelated.assertTrue((String)"Images In Series is safe", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(37, 4103), attributeList));
        attributeList = new AttributeList();
        longStringAttribute = new LongStringAttribute(new AttributeTag(67, 16));
        ((Attribute)longStringAttribute).addValue("GEMS_PARM_01");
        attributeList.put(longStringAttribute);
        TestSafePrivateGEMRRelated.assertTrue((String)"Scanner Table Entry + Gradient Coil Selected", (boolean)ClinicalTrialsAttributes.isSafePrivateAttribute(new AttributeTag(67, 4207), attributeList));
    }

    private void testIsNotRemovedAndRetainsValue(String string, AttributeTag attributeTag, String string2, Attribute attribute, String string3) throws DicomException {
        AttributeList attributeList = new AttributeList();
        Object object = new LongStringAttribute(attributeTag);
        ((Attribute)object).addValue(string2);
        attributeList.put((Attribute)object);
        attributeList.put(attribute);
        object = attribute.getTag();
        attributeList.removeUnsafePrivateAttributes();
        TestSafePrivateGEMRRelated.assertTrue((String)"Checking Creator is not removed", (attributeList.get(attributeTag) != null ? 1 : 0) != 0);
        TestSafePrivateGEMRRelated.assertEquals((String)"Checking Creator retains value", (String)string2, (String)Attribute.getDelimitedStringValuesOrEmptyString(attributeList, attributeTag));
        TestSafePrivateGEMRRelated.assertTrue((String)("Checking " + string + " is not removed"), (attributeList.get((AttributeTag)object) != null ? 1 : 0) != 0);
        TestSafePrivateGEMRRelated.assertEquals((String)("Checking " + string + " retains value"), (String)string3, (String)Attribute.getDelimitedStringValuesOrEmptyString(attributeList, (AttributeTag)object));
    }

    public void TestSafePrivateGEMRRelated_AddedToList() throws Exception {
        String string = "MySequence";
        Attribute attribute = new LongStringAttribute(new AttributeTag(25, 4254));
        attribute.addValue(string);
        this.testIsNotRemovedAndRetainsValue("Internal Pulse Sequence Name", new AttributeTag(25, 16), "GEMS_ACQU_01", attribute, string);
        string = "35";
        attribute = new SignedLongAttribute(new AttributeTag(37, 4103));
        attribute.addValue(string);
        this.testIsNotRemovedAndRetainsValue("Images In Series", new AttributeTag(37, 16), "GEMS_SERS_01", attribute, string);
        string = "0\\0\\0\\2";
        attribute = new DecimalStringAttribute(new AttributeTag(67, 4207));
        attribute.addValue("0");
        attribute.addValue("0");
        attribute.addValue("0");
        attribute.addValue("2");
        this.testIsNotRemovedAndRetainsValue("Scanner Table Entry + Gradient Coil Selected", new AttributeTag(67, 16), "GEMS_PARM_01", attribute, string);
    }
}

