/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.utils.StringUtilities;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestStringUtilities
extends TestCase {
    public TestStringUtilities(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestStringUtilities");
        testSuite.addTest((Test)new TestStringUtilities("TestStringUtilities_RemoveTrailingSpaces"));
        testSuite.addTest((Test)new TestStringUtilities("TestStringUtilities_CompareEmbeddedNonZeroPaddedIntegers"));
        testSuite.addTest((Test)new TestStringUtilities("TestStringUtilities_Truncate"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestStringUtilities_RemoveTrailingSpaces() throws Exception {
        TestStringUtilities.assertEquals((String)"Checking no spaces", (String)"1234", (String)StringUtilities.removeTrailingSpaces("1234"));
        TestStringUtilities.assertEquals((String)"Checking trailing spaces", (String)"1234", (String)StringUtilities.removeTrailingSpaces("1234  "));
        TestStringUtilities.assertEquals((String)"Checking middle and trailing spaces", (String)"12  34", (String)StringUtilities.removeTrailingSpaces("12  34  "));
        TestStringUtilities.assertEquals((String)"Checking leading spaces", (String)"  1234", (String)StringUtilities.removeTrailingSpaces("  1234"));
        TestStringUtilities.assertEquals((String)"Checking leading and trailing spaces", (String)"  1234", (String)StringUtilities.removeTrailingSpaces("  1234  "));
        TestStringUtilities.assertEquals((String)"Checking single digit", (String)"1", (String)StringUtilities.removeTrailingSpaces("1"));
        TestStringUtilities.assertEquals((String)"Checking just space", (String)"", (String)StringUtilities.removeTrailingSpaces(" "));
        TestStringUtilities.assertEquals((String)"Checking just spaces", (String)"", (String)StringUtilities.removeTrailingSpaces("    "));
        TestStringUtilities.assertEquals((String)"Checking nothing", (String)"", (String)StringUtilities.removeTrailingSpaces(""));
    }

    public void TestStringUtilities_CompareEmbeddedNonZeroPaddedIntegers() throws Exception {
        TestStringUtilities.assertTrue((String)"Checking equal", (StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers("this is 2 way", "this is 2 way") == 0 ? 1 : 0) != 0);
        TestStringUtilities.assertTrue((String)"Checking less", (StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers("this is 2 way", "this is 10 way") < 0 ? 1 : 0) != 0);
        TestStringUtilities.assertTrue((String)"Checking greater", (StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers("this is 10 way", "this is 2 way") > 0 ? 1 : 0) != 0);
        TestStringUtilities.assertTrue((String)"Checking equal longer", (StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers("this is 2 way", "this is 2 way plus") == 0 ? 1 : 0) != 0);
        TestStringUtilities.assertTrue((String)"Checking less longer", (StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers("this is 2 way", "this is 10 way plus") < 0 ? 1 : 0) != 0);
        TestStringUtilities.assertTrue((String)"Checking greater longer", (StringUtilities.compareStringsWithEmbeddedNonZeroPaddedIntegers("this is 10 way", "this is 2 way plus") > 0 ? 1 : 0) != 0);
    }

    public void TestStringUtilities_Truncate() throws Exception {
        TestStringUtilities.assertEquals((String)"Checking equal", (String)"123", (String)StringUtilities.getStringNoLongerThanTruncatedIfNecessary("123", 3));
        TestStringUtilities.assertEquals((String)"Checking longer", (String)"123", (String)StringUtilities.getStringNoLongerThanTruncatedIfNecessary("1234", 3));
        TestStringUtilities.assertEquals((String)"Checking shorter", (String)"12", (String)StringUtilities.getStringNoLongerThanTruncatedIfNecessary("12", 3));
        TestStringUtilities.assertEquals((String)"Checking empty", (String)"", (String)StringUtilities.getStringNoLongerThanTruncatedIfNecessary("", 3));
    }
}

