/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.FloatSingleAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestUnknownAttributeBinaryValueExtraction
extends TestCase {
    public TestUnknownAttributeBinaryValueExtraction(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite("TestUnknownAttributeBinaryValueExtraction");
        testSuite.addTest((Test)new TestUnknownAttributeBinaryValueExtraction("TestUnknownAttributeBinaryValueExtraction_WriteFloatDoubleValuesAsPrivateAttributeInImplicitVRAndExtractFromUnkownVRAfterReading"));
        testSuite.addTest((Test)new TestUnknownAttributeBinaryValueExtraction("TestUnknownAttributeBinaryValueExtraction_WriteFloatSingleValuesAsPrivateAttributeInImplicitVRAndExtractFromUnkownVRAfterReading"));
        return testSuite;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void TestUnknownAttributeBinaryValueExtraction_WriteFloatDoubleValuesAsPrivateAttributeInImplicitVRAndExtractFromUnkownVRAfterReading() throws Exception {
        double d = 39.76;
        double d2 = -56356.457457;
        double d3 = 0.0;
        double d4 = 7.45345345E-21;
        AttributeTag attributeTag = new AttributeTag(17, 4112);
        FloatDoubleAttribute floatDoubleAttribute = new FloatDoubleAttribute(attributeTag);
        floatDoubleAttribute.addValue(d);
        floatDoubleAttribute.addValue(d2);
        floatDoubleAttribute.addValue(d3);
        floatDoubleAttribute.addValue(d4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, null, "1.2.840.10008.1.2");
        floatDoubleAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        AttributeList attributeList = new AttributeList();
        attributeList.read(new DicomInputStream(byteArrayInputStream, "1.2.840.10008.1.2", false));
        Attribute attribute = attributeList.get(attributeTag);
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"VR", (Object)ValueRepresentation.UN, (Object)attribute.getVR());
        double[] dArray = attribute.getDoubleValues();
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"Checking value1", (Object)d, (Object)dArray[0]);
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"Checking value2", (Object)d2, (Object)dArray[1]);
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"Checking value3", (Object)d3, (Object)dArray[2]);
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"Checking value4", (Object)d4, (Object)dArray[3]);
    }

    public void TestUnknownAttributeBinaryValueExtraction_WriteFloatSingleValuesAsPrivateAttributeInImplicitVRAndExtractFromUnkownVRAfterReading() throws Exception {
        float f = 39.76f;
        float f2 = -56356.457f;
        float f3 = 0.0f;
        float f4 = 7.453453E-21f;
        AttributeTag attributeTag = new AttributeTag(17, 4112);
        FloatSingleAttribute floatSingleAttribute = new FloatSingleAttribute(attributeTag);
        floatSingleAttribute.addValue(f);
        floatSingleAttribute.addValue(f2);
        floatSingleAttribute.addValue(f3);
        floatSingleAttribute.addValue(f4);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DicomOutputStream dicomOutputStream = new DicomOutputStream(byteArrayOutputStream, null, "1.2.840.10008.1.2");
        floatSingleAttribute.write(dicomOutputStream);
        dicomOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        AttributeList attributeList = new AttributeList();
        attributeList.read(new DicomInputStream(byteArrayInputStream, "1.2.840.10008.1.2", false));
        Attribute attribute = attributeList.get(attributeTag);
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"VR", (Object)ValueRepresentation.UN, (Object)attribute.getVR());
        float[] fArray = attribute.getFloatValues();
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"Checking value1", (Object)Float.valueOf(f), (Object)Float.valueOf(fArray[0]));
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"Checking value2", (Object)Float.valueOf(f2), (Object)Float.valueOf(fArray[1]));
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"Checking value3", (Object)Float.valueOf(f3), (Object)Float.valueOf(fArray[2]));
        TestUnknownAttributeBinaryValueExtraction.assertEquals((String)"Checking value4", (Object)Float.valueOf(f4), (Object)Float.valueOf(fArray[3]));
    }
}

