/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.test;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;

public class UserInterfaceUtilities {
    protected static Map<String, JDialog> openDialogs = new HashMap<String, JDialog>();

    protected static void dumpAllOwnedWindows(Window window, PrintStream printStream, String string, String string2) {
        printStream.println(string + window);
        String string3 = string + string2;
        UserInterfaceUtilities.dumpAllOwnedWindows(window.getOwnedWindows(), printStream, string3, string2);
    }

    protected static void dumpAllOwnedWindows(Window[] windowArray, PrintStream printStream, String string, String string2) {
        for (Window window : windowArray) {
            UserInterfaceUtilities.dumpAllOwnedWindows(window, printStream, string, string2);
        }
    }

    protected static void dumpAllOwnedWindows(PrintStream printStream, String string, String string2) {
        Frame[] frameArray;
        String string3 = string + string2;
        for (Frame frame : frameArray = Frame.getFrames()) {
            printStream.println(string + frame);
            UserInterfaceUtilities.dumpAllOwnedWindows(frame.getOwnedWindows(), printStream, string3, string2);
        }
    }

    public static void dumpAllOwnedWindows(PrintStream printStream) {
        UserInterfaceUtilities.dumpAllOwnedWindows(printStream, "", "\t");
    }

    protected static void dumpRootPaneAndChildren(PrintStream printStream, String string, String string2) {
        Frame[] frameArray;
        HashSet<JRootPane> hashSet = new HashSet<JRootPane>();
        for (Frame frame : frameArray = Frame.getFrames()) {
            JRootPane jRootPane;
            if (!(frame instanceof JFrame) || hashSet.contains(jRootPane = ((JFrame)frame).getRootPane())) continue;
            hashSet.add(jRootPane);
            UserInterfaceUtilities.dumpComponentAndChildren(jRootPane, printStream, string, string2);
        }
    }

    public static void dumpRootPaneAndChildren(PrintStream printStream) {
        UserInterfaceUtilities.dumpRootPaneAndChildren(printStream, "", "\t");
    }

    protected static void dumpComponentAndChildren(Component component, PrintStream printStream, String string, String string2) {
        printStream.println(string + component);
        if (component instanceof Container) {
            Component[] componentArray;
            String string3 = string + string2;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                UserInterfaceUtilities.dumpComponentAndChildren(component2, printStream, string3, string2);
            }
        }
    }

    public static void dumpComponentAndChildren(Component component, PrintStream printStream) {
        UserInterfaceUtilities.dumpComponentAndChildren(component, printStream, "", "\t");
    }

    protected static void dumpAllFramesAndChildren(PrintStream printStream, String string, String string2) {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            UserInterfaceUtilities.dumpComponentAndChildren(frame, printStream, string, string2);
        }
    }

    public static void dumpAllFramesAndChildren(PrintStream printStream) {
        UserInterfaceUtilities.dumpAllFramesAndChildren(printStream, "", "\t");
    }

    protected static void findComponentsOfClassWithTextValue(ArrayList<Component> arrayList, Component component, String string, String string2) {
        if (string.equals(component.getClass().getName()) && component instanceof AbstractButton && string2.equals(((AbstractButton)component).getText())) {
            arrayList.add(component);
        } else if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                UserInterfaceUtilities.findComponentsOfClassWithTextValue(arrayList, component2, string, string2);
            }
        }
    }

    public static Component[] findComponentsOfClassWithTextValue(Component component, String string, String string2) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        UserInterfaceUtilities.findComponentsOfClassWithTextValue(arrayList, component, string, string2);
        return arrayList.toArray(new Component[0]);
    }

    public static Component[] findComponentsOfClassWithTextValue(String string, String string2) {
        Frame[] frameArray;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Frame frame : frameArray = Frame.getFrames()) {
            UserInterfaceUtilities.findComponentsOfClassWithTextValue(arrayList, frame, string, string2);
        }
        return arrayList.toArray(new Component[0]);
    }

    protected static void findComponentsOfClass(ArrayList<Component> arrayList, Component component, String string) {
        if (string.equals(component.getClass().getName())) {
            arrayList.add(component);
        } else if (component instanceof Container) {
            Component[] componentArray;
            for (Component component2 : componentArray = ((Container)component).getComponents()) {
                UserInterfaceUtilities.findComponentsOfClass(arrayList, component2, string);
            }
        }
    }

    public static Component[] findComponentsOfClass(Component component, String string) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        UserInterfaceUtilities.findComponentsOfClass(arrayList, component, string);
        return arrayList.toArray(new Component[0]);
    }

    public static Component[] findComponentsOfClass(String string) {
        Frame[] frameArray;
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Frame frame : frameArray = Frame.getFrames()) {
            UserInterfaceUtilities.findComponentsOfClass(arrayList, frame, string);
        }
        return arrayList.toArray(new Component[0]);
    }

    public static void registerWindowOpeningAndClosingListenerToTrackDialogs() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        AWTEventListener aWTEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent aWTEvent) {
                int n = aWTEvent.getID();
                Window window = ((WindowEvent)aWTEvent).getWindow();
                if (window instanceof JDialog) {
                    JDialog jDialog = (JDialog)window;
                    String string = jDialog.getTitle();
                    if (n == 200) {
                        openDialogs.put(string, jDialog);
                    } else if (n == 202) {
                        openDialogs.remove(string);
                    }
                }
            }
        };
        toolkit.addAWTEventListener(aWTEventListener, 64L);
    }

    public static JDialog getOpenDialogByTitle(String string) {
        return openDialogs.get(string);
    }
}

