/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.validate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExtractContextGroupsWithTransitiveClosure {
    protected SortedMap<ContextGroupIdentifier, ContextGroup> originalContextGroupsByCID = new TreeMap<ContextGroupIdentifier, ContextGroup>();
    protected SortedMap<ContextGroupIdentifier, ContextGroup> closedContextGroupsByCID = new TreeMap<ContextGroupIdentifier, ContextGroup>();

    public static boolean isNonEmptyNumericArray(String string) {
        if (string == null) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    protected void readContextGroupsFile(String string, Map<ContextGroupIdentifier, ContextGroup> map) throws IOException, ParserConfigurationException, SAXException, Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string));
        Element element = document.getDocumentElement();
        if (element.getTagName().equals("definecontextgroups")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("definecontextgroup")) continue;
                String string2 = "";
                String string3 = "";
                String string4 = "";
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                Object object2 = node.getAttributes();
                if (object2 != null) {
                    object = object2.getNamedItem("cid");
                    if (object != null) {
                        string2 = object.getTextContent();
                    }
                    if ((object = object2.getNamedItem("name")) != null) {
                        string3 = object.getTextContent();
                    }
                    if ((object = object2.getNamedItem("version")) != null) {
                        string4 = object.getTextContent();
                    }
                    if ((object = object2.getNamedItem("uid")) != null) {
                        string5 = object.getTextContent();
                    }
                    if ((object = object2.getNamedItem("keyword")) != null) {
                        string6 = object.getTextContent();
                    }
                    if ((object = object2.getNamedItem("extensible")) != null) {
                        string7 = object.getTextContent();
                    }
                    if ((object = object2.getNamedItem("fhirkeyword")) != null) {
                        string8 = object.getTextContent();
                    }
                }
                object2 = new ContextGroup(string2, string3, string4, string5, string6, string7, string8);
                map.put(new ContextGroupIdentifier(string2), (ContextGroup)object2);
                object = node.getChildNodes();
                for (int j = 0; j < object.getLength(); ++j) {
                    Object object3;
                    Object object4;
                    String string9;
                    Node node2 = object.item(j);
                    if (node2.getNodeType() != 1) continue;
                    if (((Element)node2).getTagName().equals("include")) {
                        string9 = "";
                        object4 = node2.getAttributes();
                        if (object4 != null && (object3 = object4.getNamedItem("cid")) != null) {
                            string9 = object3.getTextContent();
                        }
                        ((ContextGroup)object2).includedCIDs.add(string9);
                        continue;
                    }
                    if (!((Element)node2).getTagName().equals("contextgroupcode")) continue;
                    string9 = "";
                    object4 = "";
                    object3 = "";
                    String string10 = "";
                    String string11 = "";
                    String string12 = null;
                    Object object5 = node2.getAttributes();
                    if (object5 != null) {
                        Node node3 = object5.getNamedItem("csd");
                        if (node3 != null) {
                            string9 = node3.getTextContent();
                        }
                        if ((node3 = object5.getNamedItem("cv")) != null) {
                            object4 = node3.getTextContent();
                        }
                        if ((node3 = object5.getNamedItem("cm")) != null) {
                            object3 = node3.getTextContent();
                        }
                        if ((node3 = object5.getNamedItem("sct")) != null) {
                            string10 = node3.getTextContent();
                        }
                        if ((node3 = object5.getNamedItem("umlscui")) != null) {
                            string11 = node3.getTextContent();
                        }
                        if ((node3 = object5.getNamedItem("propertyTypeCIDForCategory")) != null) {
                            string12 = node3.getTextContent();
                        }
                    }
                    object5 = new CodedConceptInContextGroup(string9, (String)object4, (String)object3, string10, string11);
                    ((ContextGroup)object2).codedConcepts.add((CodedConceptInContextGroup)object5);
                }
            }
        } else {
            throw new Exception("Expected definecontextgroups element got " + element.getTagName());
        }
    }

    protected void createNamedAttributeAndAppendToElement(Document document, Node node, String string, String string2) {
        Attr attr = document.createAttribute(string);
        attr.setValue(string2);
        node.getAttributes().setNamedItem(attr);
    }

    protected void writeContextGroupsFile(String string, List<String> list, Map<ContextGroupIdentifier, ContextGroup> map) throws IOException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("definecontextgroups");
        this.createNamedAttributeAndAppendToElement(document, element, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.createNamedAttributeAndAppendToElement(document, element, "xsi:noNamespaceSchemaLocation", "http://www.pixelmed.com/schemas/contextgroups.xsd");
        for (ContextGroup object22 : map.values()) {
            if (!list.contains(object22.cid)) continue;
            object = document.createElement("definecontextgroup");
            this.createNamedAttributeAndAppendToElement(document, (Node)object, "cid", object22.cid);
            this.createNamedAttributeAndAppendToElement(document, (Node)object, "name", object22.keyword);
            this.createNamedAttributeAndAppendToElement(document, (Node)object, "extensible", object22.extensible);
            this.createNamedAttributeAndAppendToElement(document, (Node)object, "version", object22.version);
            for (CodedConceptInContextGroup codedConceptInContextGroup : object22.codedConcepts) {
                Element element2 = document.createElement("contextgroupcode");
                this.createNamedAttributeAndAppendToElement(document, element2, "csd", codedConceptInContextGroup.csd);
                this.createNamedAttributeAndAppendToElement(document, element2, "cv", codedConceptInContextGroup.cv);
                this.createNamedAttributeAndAppendToElement(document, element2, "cm", codedConceptInContextGroup.cm);
                object.appendChild(element2);
            }
            element.appendChild((Node)object);
        }
        document.appendChild(element);
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(new FileOutputStream(string));
        object = TransformerFactory.newInstance().newTransformer();
        Properties properties = new Properties();
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        properties.setProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        properties.setProperty("encoding", "UTF-8");
        ((Transformer)object).setOutputProperties(properties);
        ((Transformer)object).transform(dOMSource, streamResult);
    }

    protected List<String> readContextGroupsWantedFile(String string) throws IOException {
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        LineNumberReader lineNumberReader = new LineNumberReader(new BufferedReader(new FileReader(string)));
        while ((string2 = lineNumberReader.readLine()) != null) {
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected void performTransitiveClosure(Map<ContextGroupIdentifier, ContextGroup> map, Map<ContextGroupIdentifier, ContextGroup> map2) {
        for (ContextGroup contextGroup : map.values()) {
            ContextGroup contextGroup2 = contextGroup.getTransitiveClosure(map);
            map2.put(new ContextGroupIdentifier(contextGroup.cid), contextGroup2);
        }
    }

    public ExtractContextGroupsWithTransitiveClosure(String string, String string2, String string3, String string4) throws IOException, ParserConfigurationException, SAXException, Exception {
        this.readContextGroupsFile(string, this.originalContextGroupsByCID);
        this.readContextGroupsFile(string2, this.originalContextGroupsByCID);
        this.performTransitiveClosure(this.originalContextGroupsByCID, this.closedContextGroupsByCID);
        List<String> list = this.readContextGroupsWantedFile(string3);
        this.writeContextGroupsFile(string4, list, this.closedContextGroupsByCID);
    }

    public static void main(String[] stringArray) {
        try {
            new ExtractContextGroupsWithTransitiveClosure(stringArray[0], stringArray[1], stringArray[2], stringArray[3]);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected class ContextGroup
    implements Comparable {
        String cid;
        String name;
        String version;
        String uid;
        String keyword;
        String extensible;
        String fhirkeyword;
        Set<String> includedCIDs = new HashSet<String>();
        Set<CodedConceptInContextGroup> codedConcepts = new HashSet<CodedConceptInContextGroup>();
        ContextGroup transitiveClosure;

        public int compareTo(Object object) {
            int n = -1;
            if (this.equals(object)) {
                n = 0;
            } else if (object instanceof ContextGroup) {
                try {
                    int n2 = Integer.parseInt(this.cid);
                    int n3 = Integer.parseInt(((ContextGroup)object).cid);
                    n = n2 == n3 ? 0 : (n2 < n3 ? -1 : 1);
                }
                catch (NumberFormatException numberFormatException) {
                    n = this.cid.compareTo(((ContextGroup)object).cid);
                }
            }
            return n;
        }

        public ContextGroup(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
            this.cid = string;
            this.name = string2;
            this.version = string3;
            this.uid = string4;
            this.keyword = string5;
            this.extensible = string6;
            this.fhirkeyword = string7;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("CID ");
            stringBuffer.append(this.cid);
            stringBuffer.append(" ");
            stringBuffer.append(this.name);
            stringBuffer.append(" ");
            stringBuffer.append(this.version);
            stringBuffer.append(" ");
            stringBuffer.append(this.uid);
            stringBuffer.append(" ");
            stringBuffer.append(this.keyword);
            stringBuffer.append(" ");
            stringBuffer.append(this.extensible);
            stringBuffer.append(" ");
            stringBuffer.append(this.fhirkeyword);
            stringBuffer.append("\n");
            for (String object : this.includedCIDs) {
                stringBuffer.append("\tInclude ");
                stringBuffer.append(object);
                stringBuffer.append("\n");
            }
            for (CodedConceptInContextGroup codedConceptInContextGroup : this.codedConcepts) {
                stringBuffer.append("\t");
                stringBuffer.append(codedConceptInContextGroup);
                stringBuffer.append("\n");
            }
            return stringBuffer.toString();
        }

        public ContextGroup getTransitiveClosure(Map<ContextGroupIdentifier, ContextGroup> map) {
            if (this.transitiveClosure == null) {
                this.transitiveClosure = new ContextGroup(this.cid, this.name, this.version, this.uid, this.keyword, this.extensible, this.fhirkeyword);
                this.transitiveClosure.codedConcepts = new HashSet<CodedConceptInContextGroup>();
                this.transitiveClosure.codedConcepts.addAll(this.codedConcepts);
                for (String string : this.includedCIDs) {
                    ContextGroup contextGroup = map.get(new ContextGroupIdentifier(string));
                    if (contextGroup != null) {
                        ContextGroup contextGroup2 = contextGroup.getTransitiveClosure(map);
                        if (contextGroup2 == null) continue;
                        this.transitiveClosure.codedConcepts.addAll(contextGroup2.codedConcepts);
                        continue;
                    }
                    System.err.println("Error: Cannot find CID " + string + " to include in CID " + this.cid);
                }
            }
            return this.transitiveClosure;
        }
    }

    protected class ContextGroupIdentifier
    implements Comparable {
        protected String cid;

        protected ContextGroupIdentifier(String string) {
            this.cid = string;
        }

        public int compareTo(Object object) {
            int n = -1;
            if (this.equals(object)) {
                n = 0;
            } else if (object instanceof ContextGroupIdentifier) {
                try {
                    int n2 = Integer.parseInt(this.cid);
                    int n3 = Integer.parseInt(((ContextGroupIdentifier)object).cid);
                    n = n2 == n3 ? 0 : (n2 < n3 ? -1 : 1);
                }
                catch (NumberFormatException numberFormatException) {
                    n = this.cid.compareTo(((ContextGroupIdentifier)object).cid);
                }
            }
            return n;
        }
    }

    protected class CodedConceptInContextGroup
    extends CodedConcept {
        String sct;
        String umlscui;

        public CodedConceptInContextGroup(String string, String string2, String string3) {
            super(string, string2, string3);
            this.sct = null;
            this.umlscui = null;
        }

        public CodedConceptInContextGroup(String string, String string2, String string3, String string4, String string5) {
            super(string, string2, string3);
            this.sct = string4;
            this.umlscui = string5;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            stringBuffer.append(this.cv);
            stringBuffer.append(",");
            stringBuffer.append(this.csd);
            stringBuffer.append(",\"");
            stringBuffer.append(this.cm);
            stringBuffer.append("\")");
            if (this.sct != null) {
                stringBuffer.append("\t sct = ");
                stringBuffer.append(this.sct);
            }
            if (this.umlscui != null) {
                stringBuffer.append("\t umlscui = ");
                stringBuffer.append(this.umlscui);
            }
            return stringBuffer.toString();
        }
    }

    protected class CodedConcept {
        String csd;
        String cv;
        String cm;

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof CodedConcept) {
                bl = this.csd.equals(((CodedConcept)object).csd) && this.cv.equals(((CodedConcept)object).cv);
            }
            return bl;
        }

        public int hashCode() {
            return this.csd.hashCode() + this.cv.hashCode();
        }

        public CodedConcept(String string, String string2, String string3) {
            this.csd = string;
            this.cv = string2;
            this.cm = string3;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            stringBuffer.append(this.cv);
            stringBuffer.append(",");
            stringBuffer.append(this.csd);
            stringBuffer.append(",\"");
            stringBuffer.append(this.cm);
            stringBuffer.append("\")");
            return stringBuffer.toString();
        }
    }
}

