/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.anatproc;

import com.pixelmed.anatproc.Concept;
import com.pixelmed.anatproc.DisplayableLateralityConcept;
import com.pixelmed.anatproc.ProjectionXRayAnatomy;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;

public class MammographyLaterality {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/anatproc/MammographyLaterality.java,v 1.12 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MammographyLaterality.class);
    private static Concept left = new Concept("C0205091");
    private static Concept right = new Concept("C0205090");
    private static Concept both = new Concept("C0238767");
    private static DisplayableLateralityConcept leftBreast = new DisplayableLateralityConcept("C0222601", "80248007", "SRT", "SNM3", null, "T-04030", "Left breast", null, null, null, null);
    private static DisplayableLateralityConcept rightBreast = new DisplayableLateralityConcept("C0222600", "73056007", "SRT", "SNM3", null, "T-04020", "Right breast", null, null, null, null);
    private static DisplayableLateralityConcept bothBreasts = new DisplayableLateralityConcept("C0222605", "63762007", "SRT", "SNM3", null, "T-04080", "Both breasts", null, null, null, null);

    public static DisplayableLateralityConcept convertGenericLateralityToBreastSpecificLaterality(DisplayableLateralityConcept displayableLateralityConcept) {
        if (displayableLateralityConcept != null) {
            if (displayableLateralityConcept.equals(left)) {
                displayableLateralityConcept = leftBreast;
            } else if (displayableLateralityConcept.equals(right)) {
                displayableLateralityConcept = rightBreast;
            } else if (displayableLateralityConcept.equals(both)) {
                displayableLateralityConcept = bothBreasts;
            }
        }
        return displayableLateralityConcept;
    }

    public static CodedSequenceItem convertGenericLateralityToBreastSpecificLaterality(CodedSequenceItem codedSequenceItem) {
        DisplayableLateralityConcept displayableLateralityConcept;
        DisplayableLateralityConcept displayableLateralityConcept2;
        CodedSequenceItem codedSequenceItem2 = codedSequenceItem;
        if (codedSequenceItem != null && (displayableLateralityConcept2 = (DisplayableLateralityConcept)ProjectionXRayAnatomy.getLateralityConcepts().find(codedSequenceItem)) != null && (displayableLateralityConcept = MammographyLaterality.convertGenericLateralityToBreastSpecificLaterality(displayableLateralityConcept2)) != null) {
            try {
                codedSequenceItem2 = displayableLateralityConcept.getCodedSequenceItem();
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                codedSequenceItem2 = codedSequenceItem;
            }
        }
        return codedSequenceItem2;
    }
}

