/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CompositeInstanceContext;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.HexDump;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CompareSetsOfDicomFiles {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/CompareSetsOfDicomFiles.java,v 1.7 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CompareSetsOfDicomFiles.class);
    private static MoveDicomFilesIntoHierarchy moverForSummary = new MoveDicomFilesIntoHierarchy();
    private String xmlConfidentialityProfileDataElementsResourceName = "/com/pixelmed/dicom/confidentialityprofiledataelementsandhandling.xml";
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private SortedSet<AttributeTag> confidentialityProfileDataElementTags;
    private static final AttributeTag curveDataTag = new AttributeTag(20480, 0);
    private static final AttributeTag overlayDataTag = new AttributeTag(24576, 12288);
    private static final AttributeTag graphicAnnotationSequence = TagFromName.GraphicAnnotationSequence;
    private static final AttributeTag acquisitionContextSequence = TagFromName.AcquisitionContextSequence;
    private static final AttributeTag contentSequence = TagFromName.ContentSequence;

    private static SetOfDicomFiles buildSetOfDicomFiles(String string) {
        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
        ArrayList<File> arrayList = FileUtilities.listFilesRecursively(new File(string));
        for (File file : arrayList) {
            try {
                if (!DicomFileUtilities.isDicomOrAcrNemaFile(file)) continue;
                setOfDicomFiles.add(file.getCanonicalPath(), false, false);
            }
            catch (Exception exception) {
                slf4jlogger.debug("While reading \"{}\"", file, exception);
            }
        }
        return setOfDicomFiles;
    }

    public static boolean updateDigest(MessageDigest messageDigest, BufferedImage bufferedImage) throws DicomException, IOException {
        boolean bl = false;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ColorModel colorModel = bufferedImage.getColorModel();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n3 = dataBuffer.getOffset();
        int n4 = writableRaster.getNumBands();
        if (dataBuffer instanceof DataBufferUShort) {
            short[] sArray = ((DataBufferUShort)dataBuffer).getData();
            int n5 = sArray.length;
            for (int i = 0; i < n2; ++i) {
                int n6 = n3 + i * n;
                for (int j = 0; j < n; ++j) {
                    short s = sArray[n6 + j];
                    if (s != 0) {
                        bl = true;
                    }
                    byteArrayOutputStream.write(s & 0xFF);
                    byteArrayOutputStream.write(s >> 8 & 0xFF);
                }
            }
        } else if (dataBuffer instanceof DataBufferByte) {
            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
            int n7 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                int n8 = n3 + i * n;
                for (int j = 0; j < n; ++j) {
                    byte by = byArray[n8 + j];
                    if (by != 0) {
                        bl = true;
                    }
                    byteArrayOutputStream.write(by);
                }
            }
        } else {
            throw new DicomException("Unsupported BufferedImage type");
        }
        messageDigest.update(byteArrayOutputStream.toByteArray());
        return bl;
    }

    private void buildFingerPrints(SetOfDicomFiles setOfDicomFiles, Map<String, FingerPrint> map, Map<String, SetOfDicomFiles> map2, Set<String> set) {
        for (SetOfDicomFiles.DicomFile dicomFile : setOfDicomFiles) {
            String string = dicomFile.getFileName();
            if (string != null && string.length() > 0) {
                if (map.get(string) == null) {
                    try {
                        FingerPrint fingerPrint = new FingerPrint(dicomFile);
                        map.put(string, fingerPrint);
                        String string2 = fingerPrint.getDigestAsString();
                        SetOfDicomFiles setOfDicomFiles2 = map2.get(string2);
                        if (setOfDicomFiles2 == null) {
                            setOfDicomFiles2 = new SetOfDicomFiles();
                            map2.put(string2, setOfDicomFiles2);
                        }
                        setOfDicomFiles2.add(dicomFile);
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("file \"{}\" fingerprint extraction failed {}", string, exception);
                        set.add(string);
                    }
                    continue;
                }
                slf4jlogger.error("file \"{}\" has already had fingerprint extracted - ignoring duplicate", string);
                continue;
            }
            slf4jlogger.error("DicomFile {} has no file name - cannot add fingerprint to map", dicomFile.toString());
        }
    }

    private AttributeList readAttributeListWithoutPixelData(SetOfDicomFiles.DicomFile dicomFile, String string) {
        AttributeList attributeList = new AttributeList();
        String string2 = dicomFile.getFileName();
        if (string2 != null && string2.length() > 0) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string2)));
                attributeList.setDecompressPixelData(false);
                attributeList.read(dicomInputStream, TagFromName.PixelData);
            }
            catch (Exception exception) {
                slf4jlogger.error("file \"{}\" {} failed to {}", string2, string, exception);
            }
        } else {
            slf4jlogger.error("DicomFile {} has no file name - cannot {}", dicomFile.toString(), string);
        }
        return attributeList;
    }

    private CompositeInstanceContext extractCompositeInstanceContext(SetOfDicomFiles.DicomFile dicomFile) {
        CompositeInstanceContext compositeInstanceContext = null;
        AttributeList attributeList = this.readAttributeListWithoutPixelData(dicomFile, "extract CompositeInstanceContext");
        if (attributeList != null) {
            compositeInstanceContext = new CompositeInstanceContext(attributeList, false);
            AttributeList attributeList2 = compositeInstanceContext.getAttributeList();
            attributeList2.remove(TagFromName.PatientIdentityRemoved);
            attributeList2.remove(TagFromName.DeidentificationMethod);
            attributeList2.remove(TagFromName.DeidentificationMethodCodeSequence);
        }
        return compositeInstanceContext;
    }

    private void extractCompositeInstanceContextForMatchingFiles(Map<String, Set<String>> map, Map<CompositeInstanceContext, Set<CompositeInstanceContext>> map2, Map<String, Set<String>> map3, Map<CompositeInstanceContext, Set<CompositeInstanceContext>> map4, SetOfDicomFiles setOfDicomFiles, SetOfDicomFiles setOfDicomFiles2) {
        Object object;
        Set<Object> set;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        HashSet<CompositeInstanceContext> hashSet5 = new HashSet<CompositeInstanceContext>();
        HashSet<CompositeInstanceContext> hashSet6 = new HashSet<CompositeInstanceContext>();
        HashSet<CompositeInstanceContext> hashSet7 = new HashSet<CompositeInstanceContext>();
        HashSet<CompositeInstanceContext> hashSet8 = new HashSet<CompositeInstanceContext>();
        for (SetOfDicomFiles.DicomFile object3 : setOfDicomFiles) {
            set = this.extractCompositeInstanceContext(object3);
            if (set == null) continue;
            object = ((CompositeInstanceContext)((Object)set)).getAttributeList();
            String string = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.StudyInstanceUID);
            if (string.length() > 0) {
                hashSet.add(string);
            } else {
                slf4jlogger.error("DicomFile {} has Study Instance UID", object3.toString());
            }
            String string2 = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.SeriesInstanceUID);
            if (string2.length() > 0) {
                hashSet3.add(string2);
            } else {
                slf4jlogger.error("DicomFile {} has Series Instance UID", object3.toString());
            }
            CompositeInstanceContext compositeInstanceContext = new CompositeInstanceContext((AttributeList)object, false);
            compositeInstanceContext.removeAllButStudy();
            hashSet5.add(compositeInstanceContext);
            CompositeInstanceContext compositeInstanceContext2 = new CompositeInstanceContext((AttributeList)object, false);
            compositeInstanceContext2.removeAllButSeries();
            hashSet7.add(compositeInstanceContext2);
        }
        for (SetOfDicomFiles.DicomFile dicomFile : setOfDicomFiles2) {
            set = this.extractCompositeInstanceContext(dicomFile);
            if (set == null) continue;
            object = ((CompositeInstanceContext)((Object)set)).getAttributeList();
            String string = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.StudyInstanceUID);
            if (string.length() > 0) {
                hashSet2.add(string);
            } else {
                slf4jlogger.error("DicomFile {} missing Study Instance UID", dicomFile.toString());
            }
            String string3 = Attribute.getSingleStringValueOrEmptyString(object, TagFromName.SeriesInstanceUID);
            if (string3.length() > 0) {
                hashSet4.add(string3);
            } else {
                slf4jlogger.error("DicomFile {} missing Series Instance UID", dicomFile.toString());
            }
            CompositeInstanceContext compositeInstanceContext = new CompositeInstanceContext((AttributeList)object, false);
            compositeInstanceContext.removeAllButStudy();
            hashSet6.add(compositeInstanceContext);
            CompositeInstanceContext compositeInstanceContext3 = new CompositeInstanceContext((AttributeList)object, false);
            compositeInstanceContext3.removeAllButSeries();
            hashSet8.add(compositeInstanceContext3);
        }
        for (String string : hashSet) {
            set = map.get(string);
            if (set == null) {
                set = new HashSet();
                map.put(string, set);
            }
            for (String string4 : hashSet2) {
                set.add(string4);
            }
        }
        for (String string : hashSet3) {
            set = map3.get(string);
            if (set == null) {
                set = new HashSet();
                map3.put(string, set);
            }
            for (String string5 : hashSet4) {
                set.add((String)((Object)string5));
            }
        }
        for (CompositeInstanceContext compositeInstanceContext : hashSet5) {
            set = map2.get(compositeInstanceContext);
            if (set == null) {
                set = new HashSet();
                map2.put(compositeInstanceContext, set);
            }
            for (CompositeInstanceContext compositeInstanceContext4 : hashSet6) {
                set.add((String)((Object)compositeInstanceContext4));
            }
        }
        for (CompositeInstanceContext compositeInstanceContext : hashSet7) {
            set = map4.get(compositeInstanceContext);
            if (set == null) {
                set = new HashSet();
                map4.put(compositeInstanceContext, set);
            }
            for (CompositeInstanceContext compositeInstanceContext5 : hashSet8) {
                set.add((String)((Object)compositeInstanceContext5));
            }
        }
    }

    private void extractCompositeInstanceContextForUnmatchedFiles(Set<String> set, Set<CompositeInstanceContext> set2, Set<String> set3, Set<CompositeInstanceContext> set4, SetOfDicomFiles setOfDicomFiles) {
        for (SetOfDicomFiles.DicomFile dicomFile : setOfDicomFiles) {
            CompositeInstanceContext compositeInstanceContext = this.extractCompositeInstanceContext(dicomFile);
            if (compositeInstanceContext == null) continue;
            AttributeList attributeList = compositeInstanceContext.getAttributeList();
            Object object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
            if (((String)object).length() > 0) {
                set.add((String)object);
            } else {
                slf4jlogger.error("DicomFile {} missing Study Instance UID", dicomFile.toString());
            }
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
            if (((String)object).length() > 0) {
                set3.add((String)object);
            } else {
                slf4jlogger.error("DicomFile {} missing Series Instance UID", dicomFile.toString());
            }
            object = new CompositeInstanceContext(attributeList, false);
            ((CompositeInstanceContext)object).removeAllButStudy();
            set2.add((CompositeInstanceContext)object);
            object = new CompositeInstanceContext(attributeList, false);
            ((CompositeInstanceContext)object).removeAllButSeries();
            set4.add((CompositeInstanceContext)object);
        }
    }

    private String summarizeStudy(CompositeInstanceContext compositeInstanceContext) {
        AttributeList attributeList = compositeInstanceContext.getAttributeList();
        return moverForSummary.makeStudyLabelFromAttributes(attributeList, 3) + " (" + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID) + ")";
    }

    private String summarizeSeries(CompositeInstanceContext compositeInstanceContext) {
        AttributeList attributeList = compositeInstanceContext.getAttributeList();
        return moverForSummary.makeSeriesLabelFromAttributes(attributeList, 3) + " (" + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID) + ")";
    }

    private Document readDataElementHandlingFile() throws IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = this.getClass().getResourceAsStream(this.xmlConfidentialityProfileDataElementsResourceName);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputStream);
    }

    private SortedSet<AttributeTag> getAttributeTagsOfDataElementsFromFile() throws IOException, ParserConfigurationException, SAXException {
        TreeSet<AttributeTag> treeSet = new TreeSet<AttributeTag>();
        Document document = this.readDataElementHandlingFile();
        Element element = document.getDocumentElement();
        if (element.getTagName().equals("DataElements")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !((Element)node).getTagName().equals("DataElement")) continue;
                String string = "";
                String string2 = "";
                String string3 = "";
                String string4 = "";
                Object object = node.getAttributes();
                if (object != null) {
                    Node node2 = object.getNamedItem("name");
                    if (node2 != null) {
                        string = node2.getTextContent();
                    }
                    if ((node2 = object.getNamedItem("group")) != null) {
                        string2 = node2.getTextContent();
                    }
                    if ((node2 = object.getNamedItem("element")) != null) {
                        string3 = node2.getTextContent();
                    }
                    if ((node2 = object.getNamedItem("action")) != null) {
                        string4 = node2.getTextContent();
                    }
                }
                if (string2.length() > 0 && string3.length() > 0 && !string.toLowerCase().trim().equals("private attributes")) {
                    object = new AttributeTag(Integer.parseInt(string2.replaceAll("[Xx]", "0"), 16), Integer.parseInt(string3.replaceAll("[Xx]", "0"), 16));
                    treeSet.add((AttributeTag)object);
                    continue;
                }
                slf4jlogger.debug("getAttributeTagsOfDataElementsFromFile(): Ignoring " + string);
            }
        }
        return treeSet;
    }

    private void checkIsDeidentifiedproperly(SetOfDicomFiles.DicomFile dicomFile, SetOfDicomFiles.DicomFile dicomFile2, Map<AttributeTag, SortedSet<StringPair>> map, Map<AttributeTag, SortedSet<String>> map2) {
        AttributeList attributeList = this.readAttributeListWithoutPixelData(dicomFile, "check second set is de-identified");
        AttributeList attributeList2 = this.readAttributeListWithoutPixelData(dicomFile2, "check second set is de-identified");
        String string = dicomFile.getFileName();
        String string2 = dicomFile2.getFileName();
        if (this.confidentialityProfileDataElementTags == null) {
            try {
                this.confidentialityProfileDataElementTags = this.getAttributeTagsOfDataElementsFromFile();
            }
            catch (Exception exception) {
                slf4jlogger.error("Unable to load confidentialityProfileDataElementTags {}", exception);
            }
        }
        TreeSet treeSet = new TreeSet();
        Set set = attributeList.keySet();
        Object object2 = attributeList2.keySet();
        treeSet.addAll(set);
        treeSet.addAll(object2);
        for (Object object2 : treeSet) {
            SortedSet<Object> sortedSet;
            Object object3;
            Object object4;
            Object object5;
            if (((AttributeTag)object2).equals(curveDataTag)) {
                slf4jlogger.debug("Not checking curveDataTag {}", ((AttributeTag)object2).toString(dictionary));
                continue;
            }
            if (((AttributeTag)object2).equals(overlayDataTag)) {
                slf4jlogger.debug("Not checking overlayDataTag {}", ((AttributeTag)object2).toString(dictionary));
                continue;
            }
            if (((AttributeTag)object2).equals(graphicAnnotationSequence)) {
                slf4jlogger.debug("Not checking graphicAnnotationSequence {}", ((AttributeTag)object2).toString(dictionary));
                continue;
            }
            if (((AttributeTag)object2).equals(acquisitionContextSequence)) {
                slf4jlogger.debug("Not checking acquisitionContextSequence {}", ((AttributeTag)object2).toString(dictionary));
                continue;
            }
            if (((AttributeTag)object2).equals(contentSequence)) {
                slf4jlogger.debug("Not checking contentSequence {}", ((AttributeTag)object2).toString(dictionary));
                continue;
            }
            String string3 = this.confidentialityProfileDataElementTags.contains(object2) ? " [DEID]" : "";
            slf4jlogger.debug("{} confidentialityProfileDataElementTags {}", ((AttributeTag)object2).toString(dictionary), string3);
            byte[] byArray = dictionary.getValueRepresentationFromTag((AttributeTag)object2);
            if (byArray == null || ValueRepresentation.isUnknownVR(byArray)) {
                object5 = attributeList.get((AttributeTag)object2);
                if (object5 != null) {
                    byArray = ((Attribute)object5).getVR();
                }
                if ((byArray == null || ValueRepresentation.isUnknownVR(byArray)) && (object4 = attributeList2.get((AttributeTag)object2)) != null) {
                    byArray = ((Attribute)object4).getVR();
                }
            }
            Object object6 = object5 = byArray == null ? "null" : ValueRepresentation.getAsString(byArray);
            if (byArray == null || ValueRepresentation.isUnknownVR(byArray) || ValueRepresentation.isOtherByteVR(byArray) || ValueRepresentation.isOtherDoubleVR(byArray) || ValueRepresentation.isOtherFloatVR(byArray) || ValueRepresentation.isOtherLongVR(byArray) || ValueRepresentation.isOtherWordVR(byArray) || ValueRepresentation.isOtherUnspecifiedVR(byArray)) {
                object4 = attributeList.get((AttributeTag)object2);
                object3 = attributeList2.get((AttributeTag)object2);
                if (object3 == null || ((Attribute)object3).getVL() == 0L) {
                    if (object4 == null || ((Attribute)object4).getVL() == 0L) {
                        slf4jlogger.debug("In \"{}\": Was not present or was empty before {}{} VR {}", string2, ((AttributeTag)object2).toString(dictionary), string3, object5);
                        continue;
                    }
                    slf4jlogger.debug("In \"{}\": Removed or is empty {}{} VR {}", string2, ((AttributeTag)object2).toString(dictionary), string3, object5);
                    continue;
                }
                slf4jlogger.error("In \"{}\": Not removed or made zero length {}{} VR {}", string2, ((AttributeTag)object2).toString(dictionary), string3, object5);
                continue;
            }
            if (ValueRepresentation.isSequenceVR(byArray)) {
                object4 = attributeList.get((AttributeTag)object2);
                object3 = attributeList2.get((AttributeTag)object2);
                if (object3 == null || ((SequenceAttribute)object3).getNumberOfItems() == 0) {
                    if (object4 == null || ((SequenceAttribute)object4).getNumberOfItems() == 0) {
                        slf4jlogger.debug("In \"{}\": Was not present or was empty before {}{} VR SQ", string2, ((AttributeTag)object2).toString(dictionary), string3);
                        continue;
                    }
                    slf4jlogger.debug("In \"{}\": Removed or is empty {}{} VR SQ", string2, ((AttributeTag)object2).toString(dictionary), string3);
                    continue;
                }
                slf4jlogger.error("In \"{}\": Not removed or made zero length {}{} VR SQ", string2, ((AttributeTag)object2).toString(dictionary), string3);
                continue;
            }
            object4 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, (AttributeTag)object2);
            object3 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList2, (AttributeTag)object2);
            if (!((String)object3).equals(object4)) {
                slf4jlogger.debug("Comparing \"{}\" with \"{}\": different {}{} VR {} \"{}\" -> \"{}\"", string, string2, ((AttributeTag)object2).toString(dictionary), string3, object5, object4, object3);
                sortedSet = map.get(object2);
                if (sortedSet == null) {
                    sortedSet = new TreeSet<StringPair>();
                    map.put((AttributeTag)object2, sortedSet);
                }
                sortedSet.add(new StringPair((String)object4, (String)object3));
                continue;
            }
            if (((String)object4).length() == 0) {
                slf4jlogger.debug("Comparing \"{}\" with \"{}\": empty in both \"{}\"", string, string2, ((AttributeTag)object2).toString(dictionary));
                continue;
            }
            if (ValueRepresentation.isPersonNameVR(byArray) && ((String)object4).replaceAll("(\\^|=)", "").length() == 0) {
                slf4jlogger.debug("Comparing \"{}\" with \"{}\": same {}{} VR PN after accounting for component delimiters \"{}\" -> \"{}\"", string, string2, ((AttributeTag)object2).toString(dictionary), string3, object4, object3);
                continue;
            }
            slf4jlogger.error("Comparing \"{}\" with \"{}\": not different {}{} VR {} \"{}\" ", string, string2, ((AttributeTag)object2).toString(dictionary), string3, object5, object4);
            sortedSet = map2.get(object2);
            if (sortedSet == null) {
                sortedSet = new TreeSet();
                map2.put((AttributeTag)object2, sortedSet);
            }
            sortedSet.add((StringPair)object4);
        }
    }

    private void checkMatchingFilesAreDeidentifiedInSecondSet(SetOfDicomFiles setOfDicomFiles, SetOfDicomFiles setOfDicomFiles2, Map<AttributeTag, SortedSet<StringPair>> map, Map<AttributeTag, SortedSet<String>> map2) {
        for (SetOfDicomFiles.DicomFile dicomFile : setOfDicomFiles) {
            for (SetOfDicomFiles.DicomFile dicomFile2 : setOfDicomFiles2) {
                this.checkIsDeidentifiedproperly(dicomFile, dicomFile2, map, map2);
            }
        }
    }

    private void compareSets(SetOfDicomFiles setOfDicomFiles, SetOfDicomFiles setOfDicomFiles2) {
        Object object;
        Set<SetOfDicomFiles.DicomFile> set;
        HashMap<String, FingerPrint> hashMap = new HashMap<String, FingerPrint>();
        HashMap<String, SetOfDicomFiles> hashMap2 = new HashMap<String, SetOfDicomFiles>();
        HashSet<String> hashSet = new HashSet<String>();
        this.buildFingerPrints(setOfDicomFiles, hashMap, hashMap2, hashSet);
        HashMap<String, FingerPrint> hashMap3 = new HashMap<String, FingerPrint>();
        HashMap<String, SetOfDicomFiles> hashMap4 = new HashMap<String, SetOfDicomFiles>();
        HashSet<String> hashSet2 = new HashSet<String>();
        this.buildFingerPrints(setOfDicomFiles2, hashMap3, hashMap4, hashSet2);
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        TreeMap<String, Set<String>> treeMap = new TreeMap<String, Set<String>>();
        HashSet<CompositeInstanceContext> hashSet5 = new HashSet<CompositeInstanceContext>();
        HashSet<CompositeInstanceContext> hashSet6 = new HashSet<CompositeInstanceContext>();
        HashMap<CompositeInstanceContext, Set<CompositeInstanceContext>> hashMap5 = new HashMap<CompositeInstanceContext, Set<CompositeInstanceContext>>();
        HashSet<String> hashSet7 = new HashSet<String>();
        HashSet<String> hashSet8 = new HashSet<String>();
        TreeMap<String, Set<String>> treeMap2 = new TreeMap<String, Set<String>>();
        HashSet<CompositeInstanceContext> hashSet9 = new HashSet<CompositeInstanceContext>();
        HashSet<CompositeInstanceContext> hashSet10 = new HashSet<CompositeInstanceContext>();
        HashMap<CompositeInstanceContext, Set<CompositeInstanceContext>> hashMap6 = new HashMap<CompositeInstanceContext, Set<CompositeInstanceContext>>();
        TreeMap<AttributeTag, SortedSet<StringPair>> treeMap3 = new TreeMap<AttributeTag, SortedSet<StringPair>>();
        TreeMap<AttributeTag, SortedSet<String>> treeMap4 = new TreeMap<AttributeTag, SortedSet<String>>();
        for (String object2 : hashMap2.keySet()) {
            slf4jlogger.debug("Looking for {}", object2);
            set = (SetOfDicomFiles)hashMap2.get(object2);
            object = (SetOfDicomFiles)hashMap4.get(object2);
            if (object == null) {
                slf4jlogger.info("For digest {}:\n\t Only in 1st set contains {}", object2, ((SetOfDicomFiles)set).toString());
                this.extractCompositeInstanceContextForUnmatchedFiles(hashSet3, hashSet5, hashSet7, hashSet9, (SetOfDicomFiles)set);
                continue;
            }
            slf4jlogger.debug("For digest {}:\n\t 1st set contains {}\n\t 2nd set contains {}", object2, ((SetOfDicomFiles)set).toString(), ((SetOfDicomFiles)object).toString());
            if (((HashSet)set).size() == 1 && ((HashSet)object).size() == 1) {
                String string = ((SetOfDicomFiles.DicomFile)((HashSet)set).iterator().next()).getFileName();
                String string2 = ((SetOfDicomFiles.DicomFile)((HashSet)object).iterator().next()).getFileName();
                slf4jlogger.info("For digest {}:\t 1st set contains file \"{}\"\t 2nd set contains file \"{}\"", object2, string, string2);
            } else {
                slf4jlogger.error("More than one file in first or second set for digest {}", object2);
            }
            this.extractCompositeInstanceContextForMatchingFiles((Map<String, Set<String>>)treeMap, (Map<CompositeInstanceContext, Set<CompositeInstanceContext>>)hashMap5, (Map<String, Set<String>>)treeMap2, (Map<CompositeInstanceContext, Set<CompositeInstanceContext>>)hashMap6, (SetOfDicomFiles)set, (SetOfDicomFiles)object);
            this.checkMatchingFilesAreDeidentifiedInSecondSet((SetOfDicomFiles)set, (SetOfDicomFiles)object, (Map<AttributeTag, SortedSet<StringPair>>)treeMap3, (Map<AttributeTag, SortedSet<String>>)treeMap4);
        }
        for (String string : hashMap4.keySet()) {
            slf4jlogger.debug("Looking for {}", string);
            set = (SetOfDicomFiles)hashMap2.get(string);
            if (set != null) continue;
            object = (SetOfDicomFiles)hashMap4.get(string);
            slf4jlogger.info("For digest {}:\n\t Only in 2nd set contains {}", string, ((SetOfDicomFiles)object).toString());
            this.extractCompositeInstanceContextForUnmatchedFiles(hashSet4, hashSet6, hashSet8, hashSet10, (SetOfDicomFiles)object);
        }
        slf4jlogger.debug("First set failed fingerprinting:");
        for (String string : hashSet) {
            slf4jlogger.info("\tFailed to fingerprint first set {}", string);
        }
        slf4jlogger.debug("Second set failed fingerprinting:");
        for (String string : hashSet2) {
            slf4jlogger.info("\tFailed to fingerprint second set {}", string);
        }
        for (CompositeInstanceContext compositeInstanceContext : hashMap5.keySet()) {
            slf4jlogger.info("StudyCIC first set: {}", this.summarizeStudy(compositeInstanceContext));
            slf4jlogger.debug("StudyCIC first set:\n{}", compositeInstanceContext);
            set = (Set)hashMap5.get(compositeInstanceContext);
            for (CompositeInstanceContext compositeInstanceContext2 : set) {
                slf4jlogger.info("Maps to StudyCIC second set: {}", this.summarizeStudy(compositeInstanceContext2));
                slf4jlogger.debug("Maps to StudyCIC second set:\n{}", compositeInstanceContext2);
            }
        }
        for (CompositeInstanceContext compositeInstanceContext : hashSet5) {
            slf4jlogger.info("StudyCIC first set has one or more unmatched files: {}", this.summarizeStudy(compositeInstanceContext));
            slf4jlogger.debug("StudyCIC first set has one or more unmatched files:\n{}", compositeInstanceContext);
        }
        for (CompositeInstanceContext compositeInstanceContext : hashSet6) {
            slf4jlogger.info("StudyCIC second set has one or more unmatched files: {}", this.summarizeStudy(compositeInstanceContext));
            slf4jlogger.debug("StudyCIC second set has one or more unmatched files:\n{}", compositeInstanceContext);
        }
        for (CompositeInstanceContext compositeInstanceContext : hashMap6.keySet()) {
            slf4jlogger.info("SeriesCIC first set: {}", this.summarizeSeries(compositeInstanceContext));
            slf4jlogger.debug("SeriesCIC first set:\n{}", compositeInstanceContext);
            set = (Set)hashMap6.get(compositeInstanceContext);
            for (CompositeInstanceContext compositeInstanceContext3 : set) {
                slf4jlogger.info("Maps to SeriesCIC second set: {}", this.summarizeSeries(compositeInstanceContext3));
                slf4jlogger.debug("Maps to SeriesCIC second set:\n{}", compositeInstanceContext3);
            }
        }
        for (CompositeInstanceContext compositeInstanceContext : hashSet9) {
            slf4jlogger.info("SeriesCIC first set has one or more unmatched files: {}", this.summarizeSeries(compositeInstanceContext));
            slf4jlogger.debug("SeriesCIC first set has one or more unmatched files:\n{}", compositeInstanceContext);
        }
        for (CompositeInstanceContext compositeInstanceContext : hashSet10) {
            slf4jlogger.info("SeriesCIC second set has one or more unmatched files: {}", this.summarizeSeries(compositeInstanceContext));
            slf4jlogger.debug("SeriesCIC second set has one or more unmatched files:\n{}", compositeInstanceContext);
        }
        for (String string : treeMap.keySet()) {
            set = (Set)treeMap.get(string);
            if (set == null) {
                slf4jlogger.info("StudyInstanceUID first set {} has no match", string);
                continue;
            }
            for (String string3 : set) {
                slf4jlogger.info("StudyInstanceUID first set {} -> second set {}", string, string3);
            }
        }
        for (String string : hashSet3) {
            slf4jlogger.info("StudyInstanceUID first set {} has one or more unmatched files", string);
        }
        for (String string : hashSet4) {
            slf4jlogger.info("StudyInstanceUID second set {} has one or more unmatched files", string);
        }
        for (String string : treeMap2.keySet()) {
            set = (Set)treeMap2.get(string);
            if (set == null) {
                slf4jlogger.info("SeriesInstanceUID first set {} has no match", string);
                continue;
            }
            for (String string4 : set) {
                slf4jlogger.info("SeriesInstanceUID first set {} -> second set {}", string, string4);
            }
        }
        for (String string : hashSet7) {
            slf4jlogger.info("SeriesInstanceUID first set {} has one or more unmatched files", string);
        }
        for (String string : hashSet8) {
            slf4jlogger.info("SeriesInstanceUID second set {} has one or more unmatched files", string);
        }
        for (AttributeTag attributeTag : treeMap3.keySet()) {
            set = (SortedSet)treeMap3.get(attributeTag);
            object = this.confidentialityProfileDataElementTags.contains(attributeTag) ? " [DEID]" : "";
            slf4jlogger.warn("{}{} values that were different:", attributeTag.toString(dictionary), object);
            for (StringPair stringPair : set) {
                slf4jlogger.warn("\t\"{}\" -> \"{}\"", stringPair.string1, stringPair.string2);
            }
        }
        for (AttributeTag attributeTag : treeMap4.keySet()) {
            set = (SortedSet)treeMap4.get(attributeTag);
            object = this.confidentialityProfileDataElementTags.contains(attributeTag) ? " [DEID]" : "";
            slf4jlogger.warn("{}{} values that were not different:", attributeTag.toString(dictionary), object);
            for (String string : set) {
                slf4jlogger.warn("\t\"{}\"", string);
            }
        }
    }

    public CompareSetsOfDicomFiles(String string, String string2) {
        SetOfDicomFiles setOfDicomFiles = CompareSetsOfDicomFiles.buildSetOfDicomFiles(string);
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("1st set:\n{}", setOfDicomFiles.toString());
        }
        SetOfDicomFiles setOfDicomFiles2 = CompareSetsOfDicomFiles.buildSetOfDicomFiles(string2);
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("2nd set:\n{}", setOfDicomFiles2.toString());
        }
        this.compareSets(setOfDicomFiles, setOfDicomFiles2);
    }

    public static void main(String[] stringArray) {
        new CompareSetsOfDicomFiles(stringArray[0], stringArray[1]);
    }

    private class FingerPrint {
        String pixelDataDigestAsString;

        String getDigestAsString() {
            return this.pixelDataDigestAsString;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public FingerPrint(SetOfDicomFiles.DicomFile dicomFile) throws DicomException, IOException, NoSuchAlgorithmException {
            String string = dicomFile.getFileName();
            if (string == null || string.length() <= 0) throw new DicomException("FingerPrint extraction - missing filename in " + dicomFile.toString());
            String string2 = dicomFile.getSOPClassUID();
            if (string2 == null || string2.length() <= 0) throw new DicomException("FingerPrint extraction - missing SOP Class UID in \"" + string + "\"");
            if (!SOPClass.isImageStorage(string2)) throw new DicomException("FingerPrint extraction - unsupported SOP Class UID in \"" + string + "\"");
            DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
            AttributeList attributeList = new AttributeList();
            attributeList.setDecompressPixelData(false);
            attributeList.read(dicomInputStream);
            SourceImage sourceImage = new SourceImage(attributeList);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int n = sourceImage.getNumberOfFrames();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                BufferedImage bufferedImage = sourceImage.getBufferedImage(i);
                boolean bl2 = CompareSetsOfDicomFiles.updateDigest(messageDigest, bufferedImage);
                bl = bl2 || bl;
            }
            if (bl) {
                byte[] byArray = messageDigest.digest();
                this.pixelDataDigestAsString = HexDump.byteArrayToHexString(byArray);
                slf4jlogger.debug("file \"{}\" fingerprint image message digest {}", string, this.pixelDataDigestAsString);
                return;
            } else {
                slf4jlogger.error("file \"{}\" fingerprint image message digest creation failed (e.g., all zero pixel values)", string);
            }
        }
    }

    private class StringPair
    implements Comparable {
        String string1;
        String string2;

        public StringPair(String string, String string2) {
            this.string1 = string;
            this.string2 = string2;
        }

        public int compareTo(Object object) {
            int n = -1;
            if (object instanceof StringPair) {
                StringPair stringPair = (StringPair)object;
                n = this.string1.compareTo(stringPair.string1);
                if (n == 0) {
                    n = this.string2.compareTo(stringPair.string2);
                }
            }
            return n;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        public int hashCode() {
            return this.string1.hashCode() + this.string2.hashCode();
        }
    }
}

