/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ConvertSRTCodesToSCT {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/ConvertSRTCodesToSCT.java,v 1.6 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ConvertSRTCodesToSCT.class);
    protected String ourAETitle = "OURAETITLE";
    protected String xmlSRTSCTMappingResourceName = "/com/pixelmed/validate/srtsctmapping.xml";
    protected String xmlRetiredSRTNewSCTMappingResourceName = "/com/pixelmed/validate/retiredsrtnewsctmapping.xml";
    Map<String, String> sctCodeBySRTCode = new HashMap<String, String>();

    private Document readXMLSRTSCTMapping(String string) throws IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = ConvertSRTCodesToSCT.class.getResourceAsStream(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputStream);
    }

    private void loadMapping(String string) {
        try {
            Document document = this.readXMLSRTSCTMapping(string);
            Element element = document.getDocumentElement();
            if (!element.getNodeName().equals("definesrttosctmappingtable")) {
                throw new DicomException("Missing definesrttosctmappingtable root element in " + this.xmlSRTSCTMappingResourceName);
            }
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!node.getNodeName().equals("mapping")) continue;
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string2 = namedNodeMap.getNamedItem("sct").getNodeValue();
                String string3 = namedNodeMap.getNamedItem("srt").getNodeValue();
                this.sctCodeBySRTCode.put(string3, string2);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Unable to construct SRT to SCT mapping from XML ", exception);
        }
    }

    public void convertSRTToSCTInThisItem(AttributeList attributeList) {
        String string;
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.CodingSchemeDesignator);
        if (string2.length() > 0 && (string2.equals("SRT") || string2.equals("SNM") || string2.equals("SNM3") || string2.equals("99SDM")) && (string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.CodeValue)).length() > 0) {
            String string3 = this.sctCodeBySRTCode.get(string);
            if (string3 != null && string3.length() > 0) {
                slf4jlogger.info("Mapped SRT: {} to SCT: ", string, string3);
                try {
                    ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.CodeValue);
                    ((Attribute)shortStringAttribute).addValue(string3);
                    attributeList.put(shortStringAttribute);
                    shortStringAttribute = new ShortStringAttribute(TagFromName.CodingSchemeDesignator);
                    ((Attribute)shortStringAttribute).addValue("SCT");
                    attributeList.put(shortStringAttribute);
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("Unable to replace CodeValue or CodingSchemeDesignator", dicomException);
                }
            } else {
                slf4jlogger.error("Could not map SRT: {} to SCT", string);
            }
        }
    }

    public void findCodeSequenceItemsAndConvertSRTCodesToSCT(AttributeList attributeList) {
        for (Attribute attribute : attributeList.values()) {
            if (attribute == null || !(attribute instanceof SequenceAttribute)) continue;
            Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
            while (iterator.hasNext()) {
                AttributeList attributeList2;
                SequenceItem sequenceItem = iterator.next();
                if (sequenceItem == null || (attributeList2 = sequenceItem.getAttributeList()) == null) continue;
                this.convertSRTToSCTInThisItem(attributeList2);
                this.findCodeSequenceItemsAndConvertSRTCodesToSCT(attributeList2);
            }
        }
    }

    public ConvertSRTCodesToSCT(String[] stringArray, String string) throws FileNotFoundException, IOException, DicomException {
        this.loadMapping(this.xmlSRTSCTMappingResourceName);
        this.loadMapping(this.xmlRetiredSRTNewSCTMappingResourceName);
        OurMediaImporter ourMediaImporter = new OurMediaImporter(string);
        for (String string2 : stringArray) {
            ourMediaImporter.importDicomFiles(string2);
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length >= 2) {
                int n = stringArray.length - 1;
                String[] stringArray2 = new String[n];
                System.arraycopy(stringArray, 0, stringArray2, 0, n);
                new ConvertSRTCodesToSCT(stringArray2, stringArray[n]);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.ConvertSRTCodesToSCT srcdir|DICOMDIR [srcdir|DICOMDIR]* dstdir");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        String dstFolderName;

        public OurMediaImporter(String string) {
            super(null);
            this.dstFolderName = string;
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.setDecompressPixelData(false);
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                attributeList.removeGroupLengthAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                String string2 = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.TransferSyntaxUID, "1.2.840.10008.1.2.1");
                attributeList.removeMetaInformationHeaderAttributes();
                ConvertSRTCodesToSCT.this.findCodeSequenceItemsAndConvertSRTCodesToSCT(attributeList);
                CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
                attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                FileMetaInformation.addFileMetaInformation(attributeList, string2, ConvertSRTCodesToSCT.this.ourAETitle);
                File file = new File(this.dstFolderName, MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList));
                if (file.exists()) {
                    throw new DicomException("\"" + string + "\": new file \"" + file + "\" already exists - not overwriting");
                }
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new DicomException("\"" + string + "\": parent directory creation failed for \"" + file + "\"");
                }
                slf4jlogger.info("Copying from \"{}\" to \"{}\"", string, file);
                attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }
}

