/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.apps.DoseUtility;
import com.pixelmed.database.DatabaseApplicationProperties;
import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.MinimalPatientStudySeriesInstanceModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dose.CTDose;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.OCR;
import com.pixelmed.ftp.FTPApplicationProperties;
import com.pixelmed.ftp.FTPException;
import com.pixelmed.ftp.FTPFileSender;
import com.pixelmed.ftp.FTPRemoteHost;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class DoseReporterWithLegacyOCRAndAutoSendToRegistry {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/DoseReporterWithLegacyOCRAndAutoSendToRegistry.java,v 1.28 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DoseReporterWithLegacyOCRAndAutoSendToRegistry.class);
    protected static String defaultPropertiesFileName = ".com.pixelmed.apps.DoseReporterWithLegacyOCRAndAutoSendToRegistry.properties";
    protected static String propertyName_SelectedDoseRegistry = "Application.SelectedDoseRegistry";
    protected static String propertyName_SleepTimeBetweenPassesToProcessReceivedFiles = "Application.SleepTimeBetweenPassesToProcessReceivedFiles";
    protected static String propertyName_IntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy = "Application.IntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy";
    protected static String propertyName_SleepTimeBetweenPassesToQueryRemoteAEs = "Application.SleepTimeBetweenPassesToQueryRemoteAEs";
    protected static String propertyName_DaysBackwardsFromTodayToQuery = "Application.DaysBackwardsFromTodayToQuery";
    protected static String propertyName_RetainSourceFilesUsedForSRGeneration = "Application.RetainSourceFilesUsedForSRGeneration";
    protected static String propertyName_RetainGeneratedRDSRFiles = "Application.RetainGeneratedRDSRFiles";
    protected static String propertyName_RetainDeidentifiedFiles = "Application.RetainDeidentifiedFiles";
    protected static String propertyName_RemoteAEsForQuery = "Application.RemoteAEsForQuery";
    protected static String propertyDelimitersForTokenizer_RemoteAEsForQuery = ", ";
    protected boolean retainDeidentifiedFiles;
    protected boolean retainGeneratedRDSRFiles;
    protected boolean retainSourceFilesUsedForSRGeneration;
    protected String defaultRetainDeidentifiedFiles = Boolean.toString(false);
    protected String defaultRetainGeneratedRDSRFiles = Boolean.toString(false);
    protected String defaultRetainSourceFilesUsedForSRGeneration = Boolean.toString(false);
    protected String defaultSleepTimeBetweenPassesToProcessReceivedFiles = "60";
    protected String defaultIntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy = "60";
    protected String defaultSleepTimeBetweenPassesToQueryRemoteAEs = "60";
    protected String defaultDaysBackwardsFromTodayToQuery = "0";
    protected static int sleepTimeBetweenPassesToProcessReceivedFiles;
    protected static int intervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy;
    protected static int sleepTimeBetweenPassesToQueryRemoteAEs;
    protected static int daysBackwardsFromTodayToQuery;
    protected static final long millisecondsPerDay = 86400000L;
    protected Properties properties;
    protected NetworkApplicationProperties networkApplicationProperties;
    protected NetworkApplicationInformationFederated networkApplicationInformation;
    protected String ourCalledAETitle;
    protected List<String> remoteAEsForQuery;
    protected DatabaseInformationModel databaseInformationModel;
    protected FTPRemoteHost remoteHost;
    protected String buildDate = this.getBuildDate();
    protected File savedImagesFolder;
    protected StoredFilePathStrategy storedFilePathStrategy = StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS;
    protected String studyHasBeenProcessedColumnName = "PM_STUDYHASBEENPROCESSED";
    protected String instanceHasBeenSentToRegistryColumnName = "PM_INSTANCEHASBEENSENTTOREGISTRY";
    protected String instanceIsRadiationDoseSRColumnName = "PM_ISRADIATIONDOSESR";
    protected String instanceIsRadiationDoseScreenColumnName = "PM_ISRADIATIONDOSESCREEN";
    protected String instanceIsExposureDoseSequenceColumnName = "PM_ISEXPOSUREDOSESEQUENCE";
    protected String studyInstanceUIDColumnName;
    protected String sopClassUIDColumnName;
    protected String manufacturerColumnName;
    protected String imageTypeColumnName;
    protected String instanceCreatorUIDColumnName;
    protected String sourceApplicationEntityTitleColumnName;
    protected String instanceLocalParentReferenceColumnName;
    protected String instanceLocalFileNameColumnName;
    protected String instanceLocalFileReferenceTypeColumnName;
    protected String instanceLocalPrimaryKeyColumnName;

    protected String getBuildDate() {
        String string = "";
        try {
            string = new BufferedReader(new InputStreamReader(DoseReporterWithLegacyOCRAndAutoSendToRegistry.class.getResourceAsStream("/BUILDDATE"))).readLine();
        }
        catch (IOException iOException) {
            slf4jlogger.error("", iOException);
        }
        return string;
    }

    protected void loadProperties(String string) throws IOException {
        this.properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string);
        this.properties.load(fileInputStream);
        fileInputStream.close();
    }

    protected String deidentifyFile(String string) throws DicomException, IOException {
        slf4jlogger.trace("deidentifyFile(): doing file {}", string);
        File file = new File(string);
        DicomInputStream dicomInputStream = new DicomInputStream(file);
        AttributeList attributeList = new AttributeList();
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        attributeList.removeGroupLengthAttributes();
        attributeList.correctDecompressedImagePixelModule();
        attributeList.insertLossyImageCompressionHistoryIfDecompressed();
        attributeList.removeMetaInformationHeaderAttributes();
        attributeList.removeUnsafePrivateAttributes();
        ClinicalTrialsAttributes.removeClinicalTrialsAttributes(attributeList);
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, true, true, true, true, true);
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), "PixelMed", null, null, null, this.ourCalledAETitle, "DoseReporterWithLegacyOCRAndAutoSendToRegistry", null, this.buildDate, "De-identified");
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", this.ourCalledAETitle);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        File file2 = File.createTempFile("clean", ".dcm");
        String string2 = file2.getCanonicalPath();
        slf4jlogger.trace("deidentifyFile(): deidentified file is {}", string2);
        if (!this.retainDeidentifiedFiles) {
            file2.deleteOnExit();
        }
        attributeList.write(file2);
        return string2;
    }

    protected void sendFileToRegistry(String string) throws DicomException, IOException, NoSuchAlgorithmException, Exception {
        String string2 = this.deidentifyFile(string);
        String[] stringArray = new String[]{string2};
        new FTPFileSender(this.remoteHost, stringArray, true, null, null);
        slf4jlogger.debug("sendFileToRegistry(): successful send of deidentified version of {}", string);
        if (!this.retainDeidentifiedFiles) {
            slf4jlogger.trace("sendFileToRegistry(): deleting deidentified file {}", string2);
            try {
                if (!new File(string2).delete()) {
                    throw new DicomException("Failed to delete deidentified file that we sent to registry " + string2);
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    protected void sendFileToRegistry(CandidateFile candidateFile) throws DicomException, IOException, NoSuchAlgorithmException, Exception {
        if (candidateFile.localPrimaryKeyValue == null) {
            throw new Exception("Internal error - did not receive localPrimaryKeyValue - not attempting to send since will not be able to update database with instance has been sent");
        }
        try {
            this.sendFileToRegistry(candidateFile.fileName);
            slf4jlogger.trace("sendFileToRegistry(): setting instance has been sent flag for " + candidateFile.localPrimaryKeyValue + " " + candidateFile.fileName);
            this.databaseInformationModel.updateSelectedRecord(InformationEntity.INSTANCE, candidateFile.localPrimaryKeyValue, this.instanceHasBeenSentToRegistryColumnName, "TRUE");
            candidateFile.instanceHasBeenSent = true;
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    protected void sendFilesToRegistry(Set<CandidateFile> set) throws DicomException, IOException, NoSuchAlgorithmException, Exception {
        for (CandidateFile candidateFile : set) {
            if (!candidateFile.instanceHasBeenSent) {
                slf4jlogger.trace("sendFilesToRegistry(): attempting to send = " + candidateFile.fileName);
                this.sendFileToRegistry(candidateFile);
                slf4jlogger.trace("sendFilesToRegistry(): sending was successful = " + candidateFile.fileName);
                continue;
            }
            slf4jlogger.trace("sendFilesToRegistry(): already sent so not sending again = " + candidateFile.fileName);
        }
    }

    protected void makeSRFileAndSendFileToRegistry(CTDose cTDose) {
        block8: {
            try {
                AttributeList attributeList = cTDose.getAttributeList();
                File file = this.storedFilePathStrategy.makeReliableStoredFilePathWithFoldersCreated(this.savedImagesFolder, Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.SOPInstanceUID, "1.1.1.1"));
                String string = file.getCanonicalPath();
                cTDose.write(string, this.ourCalledAETitle, this.getClass().getCanonicalName());
                try {
                    slf4jlogger.debug("makeSRFileAndSendFileToRegistry(): sending our own newly created SR file = {}", string);
                    this.sendFileToRegistry(string);
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
                if (file == null) break block8;
                if (this.retainGeneratedRDSRFiles) {
                    this.databaseInformationModel.insertObject(attributeList, string, "C");
                    this.setSelectedDatabaseRecordIsRadiationDoseSR(string);
                    this.setSelectedDatabaseRecordHasBeenSentToRegistry(string);
                    break block8;
                }
                try {
                    if (!file.delete()) {
                        throw new DicomException("Failed to delete RDSR file that we created " + string);
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    protected void deleteFilesAndDatabaseRecords(Set<CandidateFile> set) throws DicomException, IOException {
        HashSet<String> hashSet = new HashSet<String>();
        for (CandidateFile object : set) {
            slf4jlogger.trace("deleteFilesAndDatabaseRecords(): deleting file " + object.fileName);
            if (!new File(object.fileName).delete()) {
                throw new DicomException("Failed to delete file " + object.fileName);
            }
            slf4jlogger.trace("deleteFilesAndDatabaseRecords(): deleting database instance " + object.localPrimaryKeyValue);
            this.databaseInformationModel.deleteRecord(InformationEntity.INSTANCE, object.localPrimaryKeyValue);
            if (object.localParentReference == null || object.localParentReference.length() <= 0) continue;
            hashSet.add(object.localParentReference);
        }
        for (String string : hashSet) {
            ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity.INSTANCE, string);
            if (arrayList == null || arrayList.isEmpty()) {
                slf4jlogger.trace("deleteFilesAndDatabaseRecords(): pruning empty series = {}", string);
                this.databaseInformationModel.deleteRecord(InformationEntity.SERIES, string);
                continue;
            }
            slf4jlogger.trace("deleteFilesAndDatabaseRecords(): surprisingly, series is not empty after deletion of instances = {}", string);
        }
    }

    protected void deleteFilesAndSetDatabaseRecordsToReferenced(Set<CandidateFile> set) throws DicomException, IOException {
        for (CandidateFile candidateFile : set) {
            slf4jlogger.trace("deleteFilesAndSetDatabaseRecordsToReferenced(): deleting file " + candidateFile.fileName);
            if (!new File(candidateFile.fileName).delete()) {
                throw new DicomException("Failed to delete file " + candidateFile.fileName);
            }
            slf4jlogger.trace("deleteFilesAndSetDatabaseRecordsToReferenced(): deleting database instance " + candidateFile.localPrimaryKeyValue);
            this.databaseInformationModel.updateSelectedRecord(InformationEntity.INSTANCE, candidateFile.localPrimaryKeyValue, this.instanceLocalFileReferenceTypeColumnName, "R");
            this.databaseInformationModel.updateSelectedRecord(InformationEntity.INSTANCE, candidateFile.localPrimaryKeyValue, this.instanceLocalFileNameColumnName, "NULL");
        }
    }

    protected long findCandidateFilesToSendToRegistry(InformationEntity informationEntity, String string, Set<CandidateFile> set, Set<CandidateFile> set2, Set<CandidateFile> set3, long l) throws DicomException {
        slf4jlogger.trace("findCandidateFilesToSendToRegistry(): mostRecentInsertionTime on entry = {}", l);
        if (informationEntity == InformationEntity.INSTANCE) {
            CandidateFile candidateFile = new CandidateFile(string);
            slf4jlogger.trace("findCandidateFilesToSendToRegistry(): mostRecentInsertionTime = {}", l);
            slf4jlogger.trace("findCandidateFilesToSendToRegistry(): candidateFile.insertionTime = " + candidateFile.insertionTime);
            if (candidateFile.insertionTime > l) {
                l = candidateFile.insertionTime;
            }
            if (candidateFile.isOKToSendToRegistry()) {
                slf4jlogger.debug("findCandidateFilesToSendToRegistry(): is RDSR fileName = " + candidateFile.fileName);
                if (candidateFile.wasLocallyCreated()) {
                    slf4jlogger.debug("findCandidateFilesToSendToRegistry(): was legacy extracted RDSR fileName = " + candidateFile.fileName);
                    set2.add(candidateFile);
                } else {
                    set.add(candidateFile);
                }
            } else if (candidateFile.isOKToOCR()) {
                slf4jlogger.debug("findCandidateFilesToSendToRegistry(): is dose screen fileName = " + candidateFile.fileName);
                set3.add(candidateFile);
            } else {
                slf4jlogger.debug("findCandidateFilesToSendToRegistry(): is not RDSR or dose screen fileName = " + candidateFile.fileName);
            }
        } else {
            InformationEntity informationEntity2 = this.databaseInformationModel.getChildTypeForParent(informationEntity);
            ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(informationEntity2, string);
            for (Map map : arrayList) {
                String string2 = (String)map.get(this.databaseInformationModel.getLocalPrimaryKeyColumnName(informationEntity2));
                slf4jlogger.trace("findCandidateFilesToSendToRegistry(): mostRecentInsertionTime before recursing = {}", l);
                l = this.findCandidateFilesToSendToRegistry(informationEntity2, string2, set, set2, set3, l);
                slf4jlogger.trace("findCandidateFilesToSendToRegistry(): mostRecentInsertionTime after recursing = {}", l);
            }
        }
        return l;
    }

    protected boolean findSuitableSRFilesAndSendThemToRegistry(String string) throws DicomException, IOException, NoSuchAlgorithmException, Exception {
        boolean bl = false;
        HashSet<CandidateFile> hashSet = new HashSet<CandidateFile>();
        HashSet<CandidateFile> hashSet2 = new HashSet<CandidateFile>();
        HashSet<CandidateFile> hashSet3 = new HashSet<CandidateFile>();
        long l = this.findCandidateFilesToSendToRegistry(InformationEntity.STUDY, string, hashSet, hashSet2, hashSet3, 0L);
        long l2 = System.currentTimeMillis();
        slf4jlogger.trace("findSuitableSRFilesAndSendThemToRegistry(): currentTimeMillis = {}", l2);
        slf4jlogger.trace("findSuitableSRFilesAndSendThemToRegistry(): mostRecentInsertionTime = {}", l);
        long l3 = (l2 - l) / 1000L;
        slf4jlogger.trace("findSuitableSRFilesAndSendThemToRegistry(): secondsSinceMostRecentInsertion = {}", l3);
        if (l3 > (long)intervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy) {
            slf4jlogger.debug("findSuitableSRFilesAndSendThemToRegistry(): processing, since old enough");
            if (hashSet.isEmpty()) {
                if (hashSet2.isEmpty()) {
                    if (!hashSet3.isEmpty()) {
                        LinkedList<String> linkedList = new LinkedList<String>();
                        for (CandidateFile object2 : hashSet3) {
                            linkedList.add(object2.fileName);
                        }
                        OCR oCR = new OCR(linkedList);
                        CTDose cTDose = OCR.getCTDoseFromOCROfDoseScreen(oCR, null, true);
                        if (cTDose != null) {
                            slf4jlogger.debug("findSuitableSRFilesAndSendThemToRegistry(): sending our newly OCRd legacy extracted SR file (made from {} screens)", linkedList.size());
                            this.makeSRFileAndSendFileToRegistry(cTDose);
                            if (!this.retainSourceFilesUsedForSRGeneration) {
                                try {
                                    this.deleteFilesAndSetDatabaseRecordsToReferenced(hashSet3);
                                }
                                catch (Exception exception) {
                                    slf4jlogger.error("", exception);
                                }
                            }
                        }
                    }
                } else {
                    slf4jlogger.debug("findSuitableSRFilesAndSendThemToRegistry(): sending our previously created legacy extracted SR files");
                    this.sendFilesToRegistry(hashSet2);
                }
            } else {
                slf4jlogger.debug("findSuitableSRFilesAndSendThemToRegistry(): sending manufacturer's SR files");
                this.sendFilesToRegistry(hashSet);
            }
            if (!this.retainGeneratedRDSRFiles && !hashSet2.isEmpty()) {
                try {
                    this.deleteFilesAndDatabaseRecords(hashSet2);
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
            bl = true;
        } else {
            slf4jlogger.debug("findSuitableSRFilesAndSendThemToRegistry(): not processing, since too recent");
        }
        return bl;
    }

    protected void setSelectedDatabaseRecordIsRadiationDoseSR(String string) throws DicomException {
        slf4jlogger.trace("setSelectedDatabaseRecordIsRadiationDoseSR.run(): filename: {}", string);
        ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(InformationEntity.INSTANCE, this.instanceLocalFileNameColumnName, string);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("setSelectedDatabaseRecordIsRadiationDoseSR.run(): records.size() = " + arrayList.size());
        }
        for (Map map : arrayList) {
            String string2 = (String)map.get(this.instanceLocalPrimaryKeyColumnName);
            slf4jlogger.trace("setSelectedDatabaseRecordIsRadiationDoseSR.run(): localPrimaryKeyValue = {}", string2);
            if (string2 == null || string2.length() <= 0) continue;
            this.databaseInformationModel.updateSelectedRecord(InformationEntity.INSTANCE, string2, this.instanceIsRadiationDoseSRColumnName, "TRUE");
        }
    }

    protected void setSelectedDatabaseRecordIsRadiationDoseScreen(String string) throws DicomException {
        slf4jlogger.trace("setSelectedDatabaseRecordIsRadiationDoseScreen.run(): filename: {}", string);
        ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(InformationEntity.INSTANCE, this.instanceLocalFileNameColumnName, string);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("setSelectedDatabaseRecordIsRadiationDoseScreen.run(): records.size() = " + arrayList.size());
        }
        for (Map map : arrayList) {
            String string2 = (String)map.get(this.instanceLocalPrimaryKeyColumnName);
            slf4jlogger.trace("setSelectedDatabaseRecordIsRadiationDoseScreen.run(): localPrimaryKeyValue = {}", string2);
            if (string2 == null || string2.length() <= 0) continue;
            this.databaseInformationModel.updateSelectedRecord(InformationEntity.INSTANCE, string2, this.instanceIsRadiationDoseScreenColumnName, "TRUE");
        }
    }

    protected void setSelectedDatabaseRecordIsExposureDoseSequence(String string) throws DicomException {
        slf4jlogger.trace("setSelectedDatabaseRecordIsExposureDoseSequence.run(): filename: {}", string);
        ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(InformationEntity.INSTANCE, this.instanceLocalFileNameColumnName, string);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("setSelectedDatabaseRecordIsExposureDoseSequence.run(): records.size() = " + arrayList.size());
        }
        for (Map map : arrayList) {
            String string2 = (String)map.get(this.instanceLocalPrimaryKeyColumnName);
            slf4jlogger.trace("setSelectedDatabaseRecordIsExposureDoseSequence.run(): localPrimaryKeyValue = {}", string2);
            if (string2 == null || string2.length() <= 0) continue;
            this.databaseInformationModel.updateSelectedRecord(InformationEntity.INSTANCE, string2, this.instanceIsExposureDoseSequenceColumnName, "TRUE");
        }
    }

    protected void setSelectedDatabaseRecordHasBeenSentToRegistry(String string) throws DicomException {
        slf4jlogger.trace("setSelectedDatabaseRecordHasBeenSentToRegistry.run(): filename: {}", string);
        ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(InformationEntity.INSTANCE, this.instanceLocalFileNameColumnName, string);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("setSelectedDatabaseRecordHasBeenSentToRegistry.run(): records.size() = " + arrayList.size());
        }
        for (Map map : arrayList) {
            String string2 = (String)map.get(this.instanceLocalPrimaryKeyColumnName);
            slf4jlogger.trace("setSelectedDatabaseRecordHasBeenSentToRegistry.run(): localPrimaryKeyValue = {}", string2);
            if (string2 == null || string2.length() <= 0) continue;
            this.databaseInformationModel.updateSelectedRecord(InformationEntity.INSTANCE, string2, this.instanceHasBeenSentToRegistryColumnName, "TRUE");
        }
    }

    protected boolean alreadyHaveIt(AttributeList attributeList) throws DicomException {
        boolean bl = false;
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
        if (string != null) {
            ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.INSTANCE, string);
            bl = !arrayList.isEmpty();
            slf4jlogger.trace("alreadyHaveIt(): Do " + (bl ? "" : "not ") + "have INSTANCE " + string);
        } else {
            string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SeriesInstanceUID);
            if (string != null) {
                ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.SERIES, string);
                bl = !arrayList.isEmpty();
                slf4jlogger.trace("alreadyHaveIt(): Do " + (bl ? "" : "not ") + "have SERIES " + string);
            } else {
                string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyInstanceUID);
                if (string != null) {
                    ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.STUDY, string);
                    bl = !arrayList.isEmpty();
                    slf4jlogger.trace("alreadyHaveIt(): Do " + (bl ? "" : "not ") + "have STUDY " + string);
                }
            }
        }
        return bl;
    }

    public DoseReporterWithLegacyOCRAndAutoSendToRegistry(String string) throws DicomException, DicomNetworkException, IOException, InterruptedException, FTPException {
        this.loadProperties(string);
        this.retainDeidentifiedFiles = Boolean.parseBoolean(this.properties.getProperty(propertyName_RetainDeidentifiedFiles, this.defaultRetainDeidentifiedFiles));
        this.retainGeneratedRDSRFiles = Boolean.parseBoolean(this.properties.getProperty(propertyName_RetainGeneratedRDSRFiles, this.defaultRetainGeneratedRDSRFiles));
        this.retainSourceFilesUsedForSRGeneration = Boolean.parseBoolean(this.properties.getProperty(propertyName_RetainSourceFilesUsedForSRGeneration, this.defaultRetainSourceFilesUsedForSRGeneration));
        sleepTimeBetweenPassesToProcessReceivedFiles = Integer.valueOf(this.properties.getProperty(propertyName_SleepTimeBetweenPassesToProcessReceivedFiles, this.defaultSleepTimeBetweenPassesToProcessReceivedFiles));
        intervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy = Integer.valueOf(this.properties.getProperty(propertyName_IntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy, this.defaultIntervalAfterLastInstanceReceivedToWaitBeforeProcessingStudy));
        sleepTimeBetweenPassesToQueryRemoteAEs = Integer.valueOf(this.properties.getProperty(propertyName_SleepTimeBetweenPassesToQueryRemoteAEs, this.defaultSleepTimeBetweenPassesToQueryRemoteAEs));
        daysBackwardsFromTodayToQuery = Integer.valueOf(this.properties.getProperty(propertyName_DaysBackwardsFromTodayToQuery, this.defaultDaysBackwardsFromTodayToQuery));
        DatabaseApplicationProperties databaseApplicationProperties = new DatabaseApplicationProperties(this.properties);
        this.savedImagesFolder = databaseApplicationProperties.getSavedImagesFolderCreatingItIfNecessary();
        this.databaseInformationModel = new OurPatientStudySeriesInstanceModel(databaseApplicationProperties.getDatabaseFileName(), databaseApplicationProperties.getDatabaseServerName());
        this.studyInstanceUIDColumnName = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.StudyInstanceUID);
        this.sopClassUIDColumnName = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.SOPClassUID);
        this.manufacturerColumnName = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.Manufacturer);
        this.imageTypeColumnName = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.ImageType);
        this.instanceCreatorUIDColumnName = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.InstanceCreatorUID);
        this.sourceApplicationEntityTitleColumnName = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.SourceApplicationEntityTitle);
        this.instanceLocalParentReferenceColumnName = this.databaseInformationModel.getLocalParentReferenceColumnName(InformationEntity.INSTANCE);
        this.instanceLocalFileNameColumnName = this.databaseInformationModel.getLocalFileNameColumnName(InformationEntity.INSTANCE);
        this.instanceLocalFileReferenceTypeColumnName = this.databaseInformationModel.getLocalFileReferenceTypeColumnName(InformationEntity.INSTANCE);
        this.instanceLocalPrimaryKeyColumnName = this.databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.INSTANCE);
        FTPApplicationProperties fTPApplicationProperties = new FTPApplicationProperties(this.properties);
        String string2 = this.properties.getProperty(propertyName_SelectedDoseRegistry);
        this.remoteHost = fTPApplicationProperties.getFTPRemoteHostInformation().getRemoteHost(string2);
        this.networkApplicationProperties = new NetworkApplicationProperties(this.properties, true);
        this.networkApplicationInformation = new NetworkApplicationInformationFederated();
        this.networkApplicationInformation.startupAllKnownSourcesAndRegister(this.networkApplicationProperties);
        this.ourCalledAETitle = this.networkApplicationProperties.getCalledAETitle();
        this.remoteAEsForQuery = new ArrayList<String>();
        String string3 = this.properties.getProperty(propertyName_RemoteAEsForQuery);
        if (string3 != null && string3.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, propertyDelimitersForTokenizer_RemoteAEsForQuery);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                this.remoteAEsForQuery.add(string4);
            }
        }
        slf4jlogger.trace("Starting up DICOM association listener ...");
        int n = this.networkApplicationProperties.getListeningPort();
        new Thread(new StorageSOPClassSCPDispatcher(n, this.ourCalledAETitle, this.networkApplicationProperties.getAcceptorMaximumLengthReceived(), this.networkApplicationProperties.getAcceptorSocketReceiveBufferSize(), this.networkApplicationProperties.getAcceptorSocketSendBufferSize(), this.savedImagesFolder, this.storedFilePathStrategy, new OurReceivedObjectHandler(), this.databaseInformationModel.getQueryResponseGeneratorFactory(), this.databaseInformationModel.getRetrieveResponseGeneratorFactory(), this.networkApplicationInformation, false)).start();
        new Thread(new WatchDatabaseAndSendToRegistry()).start();
        new Thread(new WatchRemoteAEsForNewDoseInformation()).start();
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray.length > 0 ? stringArray[0] : FileUtilities.makePathToFileInUsersHomeDirectory(defaultPropertiesFileName);
            new DoseReporterWithLegacyOCRAndAutoSendToRegistry(string);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurPatientStudySeriesInstanceModel
    extends MinimalPatientStudySeriesInstanceModel {
        OurPatientStudySeriesInstanceModel(String string, String string2) throws DicomException {
            super(string, string2);
        }

        @Override
        protected void extendCreateStatementStringWithUserColumns(StringBuffer stringBuffer, InformationEntity informationEntity) {
            if (informationEntity == InformationEntity.STUDY) {
                stringBuffer.append(", ");
                stringBuffer.append(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.studyHasBeenProcessedColumnName);
                stringBuffer.append(" ");
                stringBuffer.append("BOOLEAN");
            } else if (informationEntity == InformationEntity.INSTANCE) {
                stringBuffer.append(", ");
                stringBuffer.append(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.instanceHasBeenSentToRegistryColumnName);
                stringBuffer.append(" ");
                stringBuffer.append("BOOLEAN");
                stringBuffer.append(", ");
                stringBuffer.append(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.instanceIsRadiationDoseSRColumnName);
                stringBuffer.append(" ");
                stringBuffer.append("BOOLEAN");
                stringBuffer.append(", ");
                stringBuffer.append(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.instanceIsRadiationDoseScreenColumnName);
                stringBuffer.append(" ");
                stringBuffer.append("BOOLEAN");
                stringBuffer.append(", ");
                stringBuffer.append(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.instanceIsExposureDoseSequenceColumnName);
                stringBuffer.append(" ");
                stringBuffer.append("BOOLEAN");
            }
        }
    }

    protected class WatchRemoteAEsForNewDoseInformation
    implements Runnable {
        protected WatchRemoteAEsForNewDoseInformation() {
        }

        @Override
        public void run() {
            long l = (long)daysBackwardsFromTodayToQuery * 86400000L;
            boolean bl = false;
            while (!bl) {
                slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): Starting or waking up ... ");
                try {
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - l;
                    for (long i = l2; i >= l3; i -= 86400000L) {
                        String string = new SimpleDateFormat("yyyyMMdd").format(new Date(i));
                        slf4jlogger.debug("WatchRemoteAEsForNewDoseInformation.run(): Query for all studies dated " + string + " on " + DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.remoteAEsForQuery);
                        for (String string2 : DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.remoteAEsForQuery) {
                            Object object;
                            ArrayList<QueryTreeRecord> arrayList;
                            Object object2;
                            Object object3;
                            StudyRootQueryInformationModel studyRootQueryInformationModel = null;
                            if (string2 != null && string2.length() > 0 && DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.networkApplicationProperties != null && DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.networkApplicationInformation != null) {
                                try {
                                    object3 = DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.networkApplicationProperties.getCallingAETitle();
                                    object2 = DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string2);
                                    arrayList = DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress((String)object2);
                                    if (arrayList == null) {
                                        throw new Exception("For remote query AE <" + string2 + ">, presentationAddress cannot be determined");
                                    }
                                    String string3 = ((PresentationAddress)((Object)arrayList)).getHostname();
                                    int n = ((PresentationAddress)((Object)arrayList)).getPort();
                                    object = DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.networkApplicationInformation.getApplicationEntityMap().getQueryModel((String)object2);
                                    if (!NetworkApplicationProperties.isStudyRootQueryModel((String)object) && object != null) {
                                        throw new Exception("For remote query AE <" + string2 + ">, query model " + (String)object + " not supported");
                                    }
                                    studyRootQueryInformationModel = new StudyRootQueryInformationModel(string3, n, (String)object2, (String)object3);
                                    slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): Performing query on {} ...", studyRootQueryInformationModel);
                                }
                                catch (Exception exception) {
                                    slf4jlogger.error("", exception);
                                }
                            }
                            if (studyRootQueryInformationModel == null) continue;
                            try {
                                object3 = new AttributeList();
                                object2 = TagFromName.ModalitiesInStudy;
                                arrayList = new CodeStringAttribute((AttributeTag)object2);
                                ((Attribute)((Object)arrayList)).addValue("CT");
                                ((Attribute)((Object)arrayList)).addValue("SR");
                                ((AttributeList)object3).put((AttributeTag)object2, (Attribute)((Object)arrayList));
                                object2 = TagFromName.StudyDate;
                                arrayList = new DateAttribute((AttributeTag)object2);
                                ((Attribute)((Object)arrayList)).addValue(string);
                                ((AttributeList)object3).put((AttributeTag)object2, (Attribute)((Object)arrayList));
                                object2 = TagFromName.SeriesNumber;
                                arrayList = new IntegerStringAttribute((AttributeTag)object2);
                                ((AttributeList)object3).put((AttributeTag)object2, (Attribute)((Object)arrayList));
                                object2 = TagFromName.Modality;
                                arrayList = new CodeStringAttribute((AttributeTag)object2);
                                ((AttributeList)object3).put((AttributeTag)object2, (Attribute)((Object)arrayList));
                                object2 = TagFromName.ImageType;
                                arrayList = new CodeStringAttribute((AttributeTag)object2);
                                ((AttributeList)object3).put((AttributeTag)object2, (Attribute)((Object)arrayList));
                                object2 = TagFromName.StudyInstanceUID;
                                arrayList = new UniqueIdentifierAttribute((AttributeTag)object2);
                                ((AttributeList)object3).put((AttributeTag)object2, (Attribute)((Object)arrayList));
                                object2 = TagFromName.SeriesInstanceUID;
                                arrayList = new UniqueIdentifierAttribute((AttributeTag)object2);
                                ((AttributeList)object3).put((AttributeTag)object2, (Attribute)((Object)arrayList));
                                object2 = TagFromName.SOPInstanceUID;
                                arrayList = new UniqueIdentifierAttribute((AttributeTag)object2);
                                ((AttributeList)object3).put((AttributeTag)object2, (Attribute)((Object)arrayList));
                                object2 = TagFromName.SOPClassUID;
                                arrayList = new UniqueIdentifierAttribute((AttributeTag)object2);
                                ((AttributeList)object3).put((AttributeTag)object2, (Attribute)((Object)arrayList));
                                object2 = studyRootQueryInformationModel.performHierarchicalQuery((AttributeList)object3);
                                if (slf4jlogger.isTraceEnabled()) {
                                    slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): Query result=\n{}", ((QueryTreeModel)object2).toString());
                                }
                                if ((arrayList = DoseUtility.findDoseSeriesRecordsInQueryTree((QueryTreeRecord)((QueryTreeModel)object2).getRoot(), new ArrayList<QueryTreeRecord>())) == null) continue;
                                for (QueryTreeRecord queryTreeRecord : arrayList) {
                                    object = queryTreeRecord.getUniqueKeys();
                                    Attribute attribute = queryTreeRecord.getUniqueKey();
                                    AttributeList attributeList = queryTreeRecord.getAllAttributesReturnedInIdentifier();
                                    if (slf4jlogger.isTraceEnabled()) {
                                        slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): uniqueKeys:\n{}", ((AttributeList)object).toString());
                                    }
                                    if (slf4jlogger.isTraceEnabled()) {
                                        slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): uniqueKey: {}", attribute.toString());
                                    }
                                    if (slf4jlogger.isTraceEnabled()) {
                                        slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): queryIdentifier:\n{}", attributeList.toString());
                                    }
                                    String string4 = DoseUtility.getQueryRetrieveAEFromIdentifier(attributeList, studyRootQueryInformationModel);
                                    String string5 = DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string4);
                                    String string6 = DoseUtility.getQueryRetrieveLevel(attributeList, attribute);
                                    if (object == null) continue;
                                    if (!DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.alreadyHaveIt((AttributeList)object)) {
                                        AttributeList attributeList2 = new AttributeList();
                                        attributeList2.putAll(object);
                                        AttributeTag attributeTag = TagFromName.QueryRetrieveLevel;
                                        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(attributeTag);
                                        ((Attribute)codeStringAttribute).addValue(string6);
                                        attributeList2.put(attributeTag, codeStringAttribute);
                                        if (slf4jlogger.isTraceEnabled()) {
                                            slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): retrieveIdentifier:\n{}", attributeList2);
                                        }
                                        studyRootQueryInformationModel.performHierarchicalMoveFrom(attributeList2, string4);
                                        continue;
                                    }
                                    if (!slf4jlogger.isTraceEnabled()) continue;
                                    slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): already have it so not retrieving again:\n{}", ((AttributeList)object).toString());
                                }
                            }
                            catch (Exception exception) {
                                slf4jlogger.error("", exception);
                            }
                        }
                    }
                    slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): sleeping for {} seconds", sleepTimeBetweenPassesToQueryRemoteAEs);
                    Thread.currentThread();
                    Thread.sleep(sleepTimeBetweenPassesToQueryRemoteAEs * 1000);
                }
                catch (InterruptedException interruptedException) {
                    slf4jlogger.trace("WatchRemoteAEsForNewDoseInformation.run(): interrupted: {}", interruptedException);
                    bl = true;
                }
            }
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                slf4jlogger.debug("Received: " + string + " from " + string3 + " in " + string2);
                try {
                    new Thread(new ReceivedFileProcessor(string)).start();
                }
                catch (Exception exception) {
                    slf4jlogger.error("Unable to process {} received from {} in {}", string, string3, string2, exception);
                }
            }
        }
    }

    protected class ReceivedFileProcessor
    implements Runnable {
        String receivedFileName;
        AttributeList list;

        ReceivedFileProcessor(String string) {
            this.receivedFileName = string;
        }

        @Override
        public void run() {
            try {
                slf4jlogger.trace("ReceivedFileProcessor.run(): receivedFileName = {}", this.receivedFileName);
                FileInputStream fileInputStream = new FileInputStream(this.receivedFileName);
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream, TagFromName.PixelData);
                dicomInputStream.close();
                fileInputStream.close();
                boolean bl = false;
                String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                if (string.equals("1.2.840.10008.5.1.4.1.1.88.67")) {
                    slf4jlogger.debug("ReceivedFileProcessor.run(): is RDSR SOP Class");
                    bl = true;
                    DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.setSelectedDatabaseRecordIsRadiationDoseSR(this.receivedFileName);
                } else if (attributeList.isSRDocument() && SOPClass.isStructuredReport(string)) {
                    slf4jlogger.debug("ReceivedFileProcessor.run(): is SR SOP Class");
                    boolean bl2 = false;
                    CodedSequenceItem codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.ConceptNameCodeSequence);
                    if (codedSequenceItem != null) {
                        String string2 = codedSequenceItem.getCodingSchemeDesignator();
                        String string3 = codedSequenceItem.getCodeValue();
                        if (string2 != null && string2.equals("DCM") && string3 != null && string3.equals("113701")) {
                            slf4jlogger.debug("ReceivedFileProcessor.run(): is SR SOP Class with X-Ray Radiation Dose Report document title");
                            bl = true;
                            DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.insertObject(attributeList, this.receivedFileName, "C");
                            DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.setSelectedDatabaseRecordIsRadiationDoseSR(this.receivedFileName);
                        }
                    }
                } else if (OCR.isDoseScreenInstance(attributeList)) {
                    slf4jlogger.debug("ReceivedFileProcessor.run(): isDoseScreenInstance - adding to database for deferred OCR");
                    bl = true;
                    DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.insertObject(attributeList, this.receivedFileName, "C");
                    DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.setSelectedDatabaseRecordIsRadiationDoseScreen(this.receivedFileName);
                } else if (ExposureDoseSequence.isPhilipsDoseScreenInstance(attributeList)) {
                    CTDose cTDose;
                    slf4jlogger.debug("ReceivedFileProcessor.run(): isPhilipsDoseScreenInstance");
                    if (DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.retainSourceFilesUsedForSRGeneration) {
                        bl = true;
                        DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.insertObject(attributeList, this.receivedFileName, "C");
                        DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.setSelectedDatabaseRecordIsExposureDoseSequence(this.receivedFileName);
                    }
                    if ((cTDose = ExposureDoseSequence.getCTDoseFromExposureDoseSequence(attributeList, null, true)) != null) {
                        AttributeList attributeList2 = cTDose.getAttributeList();
                        File file = DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.storedFilePathStrategy.makeReliableStoredFilePathWithFoldersCreated(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.savedImagesFolder, Attribute.getSingleStringValueOrDefault(attributeList2, TagFromName.SOPInstanceUID, "1.1.1.1"));
                        String string4 = file.getCanonicalPath();
                        slf4jlogger.debug("ReceivedFileProcessor.run(): adding our own newly created SR file = {}", string4);
                        cTDose.write(string4, DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.ourCalledAETitle, this.getClass().getCanonicalName());
                        DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.insertObject(attributeList2, string4, "C");
                        DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.setSelectedDatabaseRecordIsRadiationDoseSR(string4);
                    }
                } else {
                    slf4jlogger.debug("ReceivedFileProcessor.run(): received file that we couldn't extract from {}", this.receivedFileName);
                }
                if (!bl) {
                    DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.insertObject(attributeList, "NULL", "R");
                    if (!new File(this.receivedFileName).delete()) {
                        throw new DicomException("Failed to delete received SR file that was not an RDSR " + this.receivedFileName);
                    }
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    protected class WatchDatabaseAndSendToRegistry
    implements Runnable {
        protected WatchDatabaseAndSendToRegistry() {
        }

        @Override
        public void run() {
            boolean bl = false;
            while (!bl) {
                slf4jlogger.trace("WatchDatabaseAndSendToRegistry.run(): Starting or waking up WatchDatabaseAndSendToRegistry ...");
                try {
                    ArrayList arrayList = DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntity(InformationEntity.STUDY);
                    for (Map map : arrayList) {
                        boolean bl2;
                        String string2;
                        if (slf4jlogger.isTraceEnabled()) {
                            slf4jlogger.trace("STUDY:");
                            for (String string2 : map.keySet()) {
                                slf4jlogger.trace("\t{} = {}", string2, map.get(string2));
                            }
                        }
                        String string3 = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.getLocalPrimaryKeyColumnName(InformationEntity.STUDY));
                        string2 = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.studyHasBeenProcessedColumnName);
                        boolean bl3 = bl2 = string2 != null && string2.toUpperCase(Locale.US).equals("TRUE");
                        if (bl2) {
                            if (!slf4jlogger.isTraceEnabled()) continue;
                            slf4jlogger.trace("WatchDatabaseAndSendToRegistry.run(): Already processed {}", map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.studyInstanceUIDColumnName));
                            continue;
                        }
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("WatchDatabaseAndSendToRegistry.run(): Processing {}", map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.studyInstanceUIDColumnName));
                        }
                        try {
                            if (!DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.findSuitableSRFilesAndSendThemToRegistry(string3)) continue;
                            DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.updateSelectedRecord(InformationEntity.STUDY, string3, DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.studyHasBeenProcessedColumnName, "TRUE");
                        }
                        catch (Exception exception) {
                            slf4jlogger.error("", exception);
                        }
                    }
                    slf4jlogger.trace("WatchDatabaseAndSendToRegistry.run(): sleeping for " + sleepTimeBetweenPassesToProcessReceivedFiles + " seconds");
                    Thread.currentThread();
                    Thread.sleep(sleepTimeBetweenPassesToProcessReceivedFiles * 1000);
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                }
                catch (InterruptedException interruptedException) {
                    slf4jlogger.trace("WatchDatabaseAndSendToRegistry.run(): interrupted: {}", interruptedException);
                    bl = true;
                }
            }
        }
    }

    protected class CandidateFile {
        String localPrimaryKeyValue;
        String localParentReference;
        String fileName;
        long insertionTime;
        String sopClassUID;
        String instanceCreatorUID;
        String sourceApplicationEntityTitle;
        String manufacturer;
        String imageType;
        boolean instanceHasBeenSent;
        boolean isRadiationDoseSR;
        boolean isRadiationDoseScreen;

        CandidateFile(String string) throws DicomException {
            this.localPrimaryKeyValue = string;
            slf4jlogger.trace("CandidateFile(): localPrimaryKeyValue = {}", string);
            Map map = DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.findAllAttributeValuesForSelectedRecord(InformationEntity.INSTANCE, string);
            this.localParentReference = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.instanceLocalParentReferenceColumnName);
            slf4jlogger.trace("CandidateFile(): localParentReference = {}", this.localParentReference);
            this.fileName = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.getLocalFileNameColumnName(InformationEntity.INSTANCE));
            slf4jlogger.trace("CandidateFile(): fileName = {}", this.fileName);
            String string2 = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.databaseInformationModel.getLocalRecordInsertionTimeColumnName(InformationEntity.INSTANCE));
            if (string2 == null) {
                this.insertionTime = 0L;
            } else {
                try {
                    this.insertionTime = Long.parseLong(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    slf4jlogger.error("", numberFormatException);
                    this.insertionTime = 0L;
                }
            }
            slf4jlogger.trace("CandidateFile(): insertionTime = {}", this.insertionTime);
            this.sopClassUID = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.sopClassUIDColumnName);
            slf4jlogger.trace("CandidateFile(): sopClassUID = {}", this.sopClassUID);
            this.instanceCreatorUID = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.instanceCreatorUIDColumnName);
            slf4jlogger.trace("CandidateFile(): instanceCreatorUID = {}", this.instanceCreatorUID);
            this.sourceApplicationEntityTitle = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.sourceApplicationEntityTitleColumnName);
            slf4jlogger.trace("CandidateFile(): sourceApplicationEntityTitle = {}", this.sourceApplicationEntityTitle);
            this.manufacturer = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.manufacturerColumnName);
            slf4jlogger.trace("CandidateFile(): manufacturer = {}", this.manufacturer);
            this.imageType = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.imageTypeColumnName);
            slf4jlogger.trace("CandidateFile(): imageType = {}", this.imageType);
            String string3 = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.instanceHasBeenSentToRegistryColumnName);
            this.instanceHasBeenSent = string3 != null && string3.toUpperCase(Locale.US).equals("TRUE");
            slf4jlogger.trace("CandidateFile(): instanceHasBeenSent = {}", this.instanceHasBeenSent);
            String string4 = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.instanceIsRadiationDoseSRColumnName);
            this.isRadiationDoseSR = string4 != null && string4.toUpperCase(Locale.US).equals("TRUE");
            slf4jlogger.trace("CandidateFile(): isRadiationDoseSR = {}", this.isRadiationDoseSR);
            String string5 = (String)map.get(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.instanceIsRadiationDoseScreenColumnName);
            this.isRadiationDoseScreen = string5 != null && string5.toUpperCase(Locale.US).equals("TRUE");
            slf4jlogger.trace("CandidateFile(): isRadiationDoseScreen = {}", this.isRadiationDoseScreen);
        }

        boolean isOKToOCR() {
            return this.isRadiationDoseScreen;
        }

        boolean isOKToSendToRegistry() {
            return this.isRadiationDoseSR && this.sopClassUID != null && SOPClass.isStructuredReport(this.sopClassUID);
        }

        boolean wasLocallyCreated() {
            return this.instanceCreatorUID != null && this.instanceCreatorUID.equals("1.3.6.1.4.1.5962.99.3") && this.sourceApplicationEntityTitle != null && this.sourceApplicationEntityTitle.equals(DoseReporterWithLegacyOCRAndAutoSendToRegistry.this.ourCalledAETitle);
        }
    }
}

