/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DatabaseTreeBrowser;
import com.pixelmed.database.DatabaseTreeRecord;
import com.pixelmed.database.MinimalPatientStudySeriesInstanceModel;
import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.DialogMessageLogger;
import com.pixelmed.display.DicomBrowser;
import com.pixelmed.display.SafeCursorChanger;
import com.pixelmed.display.SafeFileChooser;
import com.pixelmed.display.SafeProgressBarUpdaterThread;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.ftp.FTPApplicationProperties;
import com.pixelmed.ftp.FTPClientApplicationConfigurationDialog;
import com.pixelmed.ftp.FTPFileSender;
import com.pixelmed.ftp.FTPRemoteHost;
import com.pixelmed.ftp.FTPRemoteHostInformation;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MultipleInstanceTransferStatusHandlerWithFileName;
import com.pixelmed.network.NetworkApplicationConfigurationDialog;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.network.TransferSyntaxSelectionPolicy;
import com.pixelmed.network.UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeBrowser;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CapabilitiesAvailable;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.MessageLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DownloadOrTransmit
extends ApplicationFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/DownloadOrTransmit.java,v 1.24 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DownloadOrTransmit.class);
    protected static String propertiesFileName = ".com.pixelmed.apps.DownloadOrTransmit.properties";
    protected static String propertyName_DicomCurrentlySelectedStorageTargetAE = "Dicom.CurrentlySelectedStorageTargetAE";
    protected static String propertyName_DicomCurrentlySelectedQueryTargetAE = "Dicom.CurrentlySelectedQueryTargetAE";
    protected static String propertyName_CurrentlySelectedFtpTarget = "DownloadOrTransmit.CurrentlySelectedFtpTarget";
    protected static String localDatabaseName = "Local";
    protected static String localDatabaseServerName = "DownloadOrTransmit";
    protected static String rootNameForDicomInstanceFilesOnInterchangeMedia = "DICOM";
    protected static String filePrefixForDicomInstanceFilesOnInterchangeMedia = "I";
    protected static String fileSuffixForDicomInstanceFilesOnInterchangeMedia = "";
    protected static String nameForDicomDirectoryOnInterchangeMedia = "DICOMDIR";
    protected static String exportedZipFileName = "export.zip";
    protected static int textFieldLengthForQueryPatientName = 16;
    protected static int textFieldLengthForQueryPatientID = 10;
    protected static int textFieldLengthForQueryStudyDate = 8;
    protected static String queryIntroductionLabelText = "Query -";
    protected static String queryPatientNameLabelText = "Patient's Name:";
    protected static String queryPatientIDLabelText = "Patient's ID:";
    protected static String queryStudyDateLabelText = "Study Date:";
    protected static String configureButtonLabel = "Configure";
    protected static String logButtonLabel = "Log";
    protected static String queryButtonLabel = "Query";
    protected static String retrieveButtonLabel = "Retrieve";
    protected static String importButtonLabel = "Open";
    protected static String viewButtonLabel = "View";
    protected static String exportButtonLabel = "->Save";
    protected static String sendButtonLabel = "->Dicom";
    protected static String ftpButtonLabel = "->Ftp";
    protected static String purgeButtonLabel = "Purge";
    protected static String configureButtonToolTipText = "Configure the application, including DICOM network properties";
    protected static String logButtonToolTipText = "Show the log of activities";
    protected static String queryButtonToolTipText = "Query a remote DICOM network host";
    protected static String retrieveButtonToolTipText = "Retrieve query selection from remote DICOM network host";
    protected static String importButtonToolTipText = "Open files and import them for sending";
    protected static String viewButtonToolTipText = "View image";
    protected static String exportButtonToolTipText = "exportButtonToolTipText";
    protected static String sendButtonToolTipText = "Send to remote DICOM host";
    protected static String ftpButtonToolTipText = "Send to remote FTP site";
    protected static String purgeButtonToolTipText = "Remove selected entry from local database and delete any local copy of files";
    protected static String queryPatientNameToolTipText = "The text to use for the Patient's Name when querying";
    protected static String queryPatientIDToolTipText = "The text to use for the Patient's ID when querying";
    protected static String queryStudyDateToolTipText = "The text to use for the Study Date when querying";
    protected static String showDetailedLogLabelText = "Show detailed log";
    protected static String zipExportLabelText = "Zip exported files";
    protected static String hierarchicalExportLabelText = "Hierarchical names in export";
    protected static String addDicomDirectoryLabelText = "Include DICOMDIR in export";
    protected static String hierarchicalExportToolTipText = "Use descriptive Patient/Study/Series/Instance hierarchy of folder and file names (which are ILLEGAL on DICOM media and INVALID for CS VR in DICOMDIR)";
    protected static String addDicomDirectoryToolTipText = "Generate a DICOMDIR for the exported files (required to make a valid DICOM Fileset)";
    protected static String loggerTitleMessage = "Download Or Transmit Log";
    protected static int viewerFrameWidthWanted = 512;
    protected static int viewerFrameHeightWanted = 512;
    protected static int validatorFrameWidthWanted = 512;
    protected static int validatorFrameHeightWanted = 384;
    protected static int loggertDialogWidthWanted = 512;
    protected static int loggerDialogHeightWanted = 384;
    protected DatabaseInformationModel srcDatabase;
    protected JPanel srcDatabasePanel;
    protected JPanel remoteQueryRetrievePanel;
    protected JCheckBox showDetailedLogCheckBox;
    protected JCheckBox zipExportCheckBox;
    protected JCheckBox hierarchicalExportCheckBox;
    protected JCheckBox addDicomDirectoryCheckBox;
    protected JTextField queryFilterPatientNameTextField;
    protected JTextField queryFilterPatientIDTextField;
    protected JTextField queryFilterStudyDateTextField;
    protected SafeProgressBarUpdaterThread progressBarUpdater;
    protected SafeCursorChanger cursorChanger;
    protected MessageLogger logger;
    protected NetworkApplicationProperties networkApplicationProperties;
    protected NetworkApplicationInformation networkApplicationInformation;
    protected FTPApplicationProperties ftpApplicationProperties;
    protected FTPRemoteHostInformation ftpRemoteHostInformation;
    protected QueryInformationModel currentRemoteQueryInformationModel;
    protected QueryTreeBrowser currentRemoteQueryTreeBrowser;
    protected QueryTreeRecord currentRemoteQuerySelectionQueryTreeRecord;
    protected AttributeList currentRemoteQuerySelectionUniqueKeys;
    protected Attribute currentRemoteQuerySelectionUniqueKey;
    protected String currentRemoteQuerySelectionRetrieveAE;
    protected String currentRemoteQuerySelectionLevel;
    protected String ourCalledAETitle;
    protected File savedImagesFolder;
    protected StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher;
    protected DatabaseTreeRecord[] currentDatabaseTreeRecordSelections;
    protected String exportDirectoryPath;
    protected String importDirectoryPath;
    Thread activeThread;

    protected void setCurrentRemoteQueryInformationModel(String string) {
        this.currentRemoteQueryInformationModel = null;
        String string2 = "";
        if (string != null && string.length() > 0 && this.networkApplicationProperties != null && this.networkApplicationInformation != null) {
            try {
                String string3 = this.networkApplicationProperties.getCallingAETitle();
                String string4 = this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                PresentationAddress presentationAddress = this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string4);
                if (presentationAddress == null) {
                    throw new Exception("For remote query AE <" + string + ">, presentationAddress cannot be determined");
                }
                String string5 = presentationAddress.getHostname();
                int n = presentationAddress.getPort();
                String string6 = this.networkApplicationInformation.getApplicationEntityMap().getQueryModel(string4);
                if (!NetworkApplicationProperties.isStudyRootQueryModel(string6) && string6 != null) {
                    throw new Exception("For remote query AE <" + string + ">, query model " + string6 + " not supported");
                }
                this.currentRemoteQueryInformationModel = new StudyRootQueryInformationModel(string5, n, string4, string3);
                string2 = ":" + string;
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    private String showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(String string, String string2, String string3) {
        Set set;
        String string4 = string3;
        if (this.networkApplicationInformation != null && (set = this.networkApplicationInformation.getListOfLocalNamesOfApplicationEntities()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string4 = (String)JOptionPane.showInputDialog(this.getContentPane(), string, string2, 3, null, objectArray, string4);
        }
        return string4;
    }

    protected static void importFileIntoDatabase(DatabaseInformationModel databaseInformationModel, String string, String string2) throws FileNotFoundException, IOException, DicomException {
        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing: " + string));
        FileInputStream fileInputStream = new FileInputStream(string);
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
        AttributeList attributeList = new AttributeList();
        attributeList.read(dicomInputStream, TagFromName.PixelData);
        dicomInputStream.close();
        fileInputStream.close();
        databaseInformationModel.insertObject(attributeList, string, string2);
    }

    protected void activateStorageSCP() throws DicomException, IOException {
        if (this.networkApplicationProperties != null) {
            int n = this.networkApplicationProperties.getListeningPort();
            this.ourCalledAETitle = this.networkApplicationProperties.getCalledAETitle();
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Starting up DICOM association listener on port " + n + " AET " + this.ourCalledAETitle));
            slf4jlogger.info("Starting up DICOM association listener on port {} AET {}", n, this.ourCalledAETitle);
            this.storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, this.ourCalledAETitle, this.networkApplicationProperties.getAcceptorMaximumLengthReceived(), this.networkApplicationProperties.getAcceptorSocketReceiveBufferSize(), this.networkApplicationProperties.getAcceptorSocketSendBufferSize(), this.savedImagesFolder, StoredFilePathStrategy.BYSOPINSTANCEUIDINSINGLEFOLDER, new OurReceivedObjectHandler(), null, this.srcDatabase == null ? null : this.srcDatabase.getQueryResponseGeneratorFactory(), this.srcDatabase == null ? null : this.srcDatabase.getRetrieveResponseGeneratorFactory(), this.networkApplicationInformation, new OurPresentationContextSelectionPolicy(), false);
            new Thread(this.storageSOPClassSCPDispatcher).start();
        }
    }

    protected void activateTemporaryDatabases() throws DicomException {
        this.srcDatabase = new MinimalPatientStudySeriesInstanceModel("mem:src", localDatabaseServerName, localDatabaseName);
    }

    protected Vector getCurrentSourceFilePathSelections() {
        Vector vector = new Vector();
        if (this.currentDatabaseTreeRecordSelections != null) {
            for (DatabaseTreeRecord databaseTreeRecord : this.currentDatabaseTreeRecordSelections) {
                DatabaseTreeBrowser.recurseThroughChildrenGatheringFileNames(databaseTreeRecord, vector);
            }
        }
        return vector;
    }

    protected void purgeFilesAndDatabaseInformation(DatabaseTreeRecord[] databaseTreeRecordArray, MessageLogger messageLogger, SafeProgressBarUpdaterThread safeProgressBarUpdaterThread, int n, int n2) throws DicomException, IOException {
        if (databaseTreeRecordArray != null) {
            for (DatabaseTreeRecord databaseTreeRecord : databaseTreeRecordArray) {
                this.purgeFilesAndDatabaseInformation(databaseTreeRecord, messageLogger, safeProgressBarUpdaterThread, n, n2);
            }
        }
    }

    protected void purgeFilesAndDatabaseInformation(DatabaseTreeRecord databaseTreeRecord, MessageLogger messageLogger, SafeProgressBarUpdaterThread safeProgressBarUpdaterThread, int n, int n2) throws DicomException, IOException {
        if (databaseTreeRecord != null) {
            SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, n, n2);
            InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
            if (informationEntity == null || !informationEntity.equals(InformationEntity.INSTANCE)) {
                Enumeration enumeration = databaseTreeRecord.children();
                if (enumeration != null) {
                    n2 += databaseTreeRecord.getChildCount();
                    while (enumeration.hasMoreElements()) {
                        DatabaseTreeRecord databaseTreeRecord2 = (DatabaseTreeRecord)enumeration.nextElement();
                        if (databaseTreeRecord2 == null) continue;
                        this.purgeFilesAndDatabaseInformation(databaseTreeRecord2, messageLogger, safeProgressBarUpdaterThread, n, n2);
                        ++n;
                    }
                }
                if (informationEntity != null) {
                    if (this.showDetailedLogCheckBox.isSelected()) {
                        messageLogger.sendLn("Purging " + databaseTreeRecord);
                    }
                    databaseTreeRecord.removeFromParent();
                }
            } else {
                String string = databaseTreeRecord.getLocalFileNameValue();
                String string2 = databaseTreeRecord.getLocalFileReferenceTypeValue();
                if (string2 != null && string2.equals("C")) {
                    try {
                        if (this.showDetailedLogCheckBox.isSelected()) {
                            messageLogger.sendLn("Deleting file " + string);
                        }
                        if (!new File(string).delete()) {
                            messageLogger.sendLn("Failed to delete local copy of file " + string);
                        }
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Failed to delete local copy of file {}", string, exception);
                        messageLogger.sendLn("Failed to delete local copy of file " + string);
                    }
                }
                if (this.showDetailedLogCheckBox.isSelected()) {
                    messageLogger.sendLn("Purging " + databaseTreeRecord);
                }
                databaseTreeRecord.removeFromParent();
            }
        }
    }

    protected static String getSRDescriptionForLog(AttributeList attributeList) {
        return "Patient " + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID) + " Study " + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate) + " Accession " + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AccessionNumber);
    }

    protected static String makeNewFullyQualifiedInterchangeMediaInstancePathName(int n) throws IOException {
        return new File(rootNameForDicomInstanceFilesOnInterchangeMedia, filePrefixForDicomInstanceFilesOnInterchangeMedia + Integer.toString(n) + fileSuffixForDicomInstanceFilesOnInterchangeMedia).getPath();
    }

    protected static String makeNewFullyQualifiedHierarchicalInstancePathName(String string) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string, TagFromName.PixelData);
        String string2 = MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList);
        return new File(rootNameForDicomInstanceFilesOnInterchangeMedia, string2).getPath();
    }

    protected static void exportFiles(Vector<String> vector, File file, String string, SafeProgressBarUpdaterThread safeProgressBarUpdaterThread, MessageLogger messageLogger, boolean bl, boolean bl2, boolean bl3, String string2) {
        String string3 = string.replaceFirst("[aeiou]$", "") + "ing";
        String string4 = string.replaceFirst("[aeiou]$", "") + "ed";
        messageLogger.sendLn(string + " started");
        try {
            Object object;
            Object object2;
            int n = vector.size();
            SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, 0, n + 1);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                object2 = vector.get(i);
                object = bl3 ? DownloadOrTransmit.makeNewFullyQualifiedHierarchicalInstancePathName((String)object2) : DownloadOrTransmit.makeNewFullyQualifiedInterchangeMediaInstancePathName(i);
                File file2 = new File(file, (String)object);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(string3 + " " + (String)object));
                if (bl) {
                    messageLogger.sendLn(string3 + " " + (String)object2 + " to " + file2.getCanonicalPath());
                }
                file2.getParentFile().mkdirs();
                CopyStream.copy(new File((String)object2), file2);
                stringArray[i] = object;
                SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, i + 1);
            }
            if (bl2) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Creating DICOMDIR"));
                messageLogger.sendLn("Creating DICOMDIR");
                DicomDirectory dicomDirectory = new DicomDirectory(file, stringArray);
                dicomDirectory.write(new File(file, nameForDicomDirectoryOnInterchangeMedia).getCanonicalPath());
                SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, n + 1);
            }
            if (string2 != null && string2.length() > 0) {
                Object object3;
                Object object4;
                File file3 = new File(file, string2);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Zipping " + string4.toLowerCase() + " files to " + file3));
                if (bl) {
                    messageLogger.sendLn("Zipping " + string4.toLowerCase() + " files to " + file3);
                }
                file3.delete();
                object2 = new FileOutputStream(file3);
                object = new ZipOutputStream((OutputStream)object2);
                ((ZipOutputStream)object).setMethod(8);
                ((ZipOutputStream)object).setLevel(9);
                SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, 0, n + 1);
                for (int i = 0; i < n; ++i) {
                    object4 = stringArray[i];
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Adding " + (String)object4 + " to " + file3));
                    if (bl) {
                        messageLogger.sendLn("Adding " + (String)object4 + " to " + file3);
                    }
                    object3 = new File(file, (String)object4);
                    ZipEntry zipEntry = new ZipEntry((String)object4);
                    ((ZipOutputStream)object).putNextEntry(zipEntry);
                    FileInputStream fileInputStream = new FileInputStream((File)object3);
                    CopyStream.copy(fileInputStream, (OutputStream)object);
                    ((ZipOutputStream)object).closeEntry();
                    fileInputStream.close();
                    ((File)object3).delete();
                    SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, i + 1);
                }
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Adding " + nameForDicomDirectoryOnInterchangeMedia + " to " + file3));
                if (bl) {
                    messageLogger.sendLn("Adding " + nameForDicomDirectoryOnInterchangeMedia + " to " + file3);
                }
                File file4 = new File(file, nameForDicomDirectoryOnInterchangeMedia);
                object4 = new ZipEntry(nameForDicomDirectoryOnInterchangeMedia);
                ((ZipEntry)object4).setMethod(8);
                ((ZipOutputStream)object).putNextEntry((ZipEntry)object4);
                object3 = new FileInputStream(file4);
                CopyStream.copy((InputStream)object3, (OutputStream)object);
                ((ZipOutputStream)object).closeEntry();
                ((FileInputStream)object3).close();
                file4.delete();
                SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, n + 1);
                ((ZipOutputStream)object).close();
                ((FileOutputStream)object2).close();
                new File(file, rootNameForDicomInstanceFilesOnInterchangeMedia).delete();
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Zipping to " + file3 + " complete"));
                if (bl) {
                    messageLogger.sendLn("Zipping to " + file3 + " complete");
                }
            }
        }
        catch (Exception exception) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent(string + " failed: " + exception));
            slf4jlogger.error("", exception);
        }
        SafeProgressBarUpdaterThread.endProgressBar(safeProgressBarUpdaterThread);
        messageLogger.sendLn(string + " complete");
        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done " + string3 + " to " + file));
    }

    private String showInputDialogToSelectFTPTargetByLocalName(String string, String string2, String string3) {
        Set set;
        String string4 = string3;
        if (this.ftpRemoteHostInformation != null && (set = this.ftpRemoteHostInformation.getListOfLocalNames()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string4 = (String)JOptionPane.showInputDialog(this.getContentPane(), string, string2, 3, null, objectArray, string4);
        }
        return string4;
    }

    public static String getQueryRetrieveAEFromIdentifier(AttributeList attributeList, QueryInformationModel queryInformationModel) {
        Attribute attribute;
        String string = null;
        if (attributeList != null && (attribute = attributeList.get(TagFromName.RetrieveAETitle)) != null) {
            string = attribute.getSingleStringValueOrNull();
        }
        if (string == null && queryInformationModel != null) {
            string = queryInformationModel.getCalledAETitle();
        }
        return string;
    }

    public static String getQueryRetrieveLevel(AttributeList attributeList, Attribute attribute) {
        Object object;
        String string = null;
        if (attributeList != null && (object = attributeList.get(TagFromName.QueryRetrieveLevel)) != null) {
            string = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (string == null && attribute != null && (object = attribute.getTag()) != null) {
            if (((AttributeTag)object).equals(TagFromName.PatientID)) {
                string = "PATIENT";
            } else if (((AttributeTag)object).equals(TagFromName.StudyInstanceUID)) {
                string = "STUDY";
            } else if (((AttributeTag)object).equals(TagFromName.SeriesInstanceUID)) {
                string = "SERIES";
            } else if (((AttributeTag)object).equals(TagFromName.SOPInstanceUID)) {
                string = "IMAGE";
            }
        }
        return string;
    }

    protected void setCurrentRemoteQuerySelection(AttributeList attributeList, Attribute attribute, AttributeList attributeList2) {
        Object object;
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("setCurrentRemoteQuerySelection(): identifier =\n{}", attributeList2.toString());
        }
        this.currentRemoteQuerySelectionUniqueKeys = attributeList;
        this.currentRemoteQuerySelectionUniqueKey = attribute;
        this.currentRemoteQuerySelectionRetrieveAE = null;
        slf4jlogger.debug("setCurrentRemoteQuerySelection(): default currentRemoteQuerySelectionRetrieveAE to null");
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.RetrieveAETitle)) != null) {
            this.currentRemoteQuerySelectionRetrieveAE = ((Attribute)object).getSingleStringValueOrNull();
            slf4jlogger.debug("setCurrentRemoteQuerySelection(): set currentRemoteQuerySelectionRetrieveAE from RetrieveAETitle in identifier to {}", this.currentRemoteQuerySelectionRetrieveAE);
        }
        if (this.currentRemoteQuerySelectionRetrieveAE == null && this.currentRemoteQueryInformationModel != null) {
            this.currentRemoteQuerySelectionRetrieveAE = this.currentRemoteQueryInformationModel.getCalledAETitle();
            slf4jlogger.debug("setCurrentRemoteQuerySelection(): set currentRemoteQuerySelectionRetrieveAE to CalledAETitle since RetrieveAETitle missing or empty in identifier {}", this.currentRemoteQuerySelectionRetrieveAE);
        }
        this.currentRemoteQuerySelectionLevel = null;
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.QueryRetrieveLevel)) != null) {
            this.currentRemoteQuerySelectionLevel = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (this.currentRemoteQuerySelectionLevel == null) {
            if (attribute != null && (object = attribute.getTag()) != null) {
                if (((AttributeTag)object).equals(TagFromName.PatientID)) {
                    this.currentRemoteQuerySelectionLevel = "PATIENT";
                } else if (((AttributeTag)object).equals(TagFromName.StudyInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "STUDY";
                } else if (((AttributeTag)object).equals(TagFromName.SeriesInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "SERIES";
                } else if (((AttributeTag)object).equals(TagFromName.SOPInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "IMAGE";
                }
            }
            slf4jlogger.info("DownloadOrTransmit.setCurrentRemoteQuerySelection(): Guessed missing currentRemoteQuerySelectionLevel to be {}", this.currentRemoteQuerySelectionLevel);
        }
    }

    protected void performRetrieve(AttributeList attributeList, String string, String string2) {
        try {
            AttributeList attributeList2 = new AttributeList();
            if (attributeList != null) {
                attributeList2.putAll(attributeList);
                AttributeTag attributeTag = TagFromName.QueryRetrieveLevel;
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(attributeTag);
                ((Attribute)codeStringAttribute).addValue(string);
                attributeList2.put(attributeTag, codeStringAttribute);
                this.currentRemoteQueryInformationModel.performHierarchicalMoveFrom(attributeList2, string2);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Retrieve failed", exception);
        }
    }

    public DownloadOrTransmit(String string) throws DicomException, IOException {
        super(string, propertiesFileName);
        this.activateTemporaryDatabases();
        this.savedImagesFolder = new File(System.getProperty("java.io.tmpdir"));
        try {
            this.networkApplicationProperties = new NetworkApplicationProperties(this.getProperties(), true);
        }
        catch (Exception exception) {
            this.networkApplicationProperties = null;
        }
        Object object = new NetworkApplicationInformationFederated();
        ((NetworkApplicationInformationFederated)object).startupAllKnownSourcesAndRegister(this.networkApplicationProperties);
        this.networkApplicationInformation = object;
        System.err.print("networkApplicationInformation ...\n" + this.networkApplicationInformation);
        this.activateStorageSCP();
        try {
            this.ftpApplicationProperties = new FTPApplicationProperties(this.getProperties());
        }
        catch (Exception exception) {
            this.ftpApplicationProperties = null;
        }
        if (this.ftpApplicationProperties != null) {
            this.ftpRemoteHostInformation = this.ftpApplicationProperties.getFTPRemoteHostInformation();
        }
        this.logger = new DialogMessageLogger(loggerTitleMessage, loggertDialogWidthWanted, loggerDialogHeightWanted, false, false);
        this.cursorChanger = new SafeCursorChanger(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (DownloadOrTransmit.this.networkApplicationInformation != null && DownloadOrTransmit.this.networkApplicationInformation instanceof NetworkApplicationInformationFederated) {
                    ((NetworkApplicationInformationFederated)DownloadOrTransmit.this.networkApplicationInformation).removeAllSources();
                }
            }
        });
        this.srcDatabasePanel = new JPanel();
        this.remoteQueryRetrievePanel = new JPanel();
        this.srcDatabasePanel.setLayout(new GridLayout(1, 1));
        this.remoteQueryRetrievePanel.setLayout(new GridLayout(1, 1));
        object = new OurSourceDatabaseTreeBrowser(this.srcDatabase, this.srcDatabasePanel);
        Border border = BorderFactory.createEtchedBorder();
        JSplitPane jSplitPane = new JSplitPane(1, this.remoteQueryRetrievePanel, this.srcDatabasePanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        jPanel.setBorder(border);
        JButton jButton = new JButton(configureButtonLabel);
        jButton.setToolTipText(configureButtonToolTipText);
        jPanel.add(jButton);
        jButton.addActionListener(new ConfigureActionListener());
        JButton jButton2 = new JButton(logButtonLabel);
        jButton2.setToolTipText(logButtonToolTipText);
        jPanel.add(jButton2);
        jButton2.addActionListener(new LogActionListener());
        JButton jButton3 = new JButton(queryButtonLabel);
        jButton3.setToolTipText(queryButtonToolTipText);
        jPanel.add(jButton3);
        jButton3.addActionListener(new QueryActionListener());
        JButton jButton4 = new JButton(retrieveButtonLabel);
        jButton4.setToolTipText(retrieveButtonToolTipText);
        jPanel.add(jButton4);
        jButton4.addActionListener(new RetrieveActionListener());
        JButton jButton5 = new JButton(importButtonLabel);
        jButton5.setToolTipText(importButtonToolTipText);
        jPanel.add(jButton5);
        jButton5.addActionListener(new ImportActionListener());
        JButton jButton6 = new JButton(viewButtonLabel);
        jButton6.setToolTipText(viewButtonToolTipText);
        jPanel.add(jButton6);
        jButton6.addActionListener(new ViewActionListener());
        JButton jButton7 = new JButton(exportButtonLabel);
        jButton7.setToolTipText(exportButtonToolTipText);
        jPanel.add(jButton7);
        jButton7.addActionListener(new ExportActionListener());
        JButton jButton8 = new JButton(sendButtonLabel);
        jButton8.setToolTipText(sendButtonToolTipText);
        jPanel.add(jButton8);
        jButton8.addActionListener(new SendActionListener());
        JButton jButton9 = new JButton(ftpButtonLabel);
        jButton9.setToolTipText(ftpButtonToolTipText);
        jPanel.add(jButton9);
        jButton9.addActionListener(new FtpSendActionListener());
        JButton jButton10 = new JButton(purgeButtonLabel);
        jButton10.setToolTipText(purgeButtonToolTipText);
        jPanel.add(jButton10);
        jButton10.addActionListener(new PurgeActionListener());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0));
        jPanel2.setBorder(border);
        JLabel jLabel = new JLabel(queryIntroductionLabelText);
        jPanel2.add(jLabel);
        JLabel jLabel2 = new JLabel(queryPatientNameLabelText);
        jLabel2.setToolTipText(queryPatientNameToolTipText);
        jPanel2.add(jLabel2);
        this.queryFilterPatientNameTextField = new JTextField("", textFieldLengthForQueryPatientName);
        jPanel2.add(this.queryFilterPatientNameTextField);
        JLabel jLabel3 = new JLabel(queryPatientIDLabelText);
        jLabel3.setToolTipText(queryPatientIDToolTipText);
        jPanel2.add(jLabel3);
        this.queryFilterPatientIDTextField = new JTextField("", textFieldLengthForQueryPatientID);
        jPanel2.add(this.queryFilterPatientIDTextField);
        JLabel jLabel4 = new JLabel(queryStudyDateLabelText);
        jLabel4.setToolTipText(queryStudyDateToolTipText);
        jPanel2.add(jLabel4);
        this.queryFilterStudyDateTextField = new JTextField("", textFieldLengthForQueryStudyDate);
        jPanel2.add(this.queryFilterStudyDateTextField);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 0));
        jPanel3.setBorder(border);
        this.showDetailedLogCheckBox = new JCheckBox(showDetailedLogLabelText);
        this.showDetailedLogCheckBox.setSelected(false);
        jPanel3.add(this.showDetailedLogCheckBox);
        this.zipExportCheckBox = new JCheckBox(zipExportLabelText);
        this.zipExportCheckBox.setSelected(false);
        jPanel3.add(this.zipExportCheckBox);
        this.hierarchicalExportCheckBox = new JCheckBox(hierarchicalExportLabelText);
        this.hierarchicalExportCheckBox.setSelected(false);
        this.hierarchicalExportCheckBox.setToolTipText(hierarchicalExportToolTipText);
        jPanel3.add(this.hierarchicalExportCheckBox);
        this.addDicomDirectoryCheckBox = new JCheckBox(addDicomDirectoryLabelText);
        this.addDicomDirectoryCheckBox.setSelected(true);
        this.addDicomDirectoryCheckBox.setToolTipText(addDicomDirectoryToolTipText);
        jPanel3.add(this.addDicomDirectoryCheckBox);
        JPanel jPanel4 = new JPanel();
        Serializable serializable = new GridBagLayout();
        jPanel4.setLayout((LayoutManager)((Object)serializable));
        Serializable serializable2 = this.getStatusBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        ((GridBagLayout)serializable).setConstraints((Component)serializable2, gridBagConstraints);
        jPanel4.add((Component)serializable2);
        serializable2 = new JProgressBar();
        ((JProgressBar)serializable2).setStringPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)serializable).setConstraints((Component)serializable2, gridBagConstraints);
        jPanel4.add((Component)serializable2);
        this.progressBarUpdater = new SafeProgressBarUpdaterThread((JProgressBar)serializable2);
        serializable = new JPanel();
        serializable2 = new GridBagLayout();
        ((Container)serializable).setLayout((LayoutManager)((Object)serializable2));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        ((GridBagLayout)serializable2).setConstraints(jSplitPane, gridBagConstraints);
        ((Container)serializable).add(jSplitPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel, gridBagConstraints);
        ((Container)serializable).add(jPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel2, gridBagConstraints);
        ((Container)serializable).add(jPanel2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel3, gridBagConstraints);
        ((Container)serializable).add(jPanel3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable2).setConstraints(jPanel4, gridBagConstraints);
        ((Container)serializable).add(jPanel4);
        serializable2 = this.getContentPane();
        ((Container)serializable2).add((Component)serializable);
        this.pack();
        this.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            String string = System.getProperty("os.name");
            if (string != null && string.toLowerCase(Locale.US).startsWith("windows")) {
                slf4jlogger.info("main(): detected Windows - using Windows LAF");
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            new DownloadOrTransmit("Download or Transmit");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected class ConfigureActionListener
    implements ActionListener {
        protected ConfigureActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DownloadOrTransmit.this.storageSOPClassSCPDispatcher.shutdown();
                new NetworkApplicationConfigurationDialog(DownloadOrTransmit.this.getContentPane(), DownloadOrTransmit.this.networkApplicationInformation, DownloadOrTransmit.this.networkApplicationProperties);
                new FTPClientApplicationConfigurationDialog(DownloadOrTransmit.this.getContentPane(), DownloadOrTransmit.this.ftpRemoteHostInformation, DownloadOrTransmit.this.ftpApplicationProperties);
                DownloadOrTransmit.this.networkApplicationProperties.getProperties(DownloadOrTransmit.this.getProperties());
                DownloadOrTransmit.this.ftpApplicationProperties.getProperties(DownloadOrTransmit.this.getProperties());
                DownloadOrTransmit.this.storeProperties("Edited and saved from user interface");
                DownloadOrTransmit.this.activateStorageSCP();
            }
            catch (Exception exception) {
                slf4jlogger.error("Configuration failed", exception);
            }
        }
    }

    protected class LogActionListener
    implements ActionListener {
        protected LogActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DownloadOrTransmit.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DownloadOrTransmit.this.logger).setVisible(true);
            }
        }
    }

    protected class RetrieveActionListener
    implements ActionListener {
        protected RetrieveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DownloadOrTransmit.this.activeThread = new Thread(new RetrieveWorker());
            DownloadOrTransmit.this.activeThread.start();
        }
    }

    protected class RetrieveWorker
    implements Runnable {
        RetrieveWorker() {
        }

        @Override
        public void run() {
            DownloadOrTransmit.this.cursorChanger.setWaitCursor();
            String string = DownloadOrTransmit.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE);
            slf4jlogger.debug("RetrieveWorker.run(): localName = {} for currentRemoteQuerySelectionRetrieveAE = {}", string, DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE);
            if (DownloadOrTransmit.this.currentRemoteQuerySelectionLevel == null) {
                QueryTreeRecord queryTreeRecord = DownloadOrTransmit.this.currentRemoteQuerySelectionQueryTreeRecord;
                if (queryTreeRecord != null) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving everything from " + string));
                    DownloadOrTransmit.this.logger.sendLn("Retrieving everything from " + string + " (" + DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE + ")");
                    slf4jlogger.info("Retrieving everything from {} ({})", string, DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE);
                    Enumeration enumeration = queryTreeRecord.children();
                    if (enumeration != null) {
                        int n = queryTreeRecord.getChildCount();
                        slf4jlogger.debug("RetrieveWorker.run(): Everything nChildren = {}", n);
                        SafeProgressBarUpdaterThread.startProgressBar(DownloadOrTransmit.this.progressBarUpdater, n);
                        int n2 = 0;
                        while (enumeration.hasMoreElements()) {
                            QueryTreeRecord queryTreeRecord2 = (QueryTreeRecord)enumeration.nextElement();
                            if (queryTreeRecord2 == null) continue;
                            DownloadOrTransmit.this.setCurrentRemoteQuerySelection(queryTreeRecord2.getUniqueKeys(), queryTreeRecord2.getUniqueKey(), queryTreeRecord2.getAllAttributesReturnedInIdentifier());
                            string = DownloadOrTransmit.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE);
                            slf4jlogger.debug("RetrieveWorker.run(): updated from identifier localName = {} for currentRemoteQuerySelectionRetrieveAE = {}", string, DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE);
                            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving " + DownloadOrTransmit.this.currentRemoteQuerySelectionLevel + " " + DownloadOrTransmit.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string));
                            DownloadOrTransmit.this.logger.sendLn("Retrieving " + DownloadOrTransmit.this.currentRemoteQuerySelectionLevel + " " + DownloadOrTransmit.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string + " (" + DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE + ")");
                            slf4jlogger.info("Retrieving {} {} from {} ({})", DownloadOrTransmit.this.currentRemoteQuerySelectionLevel, DownloadOrTransmit.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString(), string, DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE);
                            DownloadOrTransmit.this.performRetrieve(DownloadOrTransmit.this.currentRemoteQuerySelectionUniqueKeys, DownloadOrTransmit.this.currentRemoteQuerySelectionLevel, DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE);
                            SafeProgressBarUpdaterThread.updateProgressBar(DownloadOrTransmit.this.progressBarUpdater, ++n2);
                            slf4jlogger.debug("RetrieveWorker.run(): doneCount = {}", n2);
                        }
                        SafeProgressBarUpdaterThread.endProgressBar(DownloadOrTransmit.this.progressBarUpdater);
                    }
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending retrieval request"));
                    DownloadOrTransmit.this.setCurrentRemoteQuerySelection(null, null, null);
                }
            } else {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving " + DownloadOrTransmit.this.currentRemoteQuerySelectionLevel + " " + DownloadOrTransmit.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string));
                DownloadOrTransmit.this.logger.sendLn("Request retrieval of " + DownloadOrTransmit.this.currentRemoteQuerySelectionLevel + " " + DownloadOrTransmit.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string + " (" + DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE + ")");
                slf4jlogger.info("Request retrieval of {} {} from {} ({})", DownloadOrTransmit.this.currentRemoteQuerySelectionLevel, DownloadOrTransmit.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString(), string, DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE);
                SafeProgressBarUpdaterThread.startProgressBar(DownloadOrTransmit.this.progressBarUpdater, 1);
                DownloadOrTransmit.this.performRetrieve(DownloadOrTransmit.this.currentRemoteQuerySelectionUniqueKeys, DownloadOrTransmit.this.currentRemoteQuerySelectionLevel, DownloadOrTransmit.this.currentRemoteQuerySelectionRetrieveAE);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending retrieval request"));
                SafeProgressBarUpdaterThread.endProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            }
            DownloadOrTransmit.this.cursorChanger.restoreCursor();
        }
    }

    protected class QueryActionListener
    implements ActionListener {
        protected QueryActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = DownloadOrTransmit.this.getProperties();
            String string = properties.getProperty(propertyName_DicomCurrentlySelectedQueryTargetAE);
            string = DownloadOrTransmit.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select remote system", "Query ...", string);
            DownloadOrTransmit.this.remoteQueryRetrievePanel.removeAll();
            if (string != null) {
                DownloadOrTransmit.this.setCurrentRemoteQueryInformationModel(string);
                if (DownloadOrTransmit.this.currentRemoteQueryInformationModel == null) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cannot query " + string));
                } else {
                    try {
                        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
                        AttributeList attributeList = new AttributeList();
                        AttributeTag attributeTag = TagFromName.PatientName;
                        StringAttribute stringAttribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
                        String string2 = DownloadOrTransmit.this.queryFilterPatientNameTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientID;
                        stringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
                        string2 = DownloadOrTransmit.this.queryFilterPatientIDTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientBirthDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientSex;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyID;
                        stringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyDescription;
                        stringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ModalitiesInStudy;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        string2 = DownloadOrTransmit.this.queryFilterStudyDateTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientAge;
                        stringAttribute = new AgeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesDescription;
                        stringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesNumber;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.Manufacturer;
                        stringAttribute = new LongStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.Modality;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.InstanceNumber;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ContentDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ContentTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ImageType;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.NumberOfFrames;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.WindowCenter;
                        stringAttribute = new DecimalStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.WindowWidth;
                        stringAttribute = new DecimalStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SOPInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SOPClassUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SpecificCharacterSet;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        ((Attribute)stringAttribute).addValue("ISO_IR 100");
                        DownloadOrTransmit.this.activeThread = new Thread(new QueryWorker(attributeList));
                        DownloadOrTransmit.this.activeThread.start();
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Query to {} failed", string, exception);
                        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Query to " + string + " failed"));
                    }
                }
            }
            DownloadOrTransmit.this.remoteQueryRetrievePanel.validate();
        }
    }

    protected class QueryWorker
    implements Runnable {
        AttributeList filter;

        QueryWorker(AttributeList attributeList) {
            this.filter = attributeList;
        }

        @Override
        public void run() {
            DownloadOrTransmit.this.cursorChanger.setWaitCursor();
            String string = DownloadOrTransmit.this.currentRemoteQueryInformationModel.getCalledAETitle();
            String string2 = DownloadOrTransmit.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Performing query on " + string2));
            if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                DownloadOrTransmit.this.logger.sendLn("Query to " + string2 + " (" + string + ") starting");
            }
            try {
                QueryTreeModel queryTreeModel = DownloadOrTransmit.this.currentRemoteQueryInformationModel.performHierarchicalQuery(this.filter);
                DownloadOrTransmit.this.currentRemoteQueryTreeBrowser = new OurQueryTreeBrowser(DownloadOrTransmit.this.currentRemoteQueryInformationModel, queryTreeModel, DownloadOrTransmit.this.remoteQueryRetrievePanel);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done querying " + string2));
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Query to " + string2 + " failed " + exception));
                if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                    DownloadOrTransmit.this.logger.sendLn("Query to " + string2 + " (" + string + ") failed due to" + exception);
                }
                slf4jlogger.error("Query to {} failed", string, exception);
            }
            if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                DownloadOrTransmit.this.logger.sendLn("Query to " + string2 + " (" + string + ") complete");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done querying  " + string2));
            DownloadOrTransmit.this.cursorChanger.restoreCursor();
        }
    }

    protected class OurQueryTreeBrowser
    extends QueryTreeBrowser {
        OurQueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, Container container) throws DicomException {
            super(queryInformationModel, queryTreeModel, container);
        }

        @Override
        protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedLevel() {
            return new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object;
                    TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    if (treePath != null && (object = treePath.getLastPathComponent()) instanceof QueryTreeRecord) {
                        QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object;
                        DownloadOrTransmit.this.setCurrentRemoteQuerySelection(queryTreeRecord.getUniqueKeys(), queryTreeRecord.getUniqueKey(), queryTreeRecord.getAllAttributesReturnedInIdentifier());
                        DownloadOrTransmit.this.currentRemoteQuerySelectionQueryTreeRecord = queryTreeRecord;
                    }
                }
            };
        }
    }

    protected class ImportActionListener
    implements ActionListener {
        protected ImportActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (DownloadOrTransmit.this.logger instanceof DialogMessageLogger) {
                    ((DialogMessageLogger)DownloadOrTransmit.this.logger).setVisible(true);
                }
                if (DownloadOrTransmit.this.importDirectoryPath == null || DownloadOrTransmit.this.importDirectoryPath.length() == 0) {
                    DownloadOrTransmit.this.importDirectoryPath = "/";
                }
                SafeFileChooser safeFileChooser = new SafeFileChooser(DownloadOrTransmit.this.importDirectoryPath);
                safeFileChooser.setFileSelectionMode(2);
                if (safeFileChooser.showOpenDialog(DownloadOrTransmit.this.getContentPane()) == 0) {
                    DownloadOrTransmit.this.importDirectoryPath = safeFileChooser.getCurrentDirectory().getAbsolutePath();
                    String string = safeFileChooser.getSelectedFile().getAbsolutePath();
                    new Thread(new ImportWorker(string, DownloadOrTransmit.this.srcDatabase, DownloadOrTransmit.this.srcDatabasePanel)).start();
                }
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing failed: " + exception));
                slf4jlogger.error("Importing failed", exception);
            }
        }
    }

    protected class ImportWorker
    implements Runnable {
        MediaImporter importer;
        DatabaseInformationModel srcDatabase;
        JPanel srcDatabasePanel;
        String pathName;

        ImportWorker(String string, DatabaseInformationModel databaseInformationModel, JPanel jPanel) {
            this.importer = new OurMediaImporter(DownloadOrTransmit.this.logger, DownloadOrTransmit.this.progressBarUpdater.getProgressBar());
            this.srcDatabase = databaseInformationModel;
            this.srcDatabasePanel = jPanel;
            this.pathName = string;
        }

        @Override
        public void run() {
            DownloadOrTransmit.this.cursorChanger.setWaitCursor();
            SafeProgressBarUpdaterThread.startProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            try {
                this.importer.importDicomFiles(this.pathName);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing failed: " + exception));
                slf4jlogger.error("Importing failed", exception);
            }
            this.srcDatabasePanel.removeAll();
            try {
                new OurSourceDatabaseTreeBrowser(this.srcDatabase, this.srcDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                slf4jlogger.error("Refresh source database browser failed", exception);
            }
            this.srcDatabasePanel.validate();
            SafeProgressBarUpdaterThread.endProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done importing"));
            DownloadOrTransmit.this.cursorChanger.restoreCursor();
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        protected boolean canUseBzip;

        public OurMediaImporter(MessageLogger messageLogger, JProgressBar jProgressBar) {
            super(messageLogger, jProgressBar);
            this.canUseBzip = CapabilitiesAvailable.haveBzip2Support();
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DownloadOrTransmit.importFileIntoDatabase(DownloadOrTransmit.this.srcDatabase, string, "R");
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }

        @Override
        protected boolean isOKToImport(String string, String string2) {
            return string != null && (SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) && !SOPClass.isDirectory(string)) && string2 != null && (string2.equals("1.2.840.10008.1.2") || string2.equals("1.2.840.10008.1.2.1") || string2.equals("1.2.840.10008.1.2.2") || string2.equals("1.2.840.10008.1.2.1.99") || string2.equals("1.2.840.10008.1.2.1.99") && this.canUseBzip || string2.equals("1.2.840.10008.1.2.5") || string2.equals("1.2.840.10008.1.2.4.50") || CapabilitiesAvailable.haveJPEGLosslessCodec() && (string2.equals("1.2.840.10008.1.2.4.57") || string2.equals("1.2.840.10008.1.2.4.70")) || CapabilitiesAvailable.haveJPEG2000Part1Codec() && (string2.equals("1.2.840.10008.1.2.4.91") || string2.equals("1.2.840.10008.1.2.4.90")) || CapabilitiesAvailable.haveJPEGLSCodec() && (string2.equals("1.2.840.10008.1.2.4.80") || string2.equals("1.2.840.10008.1.2.4.81")));
        }
    }

    protected class FtpSendActionListener
    implements ActionListener {
        protected FtpSendActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                FTPRemoteHost fTPRemoteHost;
                Properties properties = DownloadOrTransmit.this.getProperties();
                String string = properties.getProperty(propertyName_CurrentlySelectedFtpTarget);
                string = DownloadOrTransmit.this.showInputDialogToSelectFTPTargetByLocalName("Select remote ftp site", "Ftp site ...", string);
                if (string != null && (fTPRemoteHost = DownloadOrTransmit.this.ftpRemoteHostInformation.getRemoteHost(string)) != null) {
                    DownloadOrTransmit.this.activeThread = new Thread(new FtpSendWorker(DownloadOrTransmit.this.currentDatabaseTreeRecordSelections, DownloadOrTransmit.this.srcDatabase, DownloadOrTransmit.this.srcDatabasePanel, fTPRemoteHost));
                    DownloadOrTransmit.this.activeThread.start();
                }
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Send to ftp site failed: " + exception));
                slf4jlogger.error("Send to ftp site failed", exception);
            }
        }
    }

    protected class FtpSendWorker
    implements Runnable {
        DatabaseTreeRecord[] databaseSelections;
        DatabaseInformationModel srcDatabase;
        JPanel srcDatabasePanel;
        FTPRemoteHost remoteHost;

        FtpSendWorker(DatabaseTreeRecord[] databaseTreeRecordArray, DatabaseInformationModel databaseInformationModel, JPanel jPanel, FTPRemoteHost fTPRemoteHost) {
            this.databaseSelections = databaseTreeRecordArray;
            this.srcDatabase = databaseInformationModel;
            this.srcDatabasePanel = jPanel;
            this.remoteHost = fTPRemoteHost;
        }

        @Override
        public void run() {
            DownloadOrTransmit.this.cursorChanger.setWaitCursor();
            if (DownloadOrTransmit.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DownloadOrTransmit.this.logger).setVisible(true);
            }
            if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                DownloadOrTransmit.this.logger.sendLn("Sending to Ftp started");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Sending to Ftp started"));
            SafeProgressBarUpdaterThread.startProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            if (this.databaseSelections != null) {
                Vector vector = new Vector();
                for (DatabaseTreeRecord databaseTreeRecord : this.databaseSelections) {
                    if (databaseTreeRecord == null) continue;
                    DatabaseTreeBrowser.recurseThroughChildrenGatheringFileNames(databaseTreeRecord, vector);
                }
                try {
                    Object[] objectArray = vector.toArray(new String[vector.size()]);
                    new FTPFileSender(this.remoteHost, (String[])objectArray, true, DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected() ? DownloadOrTransmit.this.logger : null, DownloadOrTransmit.this.progressBarUpdater.getProgressBar());
                }
                catch (Exception exception) {
                    if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                        DownloadOrTransmit.this.logger.sendLn(exception.toString());
                    }
                    slf4jlogger.error("", exception);
                }
            }
            SafeProgressBarUpdaterThread.endProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                DownloadOrTransmit.this.logger.sendLn("Sending to Ftp complete");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending to Ftp"));
            DownloadOrTransmit.this.cursorChanger.restoreCursor();
        }
    }

    protected class SendActionListener
    implements ActionListener {
        protected SendActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Properties properties = DownloadOrTransmit.this.getProperties();
                String string = properties.getProperty(propertyName_DicomCurrentlySelectedStorageTargetAE);
                string = DownloadOrTransmit.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName("Select destination", "Send ...", string);
                if (string != null) {
                    String string2 = DownloadOrTransmit.this.networkApplicationProperties.getCallingAETitle();
                    String string3 = DownloadOrTransmit.this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                    PresentationAddress presentationAddress = DownloadOrTransmit.this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string3);
                    String string4 = presentationAddress.getHostname();
                    int n = presentationAddress.getPort();
                    int n2 = DownloadOrTransmit.this.networkApplicationProperties.getInitiatorMaximumLengthReceived();
                    int n3 = DownloadOrTransmit.this.networkApplicationProperties.getInitiatorSocketReceiveBufferSize();
                    int n4 = DownloadOrTransmit.this.networkApplicationProperties.getInitiatorSocketSendBufferSize();
                    DownloadOrTransmit.this.activeThread = new Thread(new SendWorker(DownloadOrTransmit.this.currentDatabaseTreeRecordSelections, DownloadOrTransmit.this.srcDatabase, DownloadOrTransmit.this.srcDatabasePanel, string4, n, string3, string2, n2, n3, n4));
                    DownloadOrTransmit.this.activeThread.start();
                }
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Send to remote DICOM network host failed: " + exception));
                slf4jlogger.error("Send to remote DICOM network host failed", exception);
            }
        }
    }

    protected class SendWorker
    implements Runnable {
        DatabaseTreeRecord[] databaseSelections;
        DatabaseInformationModel srcDatabase;
        JPanel srcDatabasePanel;
        String hostname;
        int port;
        String calledAETitle;
        String callingAETitle;
        int ourMaximumLengthReceived;
        int socketReceiveBufferSize;
        int socketSendBufferSize;

        SendWorker(DatabaseTreeRecord[] databaseTreeRecordArray, DatabaseInformationModel databaseInformationModel, JPanel jPanel, String string, int n, String string2, String string3, int n2, int n3, int n4) {
            this.databaseSelections = databaseTreeRecordArray;
            this.srcDatabase = databaseInformationModel;
            this.srcDatabasePanel = jPanel;
            this.hostname = string;
            this.port = n;
            this.calledAETitle = string2;
            this.callingAETitle = string3;
            this.ourMaximumLengthReceived = n2;
            this.socketReceiveBufferSize = n3;
            this.socketSendBufferSize = n4;
        }

        @Override
        public void run() {
            DownloadOrTransmit.this.cursorChanger.setWaitCursor();
            if (DownloadOrTransmit.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DownloadOrTransmit.this.logger).setVisible(true);
            }
            if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                DownloadOrTransmit.this.logger.sendLn("Sending to remote DICOM network host started");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Sending to remote DICOM network host started"));
            SafeProgressBarUpdaterThread.startProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            if (this.databaseSelections != null) {
                Vector<String> vector = new Vector<String>();
                for (DatabaseTreeRecord databaseTreeRecord : this.databaseSelections) {
                    if (databaseTreeRecord == null) continue;
                    DatabaseTreeBrowser.recurseThroughChildrenGatheringFileNames(databaseTreeRecord, vector);
                }
                SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles((AbstractList<String>)vector);
                int n = setOfDicomFiles.size();
                if (n > 0) {
                    SafeProgressBarUpdaterThread.startProgressBar(DownloadOrTransmit.this.progressBarUpdater, n);
                    try {
                        new StorageSOPClassSCU(this.hostname, this.port, this.calledAETitle, this.callingAETitle, this.ourMaximumLengthReceived, this.socketReceiveBufferSize, this.socketSendBufferSize, setOfDicomFiles, 0, new OurMultipleInstanceTransferStatusHandler(n, DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected() ? DownloadOrTransmit.this.logger : null, DownloadOrTransmit.this.progressBarUpdater));
                    }
                    catch (Exception exception) {
                        if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                            DownloadOrTransmit.this.logger.sendLn(exception.toString());
                        }
                        slf4jlogger.error("", exception);
                    }
                } else {
                    if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                        DownloadOrTransmit.this.logger.sendLn("No DICOM Files to send to remote DICOM network host");
                    }
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("No DICOM Files to send to remote DICOM network host"));
                }
            }
            SafeProgressBarUpdaterThread.endProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                DownloadOrTransmit.this.logger.sendLn("Sending to remote DICOM network host complete");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending to remote DICOM network host"));
            DownloadOrTransmit.this.cursorChanger.restoreCursor();
        }
    }

    protected class OurMultipleInstanceTransferStatusHandler
    extends MultipleInstanceTransferStatusHandlerWithFileName {
        int nFiles;
        MessageLogger logger;
        SafeProgressBarUpdaterThread progressBarUpdater;

        OurMultipleInstanceTransferStatusHandler(int n, MessageLogger messageLogger, SafeProgressBarUpdaterThread safeProgressBarUpdaterThread) {
            this.nFiles = n;
            this.logger = messageLogger;
            this.progressBarUpdater = safeProgressBarUpdaterThread;
        }

        @Override
        public void updateStatus(int n, int n2, int n3, int n4, String string, String string2, boolean bl) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Remaining " + n + ", completed " + n2 + ", failed " + n3 + ", warning " + n4));
            SafeProgressBarUpdaterThread.updateProgressBar(this.progressBarUpdater, this.nFiles - n, this.nFiles);
            if (this.logger != null) {
                this.logger.sendLn((bl ? "Sent " : "Failed to send ") + string2);
            }
        }
    }

    protected class ExportActionListener
    implements ActionListener {
        protected ExportActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DownloadOrTransmit.this.currentDatabaseTreeRecordSelections != null) {
                Vector vector = new Vector();
                for (DatabaseTreeRecord databaseTreeRecord : DownloadOrTransmit.this.currentDatabaseTreeRecordSelections) {
                    if (databaseTreeRecord == null) continue;
                    DatabaseTreeBrowser.recurseThroughChildrenGatheringFileNames(databaseTreeRecord, vector);
                }
                if (vector.size() > 0) {
                    SafeFileChooser safeFileChooser = new SafeFileChooser(DownloadOrTransmit.this.exportDirectoryPath);
                    safeFileChooser.setFileSelectionMode(1);
                    if (safeFileChooser.showOpenDialog(DownloadOrTransmit.this.getContentPane()) == 0) {
                        try {
                            DownloadOrTransmit.this.exportDirectoryPath = safeFileChooser.getSelectedFile().getCanonicalPath();
                            File file = new File(DownloadOrTransmit.this.exportDirectoryPath);
                            new Thread(new ExportWorker(vector, file)).start();
                        }
                        catch (Exception exception) {
                            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Export failed: " + exception));
                            slf4jlogger.error("Export failed", exception);
                        }
                    }
                }
            }
        }
    }

    protected class ExportWorker
    implements Runnable {
        Vector destinationFilePathSelections;
        File exportDirectory;

        ExportWorker(Vector vector, File file) {
            this.destinationFilePathSelections = vector;
            this.exportDirectory = file;
        }

        @Override
        public void run() {
            DownloadOrTransmit.this.cursorChanger.setWaitCursor();
            DownloadOrTransmit.exportFiles(this.destinationFilePathSelections, this.exportDirectory, "Save", DownloadOrTransmit.this.progressBarUpdater, DownloadOrTransmit.this.logger, DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected(), DownloadOrTransmit.this.addDicomDirectoryCheckBox.isSelected(), DownloadOrTransmit.this.hierarchicalExportCheckBox.isSelected(), DownloadOrTransmit.this.zipExportCheckBox.isSelected() ? exportedZipFileName : null);
            DownloadOrTransmit.this.cursorChanger.restoreCursor();
        }
    }

    protected class ViewActionListener
    implements ActionListener {
        protected ViewActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DownloadOrTransmit.this.activeThread = new Thread(new ViewWorker(DownloadOrTransmit.this.getCurrentSourceFilePathSelections()));
                DownloadOrTransmit.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("View failed: " + exception));
                slf4jlogger.error("View failed", exception);
            }
        }
    }

    protected class ViewWorker
    implements Runnable {
        Vector sourceFilePathSelections;

        ViewWorker(Vector vector) {
            this.sourceFilePathSelections = vector;
        }

        @Override
        public void run() {
            DownloadOrTransmit.this.cursorChanger.setWaitCursor();
            if (DownloadOrTransmit.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DownloadOrTransmit.this.logger).setVisible(true);
            }
            if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                DownloadOrTransmit.this.logger.sendLn("View started");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("View started"));
            SafeProgressBarUpdaterThread.startProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            if (this.sourceFilePathSelections != null) {
                DicomBrowser.loadAndDisplayImagesFromSOPInstances(this.sourceFilePathSelections, null, null, viewerFrameWidthWanted, viewerFrameHeightWanted);
            }
            SafeProgressBarUpdaterThread.endProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                DownloadOrTransmit.this.logger.sendLn("View complete");
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done view"));
            DownloadOrTransmit.this.cursorChanger.restoreCursor();
        }
    }

    protected class PurgeActionListener
    implements ActionListener {
        protected PurgeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DownloadOrTransmit.this.activeThread = new Thread(new PurgeWorker(DownloadOrTransmit.this.currentDatabaseTreeRecordSelections));
                DownloadOrTransmit.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                slf4jlogger.error("Purging failed", exception);
            }
        }
    }

    protected class PurgeWorker
    implements Runnable {
        DatabaseTreeRecord[] databaseSelections;

        PurgeWorker(DatabaseTreeRecord[] databaseTreeRecordArray) {
            this.databaseSelections = databaseTreeRecordArray;
        }

        @Override
        public void run() {
            DownloadOrTransmit.this.cursorChanger.setWaitCursor();
            DownloadOrTransmit.this.logger.sendLn("Purging started");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging started"));
            SafeProgressBarUpdaterThread.startProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            try {
                DownloadOrTransmit.this.purgeFilesAndDatabaseInformation(this.databaseSelections, DownloadOrTransmit.this.logger, DownloadOrTransmit.this.progressBarUpdater, 0, 1);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                slf4jlogger.error("Purging failed", exception);
            }
            DownloadOrTransmit.this.srcDatabasePanel.removeAll();
            try {
                new OurSourceDatabaseTreeBrowser(DownloadOrTransmit.this.srcDatabase, DownloadOrTransmit.this.srcDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                slf4jlogger.error("Refresh source database browser failed", exception);
            }
            DownloadOrTransmit.this.srcDatabasePanel.validate();
            SafeProgressBarUpdaterThread.endProgressBar(DownloadOrTransmit.this.progressBarUpdater);
            DownloadOrTransmit.this.logger.sendLn("Purging complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done purging"));
            DownloadOrTransmit.this.cursorChanger.restoreCursor();
        }
    }

    protected class OurSourceDatabaseTreeBrowser
    extends DatabaseTreeBrowser {
        public OurSourceDatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, Container container) throws DicomException {
            super(databaseInformationModel, container);
        }

        @Override
        protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedFiles() {
            return new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    DownloadOrTransmit.this.currentDatabaseTreeRecordSelections = OurSourceDatabaseTreeBrowser.this.getSelectionPaths();
                }
            };
        }

        @Override
        protected void doSomethingMoreWithWhateverWasSelected() {
        }
    }

    class OurTransferSyntaxSelectionPolicy
    extends TransferSyntaxSelectionPolicy {
        OurTransferSyntaxSelectionPolicy() {
        }

        @Override
        public LinkedList applyTransferSyntaxSelectionPolicy(LinkedList linkedList, int n) {
            boolean bl = CapabilitiesAvailable.haveBzip2Support();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                PresentationContext presentationContext = (PresentationContext)listIterator.next();
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                boolean bl10 = false;
                boolean bl11 = false;
                boolean bl12 = false;
                boolean bl13 = false;
                List list = presentationContext.getTransferSyntaxUIDs();
                ListIterator listIterator2 = list.listIterator();
                while (listIterator2.hasNext()) {
                    String string = (String)listIterator2.next();
                    if (string == null) continue;
                    if (string.equals("1.2.840.10008.1.2")) {
                        bl3 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.1")) {
                        bl2 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.2")) {
                        bl4 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.1.99")) {
                        bl5 = true;
                        continue;
                    }
                    if (string.equals("1.3.6.1.4.1.5962.300.1")) {
                        bl6 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.50")) {
                        bl7 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.57")) {
                        bl8 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.70")) {
                        bl9 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.91")) {
                        bl10 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.90")) {
                        bl11 = true;
                        continue;
                    }
                    if (string.equals("1.2.840.10008.1.2.4.80")) {
                        bl12 = true;
                        continue;
                    }
                    if (!string.equals("1.2.840.10008.1.2.4.81")) continue;
                    bl13 = true;
                }
                presentationContext.newTransferSyntaxUIDs();
                if (bl6 && bl) {
                    presentationContext.addTransferSyntaxUID("1.3.6.1.4.1.5962.300.1");
                    continue;
                }
                if (bl5) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1.99");
                    continue;
                }
                if (bl2) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1");
                    continue;
                }
                if (bl4) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.2");
                    continue;
                }
                if (bl3) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2");
                    continue;
                }
                if (bl7) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.50");
                    continue;
                }
                if (bl8 && CapabilitiesAvailable.haveJPEGLosslessCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.57");
                    continue;
                }
                if (bl9 && CapabilitiesAvailable.haveJPEGLosslessCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.70");
                    continue;
                }
                if (bl10 && CapabilitiesAvailable.haveJPEG2000Part1Codec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.91");
                    continue;
                }
                if (bl11 && CapabilitiesAvailable.haveJPEG2000Part1Codec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.90");
                    continue;
                }
                if (bl12 && CapabilitiesAvailable.haveJPEGLSCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.80");
                    continue;
                }
                if (bl13 && CapabilitiesAvailable.haveJPEGLSCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.81");
                    continue;
                }
                presentationContext.setResultReason((byte)4);
            }
            return linkedList;
        }
    }

    class OurPresentationContextSelectionPolicy
    extends UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy {
        OurPresentationContextSelectionPolicy() {
            this.transferSyntaxSelectionPolicy = new OurTransferSyntaxSelectionPolicy();
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                String string4 = DownloadOrTransmit.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string3);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Received " + string + " from " + string3 + " in " + string2));
                if (DownloadOrTransmit.this.showDetailedLogCheckBox.isSelected()) {
                    DownloadOrTransmit.this.logger.sendLn("Received " + string + " from " + string4 + " (" + string3 + ")");
                }
                try {
                    DownloadOrTransmit.importFileIntoDatabase(DownloadOrTransmit.this.srcDatabase, string, "C");
                    DownloadOrTransmit.this.srcDatabasePanel.removeAll();
                    new OurSourceDatabaseTreeBrowser(DownloadOrTransmit.this.srcDatabase, DownloadOrTransmit.this.srcDatabasePanel);
                    DownloadOrTransmit.this.srcDatabasePanel.validate();
                    new File(string).deleteOnExit();
                }
                catch (Exception exception) {
                    slf4jlogger.error("Unable to insert {} received from {} in {} into database", string, string3, string2, exception);
                }
            }
        }
    }
}

