/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class FindAndCopySelectedDicomFilesUsingDatabase {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/FindAndCopySelectedDicomFilesUsingDatabase.java,v 1.12 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(FindAndCopySelectedDicomFilesUsingDatabase.class);

    public FindAndCopySelectedDicomFilesUsingDatabase(DatabaseInformationModel databaseInformationModel, Set<String> set, String string) {
        String string2 = databaseInformationModel.getLocalFileNameColumnName(InformationEntity.INSTANCE);
        for (String string3 : set) {
            slf4jlogger.info("Doing SOP Class {}", string3);
            try {
                ArrayList arrayList = databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(InformationEntity.INSTANCE, "SOPCLASSUID", string3);
                for (TreeMap treeMap : arrayList) {
                    String string4 = (String)treeMap.get(string2);
                    if (string4 != null && string4.length() > 0) {
                        String string5 = (String)treeMap.get("SOPINSTANCEUID");
                        if (string5 != null && string5.length() > 0) {
                            File file = new File(string, string5 + ".dcm");
                            slf4jlogger.info("Copying srcfilename \"{}\" to \"{}\"", string4, file);
                            CopyStream.copy(new File(string4), file);
                            continue;
                        }
                        slf4jlogger.warn("Cannot extract SOP Instance UID for \"{}\" to create output file name - ignoring", string4);
                        continue;
                    }
                    slf4jlogger.warn("Record missing filename - ignoring");
                }
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
            }
        }
    }

    public static void main(String[] stringArray) {
        block9: {
            try {
                if (stringArray.length == 4) {
                    Object object;
                    Object object2;
                    Object object3;
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    if (string.indexOf(46) == -1) {
                        string = "com.pixelmed.database." + string;
                    }
                    DatabaseInformationModel databaseInformationModel = null;
                    try {
                        object3 = Thread.currentThread().getContextClassLoader().loadClass(string);
                        object2 = new Class[]{string2.getClass()};
                        object = ((Class)object3).getConstructor((Class<?>)object2);
                        Object[] objectArray = new Object[]{string2};
                        databaseInformationModel = (DatabaseInformationModel)((Constructor)object).newInstance(objectArray);
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("", exception);
                        System.exit(0);
                    }
                    object3 = stringArray[3];
                    object2 = stringArray[2];
                    object = new HashSet();
                    if (((String)object3).startsWith("1")) {
                        object.add(object3);
                    } else {
                        for (String string3 : SOPClass.getPlausibleStandardSOPClassUIDsForModality((String)object3)) {
                            object.add(string3);
                        }
                    }
                    new FindAndCopySelectedDicomFilesUsingDatabase(databaseInformationModel, (Set<String>)object, (String)object2);
                    break block9;
                }
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.FindAndCopySelectedDicomFilesUsingDatabase databaseModelClassName databaseFileName dstdir sopclass|modality");
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
                System.exit(0);
            }
        }
    }
}

