/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.FunctionalGroupUtilities;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.ModalityTransform;
import com.pixelmed.dicom.OtherDoubleAttribute;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.PrivatePixelData;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.display.SourceImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;

public class IntegerScalingOfFloatingPointPixelData {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/IntegerScalingOfFloatingPointPixelData.java,v 1.26 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(IntegerScalingOfFloatingPointPixelData.class);

    public static void reportOnRoundTrip(double d, double d2, double d3, String string) {
        int n = (int)Math.round((d - d3) / d2) & 0xFFFF;
        double d4 = (double)n * d2 + d3;
        double d5 = Math.abs(d4 - d);
        slf4jlogger.info("performIntegerScaling(): {} {}, scaled = {}, unscaled = {}, abs error = {}", string, d, n, d4, d5);
    }

    public static void performIntegerScaling(String string, String string2, boolean bl) throws DicomException, FileNotFoundException, IOException {
        int n;
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        Attribute attribute = attributeList.getPixelData();
        if (attribute == null) {
            throw new DicomException("Input file does not contain Pixel Data");
        }
        if (!(attribute instanceof OtherFloatAttribute) && !(attribute instanceof OtherDoubleAttribute)) {
            throw new DicomException("Input file does not contain floating point Pixel Data");
        }
        slf4jlogger.info("performIntegerScaling(): calling SourceImage");
        SourceImage sourceImage = new SourceImage(attributeList);
        if (sourceImage == null) {
            throw new DicomException("Input file does not contain an image that can be extracted");
        }
        if (!sourceImage.isGrayscale()) {
            throw new DicomException("Input file does not contain grayscale data");
        }
        int n2 = sourceImage.getNumberOfBufferedImages();
        double d = 0.0;
        double d2 = 1.0;
        if (!bl) {
            double d3 = Double.MAX_VALUE;
            double d4 = Double.MIN_VALUE;
            for (int i = 0; i < n2; ++i) {
                double d5;
                sourceImage.getBufferedImage(i);
                double d6 = sourceImage.getMinimum();
                if (d6 < d3) {
                    d3 = d6;
                }
                if (!((d5 = sourceImage.getMaximum()) > d4)) continue;
                d4 = d5;
            }
            slf4jlogger.info("performIntegerScaling(): allFramesMin = {}", d3);
            slf4jlogger.info("performIntegerScaling(): allFramesMax = {}", d4);
            d = d3;
            slf4jlogger.info("performIntegerScaling(): intercept = {}", d);
            d2 = (d4 - d3) / 65535.0;
            slf4jlogger.info("performIntegerScaling(): slope = {} (1/slope = {})", d2, 1.0 / d2);
            IntegerScalingOfFloatingPointPixelData.reportOnRoundTrip(d3, d2, d, "allFramesMin");
            IntegerScalingOfFloatingPointPixelData.reportOnRoundTrip(d4, d2, d, "allFramesMax");
        }
        int n3 = sourceImage.getHeight() * sourceImage.getWidth() * n2;
        short[] sArray = new short[n3];
        if (attribute instanceof OtherFloatAttribute) {
            float[] fArray = attribute.getFloatValues();
            for (n = 0; n < n3; ++n) {
                sArray[n] = bl ? (short)Math.floor(fArray[n]) : (short)Math.round(((double)fArray[n] - d) / d2);
            }
        } else if (attribute instanceof OtherDoubleAttribute) {
            double[] dArray = attribute.getDoubleValues();
            for (n = 0; n < n3; ++n) {
                sArray[n] = bl ? (short)Math.floor(dArray[n]) : (short)Math.round((dArray[n] - d) / d2);
            }
        }
        OtherWordAttribute otherWordAttribute = new OtherWordAttribute(TagFromName.PixelData);
        ((Attribute)otherWordAttribute).setValues(sArray);
        PrivatePixelData.replacePixelData(attributeList, otherWordAttribute);
        Object object = new UnsignedShortAttribute(TagFromName.BitsStored);
        ((Attribute)object).addValue(16);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object).addValue(16);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.HighBit);
        ((Attribute)object).addValue(15);
        attributeList.put((Attribute)object);
        object = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        FunctionalGroupUtilities.removeFunctionalGroup(attributeList, TagFromName.PixelValueTransformationSequence);
        if (SOPClass.isEnhancedMultiframeImageStorage((String)object)) {
            FunctionalGroupUtilities.generatePixelValueTransformationFunctionalGroup(attributeList, n2, 1.0, 0.0, "US");
            attributeList.remove(TagFromName.RescaleSlope);
            attributeList.remove(TagFromName.RescaleIntercept);
            attributeList.remove(TagFromName.RescaleType);
        } else {
            StringAttribute stringAttribute = new DecimalStringAttribute(TagFromName.RescaleIntercept);
            ((Attribute)stringAttribute).addValue(d);
            attributeList.put(stringAttribute);
            stringAttribute = new DecimalStringAttribute(TagFromName.RescaleSlope);
            ((Attribute)stringAttribute).addValue(d2);
            attributeList.put(stringAttribute);
            stringAttribute = new LongStringAttribute(TagFromName.RescaleType);
            ((Attribute)stringAttribute).addValue("US");
            attributeList.put(stringAttribute);
        }
        FunctionalGroupUtilities.removeFunctionalGroup(attributeList, TagFromName.RealWorldValueMappingSequence);
        if (!bl) {
            FunctionalGroupUtilities.removeFunctionalGroup(attributeList, TagFromName.FrameVOILUTSequence);
            attributeList.remove(TagFromName.WindowCenter);
            attributeList.remove(TagFromName.WindowWidth);
            attributeList.remove(TagFromName.VOILUTFunction);
            if (SOPClass.isEnhancedMultiframeImageStorage((String)object)) {
                FunctionalGroupUtilities.generateVOILUTFunctionalGroup(attributeList, n2, 65536.0, 32767.0, "LINEAR");
            } else {
                StringAttribute stringAttribute = new DecimalStringAttribute(TagFromName.WindowWidth);
                ((Attribute)stringAttribute).addValue(65536);
                attributeList.put(stringAttribute);
                stringAttribute = new DecimalStringAttribute(TagFromName.WindowCenter);
                ((Attribute)stringAttribute).addValue((int)Short.MAX_VALUE);
                attributeList.put(stringAttribute);
                stringAttribute = new CodeStringAttribute(TagFromName.VOILUTFunction);
                ((Attribute)stringAttribute).addValue("LINEAR");
                attributeList.put(stringAttribute);
            }
        }
        if (((String)object).equals("1.3.6.1.4.1.5962.301.9")) {
            object = "1.2.840.10008.5.1.4.1.1.7.3";
        }
        Object object2 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object2).addValue((String)object);
        attributeList.put((Attribute)object2);
        if (((String)object).equals("1.2.840.10008.5.1.4.1.1.7.3")) {
            object2 = new AttributeTagAttribute(TagFromName.FrameIncrementPointer);
            ((AttributeTagAttribute)object2).addValue(TagFromName.PerFrameFunctionalGroupsSequence);
            attributeList.put((Attribute)object2);
        }
        if (SOPClass.isSecondaryCaptureImageStorage((String)object)) {
            object2 = new CodeStringAttribute(TagFromName.ConversionType);
            ((Attribute)object2).addValue("WSD");
            attributeList.put((Attribute)object2);
        }
        if (((String)(object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality))).equals("")) {
            object2 = "OT";
        }
        CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)codeStringAttribute).addValue((String)object2);
        attributeList.put(codeStringAttribute);
        object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PresentationLUTShape);
        if (((String)object2).equals("")) {
            object2 = "IDENTITY";
        }
        codeStringAttribute = new CodeStringAttribute(TagFromName.PresentationLUTShape);
        ((Attribute)codeStringAttribute).addValue((String)object2);
        attributeList.put(codeStringAttribute);
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.IntegerScalingOfFloatingPointPixelData.main()", null, VersionAndConstants.getBuildDate(), "Scaled floating point Pixel Data to integer");
        attributeList.removeMetaInformationHeaderAttributes();
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void reverseIntegerScaling(String string, String string2, boolean bl) throws DicomException, FileNotFoundException, IOException {
        double d;
        double d2;
        int n;
        Object object;
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        Attribute attribute = attributeList.getPixelData();
        if (attribute == null) {
            throw new DicomException("Input file does not contain Pixel Data");
        }
        if (!(attribute instanceof OtherWordAttribute)) {
            throw new DicomException("Input file does not contain short integer Pixel Data");
        }
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n6 = n3 * n4 * n2;
        int n7 = n5 * n6;
        ModalityTransform modalityTransform = new ModalityTransform(attributeList);
        if (n7 == 0) {
            throw new DicomException("Input file missing Rows or Columns");
        }
        short[] sArray = attribute.getShortValues();
        Attribute attribute2 = null;
        int n8 = 0;
        if (bl) {
            object = new double[n7];
            n = 0;
            for (int i = 0; i < n5; ++i) {
                d2 = modalityTransform.getRescaleSlope(i);
                d = modalityTransform.getRescaleIntercept(i);
                for (int j = 0; j < n6; ++j) {
                    object[n] = (double)(sArray[n] & 0xFFFF) * d2 + d;
                    ++n;
                }
            }
            attribute2 = new OtherDoubleAttribute(TagFromName.DoubleFloatPixelData);
            attribute2.setValues((double[])object);
            n8 = 64;
        } else {
            object = new float[n7];
            n = 0;
            for (int i = 0; i < n5; ++i) {
                d2 = modalityTransform.getRescaleSlope(i);
                d = modalityTransform.getRescaleIntercept(i);
                for (int j = 0; j < n6; ++j) {
                    object[n] = (float)((double)(sArray[n] & 0xFFFF) * d2 + d);
                    ++n;
                }
            }
            attribute2 = new OtherFloatAttribute(TagFromName.FloatPixelData);
            attribute2.setValues((float[])object);
            n8 = 32;
        }
        PrivatePixelData.replacePixelData(attributeList, attribute2);
        attributeList.remove(TagFromName.BitsStored);
        object = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object).addValue(n8);
        attributeList.put((Attribute)object);
        attributeList.remove(TagFromName.HighBit);
        attributeList.remove(TagFromName.PixelRepresentation);
        object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
        ((Attribute)object).addValue(0);
        attributeList.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.RescaleSlope);
        ((Attribute)object).addValue(1);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.RescaleType);
        ((Attribute)object).addValue("US");
        attributeList.put((Attribute)object);
        FunctionalGroupUtilities.removeFunctionalGroup(attributeList, TagFromName.PixelValueTransformationSequence);
        object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (((String)object).equals("1.2.840.10008.5.1.4.1.1.7.3")) {
            object = "1.3.6.1.4.1.5962.301.9";
        }
        Attribute attribute3 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        attribute3.addValue((String)object);
        attributeList.put(attribute3);
        if (((String)object).equals("1.3.6.1.4.1.5962.301.9")) {
            attribute3 = new AttributeTagAttribute(TagFromName.FrameIncrementPointer);
            ((AttributeTagAttribute)attribute3).addValue(TagFromName.PerFrameFunctionalGroupsSequence);
            attributeList.put(attribute3);
            double d3 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleSlope, 0.0);
            if (d3 > 0.0) {
                d2 = Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.RescaleIntercept, 0.0);
                String string3 = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.RescaleType, "US");
                FunctionalGroupUtilities.generatePixelValueTransformationFunctionalGroup(attributeList, n5, d3, d2, string3);
                attributeList.remove(TagFromName.RescaleSlope);
                attributeList.remove(TagFromName.RescaleIntercept);
                attributeList.remove(TagFromName.RescaleType);
            }
            attributeList.remove(TagFromName.ConversionType);
        }
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.IntegerScalingOfFloatingPointPixelData.main()", null, VersionAndConstants.getBuildDate(), "Scaled integer Pixel Data to floating point");
        attributeList.removeMetaInformationHeaderAttributes();
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            String string = null;
            String string2 = null;
            if (stringArray.length == 2) {
                bl = false;
                bl2 = true;
                string = stringArray[0];
                string2 = stringArray[1];
            } else if (stringArray.length == 3) {
                string = stringArray[1];
                string2 = stringArray[2];
                if (stringArray[0].toLowerCase(Locale.US).equals("toint")) {
                    bl = false;
                    bl2 = true;
                    bl4 = false;
                } else if (stringArray[0].toLowerCase(Locale.US).equals("tointtruncate")) {
                    bl = false;
                    bl2 = true;
                    bl4 = true;
                } else if (stringArray[0].toLowerCase(Locale.US).equals("tofloat")) {
                    bl = false;
                    bl2 = false;
                    bl3 = false;
                } else if (stringArray[0].toLowerCase(Locale.US).equals("todouble")) {
                    bl = false;
                    bl2 = false;
                    bl3 = true;
                }
            }
            if (bl) {
                System.err.println("usage: IntegerScalingOfFloatingPointPixelData [toFloat|toDouble|toInt] inputFile outputFile");
            } else if (bl2) {
                IntegerScalingOfFloatingPointPixelData.performIntegerScaling(string, string2, bl4);
            } else {
                IntegerScalingOfFloatingPointPixelData.reverseIntegerScaling(string, string2, bl3);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

