/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.MultipleInstanceTransferStatusHandlerWithFileName;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public class MultiModalitySimulator {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/MultiModalitySimulator.java,v 1.18 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MultiModalitySimulator.class);
    protected static String[] modalities = new String[]{"CT", "MR", "DX", "CR", "US", "NM", "XA", "MG", "SR", "PR"};
    protected static int[] sleepIntervalForModalityInMinutes = new int[]{1, 8, 1, 1, 4, 15, 30, 1, 1, 1};
    protected Map<String, Integer> sleepIntervalForModality = new HashMap<String, Integer>();
    protected int defaultSleepIntervalMultiplier;
    protected int sleepIntervalMultiplier;
    protected static long accessionNumberCounter = System.currentTimeMillis();
    protected String[] patientNames;
    protected String seriesLocalParentReferenceColumnName;
    protected String localFileNameColumnName;
    protected String modalityColumnName;
    protected DatabaseInformationModel databaseInformationModel;
    protected String hostname;
    protected int port;
    protected String calledAETitle;

    protected int getSleepIntervalForModalityInMilliseconds(String string) {
        return this.sleepIntervalForModality.get(string) * this.sleepIntervalMultiplier;
    }

    protected void findFilesToSend(InformationEntity informationEntity, String string, List<String> list) throws DicomException {
        slf4jlogger.trace("findFilesToSend(): checking {} {}", informationEntity, string);
        if (informationEntity == InformationEntity.INSTANCE) {
            Map map = this.databaseInformationModel.findAllAttributeValuesForSelectedRecord(InformationEntity.INSTANCE, string);
            this.localFileNameColumnName = this.databaseInformationModel.getLocalFileNameColumnName(InformationEntity.INSTANCE);
            String string2 = (String)map.get(this.localFileNameColumnName);
            list.add(string2);
            slf4jlogger.trace("findFilesToSend(): added file = {}", string2);
        } else {
            InformationEntity informationEntity2 = this.databaseInformationModel.getChildTypeForParent(informationEntity);
            slf4jlogger.trace("findFilesToSend(): childIE is {}", informationEntity2);
            ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(informationEntity2, string);
            while (informationEntity2 != null && arrayList == null || arrayList.size() == 0) {
                informationEntity2 = this.databaseInformationModel.getChildTypeForParent(informationEntity2);
                slf4jlogger.trace("findFilesToSend(): empty so descending to next childIE {}", informationEntity2);
                arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(informationEntity2, string);
            }
            if (arrayList != null) {
                for (Map map : arrayList) {
                    String string3 = (String)map.get(this.databaseInformationModel.getLocalPrimaryKeyColumnName(informationEntity2));
                    this.findFilesToSend(informationEntity2, string3, list);
                }
            }
        }
    }

    protected SetOfDicomFiles generateSyntheticStudyFromOriginal(List<String> list, String string, String string2, String string3, String string4, String string5, String string6) throws DicomException, IOException {
        slf4jlogger.debug("generateSyntheticStudyFromOriginal(): generating modality={} patientName={} patientID={} studyID={} accessionNumber={}", string, string3, string4, string5, string6);
        ClinicalTrialsAttributes.flushMapOfUIDs();
        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
        if (list != null) {
            for (String string7 : list) {
                if (string7 == null) continue;
                slf4jlogger.trace("generateSyntheticStudyFromOriginal(): doing file {}", string7);
                File file = new File(string7);
                DicomInputStream dicomInputStream = new DicomInputStream(file);
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                attributeList.removeGroupLengthAttributes();
                attributeList.correctDecompressedImagePixelModule();
                attributeList.insertLossyImageCompressionHistoryIfDecompressed();
                attributeList.removeMetaInformationHeaderAttributes();
                ClinicalTrialsAttributes.removeClinicalTrialsAttributes(attributeList);
                ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, true, true, false, true, false);
                attributeList.remove(TagFromName.DeidentificationMethod);
                attributeList.remove(TagFromName.DeidentificationMethodCodeSequence);
                attributeList.remove(TagFromName.PatientIdentityRemoved);
                Object object = new PersonNameAttribute(TagFromName.PatientName);
                ((Attribute)object).addValue(string3);
                attributeList.put((Attribute)object);
                object = new LongStringAttribute(TagFromName.PatientID);
                ((Attribute)object).addValue(string4);
                attributeList.put((Attribute)object);
                object = new DateAttribute(TagFromName.PatientBirthDate);
                attributeList.put((Attribute)object);
                object = new CodeStringAttribute(TagFromName.PatientSex);
                attributeList.put((Attribute)object);
                object = new AgeStringAttribute(TagFromName.PatientAge);
                attributeList.put((Attribute)object);
                object = new ShortStringAttribute(TagFromName.StudyID);
                ((Attribute)object).addValue(string5);
                attributeList.put((Attribute)object);
                object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
                ((Attribute)object).addValue("^^^^");
                attributeList.put((Attribute)object);
                object = new ShortStringAttribute(TagFromName.AccessionNumber);
                ((Attribute)object).addValue(string6);
                attributeList.put((Attribute)object);
                object = new LongStringAttribute(TagFromName.InstitutionName);
                ((Attribute)object).addValue("St. Elsewhere's");
                attributeList.put((Attribute)object);
                object = new Date();
                String string8 = new SimpleDateFormat("yyyyMMdd").format((Date)object);
                String string9 = new SimpleDateFormat("HHmmss.SSS").format((Date)object);
                StringAttribute stringAttribute = new DateAttribute(TagFromName.StudyDate);
                ((Attribute)stringAttribute).addValue(string8);
                attributeList.put(stringAttribute);
                stringAttribute = new TimeAttribute(TagFromName.StudyTime);
                ((Attribute)stringAttribute).addValue(string9);
                attributeList.put(stringAttribute);
                stringAttribute = new DateAttribute(TagFromName.SeriesDate);
                ((Attribute)stringAttribute).addValue(string8);
                attributeList.put(stringAttribute);
                stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
                ((Attribute)stringAttribute).addValue(string9);
                attributeList.put(stringAttribute);
                stringAttribute = new DateAttribute(TagFromName.ContentDate);
                ((Attribute)stringAttribute).addValue(string8);
                attributeList.put(stringAttribute);
                stringAttribute = new TimeAttribute(TagFromName.ContentTime);
                ((Attribute)stringAttribute).addValue(string9);
                attributeList.put(stringAttribute);
                stringAttribute = new DateAttribute(TagFromName.AcquisitionDate);
                ((Attribute)stringAttribute).addValue(string8);
                attributeList.put(stringAttribute);
                stringAttribute = new TimeAttribute(TagFromName.AcquisitionTime);
                ((Attribute)stringAttribute).addValue(string9);
                attributeList.put(stringAttribute);
                stringAttribute = new DateAttribute(TagFromName.InstanceCreationDate);
                ((Attribute)stringAttribute).addValue(string8);
                attributeList.put(stringAttribute);
                stringAttribute = new TimeAttribute(TagFromName.InstanceCreationTime);
                ((Attribute)stringAttribute).addValue(string9);
                attributeList.put(stringAttribute);
                stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
                ((Attribute)stringAttribute).addValue(DateTimeAttribute.getTimeZone(TimeZone.getDefault(), (Date)object));
                attributeList.put(stringAttribute);
                object = new UniqueIdentifierAttribute(TagFromName.InstanceCreatorUID);
                ((Attribute)object).addValue("1.3.6.1.4.1.5962.99.3");
                attributeList.put((Attribute)object);
                attributeList.removeUnsafePrivateAttributes();
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", string2);
                attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                object = File.createTempFile("synth", ".dcm");
                ((File)object).deleteOnExit();
                attributeList.write((File)object);
                string8 = ((File)object).getCanonicalPath();
                setOfDicomFiles.add(string8, Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPClassUID), Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID), Attribute.getSingleStringValueOrNull(attributeList, TagFromName.TransferSyntaxUID));
                slf4jlogger.trace("generateSyntheticStudyFromOriginal(): synthetic file {}", string8);
            }
        }
        return setOfDicomFiles;
    }

    protected static void deleteFiles(SetOfDicomFiles setOfDicomFiles) {
        for (SetOfDicomFiles.DicomFile dicomFile : setOfDicomFiles) {
            String string = dicomFile.getFileName();
            if (new File(string).delete()) continue;
            slf4jlogger.error("Failed to delete file {}", string);
        }
    }

    public MultiModalitySimulator(String string, int n, String string2, String string3, String string4) throws DicomException {
        Set<String> set;
        for (int i = 0; i < modalities.length; ++i) {
            this.sleepIntervalForModality.put(modalities[i], new Integer(sleepIntervalForModalityInMinutes[i]));
        }
        this.defaultSleepIntervalMultiplier = 60000;
        this.patientNames = new String[]{"Moses", "Mahavira", "Zoroaster", "Ananda", "Chuang-Tzu", "Mencius", "Tzu^Mo", "^John^^St.", "^Peter^^St.", "^Paul^^St.", "Akiva^^^Rabbi", "Mani", "^Augustine^^St.", "^Patrick^^St.", "Bakr^Abu", "Shankara", "Daishi^K\u014db\u014d", "Atisha^", "Aquinas^Thomas^^St.", "Shah^Mohammed", "Tsongkhapa", "d'Arc^Jeanne", "Nanak^", "Sultan^Tipu", "Ramakrishna^", "Guru^Narayana", "Truth^Sojourner", "Adamastor of Oldham", "Homer", "Thespis", "Lun^Ling", "Xizhi^Wang", "Valmiki^", "Virgil^", "Kalidas^", "Po^Li", "Fu^Du", "al-Din Rumi^Jalal", "Alighieri^Dante", "Emre^Yunus", "Amir Khusro", "Ibn Muqlah", "Michaelangelo", "Raphael", "Shakespeare^William", "de Cervantes^Miguel", "van Rijn^Rembrandt", "Vermeer^Johannes", "Bach^J. S.", "Mozart^Wolfgang^Amadeus", "von Goethe^Johann^Wolfgang", "van Beethoven^Ludwig", "Hugo^Victor", "van Gogh^Vincent", "Brahms^Johannes", "Dvo\u0159\u00e1k^Anton\u00edn", "Twain^Mark", "Monet^Claude", "Conrad^Joseph", "Kafka^Franz", "Armstrong^Louis", "Ellington^Duke", "Picasso^Pablo", "Davis^Miles", "Hendrix^Jimi", "Presley^Elvis", "Ptah^Merit", "Shi^Xi Ling", "Nabu-rimanni", "Socrates", "Plato", "Aristotle", "Euclid", "Ptolemy", "Hypatia", "Zu Chongzhi", "Aryabhata", "Al-Kindi", "Al-Khwarizmi", "Al-Razi", "Alhazen", "Copernicus^Nicolaus", "Bacon^Francis", "Brahe^Tycho", "Kepler^Johannes", "Newton^Isaac", "Galilei^Galileo", "Descartes^Ren\u00e9", "van Leeuwenhoek^Antony", "Leibniz^Gottfried", "Lomonosov^Mikhail", "Lavoisier^Antoine^Laurent", "Gauss^Carl^Friedrich", "Dalton^John", "Faraday^Michael", "Maxwell^James^Clerk", "Pasteur^Louis", "Darwin^Charles", "Rutherford^Ernest", "Curie^Marie", "Einstein^Albert", "Bohr^Niels", "Heisenberg^Werner", "Fermi^Enrico", "Franklin^Rosalind", "Sakharov^Andrei", "Harkuf", "Hanno", "Pytheas", "Qian^Zhang", "Aretas^^^^III", "Erickson^Leif", "Anshi^Wang", "Dandolo^Enrico", "Polo^Marco", "Ibn Battuta", "Whittington^Richard", "de Medici^Giovanni", "He^Zheng", "da Gama^Vasco", "Columbus^Christopher", "Magellan^Ferdinand", "Cartier^Jacques", "Raja Todar Mal", "van Diemen^Anthony", "Roe^Thomas^^Sir", "Shah Jahan", "Smith^Adam", "Cook^James", "Vanderbilt^Cornelius", "Mackenzie^Alexander^^Sir", "Mill^John^Stuart", "Carnegie^Andrew", "Rockefeller^John^D", "Keynes^John^Maynard", "Chanel^Coco", "Imhotep", "Archimedes", "Heron", "Lun^Cai", "Heng^Zhang", "Sheng^Bi", "da Vinci^Leonardo", "Sinan", "Schickard^Wilhelm", "Pascal^Blaise", "Franklin^Benjamin", "de Coulomb^Charles^Augustin", "Watt^James", "Fulton^Robert", "Jacquard^Joseph^Marie", "Brunel^Isambard^Kingdom", "Morton^William^TG", "Daguerre^Louis", "de Lesseps^Ferdinand", "Roebling^John", "Rillieux^Norbert", "Bessemer^Henry", "Singh^Nain", "Bell^Alexander^Graham", "Otto^Nikolaus^August", "Daimler^Gottlieb", "Tesla^Nikola", "Edison^Thomas", "Marconi^Guglielmo", "Eiffel^Alexandre^Gustave", "Goethals^George^Washington", "Ford^Henry", "Wright^Wilbur", "Wright^Orville", "Sargon", "Nebuchadnezzar^^^^II", "Tzu^Sun", "Leonidas", "Lysander", "Maurya^Chandragupta", "Barca^Hamilcar", "Marius^Gaius", "Africanus^Scipio", "Vercingetorix", "Arminius", "Boudica", "Cao^Cao", "Liang^Zhuge", "Belisarius", "ibn al-Walid^Khalid", "Martel^Charles", "Charlemagne", "Jayavarman^^^II", "El Cid", "William the Conqueror", "Subutai", "Timur", "Pachacuti", "Auitzotl", "Cort\u00e9s^Hernan", "Pizzaro^Francisco", "Ivan the Terrible", "Akbar^Jalaluddin^Muhammad", "Gustavus II Adolphus", "de Ruyter^Michiel ", "Cromwell^Oliver", "Eugene of Savoy", "Nelson^Horatio", "Lee^Robert", "Geronimo", "Dewey^George", "Yamamoto^Isoroku", "Patton^George^Simpson", "Montgomery^Bernard", "MacArthur^Douglas", "Guderian^Heinz", "Rommel^Erwin", "Zhukov^Georgy", "Guevara^Che", "Pebekkamen", "Ephialtes", "Ke^Jing", "Wuyang^Qin", "Calippus", "Alberti^Leone", "Barlow^John", "Walsingham^Francis", "Hanzo^Hattori", "Gerard^Balthasar", "Babington^Anthony", "Goemon^Ishikawa", "Graziani^Gaspar", "Fawkes^Guy", "Honeyman^John", "Hale^Nathan", "Corday^Charlotte", "Casanova^Giacomo", "Pinkerton^Allan", "Melville^William", "Boyd^Belle", "Reilly^Sidney", "Jung-Geun^An", "Dansey^Claude", "Hari^Mata", "Hoover^J^Edgar", "Berg^Moe", "Rosenberg^Ethel", "Rosenberg^Julius", "von Stauffenberg^Claus", "Spaak^Suzanne", "Donovan^William", "Griph^Viktor", "Matise^Joe", "Cole^Daniel", "Swiss^Mark", "Foshaug the Deceiver", "Speaker the Lionhearted", "Herodotus", "Thucydides", "Pliny", "^Augustine^^St.", "Gibbon", "Toynbee", "McCauley^^^Lord", "Livy", "Tacitus", "The Venerable Bede", "Machiavelli"};
        this.hostname = string;
        this.port = n;
        this.calledAETitle = string2;
        this.sleepIntervalMultiplier = string4 == null || string4.length() == 0 ? this.defaultSleepIntervalMultiplier : Integer.parseInt(string4);
        slf4jlogger.debug("Opening database ...");
        this.databaseInformationModel = new PatientStudySeriesConcatenationInstanceModel(string3);
        this.seriesLocalParentReferenceColumnName = this.databaseInformationModel.getLocalParentReferenceColumnName(InformationEntity.SERIES);
        this.localFileNameColumnName = this.databaseInformationModel.getLocalFileNameColumnName(InformationEntity.INSTANCE);
        this.modalityColumnName = this.databaseInformationModel.getDatabaseColumnNameFromDicomTag(TagFromName.Modality);
        slf4jlogger.debug("Building indexes of modality studies from database ...");
        HashMap hashMap = new HashMap();
        for (String string5 : modalities) {
            set = new HashSet();
            hashMap.put(string5, set);
            ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(InformationEntity.SERIES, this.modalityColumnName, string5);
            for (Map map : arrayList) {
                String string6 = (String)map.get(this.seriesLocalParentReferenceColumnName);
                if (string6 == null || string6.length() <= 0) continue;
                set.add(string6);
            }
        }
        slf4jlogger.debug("ready to begin simulation ...");
        for (String string5 : modalities) {
            set = (Set)hashMap.get(string5);
            if (set != null && set.size() > 0) {
                new Thread(new SpecificModalitySimulator(string5, set)).start();
                continue;
            }
            slf4jlogger.debug("no {} studies", string5);
        }
    }

    public MultiModalitySimulator(String string, int n, String string2, String string3) throws DicomException {
        this(string, n, string2, string3, null);
    }

    public MultiModalitySimulator(String string, int n, String string2, String string3, int n2) throws DicomException {
        this(string, n, string2, string3);
        slf4jlogger.warn("Debug level supplied in constructor ignored");
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            int n = -1;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (stringArray.length == 4 || stringArray.length == 5) {
                string = stringArray[0];
                n = Integer.parseInt(stringArray[1]);
                string2 = stringArray[2];
                string3 = stringArray[3];
                if (stringArray.length == 5) {
                    string4 = stringArray[4];
                }
            } else {
                throw new Exception("Argument list must be 4 or 5 values");
            }
            new MultiModalitySimulator(string, n, string2, string3, string4);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class SpecificModalitySimulator
    implements Runnable {
        String modality;
        String[] localPrimaryKeysOfAllStudiesOfThisModality;
        int numberOfStudies;
        int numberOfStudiesMinusOne;
        int sleepInterval;
        int studyIDCounter;

        SpecificModalitySimulator(String string, Set<String> set) {
            this.modality = string;
            this.numberOfStudies = set.size();
            this.localPrimaryKeysOfAllStudiesOfThisModality = set.toArray(new String[this.numberOfStudies]);
            this.numberOfStudiesMinusOne = this.numberOfStudies - 1;
            this.sleepInterval = MultiModalitySimulator.this.getSleepIntervalForModalityInMilliseconds(string);
            this.studyIDCounter = (int)(Math.random() * 10000.0);
        }

        @Override
        public void run() {
            if (this.numberOfStudies > 0) {
                boolean bl = false;
                while (!bl) {
                    int n = (int)(Math.random() * (double)this.numberOfStudiesMinusOne);
                    slf4jlogger.trace("SpecificModalitySimulator(): Selected {} {}", this.modality, n);
                    String string = this.localPrimaryKeysOfAllStudiesOfThisModality[n];
                    slf4jlogger.trace("SpecificModalitySimulator(): Selected {} {} {}", this.modality, n, string);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    try {
                        MultiModalitySimulator.this.findFilesToSend(InformationEntity.STUDY, string, arrayList);
                        int n2 = (int)(Math.random() * (double)(MultiModalitySimulator.this.patientNames.length - 1));
                        String string2 = MultiModalitySimulator.this.patientNames[n2];
                        String string3 = Integer.toString(263874 + n2);
                        String string4 = Integer.toString(this.studyIDCounter++);
                        String string5 = Long.toString(accessionNumberCounter++);
                        SetOfDicomFiles setOfDicomFiles = MultiModalitySimulator.this.generateSyntheticStudyFromOriginal(arrayList, this.modality, this.modality, string2, string3, string4, string5);
                        new StorageSOPClassSCU(MultiModalitySimulator.this.hostname, MultiModalitySimulator.this.port, MultiModalitySimulator.this.calledAETitle, this.modality, setOfDicomFiles, 0, new OurMultipleInstanceTransferStatusHandler());
                        MultiModalitySimulator.deleteFiles(setOfDicomFiles);
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("", exception);
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(this.sleepInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        slf4jlogger.error("", interruptedException);
                        bl = true;
                    }
                }
            }
        }
    }

    protected class OurMultipleInstanceTransferStatusHandler
    extends MultipleInstanceTransferStatusHandlerWithFileName {
        protected OurMultipleInstanceTransferStatusHandler() {
        }

        @Override
        public void updateStatus(int n, int n2, int n3, int n4, String string, String string2, boolean bl) {
            slf4jlogger.trace("Remaining {}, completed {}, failed {}, warning {}", n, n2, n3, n4);
            if (bl) {
                slf4jlogger.trace("Sent {}", string2);
            } else {
                slf4jlogger.info("Failed to send {}", string2);
            }
        }
    }
}

