/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.apps.DoseReporterWithLegacyOCRAndAutoSendToRegistry;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RemapUIDs {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/RemapUIDs.java,v 1.14 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DoseReporterWithLegacyOCRAndAutoSendToRegistry.class);
    protected String ourAETitle = "OURAETITLE";
    private Set<String> setOfCanonicalUIDs = new HashSet<String>();
    private Map<String, String> mapOfOtherUIDToCanonicalUID = new HashMap<String, String>();
    private String dstFolderName;

    public static void remapUIDs(AttributeList attributeList, Set<String> set, Map<String, String> map) {
        for (Attribute attribute : attributeList.values()) {
            Object object;
            Object object2;
            Object object3;
            if (attribute instanceof UniqueIdentifierAttribute) {
                try {
                    object3 = attribute.getStringValues();
                    if (object3 == null || ((String[])object3).length <= 0) continue;
                    object2 = attribute.getTag();
                    object = attributeList.getDictionary().getNameFromTag((AttributeTag)object2);
                    attribute.removeValues();
                    for (int i = 0; i < ((Object)object3).length; ++i) {
                        Object object4 = object3[i];
                        if (object4 != null && ((String)object4).length() > 0) {
                            if (set.contains(object4)) {
                                System.err.println("Already canonical " + object2 + " " + (String)object + " " + (String)object4);
                            } else if (((AttributeTag)object2).equals(TagFromName.TransferSyntaxUID)) {
                                System.err.println("Not mapping Transfer Syntax UID " + object2 + " " + (String)object + " " + (String)object4);
                            } else if (((AttributeTag)object2).equals(TagFromName.SOPClassUID) || ((AttributeTag)object2).equals(TagFromName.ReferencedSOPClassUID) || SOPClass.getSetOfStorageSOPClasses().contains(object4)) {
                                System.err.println("Not mapping SOP Class UID " + object2 + " " + (String)object + " " + (String)object4);
                            } else {
                                String string = map.get(object4);
                                if (string != null && string.length() > 0) {
                                    System.err.println("Mapping " + object2 + " " + (String)object + " " + (String)object4 + " to canonical " + string);
                                    object4 = string;
                                } else {
                                    System.err.println("Not mapping " + object2 + " " + (String)object + " " + (String)object4);
                                }
                            }
                        }
                        attribute.addValue((String)object4);
                    }
                    continue;
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                    continue;
                }
            }
            if (!(attribute instanceof SequenceAttribute)) continue;
            object3 = ((SequenceAttribute)attribute).iterator();
            while (object3.hasNext()) {
                object2 = (SequenceItem)object3.next();
                if (object2 == null || (object = ((SequenceItem)object2).getAttributeList()) == null) continue;
                RemapUIDs.remapUIDs((AttributeList)object, set, map);
            }
        }
    }

    private void reapMapFile(String string) throws FileNotFoundException, IOException {
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
        String string2 = null;
        while ((string2 = lineNumberReader.readLine()) != null && string2.trim().length() > 0) {
            String[] stringArray = string2.split("\t");
            if (stringArray.length >= 2) {
                this.setOfCanonicalUIDs.add(stringArray[0]);
                for (int i = 1; i < stringArray.length; ++i) {
                    this.mapOfOtherUIDToCanonicalUID.put(stringArray[i], stringArray[0]);
                }
                continue;
            }
            slf4jlogger.warn("Ignoring too few or too many UIDs (pair of 2 required): {}", string2);
        }
        lineNumberReader.close();
    }

    public RemapUIDs(String string, String string2, String string3) throws FileNotFoundException, IOException, DicomException {
        this.dstFolderName = string3;
        this.reapMapFile(string);
        OurMediaImporter ourMediaImporter = new OurMediaImporter();
        ourMediaImporter.importDicomFiles(string2);
    }

    public static void main(String[] stringArray) {
        try {
            new RemapUIDs(stringArray[0], stringArray[1], stringArray[2]);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter() {
            super(null);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            System.err.println("Doing " + string);
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                RemapUIDs.remapUIDs(attributeList, RemapUIDs.this.setOfCanonicalUIDs, RemapUIDs.this.mapOfOtherUIDToCanonicalUID);
                ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.RemapUIDs", null, "Vers. " + VersionAndConstants.getBuildDate(), "Remapped UIDs");
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", RemapUIDs.this.ourAETitle);
                File file = new File(RemapUIDs.this.dstFolderName, MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList));
                if (file.exists()) {
                    throw new DicomException("\"" + string + "\": new file \"" + file + "\" already exists - not overwriting");
                }
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new DicomException("\"" + string + "\": parent directory creation failed for \"" + file + "\"");
                }
                attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }
}

