/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ShrinkSegmentationToBoundingBox {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/ShrinkSegmentationToBoundingBox.java,v 1.5 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ShrinkSegmentationToBoundingBox.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addTLHCOfClippedRegionToImagePosition(AttributeList attributeList, int[] nArray) throws DicomException {
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        if (sequenceAttribute == null || sequenceAttribute2 == null) throw new DicomException("Missing SharedFunctionalGroupsSequence or PerFrameFunctionalGroupsSequence");
        SequenceAttribute sequenceAttribute3 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PlaneOrientationSequence);
        SequenceAttribute sequenceAttribute4 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PlanePositionSequence);
        SequenceAttribute sequenceAttribute5 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PixelMeasuresSequence);
        if (sequenceAttribute3 == null || sequenceAttribute4 != null || sequenceAttribute5 == null) throw new DicomException("Expected share orientation and pixel measures and per-frame position functioanl groups");
        Attribute attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute5, TagFromName.PixelSpacing);
        if (attribute == null) throw new DicomException("Missing PixelSpacing in shared PixelMeasuresSequence");
        double[] dArray = attribute.getDoubleValues();
        if (dArray == null || dArray.length != 2) throw new DicomException("Missing or incorrect number of values for PixelSpacing in shared PixelMeasuresSequence");
        Attribute attribute2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute5, TagFromName.SpacingBetweenSlices);
        if (attribute2 == null && (attribute2 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute5, TagFromName.SliceThickness)) != null) {
            slf4jlogger.warn("Missing SpacingBetweenSlices in shared PixelMeasuresSequence but using SliceThickness as substitute");
        }
        if (attribute2 == null) throw new DicomException("Missing SpacingBetweenSlices in shared PixelMeasuresSequence");
        double d = attribute2.getSingleDoubleValueOrDefault(0.0);
        int n4 = nArray[0];
        slf4jlogger.debug("addTLHCOfClippedRegionToImagePosition(): newMinX = {}", n4);
        int n5 = nArray[1];
        slf4jlogger.debug("addTLHCOfClippedRegionToImagePosition(): newMinY = {}", n5);
        Attribute attribute3 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute3, TagFromName.ImageOrientationPatient);
        if (attribute3 == null) throw new DicomException("Missing ImageOrientationPatient in shared PlaneOrientationSequence");
        double[] dArray2 = attribute3.getDoubleValues();
        if (dArray2 == null || dArray2.length != 6) throw new DicomException("Missing or incorrect number of values for ImageOrientationPatient in shared PlaneOrientationSequence");
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        dArray3[0] = dArray2[0];
        dArray3[1] = dArray2[1];
        dArray3[2] = dArray2[2];
        dArray4[0] = dArray2[3];
        dArray4[1] = dArray2[4];
        dArray4[2] = dArray2[5];
        double[] dArray5 = new double[]{dArray[0], dArray[1], d};
        double[] dArray6 = new double[]{n, n2, 1.0};
        for (int i = 0; i < n3; ++i) {
            SequenceAttribute sequenceAttribute6 = (SequenceAttribute)sequenceAttribute2.getItem(i).getAttributeList().get(TagFromName.PlanePositionSequence);
            if (sequenceAttribute6 == null) throw new DicomException("Missing per-frame PlanePositionSequence");
            Attribute attribute4 = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute6, TagFromName.ImagePositionPatient);
            if (attribute4 == null) throw new DicomException("Missing ImagePositionPatient in per-frame PlanePositionSequence");
            double[] dArray7 = attribute4.getDoubleValues();
            slf4jlogger.debug("addTLHCOfClippedRegionToImagePosition(): frame {}: old tlhc = {},{},{}", i, dArray7[0], dArray7[1], dArray7[2]);
            if (dArray7 == null || dArray7.length != 3) {
                throw new DicomException("Missing or incorrect number of values for ImagePositionPatient in per-frame PlanePositionSequence");
            }
            GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray3, dArray4, dArray7, dArray5, 0.0, dArray6);
            double[] dArray8 = geometryOfSlice.lookupImageCoordinate((double)n4 + 0.5, (double)n5 + 0.5);
            slf4jlogger.debug("addTLHCOfClippedRegionToImagePosition(): frame {}: new tlhc = {},{},{}", i, dArray8[0], dArray8[1], dArray8[2]);
            attribute4.removeValues();
            attribute4.addValue(dArray8[0]);
            attribute4.addValue(dArray8[1]);
            attribute4.addValue(dArray8[2]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int[] compute2DInPlaneBoundingBoxForSegments(AttributeList attributeList) throws DicomException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        int n8 = Integer.MAX_VALUE;
        int n9 = 0;
        int n10 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        int n11 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n12 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n13 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 1);
        Attribute attribute = attributeList.get(TagFromName.PixelData);
        if (attribute == null) throw new DicomException("Missing PixelData attribute");
        slf4jlogger.debug("compute2DInPlaneBoundingBoxForSegments(): aPixelData is {}", attribute.getClass());
        byte[] byArray = attribute.getByteValues();
        Object var12_13 = null;
        if (n13 == 1) {
            n5 = (n12 * n11 * n10 - 1) / 8 + 1;
            if (byArray.length < n5) throw new DicomException("For 1 bit image, expected " + n5 + " bytes in PixelData but were " + byArray.length);
            for (n4 = 0; n4 < n12; ++n4) {
                slf4jlogger.debug("compute2DInPlaneBoundingBoxForSegments(): Searching frame {}", n4);
                for (n3 = 0; n3 < n11; ++n3) {
                    for (n2 = 0; n2 < n10; ++n2) {
                        n = ShrinkSegmentationToBoundingBox.getBit(byArray, n4, n3, n2, n11, n10);
                        if (n == 0) continue;
                        slf4jlogger.debug("compute2DInPlaneBoundingBoxForSegments(): Non-zero pixel at col {} row {}", n2, n3);
                        if (n2 < n6) {
                            n6 = n2;
                        }
                        if (n2 > n7) {
                            n7 = n2;
                        }
                        if (n3 < n8) {
                            n8 = n3;
                        }
                        if (n3 <= n9) continue;
                        n9 = n3;
                    }
                }
                slf4jlogger.debug("minx so far {}", n6);
                slf4jlogger.debug("maxx so far {}", n7);
                slf4jlogger.debug("miny so far {}", n8);
                slf4jlogger.debug("maxy so far {}", n9);
            }
        } else {
            if (n13 != 8) throw new DicomException("BitsStored " + n13 + " not supported");
            n5 = n12 * n11 * n10;
            if (byArray.length < n5) throw new DicomException("For 8 bit image, expected " + n5 + " bytes in PixelData but were " + byArray.length);
            n4 = 0;
            for (n3 = 0; n3 < n12; ++n3) {
                for (n2 = 0; n2 < n11; ++n2) {
                    for (n = 0; n < n10; ++n) {
                        byte by;
                        if ((by = byArray[n4++]) == 0) continue;
                        slf4jlogger.debug("Non-zero pixel at col {} row {}", n, n2);
                        if (n < n6) {
                            n6 = n;
                        }
                        if (n > n7) {
                            n7 = n;
                        }
                        if (n2 < n8) {
                            n8 = n2;
                        }
                        if (n2 <= n9) continue;
                        n9 = n2;
                    }
                }
            }
        }
        slf4jlogger.debug("minx {}", n6);
        slf4jlogger.debug("maxx {}", n7);
        slf4jlogger.debug("miny {}", n8);
        slf4jlogger.debug("maxy {}", n9);
        int n14 = 2;
        if (n14 > 0) {
            int n15;
            for (n15 = n14; n6 > 0 && n15 > 0; --n6, --n15) {
            }
            for (n15 = n14; n8 > 0 && n15 > 0; --n8, --n15) {
            }
            for (n15 = n14; n7 < n10 - 1 && n15 > 0; ++n7, --n15) {
            }
            for (n15 = n14; n9 < n11 - 1 && n15 > 0; ++n9, --n15) {
            }
            slf4jlogger.debug("padded oldColumns {}", n10);
            slf4jlogger.debug("padded oldRows {}", n11);
            slf4jlogger.debug("padded minx {}", n6);
            slf4jlogger.debug("padded maxx {}", n7);
            slf4jlogger.debug("padded miny {}", n8);
            slf4jlogger.debug("padded maxy {}", n9);
        }
        int n16 = 16;
        if (n13 == 1 && n16 != 0) {
            while ((n3 = (n4 = n9 - n8 + 1) * (n5 = n7 - n6 + 1)) % n16 != 0 && n7 < n10 - 1 && n9 < n11 - 1) {
                ++n7;
            }
            while ((n3 = (n4 = n9 - n8 + 1) * (n5 = n7 - n6 + 1)) % n16 != 0 && n7 < n10 - 1 && n9 < n11 - 1) {
                ++n7;
            }
            slf4jlogger.debug("padded to total size multiple of {} minx {}", n16, n6);
            slf4jlogger.debug("padded to total size multiple of {} maxx {}", n16, n7);
            slf4jlogger.debug("padded to total size multiple of {} miny {}", n16, n8);
            slf4jlogger.debug("padded to total size multiple of {} maxy {}", n16, n9);
            n5 = n7 - n6 + 1;
            n4 = n9 - n8 + 1;
            n3 = n4 * n5;
            slf4jlogger.debug("padded to total size multiple of {} columns {}", n16, n5);
            slf4jlogger.debug("padded to total size multiple of {} rows {}", n16, n4);
            slf4jlogger.debug("padded to total size multiple of {} bitsperframe {}", n16, n3);
        }
        int[] nArray = new int[]{n6, n8, n7, n9};
        return nArray;
    }

    protected static void setBit(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        long l = n4 * n5;
        long l2 = l * (long)n + (long)(n5 * n2) + (long)n3;
        int n6 = (int)(l2 / 8L);
        int n7 = (int)(l2 % 8L);
        int n8 = 1 << n7;
        byArray[n6] = (byte)(byArray[n6] | n8);
    }

    protected static int getBit(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        long l = n4 * n5;
        long l2 = l * (long)n + (long)(n5 * n2) + (long)n3;
        int n6 = (int)(l2 / 8L);
        int n7 = (int)(l2 % 8L);
        int n8 = 1 << n7;
        int n9 = (byArray[n6] & n8) == 0 ? 0 : 1;
        return n9;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void clipAllFramesToSpecifiedSize(AttributeList attributeList, int[] nArray) throws DicomException {
        int n;
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 1);
        int n6 = nArray[0];
        int n7 = nArray[1];
        int n8 = nArray[2];
        int n9 = nArray[3];
        int n10 = n8 - n6 + 1;
        int n11 = n9 - n7 + 1;
        slf4jlogger.debug("newColumns {}", n10);
        slf4jlogger.debug("newRows {}", n11);
        Attribute attribute = attributeList.get(TagFromName.PixelData);
        if (attribute == null) throw new DicomException("Missing PixelData attribute");
        byte[] byArray = attribute.getByteValues();
        byte[] byArray2 = null;
        if (n5 == 1) {
            n = (n4 * n3 * n2 - 1) / 8 + 1;
            if (byArray.length < n) throw new DicomException("For 1 bit image, expected " + n + " bytes in PixelData but were " + byArray.length);
            int n12 = n4 * n11 * n10 / 8;
            if (n12 % 2 != 0) {
                ++n12;
            }
            byArray2 = n12 % 2 == 0 ? new byte[n12] : new byte[n12 + 1];
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n11; ++j) {
                    for (int k = 0; k < n10; ++k) {
                        int n13 = ShrinkSegmentationToBoundingBox.getBit(byArray, i, n7 + j, n6 + k, n3, n2);
                        if (n13 == 0) continue;
                        ShrinkSegmentationToBoundingBox.setBit(byArray2, i, j, k, n11, n10);
                    }
                }
            }
        } else {
            if (n5 != 8) throw new DicomException("BitsStored " + n5 + " not supported");
            n = n4 * n3 * n2;
            if (byArray.length < n) throw new DicomException("For 8 bit image, expected " + n + " bytes in PixelData but were " + byArray.length);
            int n14 = n4 * n11 * n10;
            byArray2 = n14 % 2 == 0 ? new byte[n14] : new byte[n14 + 1];
            int n15 = 0;
            int n16 = 0;
            for (int i = 0; i < n4; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        byte by = byArray[n15++];
                        if (j < n7 || j > n9 || k < n6 || k > n8) continue;
                        byArray2[n16++] = by;
                    }
                }
            }
        }
        if (byArray2 == null) return;
        attribute = new OtherByteAttribute(TagFromName.PixelData);
        attribute.setValues(byArray2);
        attributeList.put(attribute);
        UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.Columns);
        ((Attribute)unsignedShortAttribute).addValue(n10);
        attributeList.put(unsignedShortAttribute);
        unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.Rows);
        ((Attribute)unsignedShortAttribute).addValue(n11);
        attributeList.put(unsignedShortAttribute);
    }

    public ShrinkSegmentationToBoundingBox(String string, String string2) throws DicomException, FileNotFoundException, IOException {
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (!string3.equals("1.2.840.10008.5.1.4.1.1.66.4")) {
            throw new DicomException("Input file is not a segmentation image");
        }
        int[] nArray = this.compute2DInPlaneBoundingBoxForSegments(attributeList);
        this.clipAllFramesToSpecifiedSize(attributeList, nArray);
        this.addTLHCOfClippedRegionToImagePosition(attributeList, nArray);
        attributeList.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                new ShrinkSegmentationToBoundingBox(stringArray[0], stringArray[1]);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: ShrinkSegmentationToBoundingBox inputFile outputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

