/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class TranslateImagePositionPatient {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/TranslateImagePositionPatient.java,v 1.12 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TranslateImagePositionPatient.class);
    protected String ourAETitle = "OURAETITLE";
    private String srcFolderName;
    private String dstFolderName;
    private double x;
    private double y;
    private double z;

    public static Attribute translateImagePositionPatient(Attribute attribute, double d, double d2, double d3) throws DicomException {
        if (attribute != null) {
            double[] dArray = attribute.getDoubleValues();
            dArray[0] = dArray[0] + d;
            dArray[1] = dArray[1] + d2;
            dArray[2] = dArray[2] + d3;
            attribute = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
            attribute.addValue(dArray[0]);
            attribute.addValue(dArray[1]);
            attribute.addValue(dArray[2]);
        }
        return attribute;
    }

    public static void translateImagePositionPatientInPlanePositionSequence(SequenceAttribute sequenceAttribute, double d, double d2, double d3) throws DicomException {
        AttributeList attributeList = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
        Attribute attribute = attributeList.get(TagFromName.ImagePositionPatient);
        if (attribute != null) {
            attributeList.put(TranslateImagePositionPatient.translateImagePositionPatient(attribute, d, d2, d3));
        }
    }

    public static void translateImagePositionPatient(AttributeList attributeList, double d, double d2, double d3) throws DicomException {
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 0);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        if (n == 1 && sequenceAttribute == null) {
            Attribute attribute = attributeList.get(TagFromName.ImagePositionPatient);
            if (attribute != null) {
                attributeList.put(TranslateImagePositionPatient.translateImagePositionPatient(attribute, d, d2, d3));
            }
        } else if (n > 0 && sequenceAttribute != null) {
            SequenceAttribute sequenceAttribute2 = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PlanePositionSequence);
            if (sequenceAttribute2 != null) {
                TranslateImagePositionPatient.translateImagePositionPatientInPlanePositionSequence(sequenceAttribute2, d, d2, d3);
            } else {
                SequenceAttribute sequenceAttribute3 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
                if (sequenceAttribute3 != null) {
                    for (int i = 0; i < n; ++i) {
                        Object var12_10 = null;
                        sequenceAttribute2 = (SequenceAttribute)sequenceAttribute3.getItem(i).getAttributeList().get(TagFromName.PlanePositionSequence);
                        if (sequenceAttribute2 == null) continue;
                        TranslateImagePositionPatient.translateImagePositionPatientInPlanePositionSequence(sequenceAttribute2, d, d2, d3);
                    }
                }
            }
        }
    }

    public static void translateImagePositionPatient(AttributeList attributeList, double d) throws DicomException {
    }

    public TranslateImagePositionPatient(String string, String string2, double d, double d2, double d3) throws FileNotFoundException, IOException, DicomException {
        File file = new File(string);
        this.srcFolderName = file.isFile() ? file.getParent() : this.srcFolderName;
        this.dstFolderName = string2;
        this.x = d;
        this.y = d2;
        this.z = d3;
        OurMediaImporter ourMediaImporter = new OurMediaImporter();
        ourMediaImporter.importDicomFiles(string);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 6 && stringArray[0].toUpperCase().equals("XYZ")) {
                new TranslateImagePositionPatient(stringArray[4], stringArray[5], Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]));
            } else {
                System.err.println("Error: Usage: TranslateImagePositionPatient [XYZ x y z|NORMALDISTANCE d] srcPathName dstFolderName");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter() {
            super(null);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            System.err.println("Doing " + string);
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                TranslateImagePositionPatient.translateImagePositionPatient(attributeList, TranslateImagePositionPatient.this.x, TranslateImagePositionPatient.this.y, TranslateImagePositionPatient.this.z);
                ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.TranslateImagePositionPatient", null, "Vers. " + VersionAndConstants.getBuildDate(), "Translated Image Position (Patient) values by (" + TranslateImagePositionPatient.this.x + "," + TranslateImagePositionPatient.this.y + "," + TranslateImagePositionPatient.this.z + ")");
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", TranslateImagePositionPatient.this.ourAETitle);
                File file = FileUtilities.makeSameRelativePathNameInDifferentFolder(TranslateImagePositionPatient.this.srcFolderName, TranslateImagePositionPatient.this.dstFolderName, string);
                slf4jlogger.info("\"{}\":  =  \"{}\"", string, file);
                if (file.exists()) {
                    throw new DicomException("\"" + string + "\": new file \"" + file + "\" already exists - not overwriting");
                }
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new DicomException("\"" + string + "\": parent directory creation failed for \"" + file + "\"");
                }
                attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {} exception ", string, exception);
            }
        }
    }
}

