/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.display.DialogMessageLogger;
import com.pixelmed.display.SafeFileChooser;
import com.pixelmed.network.ApplicationEntity;
import com.pixelmed.network.ApplicationEntityConfigurationDialog;
import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MultipleInstanceTransferStatusHandlerWithFileName;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.MessageLogger;
import java.awt.EventQueue;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class WatchFolderAndSend {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/WatchFolderAndSend.java,v 1.16 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(WatchFolderAndSend.class);
    protected static int sleepTimeBetweenCheckingForFolderContent = 10000;
    protected static int intervalAfterLastModificationWithinWhichDoNotSendFileYet = 1000;
    protected static String propertiesFileName = ".com.pixelmed.apps.WatchFolderAndSend.properties";
    protected static String localnameForRemoteAE = "remote";
    protected static String propertiesFilePath = FileUtilities.makePathToFileInUsersHomeDirectory(propertiesFileName);

    protected static ApplicationEntity getPropertiesEditInDialogAndSave() {
        Closeable closeable;
        Object object;
        ApplicationEntity applicationEntity = null;
        Properties properties = new Properties();
        try {
            object = new File(propertiesFilePath);
            if (((File)object).exists()) {
                closeable = new FileInputStream((File)object);
                properties.load((InputStream)closeable);
                ((FileInputStream)closeable).close();
                slf4jlogger.debug("getPropertiesEditInDialogAndSave(): got existing properties {}", properties);
                NetworkApplicationInformation networkApplicationInformation = new NetworkApplicationInformation(properties);
                String string = networkApplicationInformation.getApplicationEntityTitleFromLocalName(localnameForRemoteAE);
                ApplicationEntityMap applicationEntityMap = networkApplicationInformation.getApplicationEntityMap();
                if (string != null && applicationEntityMap != null) {
                    applicationEntity = new ApplicationEntity(string);
                    PresentationAddress presentationAddress = applicationEntityMap.getPresentationAddress(string);
                    if (presentationAddress != null) {
                        applicationEntity.setPresentationAddress(presentationAddress);
                    }
                    slf4jlogger.debug("getPropertiesEditInDialogAndSave(): extracted AE {}", applicationEntity);
                }
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        applicationEntity = applicationEntity == null ? new ApplicationEntityConfigurationDialog(null, localnameForRemoteAE) : new ApplicationEntityConfigurationDialog(null, localnameForRemoteAE, applicationEntity);
        try {
            object = new NetworkApplicationInformation();
            ((NetworkApplicationInformation)object).add(localnameForRemoteAE, applicationEntity);
            properties = ((NetworkApplicationInformation)object).getProperties(properties);
            slf4jlogger.debug("getPropertiesEditInDialogAndSave(): saving revised properties {}", properties);
            closeable = new FileOutputStream(propertiesFilePath);
            properties.store((OutputStream)closeable, "Reconfigured from dialog");
            ((FileOutputStream)closeable).close();
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        return applicationEntity;
    }

    public WatchFolderAndSend(String string, String string2, int n, String string3, String string4, int n2, MessageLogger messageLogger) throws DicomException, DicomNetworkException, IOException, InterruptedException {
        if (string != null) {
            File file = new File(string);
            while (file.exists() && file.isDirectory()) {
                slf4jlogger.debug("watched folder exists");
                SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles();
                File[] fileArray = file.listFiles();
                if (fileArray != null && fileArray.length > 0) {
                    for (int i = 0; i < fileArray.length; ++i) {
                        File file2 = fileArray[i];
                        if (!file2.exists() || !file2.isFile()) continue;
                        String string5 = file2.getName();
                        long l = file2.lastModified();
                        long l2 = System.currentTimeMillis();
                        slf4jlogger.debug("lastModified = {}", l);
                        slf4jlogger.debug("currentTime  = {}", l2);
                        if (l2 - l > (long)intervalAfterLastModificationWithinWhichDoNotSendFileYet) {
                            if (DicomFileUtilities.isDicomOrAcrNemaFile(file2)) {
                                if (n2 > 0 && messageLogger != null) {
                                    messageLogger.sendLn("Queueing " + string5);
                                }
                                slf4jlogger.info("Queueing {}", string5);
                                setOfDicomFiles.add(file2);
                                continue;
                            }
                            if (n2 > 0 && messageLogger != null) {
                                messageLogger.sendLn("Skipping non-DICOM file " + string5);
                            }
                            slf4jlogger.info("Skipping non-DICOM file {}", string5);
                            continue;
                        }
                        if (n2 > 0 && messageLogger != null) {
                            messageLogger.sendLn("Skipping file still being modified " + string5);
                        }
                        slf4jlogger.info("Skipping file still being modified {}", string5);
                    }
                    if (setOfDicomFiles != null & setOfDicomFiles.size() > 0 && new StorageSOPClassSCU(string2, n, string3, string4, setOfDicomFiles, 0, new OurMultipleInstanceTransferStatusHandlerWithFileName(n2, messageLogger), null, 0).encounteredTrappedExceptions()) {
                        if (n2 > 0 && messageLogger != null) {
                            messageLogger.sendLn("Sending queued files problem - connection or association failure ?");
                        }
                        slf4jlogger.info("Sending queued files problem - connection or association failure ?");
                    }
                }
                slf4jlogger.debug("sleeping for " + sleepTimeBetweenCheckingForFolderContent + " mS");
                Thread.currentThread();
                Thread.sleep(sleepTimeBetweenCheckingForFolderContent);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0 || stringArray.length >= 4 && stringArray.length <= 6) {
                Object object;
                String string = null;
                String string2 = null;
                int n = 0;
                String string3 = null;
                String string4 = "US";
                int n2 = 0;
                DialogMessageLogger dialogMessageLogger = null;
                if (stringArray.length == 0) {
                    object = new SafeFileChooser.SafeFileChooserThread(1, null, "Select Watched Folder ...");
                    EventQueue.invokeAndWait((Runnable)object);
                    string = ((SafeFileChooser.SafeFileChooserThread)object).getSelectedFileName();
                    if (string == null) {
                        System.exit(0);
                    }
                    ApplicationEntity applicationEntity = WatchFolderAndSend.getPropertiesEditInDialogAndSave();
                    string2 = applicationEntity.getPresentationAddress().getHostname();
                    n = applicationEntity.getPresentationAddress().getPort();
                    string3 = applicationEntity.getDicomAETitle();
                    n2 = 1;
                    dialogMessageLogger = new DialogMessageLogger("WatchFolderAndSend Log", 512, 384, true, true);
                } else {
                    string = stringArray[0];
                    string2 = stringArray[1];
                    n = Integer.parseInt(stringArray[2]);
                    string3 = stringArray[3];
                    if (stringArray.length > 4) {
                        string4 = stringArray[4];
                    }
                    if (stringArray.length > 5) {
                        slf4jlogger.warn("Verbosity level ignored");
                    }
                    dialogMessageLogger = null;
                }
                object = new File(string);
                new WatchFolderAndSend(string, string2, n, string3, string4, n2, dialogMessageLogger);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.WatchFolderAndSend [watchedfolder remoteHost remotePort remoteAET [ourAET [verbositylevel]]]");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error(",e");
            System.exit(0);
        }
    }

    protected class OurMultipleInstanceTransferStatusHandlerWithFileName
    extends MultipleInstanceTransferStatusHandlerWithFileName {
        int verbosityLevel;
        MessageLogger logger;

        OurMultipleInstanceTransferStatusHandlerWithFileName(int n, MessageLogger messageLogger) {
            this.verbosityLevel = n;
            this.logger = messageLogger;
        }

        @Override
        public void updateStatus(int n, int n2, int n3, int n4, String string, String string2, boolean bl) {
            File file = new File(string2);
            String string3 = file.getName();
            if (this.verbosityLevel > 0 && this.logger != null) {
                this.logger.sendLn("Send of " + string3 + " " + (bl ? "succeeded" : "failed"));
            }
            slf4jlogger.info("Send of {} {}", string3, bl ? "succeeded" : "failed");
            if (bl) {
                if (file.exists() && file.isFile()) {
                    slf4jlogger.debug("removing {}", string3);
                    if (file.delete()) {
                        if (this.verbosityLevel > 0 && this.logger != null) {
                            this.logger.sendLn("Removed " + string3);
                        }
                        slf4jlogger.info("Removed {}", string3);
                    } else {
                        if (this.verbosityLevel > 0 && this.logger != null) {
                            this.logger.sendLn("Failed to remove " + string3);
                        }
                        slf4jlogger.info("Failed to remove {}", string3);
                    }
                }
            } else {
                if (this.verbosityLevel > 0 && this.logger != null) {
                    this.logger.sendLn("Leaving " + string3);
                }
                slf4jlogger.info("Leaving {}", string3);
            }
        }
    }
}

