/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;

public class EncapsulateCompressedPixelData {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/EncapsulateCompressedPixelData.java,v 1.3 2019/02/24 14:16:44 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(EncapsulateCompressedPixelData.class);

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length >= 3) {
                AttributeList attributeList = new AttributeList();
                attributeList.read(stringArray[1]);
                attributeList.remove(TagFromName.PixelData);
                int n = stringArray.length - 2;
                File[] fileArray = new File[n];
                for (int i = 0; i < n; ++i) {
                    fileArray[i] = new File(stringArray[i + 2]);
                }
                String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                if (string.length() == 0) {
                    throw new Exception("Missing TransferSyntaxUID in input file");
                }
                attributeList.removeGroupLengthAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                OtherByteAttributeMultipleCompressedFrames otherByteAttributeMultipleCompressedFrames = new OtherByteAttributeMultipleCompressedFrames(TagFromName.PixelData, fileArray);
                attributeList.put(otherByteAttributeMultipleCompressedFrames);
                attributeList.write(stringArray[0], string, true, true);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: EncapsulateCompressedPixelData outputFile dicomHeaderSourceFile inputFrame1 [inputFrame2 ...]");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

