/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.CommonConvertedAttributeGeneration;
import com.pixelmed.convert.NIfTI1Exception;
import com.pixelmed.convert.NIfTI1Header;
import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.FunctionalGroupUtilities;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherDoubleAttribute;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class NIfTI1ToDicom {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/NIfTI1ToDicom.java,v 1.40 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(NIfTI1ToDicom.class);
    protected static boolean preferSForm = true;

    public static AttributeList generateGeometryFunctionalGroupsFromNIfTI1Header(NIfTI1Header nIfTI1Header, AttributeList attributeList, int n) throws DicomException {
        int n2;
        AttributeList attributeList2;
        int n3;
        int n4;
        int n5;
        attributeList = FunctionalGroupUtilities.createFunctionalGroupsIfNotPresent(attributeList, n);
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        AttributeList attributeList3 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
        double d = 1.0;
        if (nIfTI1Header.xyzt_units_spatial == NIfTI1Header.Units.METER) {
            d = 1000.0;
        } else if (nIfTI1Header.xyzt_units_spatial == NIfTI1Header.Units.MICRON) {
            d = 0.001;
        }
        SequenceAttribute sequenceAttribute3 = new SequenceAttribute(TagFromName.PixelMeasuresSequence);
        attributeList3.put(sequenceAttribute3);
        AttributeList attributeList4 = new AttributeList();
        sequenceAttribute3.addItem(attributeList4);
        double d2 = (double)nIfTI1Header.pixdim[1] * d;
        double d3 = (double)nIfTI1Header.pixdim[2] * d;
        double d4 = (double)nIfTI1Header.pixdim[3] * d;
        Object object = new DecimalStringAttribute(TagFromName.PixelSpacing);
        ((Attribute)object).addValue(d3);
        ((Attribute)object).addValue(d2);
        attributeList4.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.SliceThickness);
        ((Attribute)object).addValue(d4);
        attributeList4.put((Attribute)object);
        object = new DecimalStringAttribute(TagFromName.SpacingBetweenSlices);
        ((Attribute)object).addValue(d4);
        attributeList4.put((Attribute)object);
        double d5 = 0.0;
        d2 = 0.0;
        d3 = 0.0;
        float f = 0.0f;
        SequenceAttribute sequenceAttribute4 = new SequenceAttribute(TagFromName.PlaneOrientationSequence);
        attributeList3.put(sequenceAttribute4);
        object = new AttributeList();
        sequenceAttribute4.addItem((AttributeList)object);
        DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        if ((preferSForm || nIfTI1Header.qform == NIfTI1Header.CoordinateTransform.UNKNOWN) && nIfTI1Header.sform != NIfTI1Header.CoordinateTransform.UNKNOWN) {
            slf4jlogger.info("Method 3 - sform: orientation");
            ((Attribute)decimalStringAttribute).addValue(-nIfTI1Header.srow_x[0] / nIfTI1Header.pixdim[1]);
            ((Attribute)decimalStringAttribute).addValue(-nIfTI1Header.srow_y[0] / nIfTI1Header.pixdim[1]);
            ((Attribute)decimalStringAttribute).addValue(nIfTI1Header.srow_z[0] / nIfTI1Header.pixdim[1]);
            ((Attribute)decimalStringAttribute).addValue(-nIfTI1Header.srow_x[1] / nIfTI1Header.pixdim[2]);
            ((Attribute)decimalStringAttribute).addValue(-nIfTI1Header.srow_y[1] / nIfTI1Header.pixdim[2]);
            ((Attribute)decimalStringAttribute).addValue(nIfTI1Header.srow_z[1] / nIfTI1Header.pixdim[2]);
        } else if (nIfTI1Header.qform != NIfTI1Header.CoordinateTransform.UNKNOWN) {
            slf4jlogger.info("Method 2 - qform: orientation");
            double d6 = nIfTI1Header.quatern_b;
            double d7 = nIfTI1Header.quatern_c;
            double d8 = nIfTI1Header.quatern_d;
            double d9 = Math.sqrt(1.0 - (d6 * d6 + d7 * d7 + d8 * d8));
            double d10 = -(d9 * d9 + d6 * d6 - d7 * d7 - d8 * d8);
            double d11 = -(2.0 * d6 * d7 + 2.0 * d9 * d8);
            double d12 = 2.0 * d6 * d8 - 2.0 * d9 * d7;
            double d13 = -(2.0 * d6 * d7 - 2.0 * d9 * d8);
            double d14 = -(d9 * d9 + d7 * d7 - d6 * d6 - d8 * d8);
            double d15 = 2.0 * d7 * d8 + 2.0 * d9 * d6;
            d5 = -(2.0 * d6 * d8 + 2.0 * d9 * d7);
            d2 = -(2.0 * d7 * d8 - 2.0 * d9 * d6);
            d3 = d9 * d9 + d8 * d8 - d7 * d7 - d6 * d6;
            slf4jlogger.info("Method 2: slice direction (normal) = ({},{},{})", d5, d2, d3);
            f = nIfTI1Header.pixdim[0] == 0.0f ? 1.0f : nIfTI1Header.pixdim[0];
            slf4jlogger.info("Method 2: use qfac {}", Float.valueOf(f));
            ((Attribute)decimalStringAttribute).addValue(d10);
            ((Attribute)decimalStringAttribute).addValue(d11);
            ((Attribute)decimalStringAttribute).addValue(d12);
            ((Attribute)decimalStringAttribute).addValue(d13);
            ((Attribute)decimalStringAttribute).addValue(d14);
            ((Attribute)decimalStringAttribute).addValue(d15);
        } else {
            slf4jlogger.info("Method 1 - assume axial: orientation");
            slf4jlogger.warn("no quaterinion or affine transform to Patient Coordinate System specified ... assuming axial images and translation only");
            ((Attribute)decimalStringAttribute).addValue(1);
            ((Attribute)decimalStringAttribute).addValue(0);
            ((Attribute)decimalStringAttribute).addValue(0);
            ((Attribute)decimalStringAttribute).addValue(0);
            ((Attribute)decimalStringAttribute).addValue(1);
            ((Attribute)decimalStringAttribute).addValue(0);
        }
        ((AttributeList)object).put(decimalStringAttribute);
        int n6 = nIfTI1Header.dim[0] >= 3 ? (nIfTI1Header.dim[3] > 0 ? nIfTI1Header.dim[3] : 1) : (n5 = 1);
        int n7 = nIfTI1Header.dim[0] >= 4 ? (nIfTI1Header.dim[4] > 0 ? nIfTI1Header.dim[4] : 1) : (n4 = 1);
        if ((preferSForm || nIfTI1Header.qform == NIfTI1Header.CoordinateTransform.UNKNOWN) && nIfTI1Header.sform != NIfTI1Header.CoordinateTransform.UNKNOWN) {
            slf4jlogger.info("Method 3 - sform: position");
            for (n3 = 0; n3 < n; ++n3) {
                SequenceAttribute sequenceAttribute5 = new SequenceAttribute(TagFromName.PlanePositionSequence);
                SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, n3).put(sequenceAttribute5);
                attributeList2 = new AttributeList();
                sequenceAttribute5.addItem(attributeList2);
                DecimalStringAttribute decimalStringAttribute2 = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
                n2 = n3 % n5;
                ((Attribute)decimalStringAttribute2).addValue(-(nIfTI1Header.srow_x[2] * (float)n2 + nIfTI1Header.srow_x[3]));
                ((Attribute)decimalStringAttribute2).addValue(-(nIfTI1Header.srow_y[2] * (float)n2 + nIfTI1Header.srow_y[3]));
                ((Attribute)decimalStringAttribute2).addValue(nIfTI1Header.srow_z[2] * (float)n2 + nIfTI1Header.srow_z[3]);
                attributeList2.put(decimalStringAttribute2);
            }
        } else if (nIfTI1Header.qform != NIfTI1Header.CoordinateTransform.UNKNOWN) {
            slf4jlogger.info("Method 2 - qform: position");
            for (n3 = 0; n3 < n; ++n3) {
                SequenceAttribute sequenceAttribute6 = new SequenceAttribute(TagFromName.PlanePositionSequence);
                SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, n3).put(sequenceAttribute6);
                attributeList2 = new AttributeList();
                sequenceAttribute6.addItem(attributeList2);
                DecimalStringAttribute decimalStringAttribute3 = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
                n2 = n3 % n5;
                ((Attribute)decimalStringAttribute3).addValue(d5 * (double)f * (double)nIfTI1Header.pixdim[3] * (double)n2 - (double)nIfTI1Header.qoffset_x);
                ((Attribute)decimalStringAttribute3).addValue(d2 * (double)f * (double)nIfTI1Header.pixdim[3] * (double)n2 - (double)nIfTI1Header.qoffset_y);
                ((Attribute)decimalStringAttribute3).addValue(d3 * (double)f * (double)nIfTI1Header.pixdim[3] * (double)n2 + (double)nIfTI1Header.qoffset_z);
                attributeList2.put(decimalStringAttribute3);
            }
        } else {
            slf4jlogger.info("Method 1 - assume axial: position");
            for (n3 = 0; n3 < n; ++n3) {
                SequenceAttribute sequenceAttribute7 = new SequenceAttribute(TagFromName.PlanePositionSequence);
                SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, n3).put(sequenceAttribute7);
                attributeList2 = new AttributeList();
                sequenceAttribute7.addItem(attributeList2);
                DecimalStringAttribute decimalStringAttribute4 = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
                n2 = n3 % n5;
                ((Attribute)decimalStringAttribute4).addValue(-nIfTI1Header.qoffset_x);
                ((Attribute)decimalStringAttribute4).addValue(-nIfTI1Header.qoffset_y);
                ((Attribute)decimalStringAttribute4).addValue(nIfTI1Header.qoffset_z + nIfTI1Header.pixdim[3] * (float)n2);
                attributeList2.put(decimalStringAttribute4);
            }
        }
        n3 = 0;
        while (n3 < n) {
            for (int i = 1; i <= n4; ++i) {
                for (int j = 1; j <= n5; ++j) {
                    SequenceAttribute sequenceAttribute8 = new SequenceAttribute(TagFromName.FrameContentSequence);
                    SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, n3).put(sequenceAttribute8);
                    AttributeList attributeList5 = new AttributeList();
                    sequenceAttribute8.addItem(attributeList5);
                    Attribute attribute = new ShortStringAttribute(TagFromName.StackID);
                    attribute.addValue(1);
                    attributeList5.put(attribute);
                    attribute = new UnsignedLongAttribute(TagFromName.InStackPositionNumber);
                    attribute.addValue(j);
                    attributeList5.put(attribute);
                    attribute = new UnsignedLongAttribute(TagFromName.TemporalPositionIndex);
                    attribute.addValue(i);
                    attributeList5.put(attribute);
                    attribute = new UnsignedLongAttribute(TagFromName.DimensionIndexValues);
                    attribute.addValue(1);
                    attribute.addValue(j);
                    attribute.addValue(i);
                    attributeList5.put(attribute);
                    ++n3;
                }
            }
        }
        return attributeList;
    }

    public static AttributeList generateDimensions(AttributeList attributeList) throws DicomException {
        UIDGenerator uIDGenerator = new UIDGenerator();
        String string = uIDGenerator.getAnotherNewUID();
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.DimensionOrganizationSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        Attribute attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string);
        attributeList2.put(attribute);
        sequenceAttribute = new SequenceAttribute(TagFromName.DimensionIndexSequence);
        attributeList.put(sequenceAttribute);
        attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        attribute = new AttributeTagAttribute(TagFromName.DimensionIndexPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.StackID);
        attributeList2.put(attribute);
        attribute = new AttributeTagAttribute(TagFromName.FunctionalGroupPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.FrameContentSequence);
        attributeList2.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string);
        attributeList2.put(attribute);
        attribute = new LongStringAttribute(TagFromName.DimensionDescriptionLabel);
        attribute.addValue("StackID");
        attributeList2.put(attribute);
        attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        attribute = new AttributeTagAttribute(TagFromName.DimensionIndexPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.InStackPositionNumber);
        attributeList2.put(attribute);
        attribute = new AttributeTagAttribute(TagFromName.FunctionalGroupPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.FrameContentSequence);
        attributeList2.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string);
        attributeList2.put(attribute);
        attribute = new LongStringAttribute(TagFromName.DimensionDescriptionLabel);
        attribute.addValue("InStackPositionNumber");
        attributeList2.put(attribute);
        attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        attribute = new AttributeTagAttribute(TagFromName.DimensionIndexPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.TemporalPositionIndex);
        attributeList2.put(attribute);
        attribute = new AttributeTagAttribute(TagFromName.FunctionalGroupPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.FrameContentSequence);
        attributeList2.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string);
        attributeList2.put(attribute);
        attribute = new LongStringAttribute(TagFromName.DimensionDescriptionLabel);
        attribute.addValue("TemporalPositionIndex");
        attributeList2.put(attribute);
        return attributeList;
    }

    public static AttributeList generateDICOMPixelDataModuleAttributesFromNIfTI1File(File file, NIfTI1Header nIfTI1Header, AttributeList attributeList) throws IOException, DicomException, NIfTI1Exception {
        Object object;
        int n;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        if ((n = nIfTI1Header.dim[0] & 0xFFFF) < 2) {
            throw new DicomException("Cannot convert if less than two dimensions");
        }
        int n2 = nIfTI1Header.dim[1] & 0xFFFF;
        int n3 = nIfTI1Header.dim[2] & 0xFFFF;
        int n4 = 1;
        if (n > 2) {
            for (int i = 3; i <= n; ++i) {
                n4 *= nIfTI1Header.dim[i] & 0xFFFF;
            }
        }
        String string = null;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Attribute attribute = null;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        switch (nIfTI1Header.datatype) {
            case UINT8: {
                attribute = new OtherByteAttribute(TagFromName.PixelData);
                n7 = 0;
                n6 = 8;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case INT16: {
                attribute = new OtherWordAttribute(TagFromName.PixelData);
                n7 = 1;
                n6 = 16;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case INT32: {
                throw new DicomException("Conversion of " + (Object)((Object)nIfTI1Header.datatype) + " not supported");
            }
            case FLOAT32: {
                attribute = new OtherFloatAttribute(TagFromName.FloatPixelData);
                bl3 = false;
                n7 = 0;
                n6 = 32;
                bl = false;
                bl2 = false;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case COMPLEX64: {
                throw new DicomException("Conversion of " + (Object)((Object)nIfTI1Header.datatype) + " not supported");
            }
            case FLOAT64: {
                attribute = new OtherDoubleAttribute(TagFromName.DoubleFloatPixelData);
                bl3 = false;
                n7 = 0;
                n6 = 64;
                bl = false;
                bl2 = false;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case RGB24: {
                attribute = new OtherByteAttribute(TagFromName.PixelData);
                n7 = 0;
                n6 = 8;
                n5 = 3;
                string = "RGB";
                break;
            }
            case INT8: {
                attribute = new OtherByteAttribute(TagFromName.PixelData);
                n7 = 1;
                n6 = 8;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case UINT16: {
                attribute = new OtherWordAttribute(TagFromName.PixelData);
                n7 = 0;
                n6 = 16;
                n5 = 1;
                string = "MONOCHROME2";
                break;
            }
            case INT64: {
                throw new DicomException("Conversion of " + (Object)((Object)nIfTI1Header.datatype) + " not supported");
            }
            case UINT64: {
                throw new DicomException("Conversion of " + (Object)((Object)nIfTI1Header.datatype) + " not supported");
            }
            case FLOAT128: {
                throw new DicomException("Conversion of " + (Object)((Object)nIfTI1Header.datatype) + " not supported");
            }
            case COMPLEX128: {
                throw new DicomException("Conversion of " + (Object)((Object)nIfTI1Header.datatype) + " not supported");
            }
            case COMPLEX256: {
                throw new DicomException("Conversion of " + (Object)((Object)nIfTI1Header.datatype) + " not supported");
            }
            case RGBA32: {
                throw new DicomException("Conversion of " + (Object)((Object)nIfTI1Header.datatype) + " not supported");
            }
            default: {
                throw new DicomException("Conversion of " + (Object)((Object)nIfTI1Header.datatype) + " not supported");
            }
        }
        double d = 0.0;
        double d2 = 0.0;
        boolean bl4 = false;
        Object object2 = nIfTI1Header.isNIfTI1DualFileMagicNumber() ? NIfTI1Header.getImageDataFile(file) : file;
        BinaryInputStream binaryInputStream = new BinaryInputStream((File)object2, nIfTI1Header.bigEndian);
        binaryInputStream.skipInsistently((long)nIfTI1Header.vox_offset);
        int n8 = n3 * n2 * n4 * n5;
        if (attribute instanceof OtherByteAttribute) {
            byte[] byArray = new byte[n8];
            binaryInputStream.readInsistently(byArray, 0, n8);
            attribute.setValues(byArray);
        } else if (attribute instanceof OtherWordAttribute) {
            short[] sArray = new short[n8];
            binaryInputStream.readUnsigned16(sArray, 0, n8);
            attribute.setValues(sArray);
        } else if (attribute instanceof OtherFloatAttribute) {
            float[] fArray = new float[n8];
            binaryInputStream.readFloat(fArray, n8);
            attribute.setValues(fArray);
            object = ArrayCopyUtilities.minMax(fArray);
            d = object[0];
            d2 = object[1];
            bl4 = true;
        } else if (attribute instanceof OtherDoubleAttribute) {
            double[] dArray = new double[n8];
            binaryInputStream.readDouble(dArray, n8);
            attribute.setValues(dArray);
            object = ArrayCopyUtilities.minMax(dArray);
            d = object[0];
            d2 = object[1];
            bl4 = true;
        }
        binaryInputStream.close();
        attributeList.put(attribute);
        object2 = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        ((Attribute)object2).addValue(string);
        attributeList.put((Attribute)object2);
        object2 = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object2).addValue(n6);
        attributeList.put((Attribute)object2);
        if (bl) {
            object2 = new UnsignedShortAttribute(TagFromName.BitsStored);
            ((Attribute)object2).addValue(n6);
            attributeList.put((Attribute)object2);
        }
        if (bl2) {
            object2 = new UnsignedShortAttribute(TagFromName.HighBit);
            ((Attribute)object2).addValue(n6 - 1);
            attributeList.put((Attribute)object2);
        }
        object2 = new UnsignedShortAttribute(TagFromName.Rows);
        ((Attribute)object2).addValue(n3);
        attributeList.put((Attribute)object2);
        object2 = new UnsignedShortAttribute(TagFromName.Columns);
        ((Attribute)object2).addValue(n2);
        attributeList.put((Attribute)object2);
        if (bl3) {
            object2 = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
            ((Attribute)object2).addValue(n7);
            attributeList.put((Attribute)object2);
        }
        attributeList.remove(TagFromName.NumberOfFrames);
        if (n4 > 1) {
            object2 = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object2).addValue(n4);
            attributeList.put((Attribute)object2);
        }
        object2 = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        ((Attribute)object2).addValue(n5);
        attributeList.put((Attribute)object2);
        attributeList.remove(TagFromName.PlanarConfiguration);
        if (n5 > 1) {
            object2 = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
            ((Attribute)object2).addValue(0);
            attributeList.put((Attribute)object2);
        }
        if (n5 == 1) {
            double d3 = nIfTI1Header.scl_slope;
            double d4 = nIfTI1Header.scl_inter;
            if (d3 == 0.0) {
                d3 = 1.0;
                d4 = 0.0;
            }
            object = new CodeStringAttribute(TagFromName.PresentationLUTShape);
            ((Attribute)object).addValue("IDENTITY");
            attributeList.put((Attribute)object);
            object = new DecimalStringAttribute(TagFromName.RescaleSlope);
            ((Attribute)object).addValue(d3);
            attributeList.put((Attribute)object);
            object = new DecimalStringAttribute(TagFromName.RescaleIntercept);
            ((Attribute)object).addValue(d4);
            attributeList.put((Attribute)object);
            object = new LongStringAttribute(TagFromName.RescaleType);
            ((Attribute)object).addValue(nIfTI1Header.intent_name[0] == 0 ? "US" : new String(nIfTI1Header.intent_name, Charset.forName("US-ASCII")));
            attributeList.put((Attribute)object);
            if (bl4) {
                double d5 = d2 - d;
                double d6 = (d2 + d) / 2.0;
                StringAttribute stringAttribute = new DecimalStringAttribute(TagFromName.WindowWidth);
                ((Attribute)stringAttribute).addValue(d5);
                attributeList.put(stringAttribute);
                stringAttribute = new DecimalStringAttribute(TagFromName.WindowCenter);
                ((Attribute)stringAttribute).addValue(d6);
                attributeList.put(stringAttribute);
                stringAttribute = new CodeStringAttribute(TagFromName.VOILUTFunction);
                ((Attribute)stringAttribute).addValue(attribute instanceof OtherFloatAttribute || attribute instanceof OtherDoubleAttribute ? "LINEAR_EXACT" : "LINEAR");
                attributeList.put(stringAttribute);
            }
        }
        return attributeList;
    }

    public NIfTI1ToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException, DicomException, NIfTI1Exception {
        this(string, string2, string3, string4, string5, string6, string7, null, null);
    }

    public NIfTI1ToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws IOException, DicomException, NIfTI1Exception {
        File file = new File(string);
        NIfTI1Header nIfTI1Header = new NIfTI1Header(file);
        AttributeList attributeList = NIfTI1ToDicom.generateDICOMPixelDataModuleAttributesFromNIfTI1File(file, nIfTI1Header, null);
        CommonConvertedAttributeGeneration.generateCommonAttributes(attributeList, string3, string4, string5, string6, string7, string8, string9, true);
        string9 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (SOPClass.isEnhancedMultiframeImageStorage(string9)) {
            int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
            NIfTI1ToDicom.generateGeometryFunctionalGroupsFromNIfTI1Header(nIfTI1Header, attributeList, n);
            NIfTI1ToDicom.generateDimensions(attributeList);
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(TagFromName.ManufacturerModelName);
        ((Attribute)longStringAttribute).addValue(this.getClass().getName());
        attributeList.put(longStringAttribute);
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        try {
            if (stringArray.length != 7) {
                if (stringArray.length == 8) {
                    string = stringArray[7];
                } else if (stringArray.length == 9) {
                    string = stringArray[7];
                    string2 = stringArray[8];
                } else {
                    System.err.println("Error: Incorrect number of arguments");
                    System.err.println("Usage: NIfTI1ToDicom inputFile outputFile patientName patientID studyID seriesNumber instanceNumber [modality [SOPClass]]");
                    System.exit(1);
                }
            }
            new NIfTI1ToDicom(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], string, string2);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

