/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.RawRGBInformation;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFilesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FilenameFilterByCaseInsensitiveSuffix;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;

public class RawRGBToDicomMultiFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/RawRGBToDicomMultiFrame.java,v 1.18 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(RawRGBToDicomMultiFrame.class);

    public static AttributeList generateGeometryFunctionalGroupsFromRawRGBInformation(RawRGBInformation rawRGBInformation, AttributeList attributeList, int n) throws DicomException {
        SequenceAttribute sequenceAttribute;
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        if ((sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence)) == null) {
            sequenceAttribute = new SequenceAttribute(TagFromName.SharedFunctionalGroupsSequence);
            attributeList.put(sequenceAttribute);
            sequenceAttribute.addItem(new AttributeList());
        }
        AttributeList attributeList2 = SequenceAttribute.getAttributeListFromWithinSequenceWithSingleItem(sequenceAttribute);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        if (sequenceAttribute2 == null) {
            sequenceAttribute2 = new SequenceAttribute(TagFromName.PerFrameFunctionalGroupsSequence);
            attributeList.put(sequenceAttribute2);
            for (int i = 0; i < n; ++i) {
                sequenceAttribute2.addItem(new AttributeList());
            }
        }
        SequenceAttribute sequenceAttribute3 = new SequenceAttribute(TagFromName.PixelMeasuresSequence);
        attributeList2.put(sequenceAttribute3);
        Object object = new AttributeList();
        sequenceAttribute3.addItem((AttributeList)object);
        Object object2 = new DecimalStringAttribute(TagFromName.PixelSpacing);
        ((Attribute)object2).addValue(rawRGBInformation.pixelHeightInMillimetres);
        ((Attribute)object2).addValue(rawRGBInformation.pixelWidthInMillimetres);
        ((AttributeList)object).put((Attribute)object2);
        object2 = new DecimalStringAttribute(TagFromName.SliceThickness);
        ((Attribute)object2).addValue(rawRGBInformation.pixelSeparationInMillimetres);
        ((AttributeList)object).put((Attribute)object2);
        sequenceAttribute3 = new SequenceAttribute(TagFromName.PlaneOrientationSequence);
        attributeList2.put(sequenceAttribute3);
        object = new AttributeList();
        sequenceAttribute3.addItem((AttributeList)object);
        object2 = new DecimalStringAttribute(TagFromName.ImageOrientationPatient);
        ((Attribute)object2).addValue(1);
        ((Attribute)object2).addValue(0);
        ((Attribute)object2).addValue(0);
        ((Attribute)object2).addValue(0);
        ((Attribute)object2).addValue(-1);
        ((Attribute)object2).addValue(0);
        ((AttributeList)object).put((Attribute)object2);
        for (int i = 0; i < n; ++i) {
            object = new SequenceAttribute(TagFromName.PlanePositionSequence);
            SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, i).put((Attribute)object);
            object2 = new AttributeList();
            ((SequenceAttribute)object).addItem((AttributeList)object2);
            DecimalStringAttribute decimalStringAttribute = new DecimalStringAttribute(TagFromName.ImagePositionPatient);
            ((Attribute)decimalStringAttribute).addValue(0);
            ((Attribute)decimalStringAttribute).addValue(0);
            ((Attribute)decimalStringAttribute).addValue(-rawRGBInformation.pixelSeparationInMillimetres * (double)i);
            ((AttributeList)object2).put(decimalStringAttribute);
        }
        return attributeList;
    }

    public static AttributeList generateDICOMPixelDataModuleAttributesFromRawRGBFiles(String[] stringArray, String string, RawRGBInformation rawRGBInformation, AttributeList attributeList) throws IOException, DicomException {
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        int n = stringArray.length;
        int n2 = rawRGBInformation.imageWidthInPixels;
        int n3 = rawRGBInformation.imageHeightInPixels;
        int n4 = n;
        String string2 = rawRGBInformation.photometricInterpretation;
        int n5 = 3;
        int n6 = rawRGBInformation.bitsPerPixel / n5;
        int n7 = rawRGBInformation.planarConfiguration.equals("NON INTERLEAVED") ? 1 : 0;
        boolean bl = false;
        Attribute attribute = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
        attribute.addValue(string2);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        attribute.addValue(n6);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.BitsStored);
        attribute.addValue(n6);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.HighBit);
        attribute.addValue(n6 - 1);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.Rows);
        attribute.addValue(n3);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.Columns);
        attribute.addValue(n2);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        attribute.addValue(bl ? 1 : 0);
        attributeList.put(attribute);
        attributeList.remove(TagFromName.NumberOfFrames);
        if (n4 > 1) {
            attribute = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            attribute.addValue(n4);
            attributeList.put(attribute);
        }
        attribute = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
        attribute.addValue(n5);
        attributeList.put(attribute);
        attribute = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
        attribute.addValue(n7);
        attributeList.put(attribute);
        attribute = null;
        long l = (long)n4 * (long)n3 * (long)n2 * (long)n5;
        long l2 = l % 2L != 0L ? l + 1L : l;
        slf4jlogger.info("Value length unpadded = {}, padded = {}", l, l2);
        if (l2 > 0xFFFFFFFEL) {
            throw new DicomException("Value length of pixel data (" + l2 + ") exceeds maximum encodable (" + 0xFFFFFFFEL + ")");
        }
        String string3 = string.toUpperCase();
        if (string3.endsWith(".GZ") || string3.endsWith(".Z") || string3.endsWith(".BZ2")) {
            attribute = new OtherByteAttributeMultipleCompressedFilesOnDisk(TagFromName.PixelData, l, stringArray);
        } else {
            attribute = new OtherByteAttributeMultipleFilesOnDisk(TagFromName.PixelData, stringArray);
            long l3 = attribute.getVL();
            if (l3 != l2) {
                throw new DicomException("Uncompressed input files contain insufficient bytes (" + l3 + ") for numberOfFrames * rows * columns * samplesPerPixel +/- padding (" + l + ")");
            }
        }
        attributeList.put(attribute);
        return attributeList;
    }

    protected static String[] getSortedInputFileNames(String string, String string2) throws IOException {
        Object[] objectArray = new File(string).list(new FilenameFilterByCaseInsensitiveSuffix(string2));
        Arrays.sort(objectArray);
        slf4jlogger.info("Number of files = {}", objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = new File(string, (String)objectArray[i]).getCanonicalPath();
            slf4jlogger.info("File: {}", objectArray[i]);
        }
        return objectArray;
    }

    public RawRGBToDicomMultiFrame(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IOException, DicomException {
        String string9 = "GM";
        String string10 = "1.2.840.10008.5.1.4.1.1.7.4";
        String string11 = "1";
        RawRGBInformation rawRGBInformation = new RawRGBInformation(string);
        String[] stringArray = RawRGBToDicomMultiFrame.getSortedInputFileNames(string2, string3);
        int n = stringArray.length;
        AttributeList attributeList = RawRGBToDicomMultiFrame.generateDICOMPixelDataModuleAttributesFromRawRGBFiles(stringArray, string3, rawRGBInformation, null);
        UIDGenerator uIDGenerator = new UIDGenerator();
        String string12 = uIDGenerator.getAnotherNewUID();
        Object object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object).addValue(string12);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.FrameOfReferenceUID);
        ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)object).addValue(string5);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)object).addValue(string6);
        attributeList.put((Attribute)object);
        object = new DateAttribute(TagFromName.PatientBirthDate);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientSex);
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)object).addValue(string7);
        attributeList.put((Attribute)object);
        object = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)object).addValue("^^^^");
        attributeList.put((Attribute)object);
        object = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object).addValue(string8);
        attributeList.put((Attribute)object);
        object = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)object).addValue(string11);
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Laterality);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.BurnedInAnnotation);
        ((Attribute)object).addValue("NO");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object).addValue("DERIVED");
        ((Attribute)object).addValue("SECONDARY");
        attributeList.put((Attribute)object);
        object = new LongStringAttribute(TagFromName.PositionReferenceIndicator);
        attributeList.put((Attribute)object);
        object = new Date();
        String string13 = new SimpleDateFormat("yyyyMMdd").format((Date)object);
        String string14 = new SimpleDateFormat("HHmmss.SSS").format((Date)object);
        StringAttribute stringAttribute = new DateAttribute(TagFromName.StudyDate);
        ((Attribute)stringAttribute).addValue(string13);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.StudyTime);
        ((Attribute)stringAttribute).addValue(string14);
        attributeList.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)stringAttribute).addValue(string13);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)stringAttribute).addValue(string14);
        attributeList.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)stringAttribute).addValue(string13);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)stringAttribute).addValue(string14);
        attributeList.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.InstanceCreationDate);
        ((Attribute)stringAttribute).addValue(string13);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.InstanceCreationTime);
        ((Attribute)stringAttribute).addValue(string14);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
        ((Attribute)stringAttribute).addValue(DateTimeAttribute.getTimeZone(TimeZone.getDefault(), (Date)object));
        attributeList.put(stringAttribute);
        object = new UniqueIdentifierAttribute(TagFromName.InstanceCreatorUID);
        ((Attribute)object).addValue("1.3.6.1.4.1.5962.99.3");
        attributeList.put((Attribute)object);
        RawRGBToDicomMultiFrame.generateGeometryFunctionalGroupsFromRawRGBInformation(rawRGBInformation, attributeList, n);
        object = new AttributeTagAttribute(TagFromName.FrameIncrementPointer);
        ((AttributeTagAttribute)object).addValue(TagFromName.PerFrameFunctionalGroupsSequence);
        attributeList.put((Attribute)object);
        object = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object).addValue(string10);
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.ConversionType);
        ((Attribute)object).addValue("WSD");
        attributeList.put((Attribute)object);
        object = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)object).addValue(string9);
        attributeList.put((Attribute)object);
        CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        object = new File(string4, string12 + ".dcm");
        attributeList.write((File)object, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 8) {
                new RawRGBToDicomMultiFrame(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], stringArray[7]);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: RawRGBToDicomMultiFrame formatFile inputFolder inputFileNameSuffix outputFolder patientName patientID studyID seriesNumber");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

