/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.TIFFException;
import com.pixelmed.convert.TIFFFile;
import com.pixelmed.convert.TIFFImageFileDirectoryEntry;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.EOFException;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;

public class TIFFImageFileDirectory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/TIFFImageFileDirectory.java,v 1.2 2019/08/11 13:19:02 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TIFFImageFileDirectory.class);
    protected long ifdOffsetThis;
    protected long ifdOffsetNext;
    protected SortedMap<Integer, TIFFImageFileDirectoryEntry> entries = new TreeMap<Integer, TIFFImageFileDirectoryEntry>();

    public long read(TIFFFile tIFFFile, long l) throws EOFException, IOException, TIFFException {
        this.ifdOffsetThis = l;
        if (tIFFFile.isBigTIFF()) {
            tIFFFile.seek(l);
            long l2 = tIFFFile.getUnsigned64();
            slf4jlogger.debug("read(): BigTIFF - numberOfTagsInIFD = {}", l2);
            for (long i = 0L; i < l2; ++i) {
                TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = TIFFImageFileDirectoryEntry.readBigIFDEntry(tIFFFile);
                this.entries.put(new Integer(tIFFImageFileDirectoryEntry.getTagIdentifier()), tIFFImageFileDirectoryEntry);
            }
            this.ifdOffsetNext = tIFFFile.getUnsigned64();
        } else {
            tIFFFile.seek(l);
            int n = tIFFFile.getUnsigned16();
            slf4jlogger.debug("read(): not BigTIFF - numberOfTagsInIFD = {}", n);
            for (int i = 0; i < n; ++i) {
                TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = TIFFImageFileDirectoryEntry.readClassicIFDEntry(tIFFFile);
                this.entries.put(new Integer(tIFFImageFileDirectoryEntry.getTagIdentifier()), tIFFImageFileDirectoryEntry);
            }
            this.ifdOffsetNext = tIFFFile.getUnsigned32();
        }
        slf4jlogger.debug("read(): Next ifdOffsetNext = {}", this.ifdOffsetNext);
        return this.ifdOffsetNext;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("offset ");
        stringBuffer.append(this.ifdOffsetThis);
        stringBuffer.append(" (0x");
        stringBuffer.append(Long.toHexString(this.ifdOffsetThis));
        stringBuffer.append(") next ");
        stringBuffer.append(this.ifdOffsetNext);
        stringBuffer.append(" (0x");
        stringBuffer.append(Long.toHexString(this.ifdOffsetNext));
        stringBuffer.append(")\n");
        for (TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry : this.entries.values()) {
            stringBuffer.append(tIFFImageFileDirectoryEntry);
        }
        return stringBuffer.toString();
    }

    public TIFFImageFileDirectoryEntry getEntry(int n) {
        return (TIFFImageFileDirectoryEntry)this.entries.get(new Integer(n));
    }

    public double getSingleRationalValue(int n, int n2, double d) {
        double d2 = d;
        TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = this.getEntry(n);
        if (tIFFImageFileDirectoryEntry != null) {
            if (tIFFImageFileDirectoryEntry.getNumberOfValues() == 1L && n2 == 0) {
                long l = tIFFImageFileDirectoryEntry.getValues().getSingleNumericValue(n2, 0L);
                d2 = l == 0L ? d : (double)l;
            } else if (tIFFImageFileDirectoryEntry.getNumberOfValues() > (long)(n2 + 1)) {
                long l = tIFFImageFileDirectoryEntry.getValues().getSingleNumericValue(n2, 0L);
                long l2 = tIFFImageFileDirectoryEntry.getValues().getSingleNumericValue(n2 + 1, 1L);
                d2 = (double)l / (double)l2;
            }
        }
        return d2;
    }

    public long getSingleNumericValue(int n, int n2, long l) {
        long l2 = l;
        TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = this.getEntry(n);
        if (tIFFImageFileDirectoryEntry != null && tIFFImageFileDirectoryEntry.getNumberOfValues() > (long)n2) {
            l2 = tIFFImageFileDirectoryEntry.getValues().getSingleNumericValue(n2, l);
        }
        return l2;
    }

    public long[] getNumericValues(int n) {
        long[] lArray = null;
        TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = this.getEntry(n);
        if (tIFFImageFileDirectoryEntry != null && tIFFImageFileDirectoryEntry.getNumberOfValues() > 0L) {
            lArray = tIFFImageFileDirectoryEntry.getValues().getNumericValues();
        }
        return lArray;
    }

    public byte[] getByteValues(int n) {
        byte[] byArray = null;
        TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = this.getEntry(n);
        if (tIFFImageFileDirectoryEntry != null && tIFFImageFileDirectoryEntry.getNumberOfValues() > 0L) {
            byArray = tIFFImageFileDirectoryEntry.getValues().getByteValues();
        }
        return byArray;
    }

    public String[] getStringValues(int n) {
        slf4jlogger.debug("getStringValues(): tagIdentifier = {}", n);
        String[] stringArray = null;
        TIFFImageFileDirectoryEntry tIFFImageFileDirectoryEntry = this.getEntry(n);
        if (tIFFImageFileDirectoryEntry != null && tIFFImageFileDirectoryEntry.getNumberOfValues() > 0L) {
            stringArray = tIFFImageFileDirectoryEntry.getValues().getStringValues();
        }
        return stringArray;
    }
}

