/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class DatabaseApplicationProperties {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DatabaseApplicationProperties.java,v 1.17 2025/01/29 10:58:06 dclunie Exp $";
    private static final String defaultDatabaseFileName = ".com.pixelmed.display.DicomImageViewer.database";
    private static final String defaultSavedImagesFolderName = ".com.pixelmed.display.DicomImageViewer.images";
    private static final String defaultDatabaseServerName = null;
    public static final String propertyName_DatabaseFileName = "Application.DatabaseFileName";
    public static final String propertyName_SavedImagesFolderName = "Application.SavedImagesFolderName";
    public static final String propertyName_DatabaseServerName = "Application.DatabaseServerName";
    private String dataBaseFileName = ".com.pixelmed.display.DicomImageViewer.database";
    private String savedImagesFolderName = ".com.pixelmed.display.DicomImageViewer.images";
    private String databaseServerName = defaultDatabaseServerName;

    public DatabaseApplicationProperties(Properties properties) {
        this.dataBaseFileName = properties.getProperty(propertyName_DatabaseFileName);
        if (this.dataBaseFileName == null) {
            this.dataBaseFileName = defaultDatabaseFileName;
        }
        this.savedImagesFolderName = properties.getProperty(propertyName_SavedImagesFolderName);
        if (this.savedImagesFolderName == null) {
            this.savedImagesFolderName = defaultSavedImagesFolderName;
        }
        this.databaseServerName = properties.getProperty(propertyName_DatabaseServerName);
        if (this.databaseServerName == null) {
            this.databaseServerName = defaultDatabaseServerName;
        }
    }

    public String getDatabaseFileName() {
        return this.dataBaseFileName;
    }

    public String getSavedImagesFolderName() {
        return this.savedImagesFolderName;
    }

    public File getSavedImagesFolderCreatingItIfNecessary() throws IOException {
        File file = new File(this.savedImagesFolderName);
        if (file.isAbsolute()) {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Cannot find or create absolute path " + file);
            }
        } else {
            file = new File(FileUtilities.makePathToFileInUsersHomeDirectory(this.savedImagesFolderName));
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new IOException("Cannot find or create home directory relative path " + file);
            }
        }
        return file;
    }

    public String getDatabaseServerName() {
        return this.databaseServerName;
    }
}

