/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DicomDatabaseInformationModel;
import com.pixelmed.database.DicomDictionaryForStudySeriesInstanceModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.TagFromName;

public class StudySeriesInstanceModel
extends DicomDatabaseInformationModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/StudySeriesInstanceModel.java,v 1.23 2025/01/29 10:58:06 dclunie Exp $";

    public StudySeriesInstanceModel(String string) throws DicomException {
        super(string, InformationEntity.STUDY, new DicomDictionaryForStudySeriesInstanceModel());
    }

    public StudySeriesInstanceModel(String string, String string2) throws DicomException {
        super(string, string2, InformationEntity.STUDY, new DicomDictionaryForStudySeriesInstanceModel());
    }

    public StudySeriesInstanceModel(String string, DicomDictionary dicomDictionary) throws DicomException {
        super(string, InformationEntity.STUDY, dicomDictionary);
    }

    public StudySeriesInstanceModel(String string, String string2, DicomDictionary dicomDictionary) throws DicomException {
        super(string, string2, InformationEntity.STUDY, dicomDictionary);
    }

    @Override
    protected boolean isInformationEntityInModel(InformationEntity informationEntity) {
        return informationEntity == InformationEntity.STUDY || informationEntity == InformationEntity.SERIES || informationEntity == InformationEntity.INSTANCE;
    }

    @Override
    public InformationEntity getChildTypeForParent(InformationEntity informationEntity, boolean bl) {
        if (informationEntity == InformationEntity.STUDY) {
            return InformationEntity.SERIES;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return InformationEntity.INSTANCE;
        }
        return null;
    }

    private InformationEntity getChildTypeForParent(InformationEntity informationEntity, String string) {
        return this.getChildTypeForParent(informationEntity, string != null);
    }

    @Override
    public InformationEntity getChildTypeForParent(InformationEntity informationEntity) {
        return this.getChildTypeForParent(informationEntity, true);
    }

    @Override
    public InformationEntity getChildTypeForParent(InformationEntity informationEntity, AttributeList attributeList) {
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ConcatenationUID);
        return this.getChildTypeForParent(informationEntity, string);
    }

    @Override
    public String getDescriptiveColumnName(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.STUDY) {
            return "STUDYID";
        }
        if (informationEntity == InformationEntity.SERIES) {
            return "SERIESNUMBER";
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "INSTANCENUMBER";
        }
        return null;
    }

    @Override
    public String getOtherDescriptiveColumnName(InformationEntity informationEntity) {
        return null;
    }

    @Override
    public String getOtherOtherDescriptiveColumnName(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.STUDY) {
            return "STUDYDESCRIPTION";
        }
        if (informationEntity == InformationEntity.SERIES) {
            return "SERIESDESCRIPTION";
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "IMAGECOMMENTS";
        }
        return null;
    }

    @Override
    public String getUIDColumnNameForInformationEntity(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.STUDY) {
            return "STUDYINSTANCEUID";
        }
        if (informationEntity == InformationEntity.SERIES) {
            return "SERIESINSTANCEUID";
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "SOPINSTANCEUID";
        }
        return null;
    }

    @Override
    protected void extendStatementStringWithMatchingAttributesForSelectedInformationEntity(StringBuffer stringBuffer, AttributeList attributeList, InformationEntity informationEntity) throws DicomException {
        if (informationEntity == InformationEntity.STUDY) {
            stringBuffer.append("STUDY.STUDYINSTANCEUID");
            StudySeriesInstanceModel.appendExactOrIsNullMatch(stringBuffer, StudySeriesInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.StudyInstanceUID)));
        } else if (informationEntity == InformationEntity.SERIES) {
            stringBuffer.append(" AND ");
            stringBuffer.append("SERIES.SERIESINSTANCEUID");
            StudySeriesInstanceModel.appendExactOrIsNullMatch(stringBuffer, StudySeriesInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.SeriesInstanceUID)));
        } else if (informationEntity == InformationEntity.INSTANCE) {
            stringBuffer.append(" AND ");
            stringBuffer.append("INSTANCE.SOPINSTANCEUID");
            StudySeriesInstanceModel.appendExactOrIsNullMatch(stringBuffer, StudySeriesInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.SOPInstanceUID)));
        }
    }
}

