/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeListTableModel;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.ApplicationFrame;
import java.awt.Component;
import java.io.Serializable;
import java.util.HashSet;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AttributeListTableBrowser
extends JTable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeListTableBrowser.java,v 1.23 2025/01/29 10:58:06 dclunie Exp $";

    public AttributeListTableBrowser(AttributeListTableModel attributeListTableModel) {
        this.setModel(attributeListTableModel);
        this.setColumnWidths();
    }

    public AttributeListTableBrowser(AttributeList attributeList) {
        this.setModel(new AttributeListTableModel(attributeList));
        this.setColumnWidths();
    }

    public AttributeListTableBrowser(AttributeList attributeList, HashSet<AttributeTag> hashSet, HashSet<AttributeTag> hashSet2) {
        this.setModel(new AttributeListTableModel(attributeList, hashSet, hashSet2));
        this.setColumnWidths();
    }

    public void setColumnWidths() {
        int n = this.getModel().getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            if (tableCellRenderer == null) {
                tableCellRenderer = this.getTableHeader().getDefaultRenderer();
            }
            Component component = tableCellRenderer.getTableCellRendererComponent(this, tableColumn.getHeaderValue(), false, false, -1, i);
            Component component2 = this.getDefaultRenderer(this.getColumnClass(i)).getTableCellRendererComponent(this, this.getModel().getValueAt(0, i), false, false, 0, i);
            int n2 = Math.max(component.getPreferredSize().width + 10, component2.getPreferredSize().width + 10);
            tableColumn.setPreferredWidth(n2);
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        try {
            attributeList.read(stringArray[0]);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.exit(0);
        }
        ApplicationFrame applicationFrame = new ApplicationFrame();
        Serializable serializable = new HashSet<AttributeTag>();
        serializable.add(TagFromName.FileMetaInformationGroupLength);
        serializable.add(TagFromName.ImplementationVersionName);
        serializable.add(TagFromName.SourceApplicationEntityTitle);
        AttributeListTableBrowser attributeListTableBrowser = new AttributeListTableBrowser(new AttributeListTableModel(attributeList, null, (HashSet)serializable));
        attributeListTableBrowser.setAutoResizeMode(0);
        serializable = new JScrollPane(attributeListTableBrowser);
        applicationFrame.getContentPane().add((Component)serializable);
        applicationFrame.pack();
        applicationFrame.setVisible(true);
    }
}

