/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.text.NumberFormat;

public class AttributeTagAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeTagAttribute.java,v 1.26 2025/01/29 10:58:06 dclunie Exp $";
    int[] groups;
    int[] elements;
    static int bytesPerValue = 4;

    public AttributeTagAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.groups = null;
        this.elements = null;
    }

    public AttributeTagAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public AttributeTagAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.valueLength = l;
        if (this.valueLength % (long)bytesPerValue != 0L) {
            throw new DicomException("incorrect value length for VR " + this.getVR());
        }
        int n = (int)(this.valueLength / (long)bytesPerValue);
        this.groups = null;
        this.elements = null;
        for (int i = 0; i < n; ++i) {
            int n2 = dicomInputStream.readUnsigned16() & 0xFFFF;
            int n3 = dicomInputStream.readUnsigned16() & 0xFFFF;
            this.addValue(n2, n3);
        }
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        for (int i = 0; i < this.valueMultiplicity; ++i) {
            dicomOutputStream.writeUnsigned16(this.groups[i]);
            dicomOutputStream.writeUnsigned16(this.elements[i]);
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" [");
        try {
            if (this.groups != null && this.elements != null) {
                for (int i = 0; i < this.groups.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    AttributeTag.toString(this.groups[i], this.elements[i]);
                }
            }
        }
        catch (Exception exception) {
            stringBuffer.append("XXXX");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        if (this.groups != null && this.elements != null) {
            stringArray = new String[this.groups.length];
            for (int i = 0; i < this.groups.length; ++i) {
                stringArray[i] = AttributeTag.toString(this.groups[i], this.elements[i]);
            }
        }
        return stringArray;
    }

    public AttributeTag[] getAttributeTagValues() throws DicomException {
        AttributeTag[] attributeTagArray = null;
        if (this.groups != null && this.elements != null) {
            attributeTagArray = new AttributeTag[this.groups.length];
            for (int i = 0; i < this.groups.length; ++i) {
                attributeTagArray[i] = new AttributeTag(this.groups[i], this.elements[i]);
            }
        }
        return attributeTagArray;
    }

    public void addValue(int n, int n2) throws DicomException {
        this.groups = ArrayCopyUtilities.expandArray(this.groups);
        this.groups[this.valueMultiplicity] = n;
        this.elements = ArrayCopyUtilities.expandArray(this.elements);
        this.elements[this.valueMultiplicity++] = n2;
        this.valueLength = this.valueMultiplicity * 4;
    }

    public void addValue(AttributeTag attributeTag) throws DicomException {
        this.addValue(attributeTag.getGroup(), attributeTag.getElement());
    }

    @Override
    public void addValue(String string) throws DicomException {
        this.addValue(new AttributeTag(string));
    }

    @Override
    public void removeValues() {
        this.groups = null;
        this.elements = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.AT;
    }
}

