/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CodedSequenceItem {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CodedSequenceItem.java,v 1.28 2025/01/29 10:58:06 dclunie Exp $";
    protected AttributeList list;

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof CodedSequenceItem) {
            bl = this.list.equals(((CodedSequenceItem)object).getAttributeList());
        }
        return bl;
    }

    public int hashCode() {
        return this.list.hashCode();
    }

    public CodedSequenceItem(AttributeList attributeList) {
        this.list = attributeList;
    }

    public CodedSequenceItem(String string, String string2, String string3) throws DicomException {
        this.list = new AttributeList();
        StringAttributeAffectedBySpecificCharacterSet stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodeValue);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodingSchemeDesignator);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string2);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new LongStringAttribute(TagFromName.CodeMeaning);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string3);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
    }

    public CodedSequenceItem(String string, String string2, String string3, String string4) throws DicomException {
        this.list = new AttributeList();
        StringAttributeAffectedBySpecificCharacterSet stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodeValue);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodingSchemeDesignator);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string2);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodingSchemeVersion);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string3);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
        stringAttributeAffectedBySpecificCharacterSet = new LongStringAttribute(TagFromName.CodeMeaning);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string4);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
    }

    public CodedSequenceItem(String string) throws DicomException {
        StringAttributeAffectedBySpecificCharacterSet stringAttributeAffectedBySpecificCharacterSet;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        Pattern pattern = Pattern.compile("[ ]*[(][ ]*\"?([^,\"]+)\"?[ ]*,[ ]*\"?([^,\"]+)\"?[ ]*,[ ]*\"?([^,\"]+)\"?[ ]*[)][ ]*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            int n = matcher.groupCount();
            if (n >= 3) {
                string2 = matcher.group(1);
                string3 = matcher.group(2);
                string5 = matcher.group(3);
            }
        } else {
            int n;
            Pattern pattern2 = Pattern.compile("[ ]*[(][ ]*\"?([^,\"]+)\"?[ ]*,[ ]*\"?([^,\"]+)\"?[ ]*,[ ]*\"?([^,\"]+)\"?[ ]*,[ ]*\"?([^,\"]+)\"?[ ]*[)][ ]*");
            Matcher matcher2 = pattern2.matcher(string);
            if (matcher2.matches() && (n = matcher2.groupCount()) >= 4) {
                string2 = matcher2.group(1);
                string3 = matcher2.group(2);
                string4 = matcher2.group(3);
                string5 = matcher2.group(4);
            }
        }
        if (string2.length() > 0 && string3.length() > 0 && string5.length() > 0) {
            this.list = new AttributeList();
            stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodeValue);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string2);
            this.list.put(stringAttributeAffectedBySpecificCharacterSet);
            stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodingSchemeDesignator);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string3);
            this.list.put(stringAttributeAffectedBySpecificCharacterSet);
            if (string4.length() > 0) {
                stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(TagFromName.CodingSchemeVersion);
                ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string4);
                this.list.put(stringAttributeAffectedBySpecificCharacterSet);
            }
        } else {
            throw new DicomException("Unable to recognize pattern of tuple");
        }
        stringAttributeAffectedBySpecificCharacterSet = new LongStringAttribute(TagFromName.CodeMeaning);
        ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string5);
        this.list.put(stringAttributeAffectedBySpecificCharacterSet);
    }

    public AttributeList getAttributeList() {
        return this.list;
    }

    public String getCodeValue() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodeValue);
    }

    public String getCodingSchemeDesignator() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodingSchemeDesignator);
    }

    public String getCodingSchemeVersion() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodingSchemeVersion);
    }

    public String getCodeMeaning() {
        return Attribute.getSingleStringValueOrEmptyString(this.list, TagFromName.CodeMeaning);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this.getCodeValue());
        stringBuffer.append(",");
        stringBuffer.append(this.getCodingSchemeDesignator());
        String string = this.getCodingSchemeVersion();
        if (string != null && string.length() > 0) {
            stringBuffer.append(",");
            stringBuffer.append(string);
        }
        stringBuffer.append(",\"");
        stringBuffer.append(this.getCodeMeaning());
        stringBuffer.append("\")");
        return stringBuffer.toString();
    }

    public String toTabDelimitedString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getCodeValue());
        stringBuffer.append("\t");
        stringBuffer.append(this.getCodingSchemeDesignator());
        String string = this.getCodingSchemeVersion();
        stringBuffer.append("\t");
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append("\t");
        stringBuffer.append(this.getCodeMeaning());
        return stringBuffer.toString();
    }

    public static CodedSequenceItem getSingleCodedSequenceItemOrNull(AttributeList attributeList, AttributeTag attributeTag) {
        CodedSequenceItem codedSequenceItem = null;
        if (attributeList != null) {
            codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList.get(attributeTag));
        }
        return codedSequenceItem;
    }

    public static CodedSequenceItem getSingleCodedSequenceItemOrNull(Attribute attribute) {
        SequenceItem sequenceItem;
        SequenceAttribute sequenceAttribute;
        Iterator<SequenceItem> iterator;
        CodedSequenceItem codedSequenceItem = null;
        if (attribute != null && attribute instanceof SequenceAttribute && (iterator = (sequenceAttribute = (SequenceAttribute)attribute).iterator()).hasNext() && (sequenceItem = iterator.next()) != null) {
            codedSequenceItem = new CodedSequenceItem(sequenceItem.getAttributeList());
        }
        return codedSequenceItem;
    }

    public static CodedSequenceItem[] getArrayOfCodedSequenceItemsOrNull(AttributeList attributeList, AttributeTag attributeTag) {
        CodedSequenceItem[] codedSequenceItemArray = null;
        if (attributeList != null) {
            codedSequenceItemArray = CodedSequenceItem.getArrayOfCodedSequenceItemsOrNull(attributeList.get(attributeTag));
        }
        return codedSequenceItemArray;
    }

    public static CodedSequenceItem[] getArrayOfCodedSequenceItemsOrNull(Attribute attribute) {
        SequenceItem sequenceItem;
        SequenceAttribute sequenceAttribute;
        Iterator<SequenceItem> iterator;
        ArrayList<CodedSequenceItem> arrayList = new ArrayList<CodedSequenceItem>();
        if (attribute != null && attribute instanceof SequenceAttribute && (iterator = (sequenceAttribute = (SequenceAttribute)attribute).iterator()).hasNext() && (sequenceItem = iterator.next()) != null) {
            arrayList.add(new CodedSequenceItem(sequenceItem.getAttributeList()));
        }
        return arrayList.size() == 0 ? null : (CodedSequenceItem[])arrayList.toArray();
    }

    public static void putSingleCodedSequenceItem(AttributeList attributeList, AttributeTag attributeTag, String string, String string2, String string3) throws DicomException {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(attributeTag);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        attributeList2.putAll(new CodedSequenceItem(string, string2, string3).getAttributeList());
    }

    public static SequenceAttribute putSingleCodedSequenceAttribute(AttributeList attributeList, AttributeTag attributeTag, CodedSequenceItem codedSequenceItem) {
        SequenceAttribute sequenceAttribute = CodedSequenceItem.newCodedSequenceAttribute(attributeTag, codedSequenceItem);
        attributeList.put(sequenceAttribute);
        return sequenceAttribute;
    }

    public static SequenceAttribute newCodedSequenceAttribute(AttributeTag attributeTag, CodedSequenceItem codedSequenceItem) {
        SequenceAttribute sequenceAttribute = new SequenceAttribute(attributeTag);
        AttributeList attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        attributeList.putAll(codedSequenceItem.getAttributeList());
        return sequenceAttribute;
    }

    public static int getItemNumberContainingCodeSequence(SequenceAttribute sequenceAttribute, AttributeTag attributeTag, CodedSequenceItem codedSequenceItem) {
        int n = -1;
        if (sequenceAttribute != null) {
            int n2 = sequenceAttribute.getNumberOfItems();
            for (int i = 0; i < n2; ++i) {
                CodedSequenceItem codedSequenceItem2;
                AttributeList attributeList;
                SequenceItem sequenceItem = sequenceAttribute.getItem(i);
                if (sequenceItem == null || (attributeList = sequenceItem.getAttributeList()) == null || (codedSequenceItem2 = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, attributeTag)) == null || !codedSequenceItem2.equals(codedSequenceItem)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    public static int getItemNumberContainingCodeSequence(AttributeList attributeList, AttributeTag attributeTag, AttributeTag attributeTag2, CodedSequenceItem codedSequenceItem) {
        int n = -1;
        SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(attributeTag);
        if (sequenceAttribute != null) {
            n = CodedSequenceItem.getItemNumberContainingCodeSequence(sequenceAttribute, attributeTag2, codedSequenceItem);
        }
        return n;
    }
}

