/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class DicomDirectoryRecord
implements Comparable,
TreeNode {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomDirectoryRecord.java,v 1.30 2025/01/29 10:58:06 dclunie Exp $";
    DicomDirectoryRecord parent;
    Collection children;
    TreeNode[] array;
    AttributeList list;
    protected String uid;
    protected String stringValue;
    protected int integerValue;

    public int compareTo(Object object) {
        return this.compareToThatReturnsZeroOnlyIfSameObject(object);
    }

    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        return bl;
    }

    protected abstract void makeStringValue();

    protected abstract void makeIntegerValue();

    protected String getStringValue() {
        return this.stringValue;
    }

    protected int getIntegerValue() {
        return this.integerValue;
    }

    protected final String getUIDForComparison() {
        return this.uid;
    }

    private int compareToThatReturnsZeroOnlyIfSameObject(Object object) {
        return super.equals(object) ? 0 : 1;
    }

    protected final int compareToByStringValue(DicomDirectoryRecord dicomDirectoryRecord, boolean bl) {
        if (this.getClass().equals(dicomDirectoryRecord.getClass())) {
            int n = this.toString().compareTo(dicomDirectoryRecord.toString());
            if (n == 0) {
                int n2 = this.getUIDForComparison().compareTo(dicomDirectoryRecord.getUIDForComparison());
                if (n2 == 0) {
                    return bl ? this.compareToThatReturnsZeroOnlyIfSameObject(dicomDirectoryRecord) : 0;
                }
                return n2;
            }
            return n;
        }
        return this.toString().compareTo(dicomDirectoryRecord.toString());
    }

    protected final int compareToByIntegerValue(DicomDirectoryRecord dicomDirectoryRecord, boolean bl) {
        if (this.getClass().equals(dicomDirectoryRecord.getClass())) {
            int n = this.getIntegerValue() - dicomDirectoryRecord.getIntegerValue();
            if (n == 0) {
                int n2 = this.toString().compareTo(dicomDirectoryRecord.toString());
                if (n2 == 0) {
                    int n3 = this.getUIDForComparison().compareTo(dicomDirectoryRecord.getUIDForComparison());
                    if (n3 == 0) {
                        return bl ? this.compareToThatReturnsZeroOnlyIfSameObject(dicomDirectoryRecord) : 0;
                    }
                    return n3;
                }
                return n2;
            }
            return n;
        }
        return this.toString().compareTo(dicomDirectoryRecord.toString());
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public TreeNode getChildAt(int n) {
        int n2 = this.children.size();
        if (this.array == null) {
            this.array = this.children.toArray(new TreeNode[n2]);
        }
        return n < n2 ? this.array[n] : null;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (this.children != null) {
            int n = this.children.size();
            if (this.array == null) {
                this.array = this.children.toArray(new TreeNode[n]);
            }
            for (int i = 0; i < n; ++i) {
                if (((DicomDirectoryRecord)this.getChildAt(i)).compareToByStringValue((DicomDirectoryRecord)treeNode, false) != 0) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Enumeration children() {
        return this.children == null ? null : new Vector(this.children).elements();
    }

    public DicomDirectoryRecord(DicomDirectoryRecord dicomDirectoryRecord, AttributeList attributeList) {
        this.parent = dicomDirectoryRecord;
        this.list = attributeList;
        this.makeIntegerValue();
        this.makeStringValue();
    }

    public void addChild(DicomDirectoryRecord dicomDirectoryRecord) {
        if (this.children == null) {
            this.children = new TreeSet();
        }
        this.children.add(dicomDirectoryRecord);
        this.array = null;
    }

    public void removeChild(DicomDirectoryRecord dicomDirectoryRecord) {
        this.children.remove(dicomDirectoryRecord);
        this.array = null;
    }

    public void addSibling(DicomDirectoryRecord dicomDirectoryRecord) throws DicomException {
        if (this.parent == null) {
            throw new DicomException("Internal error - root node with sibling");
        }
        this.parent.addChild(dicomDirectoryRecord);
    }

    public void setParent(DicomDirectoryRecord dicomDirectoryRecord) {
        this.parent = dicomDirectoryRecord;
    }

    public AttributeList getAttributeList() {
        return this.list;
    }
}

