/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DicomFileUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomFileUtilities.java,v 1.16 2025/01/29 10:58:06 dclunie Exp $";

    private DicomFileUtilities() {
    }

    static final int extractUnsigned16(byte[] byArray, int n, boolean bl) {
        short s = (short)(byArray[n + 0] & 0xFF);
        short s2 = (short)(byArray[n + 1] & 0xFF);
        return (short)(bl ? s << 8 | s2 : s2 << 8 | s);
    }

    static final long extractUnsigned32(byte[] byArray, int n, boolean bl) {
        long l = (long)byArray[n + 0] & 0xFFL;
        long l2 = (long)byArray[n + 1] & 0xFFL;
        long l3 = (long)byArray[n + 2] & 0xFFL;
        long l4 = (long)byArray[n + 3] & 0xFFL;
        return bl ? ((l << 8 | l2) << 8 | l3) << 8 | l4 : ((l4 << 8 | l3) << 8 | l2) << 8 | l;
    }

    public static boolean isDicomOrAcrNemaFile(String string) {
        return DicomFileUtilities.isDicomOrAcrNemaFile(new File(string));
    }

    public static boolean isDicomOrAcrNemaFile(File file) {
        boolean bl = false;
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[160];
            int n2 = 0;
            int n3 = 160;
            while (n3 > 0 && (n = ((InputStream)bufferedInputStream).read(byArray, n2, n3)) != -1) {
                n3 -= n;
                n2 += n;
            }
            fileInputStream.close();
            fileInputStream = null;
            if (n2 >= 136 && new String(byArray, 128, 4).equals("DICM") && (DicomFileUtilities.extractUnsigned16(byArray, 132, false) == 2 || DicomFileUtilities.extractUnsigned16(byArray, 132, false) == 0)) {
                bl = true;
            } else if (n2 >= 136 && new String(byArray, 128, 4).equals("DICM") && DicomFileUtilities.extractUnsigned16(byArray, 132, true) == 2) {
                bl = true;
            } else if (n2 >= 8 && DicomFileUtilities.extractUnsigned16(byArray, 0, false) == 8 && DicomFileUtilities.extractUnsigned16(byArray, 2, false) <= 24 && (DicomFileUtilities.extractUnsigned32(byArray, 4, false) <= 256L || Character.isUpperCase((char)byArray[4]) && Character.isUpperCase((char)byArray[5]))) {
                bl = true;
            } else if (n2 >= 8 && DicomFileUtilities.extractUnsigned16(byArray, 0, true) == 8 && DicomFileUtilities.extractUnsigned16(byArray, 2, true) <= 24 && (DicomFileUtilities.extractUnsigned32(byArray, 4, true) <= 256L || Character.isUpperCase((char)byArray[4]) && Character.isUpperCase((char)byArray[5]))) {
                bl = true;
            }
        }
        catch (Exception exception) {
            bl = false;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        try {
            for (String string : stringArray) {
                System.err.println("File " + string + " isDicomOrAcrNemaFile() = " + DicomFileUtilities.isDicomOrAcrNemaFile(string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

