/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.HexDump;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class DicomInputStream
extends BinaryInputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomInputStream.java,v 1.23 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DicomInputStream.class);
    private TransferSyntax TransferSyntaxToReadDataSet;
    private TransferSyntax TransferSyntaxToReadMetaHeader;
    private TransferSyntax TransferSyntaxInUse;
    private boolean readingDataSet;
    private long byteOffsetOfStartOfData;

    private void initializeTransferSyntax(String string, boolean bl) throws IOException {
        slf4jlogger.debug("initializeTransferSyntax: uid={} tryMeta={}", string, bl);
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("initializeTransferSyntax: markSupported()= {}", this.markSupported());
        }
        this.TransferSyntaxToReadMetaHeader = null;
        this.TransferSyntaxToReadDataSet = null;
        byte[] byArray = new byte[8];
        if (string != null) {
            TransferSyntax transferSyntax = new TransferSyntax(string);
            if (bl) {
                this.TransferSyntaxToReadMetaHeader = transferSyntax;
            } else {
                this.TransferSyntaxToReadDataSet = transferSyntax;
            }
        }
        if (bl) {
            slf4jlogger.debug("initializeTransferSyntax: looking for preamble");
            if (this.markSupported()) {
                this.mark(140);
            }
            boolean bl2 = true;
            try {
                this.skipInsistently(128L);
            }
            catch (IOException iOException) {
                bl2 = false;
            }
            if (bl2 && this.read(byArray, 0, 4) == 4 && new String(byArray, 0, 4).equals("DICM")) {
                slf4jlogger.debug("initializeTransferSyntax: detected DICM");
                if (this.TransferSyntaxToReadMetaHeader == null) {
                    slf4jlogger.debug("initializeTransferSyntax: trying to guess TransferSyntaxToReadMetaHeader");
                    if (this.markSupported()) {
                        this.mark(8);
                        this.TransferSyntaxToReadMetaHeader = this.read(byArray, 0, 6) == 6 ? (Character.isUpperCase((char)byArray[4]) && Character.isUpperCase((char)byArray[5]) ? new TransferSyntax("1.2.840.10008.1.2.1") : new TransferSyntax("1.2.840.10008.1.2")) : new TransferSyntax("1.2.840.10008.1.2.1");
                        this.reset();
                    } else {
                        this.TransferSyntaxToReadMetaHeader = new TransferSyntax("1.2.840.10008.1.2.1");
                        slf4jlogger.debug("initializeTransferSyntax: can't rewind so assuming TransferSyntaxToReadMetaHeader is ExplicitVRLittleEndian");
                    }
                }
                this.byteOffsetOfStartOfData = 132L;
            } else {
                slf4jlogger.debug("initializeTransferSyntax: no preamble");
                if (this.markSupported()) {
                    this.reset();
                    this.TransferSyntaxToReadDataSet = this.TransferSyntaxToReadMetaHeader;
                    this.byteOffsetOfStartOfData = 0L;
                } else {
                    throw new IOException("Not a DICOM PS 3.10 file - no DICM after preamble in metaheader, and can't rewind input");
                }
            }
        }
        if (this.TransferSyntaxToReadDataSet == null && this.TransferSyntaxToReadMetaHeader == null) {
            slf4jlogger.debug("initializeTransferSyntax: having to try and guess transfer syntax");
            this.guessTransferSyntaxToReadDataSet();
        }
        if (this.TransferSyntaxToReadMetaHeader != null) {
            this.setReadingMetaHeader();
        } else {
            this.setReadingDataSet();
        }
        if (this.TransferSyntaxInUse == null) {
            throw new IOException("Not a DICOM file (or can't detect Transfer Syntax)");
        }
        slf4jlogger.debug("initializeTransferSyntax: TransferSyntaxToReadMetaHeader={}", this.TransferSyntaxToReadMetaHeader);
        slf4jlogger.debug("initializeTransferSyntax: TransferSyntaxToReadDataSet={}", this.TransferSyntaxToReadDataSet);
        slf4jlogger.debug("initializeTransferSyntax: TransferSyntaxInUse={}", this.TransferSyntaxInUse);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void guessTransferSyntaxToReadDataSet() throws IOException {
        byte[] byArray = new byte[8];
        boolean bl = false;
        boolean bl2 = false;
        if (this.markSupported()) {
            this.mark(10);
            if (this.read(byArray, 0, 8) == 8) {
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("guessTransferSyntaxToReadDataSet: read beginning of first attribute = {}", HexDump.dump(byArray));
                }
                if (byArray[0] < byArray[1]) {
                    bl = true;
                } else if (byArray[0] == 0 && byArray[1] == 0 && byArray[4] < byArray[7]) {
                    bl = true;
                }
                if (Character.isUpperCase((char)byArray[4]) && Character.isUpperCase((char)byArray[5])) {
                    bl2 = true;
                }
            }
            this.reset();
        }
        if (bl) {
            if (!bl2) throw new IOException("Not a DICOM file (masquerades as explicit VR big endian)");
            this.TransferSyntaxToReadDataSet = new TransferSyntax("1.2.840.10008.1.2.2");
            return;
        } else {
            this.TransferSyntaxToReadDataSet = bl2 ? new TransferSyntax("1.2.840.10008.1.2.1") : new TransferSyntax("1.2.840.10008.1.2");
        }
    }

    public DicomInputStream(InputStream inputStream) throws IOException {
        super(inputStream, true);
        this.initializeTransferSyntax(null, true);
    }

    public DicomInputStream(File file) throws IOException {
        super(file, true);
        this.initializeTransferSyntax(null, true);
    }

    public DicomInputStream(InputStream inputStream, String string, boolean bl) throws IOException {
        super(inputStream, true);
        this.initializeTransferSyntax(string, bl);
    }

    public DicomInputStream(File file, String string, boolean bl) throws IOException {
        super(file, true);
        this.initializeTransferSyntax(string, bl);
    }

    public void setTransferSyntaxToReadDataSet(TransferSyntax transferSyntax) {
        this.TransferSyntaxToReadDataSet = transferSyntax;
    }

    public void setReadingDataSet() {
        this.TransferSyntaxInUse = this.TransferSyntaxToReadDataSet;
        this.setEndian(this.TransferSyntaxInUse.isBigEndian());
        this.readingDataSet = true;
    }

    public boolean areReadingDataSet() {
        return this.readingDataSet;
    }

    public void setReadingMetaHeader() {
        this.TransferSyntaxInUse = this.TransferSyntaxToReadMetaHeader;
        this.setEndian(this.TransferSyntaxInUse.isBigEndian());
        this.readingDataSet = false;
    }

    public boolean areReadingMetaHeader() {
        return !this.readingDataSet;
    }

    public boolean haveMetaHeader() {
        return this.TransferSyntaxToReadMetaHeader != null;
    }

    public TransferSyntax getTransferSyntaxInUse() {
        return this.TransferSyntaxInUse;
    }

    public TransferSyntax getTransferSyntaxToReadDataSet() {
        return this.TransferSyntaxToReadDataSet;
    }

    public TransferSyntax getTransferSyntaxToReadMetaHeader() {
        return this.TransferSyntaxToReadMetaHeader;
    }

    public long getByteOffsetOfStartOfData() {
        return this.byteOffsetOfStartOfData;
    }
}

