/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Locale;

public class LossyImageCompression {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/LossyImageCompression.java,v 1.18 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(LossyImageCompression.class);

    public static boolean hasEverBeenLossyCompressed(AttributeList attributeList) {
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("hasEverBeenLossyCompressed(): Checking LossyImageCompression {}", Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.LossyImageCompression, -1));
        }
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("hasEverBeenLossyCompressed(): Checking LossyImageCompressionRatio {}", Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.LossyImageCompressionRatio, -1.0));
        }
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("hasEverBeenLossyCompressed(): Checking LossyImageCompressionMethod length {}", Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompressionMethod).length());
        }
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("hasEverBeenLossyCompressed(): Checking DerivationDescription {}", Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.DerivationDescription).toLowerCase(Locale.US).indexOf("lossy"));
        }
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("hasEverBeenLossyCompressed(): Checking TransferSyntaxUID {}", Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID));
        }
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("hasEverBeenLossyCompressed(): Checking TransferSyntaxUID lossy {}", new TransferSyntax(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID)).isLossy());
        }
        return Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.LossyImageCompression, -1) > 0 || Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.LossyImageCompressionRatio, -1.0) > 0.0 || Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompressionMethod).length() > 0 || Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.DerivationDescription).toLowerCase(Locale.US).indexOf("lossy") > -1 || new TransferSyntax(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID)).isLossy();
    }

    public static String describeLossyCompression(AttributeList attributeList) {
        String string;
        if (LossyImageCompression.hasEverBeenLossyCompressed(attributeList)) {
            String string2;
            String string3 = Double.toString(Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.LossyImageCompressionRatio, -1.0));
            slf4jlogger.debug("describeLossyCompression(): LossyImageCompressionRatio " + string3);
            if (string3.length() > 0) {
                if (string3.contains(".")) {
                    string3 = string3.replaceFirst("0+$", "");
                    slf4jlogger.debug("describeLossyCompression(): LossyImageCompressionRatio after removing trailing zeroes if period " + string3);
                }
                string3 = string3.replaceFirst("[.]$", "");
                slf4jlogger.debug("describeLossyCompression(): LossyImageCompressionRatio after possibly removing trailing period " + string3);
                if (string3.equals("0")) {
                    string3 = "";
                }
                slf4jlogger.debug("describeLossyCompression(): LossyImageCompressionRatio after possibly removing only zero " + string3);
            }
            if ((string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompressionMethod)).length() > 0) {
                if (string2.equals("ISO_10918_1")) {
                    string2 = "JPEG";
                } else if (string2.equals("ISO_14495_1")) {
                    string2 = "JLS";
                } else if (string2.equals("ISO_15444_1")) {
                    string2 = "J2K";
                } else if (string2.equals("ISO_13818_2")) {
                    string2 = "MPEG2";
                }
            }
            string = string2.length() == 0 && string3.length() == 0 ? "Lossy" : (string3.length() == 0 ? "Lossy " + string2 : (string2.length() == 0 ? "Lossy " + string3 + ":1" : string2 + " " + string3 + ":1"));
        } else {
            string = "";
        }
        slf4jlogger.debug("describeLossyCompression(): LossyImageCompressionRatio returning " + string);
        return string;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            AttributeList attributeList = new AttributeList();
            DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
            attributeList.read(dicomInputStream, TagFromName.PixelData);
            dicomInputStream.close();
            System.out.println(LossyImageCompression.hasEverBeenLossyCompressed(attributeList));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

