/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BasicOffsetTableAccessor;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.ByteFrameSource;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.OtherAttributeOnDisk;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.HexDump;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class OtherByteAttributeCompressedSeparateFramesOnDisk
extends OtherAttributeOnDisk
implements ByteFrameSource,
BasicOffsetTableAccessor {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherByteAttributeCompressedSeparateFramesOnDisk.java,v 1.17 2025/02/11 22:28:28 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(OtherByteAttributeCompressedSeparateFramesOnDisk.class);
    protected long[][] frameItemByteOffsets;
    protected long[][] frameItemLengths;
    protected int[] basicOffsetTable = null;
    protected static final AttributeTag itemTag = TagFromName.Item;
    protected static final AttributeTag sequenceDelimitationItemTag = TagFromName.SequenceDelimitationItem;

    public OtherByteAttributeCompressedSeparateFramesOnDisk(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public OtherByteAttributeCompressedSeparateFramesOnDisk(AttributeTag attributeTag, File file, long[][] lArray, long[][] lArray2, boolean bl) throws IOException, DicomException {
        super(attributeTag, file, bl);
        this.valueLength = 0xFFFFFFFFL;
        this.frameItemByteOffsets = lArray;
        this.frameItemLengths = lArray2;
    }

    public OtherByteAttributeCompressedSeparateFramesOnDisk(AttributeTag attributeTag, DicomInputStream dicomInputStream, long[][] lArray, long[][] lArray2) throws IOException, DicomException {
        super(attributeTag, 0L, dicomInputStream, lArray[0][0]);
        this.valueLength = 0xFFFFFFFFL;
        this.frameItemByteOffsets = lArray;
        this.frameItemLengths = lArray2;
    }

    @Override
    public long getPaddedVL() {
        return 0xFFFFFFFFL;
    }

    protected void writeItemTag(DicomOutputStream dicomOutputStream, long l) throws IOException {
        dicomOutputStream.writeUnsigned16(itemTag.getGroup());
        dicomOutputStream.writeUnsigned16(itemTag.getElement());
        dicomOutputStream.writeUnsigned32(l);
    }

    protected void writeSequenceDelimitationItemTag(DicomOutputStream dicomOutputStream) throws IOException {
        dicomOutputStream.writeUnsigned16(sequenceDelimitationItemTag.getGroup());
        dicomOutputStream.writeUnsigned16(sequenceDelimitationItemTag.getElement());
        dicomOutputStream.writeUnsigned32(0L);
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.basicOffsetTable == null) {
            this.writeItemTag(dicomOutputStream, 0L);
        } else {
            this.writeItemTag(dicomOutputStream, this.basicOffsetTable.length * 4);
            for (int i = 0; i < this.basicOffsetTable.length; ++i) {
                dicomOutputStream.writeUnsigned32(this.basicOffsetTable[i]);
            }
        }
        byte[] byArray = null;
        int n = 0;
        BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), false);
        long l = 0L;
        int n2 = this.frameItemByteOffsets.length;
        for (int i = 0; i < n2; ++i) {
            long[] lArray = this.frameItemByteOffsets[i];
            long[] lArray2 = this.frameItemLengths[i];
            int n3 = lArray.length;
            for (int j = 0; j < n3; ++j) {
                slf4jlogger.debug("write(): reading item {}", j);
                slf4jlogger.debug("write(): lastPosition before skipping {}", l);
                long l2 = lArray[j] - l;
                slf4jlogger.debug("write(): skipping {} before reading", l2);
                binaryInputStream.skipInsistently(l2);
                slf4jlogger.debug("write(): lastPosition after skipping and before reading {}", l += l2);
                int n4 = (int)lArray2[j];
                if (n < n4) {
                    n = n4;
                    byArray = new byte[n];
                }
                binaryInputStream.readInsistently(byArray, 0, n4);
                slf4jlogger.debug("write(): lastPosition after reading {}", l += (long)n4);
                long l3 = n4 % 2;
                long l4 = (long)n4 + l3;
                this.writeItemTag(dicomOutputStream, l4);
                dicomOutputStream.write(byArray, 0, n4);
                if (l3 <= 0L) continue;
                dicomOutputStream.write(0);
            }
        }
        this.writeSequenceDelimitationItemTag(dicomOutputStream);
    }

    @Override
    public byte[] getByteValuesForSelectedFrame(int n) throws DicomException {
        slf4jlogger.debug("getByteValuesForSelectedFrame(): lazy read of selected frame {} into heap allocated memory", n);
        byte[] byArray = null;
        int n2 = 0;
        long[] lArray = this.frameItemLengths[n];
        int n3 = lArray.length;
        slf4jlogger.debug("getByteValuesForSelectedFrame(): nItemsThisFrame = {}", n3);
        for (int i = 0; i < n3; ++i) {
            n2 = (int)((long)n2 + lArray[i]);
        }
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("getByteValuesForSelectedFrame(): framesize = 0x{} ({} dec) bytes", Integer.toHexString(n2), n2);
        }
        long[] lArray2 = this.frameItemByteOffsets[n];
        byArray = new byte[n2];
        int n4 = 0;
        long l = 0L;
        try {
            BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), false);
            for (int i = 0; i < n3; ++i) {
                slf4jlogger.debug("getByteValuesForSelectedFrame(): reading item {}", i);
                slf4jlogger.debug("getByteValuesForSelectedFrame(): lastPosition before skipping {}", l);
                long l2 = lArray2[i] - l;
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("getByteValuesForSelectedFrame(): skipping itemByteOffsetsThisFrame[] 0x{} ({} dec) bytes before reading", Long.toHexString(l2), l2);
                }
                binaryInputStream.skipInsistently(l2);
                slf4jlogger.debug("getByteValuesForSelectedFrame(): lastPosition after skipping and before reading {}", l += l2);
                int n5 = (int)lArray[i];
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("getByteValuesForSelectedFrame(): reading itemLengthsThisFrame[] 0x{} ({} dec) bytes", Integer.toHexString(n5), n5);
                }
                binaryInputStream.readInsistently(byArray, n4, n5);
                slf4jlogger.debug("getByteValuesForSelectedFrame(): lastPosition after reading {}", l += (long)n5);
                n4 += n5;
            }
            binaryInputStream.close();
        }
        catch (IOException iOException) {
            throw new DicomException("Failed to read compressed frame " + n + ", offset " + l + " dec bytes in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
        }
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("getByteValuesForSelectedFrame() frame bytes =\n{}", HexDump.dump(byArray));
        }
        return byArray;
    }

    public long[][] getFrameItemLengths() {
        return this.frameItemLengths;
    }

    @Override
    public int[] getBasicOffsetTable() {
        return this.basicOffsetTable;
    }

    @Override
    public void setBasicOffsetTable(int[] nArray) {
        this.basicOffsetTable = nArray;
    }

    public int getNumberOfFrames() {
        return this.frameItemLengths.length;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OB;
    }
}

