/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BasicOffsetTableAccessor;
import com.pixelmed.dicom.ByteFrameSource;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class OtherByteAttributeMultipleCompressedFrames
extends Attribute
implements ByteFrameSource,
BasicOffsetTableAccessor {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherByteAttributeMultipleCompressedFrames.java,v 1.23 2025/02/11 22:28:28 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(OtherByteAttributeMultipleCompressedFrames.class);
    protected byte[] allframes;
    protected byte[][] frames;
    protected File[] files;
    protected int[] basicOffsetTable = null;
    protected static final AttributeTag itemTag = TagFromName.Item;
    protected static final AttributeTag sequenceDelimitationItemTag = TagFromName.SequenceDelimitationItem;

    private OtherByteAttributeMultipleCompressedFrames(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public OtherByteAttributeMultipleCompressedFrames(AttributeTag attributeTag, byte[] byArray) {
        super(attributeTag);
        this.allframes = byArray;
        this.frames = null;
        this.files = null;
        this.valueLength = 0xFFFFFFFFL;
        this.valueMultiplicity = 1;
    }

    public OtherByteAttributeMultipleCompressedFrames(AttributeTag attributeTag, byte[][] byArray) {
        super(attributeTag);
        this.allframes = null;
        this.frames = byArray;
        this.files = null;
        this.valueLength = 0xFFFFFFFFL;
        this.valueMultiplicity = 1;
    }

    public OtherByteAttributeMultipleCompressedFrames(AttributeTag attributeTag, File[] fileArray) {
        super(attributeTag);
        this.allframes = null;
        this.frames = null;
        this.files = fileArray;
        this.valueLength = 0xFFFFFFFFL;
        this.valueMultiplicity = 1;
    }

    protected void writeItemTag(DicomOutputStream dicomOutputStream, long l) throws IOException {
        dicomOutputStream.writeUnsigned16(itemTag.getGroup());
        dicomOutputStream.writeUnsigned16(itemTag.getElement());
        dicomOutputStream.writeUnsigned32(l);
    }

    protected void writeSequenceDelimitationItemTag(DicomOutputStream dicomOutputStream) throws IOException {
        dicomOutputStream.writeUnsigned16(sequenceDelimitationItemTag.getGroup());
        dicomOutputStream.writeUnsigned16(sequenceDelimitationItemTag.getElement());
        dicomOutputStream.writeUnsigned32(0L);
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        int n;
        this.writeBase(dicomOutputStream);
        if (this.basicOffsetTable == null) {
            this.writeItemTag(dicomOutputStream, 0L);
        } else {
            this.writeItemTag(dicomOutputStream, this.basicOffsetTable.length * 4);
            for (n = 0; n < this.basicOffsetTable.length; ++n) {
                dicomOutputStream.writeUnsigned32(this.basicOffsetTable[n]);
            }
        }
        if (this.allframes != null) {
            long l = this.allframes.length;
            long l2 = l % 2L;
            long l3 = l + l2;
            this.writeItemTag(dicomOutputStream, l3);
            dicomOutputStream.write(this.allframes);
            if (l2 > 0L) {
                dicomOutputStream.write(0);
            }
        } else {
            n = 0;
            if (this.files != null) {
                n = this.files.length;
            } else if (this.frames != null) {
                n = this.frames.length;
            }
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    File file = null;
                    byte[] byArray = null;
                    long l = 0L;
                    if (this.files != null) {
                        file = this.files[i];
                        l = file.length();
                    } else {
                        byArray = this.frames[i];
                        l = byArray.length;
                    }
                    long l4 = l % 2L;
                    long l5 = l + l4;
                    this.writeItemTag(dicomOutputStream, l5);
                    if (file != null) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        CopyStream.copy(fileInputStream, dicomOutputStream);
                        ((InputStream)fileInputStream).close();
                    } else {
                        dicomOutputStream.write(byArray);
                    }
                    if (l4 <= 0L) continue;
                    dicomOutputStream.write(0);
                }
            } else {
                throw new DicomException("No source of compressed pixel data to write");
            }
        }
        this.writeSequenceDelimitationItemTag(dicomOutputStream);
    }

    public byte[][] getFrames() {
        return this.frames;
    }

    public File[] getFiles() {
        return this.files;
    }

    @Override
    public byte[] getByteValuesForSelectedFrame(int n) throws DicomException {
        byte[] byArray = null;
        if (this.frames != null) {
            byArray = this.frames[n];
        } else if (this.files != null) {
            int n2;
            slf4jlogger.debug("getByteValuesForSelectedFrame(): lazy read of selected frame {} into heap allocated memory", n);
            File file = this.files[n];
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("getByteValuesForSelectedFrame(): Reading from file() = {}", file.toString());
            }
            slf4jlogger.trace("getByteValuesForSelectedFrame(): file.length() = {}", n2);
            byArray = new byte[n2];
            int n3 = 0;
            try {
                int n4;
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                for (n2 = (int)file.length(); n2 > 0 && (n4 = ((InputStream)bufferedInputStream).read(byArray, n3, n2)) > 0; n2 -= n4) {
                    n3 += n4;
                }
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to read compressed frame " + n + ", offset " + n3 + " dec bytes in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        } else {
            throw new DicomException("Failed to read compressed frame {} - no memory or file source" + n);
        }
        return byArray;
    }

    public int getNumberOfFrames() {
        return this.frames == null ? (this.files == null ? 0 : this.files.length) : this.frames.length;
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    @Override
    public void removeValues() {
        this.frames = null;
        this.files = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OB;
    }

    @Override
    public long getLengthOfEntireEncodedAttribute(boolean bl, boolean bl2) throws DicomException {
        long l = this.getLengthOfBaseOfEncodedAttribute(bl, bl2);
        l += (long)(this.basicOffsetTable == null ? 8 : this.basicOffsetTable.length * 4 + 8);
        if (this.allframes != null) {
            l += 8L;
            long l2 = this.allframes.length;
            long l3 = l2 % 2L;
            long l4 = l2 + l3;
            l += l4;
        } else {
            int n;
            int n2 = n = this.files != null ? this.files.length : this.frames.length;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    l += 8L;
                    long l5 = this.files != null ? this.files[i].length() : (long)this.frames[i].length;
                    long l6 = l5 % 2L;
                    long l7 = l5 + l6;
                    l += l7;
                }
            }
        }
        return l += 8L;
    }

    @Override
    public int[] getBasicOffsetTable() {
        return this.basicOffsetTable;
    }

    @Override
    public void setBasicOffsetTable(int[] nArray) {
        this.basicOffsetTable = nArray;
    }
}

