/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class OtherLongAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherLongAttribute.java,v 1.11 2025/01/29 10:58:07 dclunie Exp $";
    private int[] values;

    public OtherLongAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public OtherLongAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public OtherLongAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.values = null;
        this.valueLength = l;
        if (l > 0L) {
            int n = (int)(l / 4L);
            int[] nArray = new int[n];
            dicomInputStream.readUnsigned32(nArray, n);
            this.setValues(nArray);
        }
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.values != null && this.values.length > 0) {
            dicomOutputStream.writeUnsigned32(this.values, this.values.length);
            if (this.getVL() != (long)(this.values.length * 4)) {
                throw new DicomException("Internal error - int array length (" + this.values.length * 4 + ") not equal to expected VL(" + this.getVL() + ")");
            }
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    @Override
    public void setValues(int[] nArray) throws DicomException {
        this.values = nArray;
        this.valueMultiplicity = 1;
        this.valueLength = nArray.length * 4;
    }

    @Override
    public void setValues(byte[] byArray, boolean bl) throws DicomException {
        int n = byArray.length / 4;
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = byArray[n2++] & 0xFF;
            int n4 = byArray[n2++] & 0xFF;
            int n5 = byArray[n2++] & 0xFF;
            int n6 = byArray[n2++] & 0xFF;
            nArray[i] = bl ? ((n3 << 8 | n4) << 8 | n5) << 8 | n6 : ((n6 << 8 | n5) << 8 | n4) << 8 | n3;
        }
        this.setValues(nArray);
    }

    @Override
    public void removeValues() {
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    @Override
    public int[] getIntegerValues() throws DicomException {
        return this.values;
    }

    @Override
    public byte[] getByteValues(boolean bl) throws DicomException {
        byte[] byArray;
        block4: {
            byArray = null;
            if (this.values == null) break block4;
            int n = this.values.length;
            byArray = new byte[n * 4];
            int n2 = 0;
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    int n3 = this.values[i];
                    byArray[n2++] = (byte)(n3 >> 24);
                    byArray[n2++] = (byte)(n3 >> 16);
                    byArray[n2++] = (byte)(n3 >> 8);
                    byArray[n2++] = (byte)n3;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int n4 = this.values[i];
                    byArray[n2++] = (byte)n4;
                    byArray[n2++] = (byte)(n4 >> 8);
                    byArray[n2++] = (byte)(n4 >> 16);
                    byArray[n2++] = (byte)(n4 >> 24);
                }
            }
        }
        return byArray;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OL;
    }
}

