/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.FileReaper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class OtherWordAttributeMultipleFilesOnDisk
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherWordAttributeMultipleFilesOnDisk.java,v 1.9 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(OtherWordAttributeMultipleFilesOnDisk.class);
    protected File[] files;
    protected long[] byteOffsets;
    protected long[] lengths;
    protected boolean deleteFilesWhenNoLongerNeeded;
    protected boolean bigEndian;

    public OtherWordAttributeMultipleFilesOnDisk(AttributeTag attributeTag, boolean bl) {
        super(attributeTag);
        this.bigEndian = bl;
    }

    public OtherWordAttributeMultipleFilesOnDisk(AttributeTag attributeTag, File[] fileArray, long[] lArray, long[] lArray2, boolean bl) throws IOException, DicomException {
        this(attributeTag, bl);
        this.setFiles(fileArray, lArray, lArray2);
    }

    public OtherWordAttributeMultipleFilesOnDisk(AttributeTag attributeTag, String[] stringArray, long[] lArray, long[] lArray2, boolean bl) throws IOException, DicomException {
        this(attributeTag, bl);
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        this.setFiles(fileArray, lArray, lArray2);
    }

    public OtherWordAttributeMultipleFilesOnDisk(AttributeTag attributeTag, File[] fileArray, boolean bl) throws IOException, DicomException {
        this(attributeTag, fileArray, null, null, bl);
    }

    public OtherWordAttributeMultipleFilesOnDisk(AttributeTag attributeTag, String[] stringArray, boolean bl) throws IOException, DicomException {
        this(attributeTag, stringArray, null, null, bl);
    }

    public File[] getFiles() {
        return this.files;
    }

    public long[] getByteOffsets() {
        return this.byteOffsets;
    }

    public long[] getLengths() {
        return this.lengths;
    }

    public void setFiles(File[] fileArray, long[] lArray, long[] lArray2) throws IOException {
        this.files = fileArray;
        this.byteOffsets = lArray == null ? new long[fileArray.length] : lArray;
        this.lengths = lArray2 == null ? new long[fileArray.length] : lArray2;
        this.valueLength = 0L;
        for (int i = 0; i < fileArray.length; ++i) {
            long l = 0L;
            if (lArray2 == null) {
                l = fileArray[i].length();
                if (lArray != null) {
                    l -= lArray[i];
                }
                this.lengths[i] = l;
            } else {
                l = lArray2[i];
            }
            this.valueLength += l;
        }
    }

    @Override
    public long getPaddedVL() {
        long l = this.getVL();
        if (l % 2L != 0L) {
            ++l;
        }
        return l;
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.valueLength > 0L) {
            for (int i = 0; i < this.files.length; ++i) {
                File file = this.files[i];
                long l = this.byteOffsets[i];
                long l2 = this.lengths[i];
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                CopyStream.skipInsistently(bufferedInputStream, l);
                CopyStream.copy(bufferedInputStream, dicomOutputStream, l2);
                bufferedInputStream.close();
            }
            long l = this.getPaddedVL() - this.valueLength;
            while (l-- > 0L) {
                dicomOutputStream.write(0);
            }
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    @Override
    public short[] getShortValues() throws DicomException {
        short[] sArray = null;
        if (this.valueLength > 0L) {
            sArray = new short[(int)(this.valueLength / 2L)];
            try {
                int n = 0;
                for (int i = 0; i < this.files.length; ++i) {
                    File file = this.files[i];
                    BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(file), this.bigEndian);
                    binaryInputStream.skipInsistently(this.byteOffsets[i]);
                    int n2 = (int)(this.lengths[i] / 2L);
                    binaryInputStream.readUnsigned16(sArray, n, n2);
                    binaryInputStream.close();
                    n += n2;
                }
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
                throw new DicomException("Failed to read value (length " + this.valueLength + " dec) in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        }
        return sArray;
    }

    public short[][] getShortValuesPerFrame() throws DicomException {
        short[][] sArrayArray = new short[this.files.length][];
        for (int i = 0; i < this.files.length; ++i) {
            File file = this.files[i];
            try {
                BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(file), this.bigEndian);
                binaryInputStream.skipInsistently(this.byteOffsets[i]);
                int n = (int)(this.lengths[i] / 2L);
                binaryInputStream.readUnsigned16(sArrayArray[i], 0, n);
                continue;
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
                throw new DicomException("Failed to read value (length " + this.valueLength + " dec) in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        }
        return sArrayArray;
    }

    @Override
    public void removeValues() {
        this.files = null;
        this.byteOffsets = null;
        this.lengths = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public void deleteFilesWhenNoLongerNeeded() {
        this.deleteFilesWhenNoLongerNeeded = true;
    }

    protected void finalize() throws Throwable {
        if (this.deleteFilesWhenNoLongerNeeded && this.files != null) {
            for (int i = 0; i < this.files.length; ++i) {
                File file = this.files[i];
                if (file != null && !file.delete()) {
                    FileReaper.addFileToDelete(file.getCanonicalPath());
                }
                this.files[i] = null;
            }
            this.files = null;
        }
        super.finalize();
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OW;
    }
}

