/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.PhoneticStringEncoder;
import com.pixelmed.utils.PhoneticStringEncoderException;
import com.pixelmed.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class PersonNameAttribute
extends StringAttributeAffectedBySpecificCharacterSet {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/PersonNameAttribute.java,v 1.33 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(PersonNameAttribute.class);
    protected static final int MAX_LENGTH_SINGLE_VALUE = 194;

    @Override
    public final int getMaximumLengthOfSingleValue() {
        return 194;
    }

    public PersonNameAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public PersonNameAttribute(AttributeTag attributeTag, SpecificCharacterSet specificCharacterSet) {
        super(attributeTag, specificCharacterSet);
    }

    public PersonNameAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream, specificCharacterSet);
    }

    public PersonNameAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream, SpecificCharacterSet specificCharacterSet) throws IOException, DicomException {
        super(attributeTag, (long)l, dicomInputStream, specificCharacterSet);
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.PN;
    }

    public static String getCanonicalForm(String string) {
        return PersonNameAttribute.getCanonicalForm(string, false);
    }

    public static String getCanonicalForm(String string, boolean bl) {
        String string2 = null;
        if (string != null) {
            int n;
            char[] cArray = string.toCharArray();
            int n2 = cArray.length;
            int n3 = 0;
            boolean bl2 = true;
            for (n = n3; n < n2; ++n) {
                char c = cArray[n];
                if (Character.isLetter(c)) {
                    cArray[n] = bl2 ? Character.toUpperCase(c) : Character.toLowerCase(c);
                    bl2 = false;
                    continue;
                }
                if (c != '*' && c != '?') {
                    bl2 = true;
                }
                if (Character.isDigit(c) || c == '^' || c == ',' || c == '*' || c == '?') continue;
                cArray[n] = 32;
            }
            while (n3 < n2 && Character.isWhitespace(cArray[n3])) {
                ++n3;
            }
            while (n2 > n3 && (Character.isWhitespace((char)(n = cArray[n2 - 1])) || n == 94 || n == 44)) {
                --n2;
            }
            if (n3 < n2) {
                Object object;
                string2 = new String(cArray, n3, n2 - n3);
                String string3 = null;
                String string4 = null;
                if (string2.indexOf("^") != -1) {
                    object = StringUtilities.getDelimitedValues(string2, "^");
                    if (((Vector)object).size() > 0) {
                        string3 = (String)((Vector)object).get(0);
                        if (((Vector)object).size() > 1) {
                            string4 = (String)((Vector)object).get(1);
                        }
                    }
                } else if (string2.indexOf(",") != -1) {
                    object = StringUtilities.getDelimitedValues(string2, ",");
                    if (((Vector)object).size() > 0) {
                        string3 = (String)((Vector)object).get(0);
                        if (((Vector)object).size() > 1) {
                            string4 = (String)((Vector)object).get(1);
                        }
                    }
                } else {
                    object = StringUtilities.getDelimitedValues(string2, " ");
                    if (((Vector)object).size() > 0) {
                        string3 = (String)((Vector)object).get(((Vector)object).size() - 1);
                        if (((Vector)object).size() > 1) {
                            string4 = (String)((Vector)object).get(0);
                        }
                    }
                }
                if (string3 != null) {
                    object = new StringTokenizer(string3, " ", false);
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        string3 = ((StringTokenizer)object).nextToken();
                    }
                } else {
                    String string5 = string3 = bl ? "*" : "";
                }
                if (string4 != null) {
                    object = new StringTokenizer(string4, " ", false);
                    if (((StringTokenizer)object).hasMoreTokens()) {
                        string4 = ((StringTokenizer)object).nextToken();
                    }
                } else {
                    string4 = bl ? "*" : "";
                }
                string2 = string3 + "^" + string4;
            }
        }
        return string2;
    }

    private static String encodePartsSplitByWildcardOperator(String string, PhoneticStringEncoder phoneticStringEncoder) throws PhoneticStringEncoderException {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() > 0) {
            char[] cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                if (c != '*' && c != '?') continue;
                if (n2 < i) {
                    stringBuffer.append(phoneticStringEncoder.encode(string.substring(n2, i)));
                }
                stringBuffer.append(c);
                n2 = i + 1;
            }
            if (n2 < n) {
                stringBuffer.append(phoneticStringEncoder.encode(string.substring(n2, n)));
            }
        }
        return stringBuffer.toString();
    }

    private static String encodeString(String string, PhoneticStringEncoder phoneticStringEncoder, boolean bl) throws PhoneticStringEncoderException {
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = bl ? PersonNameAttribute.encodePartsSplitByWildcardOperator(string, phoneticStringEncoder) : phoneticStringEncoder.encode(string);
        }
        return string2;
    }

    public static Vector<String> getNameComponentGroups(String string) {
        return StringUtilities.getDelimitedValues(string, "=");
    }

    public static Vector<String> getNameComponents(String string) {
        return StringUtilities.getDelimitedValues(string, "^");
    }

    public static String swap(String string) {
        Vector<String> vector = PersonNameAttribute.getNameComponents(string);
        return vector.size() == 2 ? vector.get(1) + "^" + vector.get(0) : string;
    }

    public static String getPhoneticName(String string) {
        return PersonNameAttribute.getPhoneticName(string, false);
    }

    public static String getPhoneticName(String string, boolean bl) {
        String string2 = null;
        if (string != null) {
            Vector<String> vector = PersonNameAttribute.getNameComponents(string);
            String string3 = vector.size() > 0 ? vector.get(0) : "";
            String string4 = vector.size() > 1 ? vector.get(1) : "";
            try {
                PhoneticStringEncoder phoneticStringEncoder = new PhoneticStringEncoder();
                String string5 = PersonNameAttribute.encodeString(string3, phoneticStringEncoder, bl);
                String string6 = PersonNameAttribute.encodeString(string4, phoneticStringEncoder, bl);
                string2 = string5 + "^" + string6;
            }
            catch (PhoneticStringEncoderException phoneticStringEncoderException) {
                slf4jlogger.error("", phoneticStringEncoderException);
                string2 = string;
            }
        }
        return string2;
    }

    private static void processFileOrDirectory(File file) {
        if (file.isDirectory()) {
            try {
                boolean bl = true;
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    if (fileArray[i].isDirectory()) {
                        PersonNameAttribute.processFileOrDirectory(fileArray[i]);
                        continue;
                    }
                    if (!fileArray[i].isFile() || file.isHidden() || !bl) continue;
                    PersonNameAttribute.processFileOrDirectory(fileArray[i]);
                    bl = false;
                }
            }
            catch (Exception exception) {}
        } else if (file.isFile() && !file.isHidden()) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(file)));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PatientName);
                if (string != null) {
                    String string2 = PersonNameAttribute.getCanonicalForm(string);
                    String string3 = PersonNameAttribute.getPhoneticName(string2);
                    System.out.println(string + "\t" + string2 + "\t" + string3);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            PersonNameAttribute.processFileOrDirectory(new File(stringArray[i]));
        }
    }
}

