/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

public class SpatialCoordinateAndImageReference {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SpatialCoordinateAndImageReference.java,v 1.21 2025/01/29 10:58:07 dclunie Exp $";
    public static final int RenderingRequired = 0;
    public static final int RenderingOptional = 1;
    public static final int RenderingForbidden = 2;
    private int renderingIntent;
    public static final int CoordinateCategoryUnspecified = 0;
    public static final int CoordinateCategoryMammoIndividualCalcification = 1;
    public static final int CoordinateCategoryMammoCalcificationCluster = 2;
    public static final int CoordinateCategoryMammoBreastDensity = 3;
    private int coordinateCategory;
    private String sopInstanceUID;
    private String sopClassUID;
    private String graphicType;
    private float[] graphicData;
    private String annotation;
    private boolean imageLibraryEntry;

    public SpatialCoordinateAndImageReference(String string, String string2, String string3, float[] fArray, String string4, int n, int n2, boolean bl) {
        this.sopInstanceUID = string;
        this.sopClassUID = string2;
        this.graphicType = string3;
        this.graphicData = fArray;
        this.annotation = string4;
        this.renderingIntent = n;
        this.coordinateCategory = n2;
        this.imageLibraryEntry = bl;
    }

    public SpatialCoordinateAndImageReference(String string, String string2, String string3, float[] fArray, String string4, int n, int n2) {
        this(string, string2, string3, fArray, string4, n, n2, false);
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    public String getGraphicType() {
        return this.graphicType;
    }

    public float[] getGraphicData() {
        return this.graphicData;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public int getRenderingIntent() {
        return this.renderingIntent;
    }

    public boolean getImageLibraryEntry() {
        return this.imageLibraryEntry;
    }

    private String getRenderingIntentAsString() {
        String string = "rendering";
        if (this.renderingIntent == 0) {
            string = string + " required";
        } else if (this.renderingIntent == 1) {
            string = string + " optional";
        } else if (this.renderingIntent == 2) {
            string = string + " forbidden";
        }
        return string;
    }

    public int getCoordinateCategory() {
        return this.coordinateCategory;
    }

    private String getCoordinateCategoryAsString() {
        String string = "category";
        if (this.coordinateCategory == 0) {
            string = string + " unspecified";
        } else if (this.coordinateCategory == 1) {
            string = string + " individual calcification";
        } else if (this.coordinateCategory == 2) {
            string = string + " calcification cluster";
        } else if (this.coordinateCategory == 3) {
            string = string + " breast density";
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.sopInstanceUID);
        stringBuffer.append(":");
        stringBuffer.append(this.sopClassUID);
        stringBuffer.append(" = ");
        stringBuffer.append(this.graphicType);
        if (this.imageLibraryEntry) {
            stringBuffer.append(" [Image Library]");
        }
        stringBuffer.append(" [");
        stringBuffer.append(this.getRenderingIntentAsString());
        stringBuffer.append(",");
        stringBuffer.append(this.getCoordinateCategoryAsString());
        stringBuffer.append("] (");
        if (this.graphicData != null) {
            for (int i = 0; i < this.graphicData.length; ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.graphicData[i]);
            }
        }
        stringBuffer.append(") ");
        stringBuffer.append(this.annotation);
        return stringBuffer.toString();
    }
}

