/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.StoredFilePathStrategyComponentFolders;
import com.pixelmed.dicom.StoredFilePathStrategyHashSubFolders;
import com.pixelmed.dicom.StoredFilePathStrategySingleFolder;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;

public abstract class StoredFilePathStrategy {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/StoredFilePathStrategy.java,v 1.13 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(StoredFilePathStrategy.class);
    public static final StoredFilePathStrategy BYSOPINSTANCEUIDINSINGLEFOLDER = new StoredFilePathStrategySingleFolder();
    public static final StoredFilePathStrategy BYSOPINSTANCEUIDCOMPONENTFOLDERS = new StoredFilePathStrategyComponentFolders();
    public static final StoredFilePathStrategy BYSOPINSTANCEUIDHASHSUBFOLDERS = new StoredFilePathStrategyHashSubFolders();
    protected static String defaultAlternativeSubfolder = "ALTERNATIVE";

    protected StoredFilePathStrategy() {
    }

    public static final StoredFilePathStrategy getDefaultStrategy() {
        return BYSOPINSTANCEUIDINSINGLEFOLDER;
    }

    public String makeStoredFilePath(String string) {
        return null;
    }

    public File makeStoredFilePath(File file, String string) {
        return new File(file, this.makeStoredFilePath(string));
    }

    public File makeAlternativeStoredFilePath(File file, String string, String string2) {
        return BYSOPINSTANCEUIDINSINGLEFOLDER.makeStoredFilePath(new File(file, string), string2);
    }

    public File makeReliableStoredFilePathWithFoldersCreated(File file, String string, String string2) {
        File file2;
        File file3 = this.makeStoredFilePath(file, string2);
        if (file3.exists()) {
            if (file3.isFile()) {
                slf4jlogger.debug("makeReliableStoredFilePathWithFoldersCreated(): Deleting pre-existing file for same SOPInstanceUID");
                file3.delete();
            } else {
                slf4jlogger.debug("makeReliableStoredFilePathWithFoldersCreated(): use an alternative file name, since {} already used as other than a file (presumably a directory)", file3);
                file3 = this.makeAlternativeStoredFilePath(file, string, string2);
            }
        }
        if ((file2 = file3.getParentFile()) != null) {
            if (file2.exists()) {
                if (!file2.isDirectory()) {
                    slf4jlogger.debug("makeReliableStoredFilePathWithFoldersCreated(): use an alternative file name, since {} already used as a something other than a directory (presumably a file)", file3);
                    file3 = this.makeAlternativeStoredFilePath(file, string, string2);
                }
            } else {
                file2.mkdirs();
                if (!file2.isDirectory()) {
                    slf4jlogger.debug("makeReliableStoredFilePathWithFoldersCreated(): use an alternative file name, since cannot make parent directories {} for some (unanticipated) reason", file2);
                    file3 = this.makeAlternativeStoredFilePath(file, string, string2);
                    file2 = file3.getParentFile();
                    if (file2 != null) {
                        file2.mkdirs();
                    }
                }
            }
        }
        return file3;
    }

    public File makeReliableStoredFilePathWithFoldersCreated(File file, String string) {
        return this.makeReliableStoredFilePathWithFoldersCreated(file, defaultAlternativeSubfolder, string);
    }

    public void setDebugLevel(int n) {
        slf4jlogger.warn("setDebugLevel(): Debug level ignored");
    }

    protected void test(String[] stringArray) {
        System.err.println(this);
        String[] stringArray2 = new String[]{"1.2.3.4.5", "123.456.789", "123", "123.456", "5", ".1..2...3..."};
        if (stringArray.length != 0) {
            stringArray2 = stringArray;
        }
        File file = new File("savedInstancesHome");
        for (int i = 0; i < stringArray2.length; ++i) {
            System.err.println("uid: " + stringArray2[i] + "   file path: " + this.makeStoredFilePath(file, stringArray2[i]));
        }
    }
}

