/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class UniqueIdentifierAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/UniqueIdentifierAttribute.java,v 1.30 2025/01/29 10:58:07 dclunie Exp $";
    protected static final int MAX_LENGTH_SINGLE_VALUE = 64;

    @Override
    public final int getMaximumLengthOfSingleValue() {
        return 64;
    }

    public UniqueIdentifierAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public UniqueIdentifierAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public UniqueIdentifierAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, (long)l, dicomInputStream);
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.UI;
    }

    @Override
    protected byte getPadByte() {
        return 0;
    }

    public static boolean isSOPClassRelated(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.SOPClassUID) || attributeTag.equals(TagFromName.AffectedSOPClassUID) || attributeTag.equals(TagFromName.MediaStorageSOPClassUID) || attributeTag.equals(TagFromName.OriginalSpecializedSOPClassUID) || attributeTag.equals(TagFromName.ReferencedRelatedGeneralSOPClassUIDInFile) || attributeTag.equals(TagFromName.ReferencedSOPClassUID) || attributeTag.equals(TagFromName.ReferencedSOPClassUIDInFile) || attributeTag.equals(TagFromName.RelatedGeneralSOPClassUID) || attributeTag.equals(TagFromName.RequestedSOPClassUID) || attributeTag.equals(TagFromName.RelatedGeneralSOPClassUID) || attributeTag.equals(TagFromName.SOPClassesInStudy) || attributeTag.equals(TagFromName.SOPClassesSupported);
    }

    public static boolean isTransferSyntaxRelated(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.TransferSyntaxUID) || attributeTag.equals(TagFromName.EncryptedContentTransferSyntaxUID) || attributeTag.equals(TagFromName.MACCalculationTransferSyntaxUID) || attributeTag.equals(TagFromName.ReferencedTransferSyntaxUIDInFile);
    }

    public static boolean isWellKnownRelated(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.EquipmentFrameOfReferenceUID);
    }

    public static boolean isCodingSchemeRelated(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.CodingSchemeUID) || attributeTag.equals(TagFromName.ContextGroupExtensionCreatorUID);
    }

    public static boolean isPrivateRelated(AttributeTag attributeTag) {
        return attributeTag.equals(TagFromName.PrivateInformationCreatorUID) || attributeTag.equals(TagFromName.PrivateRecordUID) || attributeTag.equals(TagFromName.CreatorVersionUID);
    }

    public static boolean isTransient(AttributeTag attributeTag) {
        return !UniqueIdentifierAttribute.isSOPClassRelated(attributeTag) && !UniqueIdentifierAttribute.isTransferSyntaxRelated(attributeTag) && !UniqueIdentifierAttribute.isWellKnownRelated(attributeTag) && !UniqueIdentifierAttribute.isCodingSchemeRelated(attributeTag) && !UniqueIdentifierAttribute.isPrivateRelated(attributeTag);
    }

    public static boolean isPrivateNonTransient(AttributeTag attributeTag, AttributeList attributeList) {
        boolean bl = false;
        if (attributeTag.isPrivate()) {
            String string = attributeList.getPrivateCreatorString(attributeTag);
            int n = attributeTag.getGroup();
            int n2 = attributeTag.getElement();
            int n3 = n2 & 0xFF;
            if (n == 32721 && string.equals("SIEMENS SYNGO ULTRA-SOUND TOYON DATA STREAMING")) {
                if (n3 == 9) {
                    bl = true;
                }
            } else if (n == 153 && string.equals("NQHeader") && n3 == 1) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isTransient(AttributeTag attributeTag, AttributeList attributeList) {
        return UniqueIdentifierAttribute.isTransient(attributeTag) && !UniqueIdentifierAttribute.isPrivateNonTransient(attributeTag, attributeList);
    }

    @Override
    public final boolean isCharacterInValueValid(int n) throws DicomException {
        return n < 127 && (Character.isDigit(n) || n == 46);
    }

    @Override
    public boolean repairValues() throws DicomException {
        if (!this.isValid()) {
            this.flushCachedCopies();
            this.originalByteValues = null;
            if (this.originalValues != null && this.originalValues.length > 0) {
                for (int i = 0; i < this.originalValues.length; ++i) {
                    String string = this.originalValues[i];
                    if (string == null || string.length() <= 0) continue;
                    this.originalValues[i] = string.trim();
                }
            }
        }
        return this.isValid();
    }
}

