/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.SpatialCoordinateAndImageReference;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.DisplayDicomDirectoryBrowser;
import com.pixelmed.display.DisplayStructuredReportBrowser;
import com.pixelmed.display.DrawingUtilities;
import com.pixelmed.display.SafeFileChooser;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.TextAnnotation;
import com.pixelmed.geometry.LocalizerPosterFactory;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class DicomBrowser
extends ApplicationFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DicomBrowser.java,v 1.44 2025/01/29 18:40:30 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DicomBrowser.class);

    public DicomBrowser() {
        super(2);
    }

    public DicomBrowser(String string) {
        super(string, null, 2);
    }

    public DicomBrowser(int n) {
        super(n);
    }

    public DicomBrowser(String string, int n) {
        super(string, null, n);
    }

    public static void loadAndDisplayImagesFromDicomFiles(Vector vector, Map map, int n, int n2) {
        DicomBrowser.loadAndDisplayImagesFromSOPInstances(vector, null, map, n, n2);
    }

    public static void loadAndDisplayImagesFromSOPInstances(Vector vector, Map map, int n, int n2) {
        Vector<String> vector2 = new Vector<String>();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            SpatialCoordinateAndImageReference spatialCoordinateAndImageReference = (SpatialCoordinateAndImageReference)iterator.next();
            slf4jlogger.debug("reference: {}", spatialCoordinateAndImageReference);
            boolean bl = spatialCoordinateAndImageReference.getImageLibraryEntry();
            slf4jlogger.debug("imageLibraryEntry: {}", bl);
            String string = spatialCoordinateAndImageReference.getSOPInstanceUID();
            slf4jlogger.debug("uid: {}", string);
            String string2 = (String)map.get(string);
            slf4jlogger.debug("path: {}", string2);
            if (string2 == null || bl) {
                iterator.remove();
                continue;
            }
            vector2.add(string2);
        }
        DicomBrowser.loadAndDisplayImagesFromSOPInstances(vector2, vector, map, n, n2);
    }

    public static void loadAndDisplayImagesFromSOPInstances(Vector vector, Vector vector2, Map map, int n, int n2) {
        SingleImagePanel[] singleImagePanelArray;
        Object object;
        Serializable serializable;
        Iterator iterator;
        slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances");
        SourceImage[] sourceImageArray = new SourceImage[vector.size()];
        SpatialCoordinateAndImageReference[] spatialCoordinateAndImageReferenceArray = vector2 == null ? null : new SpatialCoordinateAndImageReference[vector.size()];
        int n3 = 0;
        int n4 = 0;
        String string = null;
        int n5 = 0;
        Iterator iterator2 = vector.iterator();
        Iterator iterator3 = iterator = vector2 == null ? null : vector2.iterator();
        while (iterator2.hasNext()) {
            String string2 = (String)iterator2.next();
            slf4jlogger.debug("{}", string2);
            try {
                DicomInputStream dicomInputStream = null;
                try {
                    dicomInputStream = new DicomInputStream(new FileInputStream(string2));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    dicomInputStream = new DicomInputStream(new FileInputStream(string2.toLowerCase(Locale.US)));
                }
                serializable = new AttributeList();
                ((AttributeList)serializable).read(dicomInputStream);
                dicomInputStream.close();
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("{}", ((AttributeList)serializable).toString());
                }
                if (((AttributeList)serializable).isImage()) {
                    if (vector2 != null) {
                        slf4jlogger.debug("coords[{}] was {}", n5, spatialCoordinateAndImageReferenceArray[n5]);
                        spatialCoordinateAndImageReferenceArray[n5] = (SpatialCoordinateAndImageReference)iterator.next();
                        slf4jlogger.debug("coords[{}] now {}", n5, spatialCoordinateAndImageReferenceArray[n5]);
                    }
                    object = new SourceImage((AttributeList)serializable);
                    singleImagePanelArray = ((SourceImage)object).getBufferedImage();
                    if (((SourceImage)object).getWidth() > n3) {
                        n3 = ((SourceImage)object).getWidth();
                    }
                    if (((SourceImage)object).getHeight() > n4) {
                        n4 = ((SourceImage)object).getHeight();
                    }
                    if (string == null) {
                        string = ((SourceImage)object).getTitle();
                    }
                    sourceImageArray[n5++] = object;
                    continue;
                }
                if (((AttributeList)serializable).isSRDocument()) {
                    if (string == null) {
                        string = ((AttributeList)serializable).buildInstanceTitleFromAttributeList();
                    }
                    object = new DisplayStructuredReportBrowser((AttributeList)serializable, map, n, n2, string);
                    ((Window)object).setVisible(true);
                    continue;
                }
                slf4jlogger.error("Unsupported SOP instance type in file {} ({}, {})", string2, Attribute.getSingleStringValueOrEmptyString((AttributeList)serializable, TagFromName.Modality), Attribute.getSingleStringValueOrEmptyString((AttributeList)serializable, TagFromName.SOPClassUID));
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
        if (n5 > 0) {
            int n6;
            Object object2;
            int n7;
            int n8 = n7 = n3 > n ? 1 : n / n3;
            if (n7 > n5) {
                n7 = n5;
            }
            int n9 = (n5 - 1) / n7 + 1;
            slf4jlogger.debug("widthMax: {}", n3);
            slf4jlogger.debug("heightMax: {}", n4);
            slf4jlogger.debug("imgCount: {}", n5);
            slf4jlogger.debug("imagesPerRow: {}", n7);
            slf4jlogger.debug("imagesPerCol: {}", n9);
            serializable = new DicomBrowser(string == null ? "Untitled" : string);
            object = new JPanel();
            ((Container)object).setLayout(new GridLayout(n9, n7));
            ((JComponent)object).setBackground(Color.black);
            singleImagePanelArray = new SingleImagePanel[n7 * n9];
            for (int i = 0; i < n5; ++i) {
                Object object3;
                object2 = sourceImageArray[i];
                Vector<Shape> vector3 = null;
                Vector<TextAnnotation> vector4 = null;
                if (spatialCoordinateAndImageReferenceArray != null) {
                    slf4jlogger.debug("[{}] = {}", i, spatialCoordinateAndImageReferenceArray[i]);
                    object3 = spatialCoordinateAndImageReferenceArray[i];
                    if (object3 != null) {
                        String string3 = ((SpatialCoordinateAndImageReference)object3).getGraphicType();
                        float[] fArray = ((SpatialCoordinateAndImageReference)object3).getGraphicData();
                        if (string3 != null && fArray != null) {
                            int n10;
                            int n11;
                            int n12;
                            int n13;
                            slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): initializing new vectors of preDefinedShapes and preDefinedText");
                            vector3 = new Vector<Shape>();
                            vector4 = new Vector<TextAnnotation>();
                            if (string3.equals("POINT") && fArray.length == 2) {
                                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding POINT");
                                n13 = (int)fArray[0];
                                n12 = (int)fArray[1];
                                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding POINT at ({},{})", n13, n12);
                                DrawingUtilities.addDiagonalCross(vector3, n13, n12, 2, 1);
                                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding POINT text: {}", ((SpatialCoordinateAndImageReference)object3).getAnnotation());
                                vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), n13 + 10, n12 + -10));
                            } else if (string3.equals("MULTIPOINT") && fArray.length % 2 == 0) {
                                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding MULTIPOINT");
                                for (n13 = 0; n13 < fArray.length; n13 += 2) {
                                    slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding MULTIPOINT point at ({},{})", Float.valueOf(fArray[n13]), Float.valueOf(fArray[n13 + 1]));
                                    DrawingUtilities.addDiagonalCross(vector3, (int)fArray[n13], (int)fArray[n13 + 1], 2, 1);
                                }
                                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding MULTIPOINT text: {}", ((SpatialCoordinateAndImageReference)object3).getAnnotation());
                                vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), (int)fArray[0] + 10, (int)fArray[1] + -10));
                            } else if (string3.equals("POLYLINE") && fArray.length == 4) {
                                int n14;
                                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding POLYLINE with two points");
                                n13 = (int)fArray[0];
                                n12 = (int)fArray[1];
                                n11 = (int)fArray[2];
                                n10 = (int)fArray[3];
                                vector3.add(new Line2D.Float(new Point(n13, n12), new Point(n11, n10)));
                                DrawingUtilities.addDiagonalCross(vector3, n13, n12, 2, 1);
                                DrawingUtilities.addDiagonalCross(vector3, n11, n10, 2, 1);
                                boolean bl = true;
                                boolean bl2 = true;
                                int n15 = bl ? (n13 < n11 ? n13 : n11) : (n14 = n13 > n11 ? n13 : n11);
                                int n16 = bl2 ? (n12 < n10 ? n12 : n10) : (n12 > n10 ? n12 : n10);
                                vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), n14 + 10, n16 + -10));
                            } else if (string3.equals("POLYLINE") && fArray.length > 4) {
                                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding POLYLINE with more than two points");
                                n13 = (int)fArray[0];
                                n12 = (int)fArray[1];
                                n11 = 2;
                                while (n11 + 1 < fArray.length) {
                                    n10 = (int)fArray[n11];
                                    int n17 = (int)fArray[n11 + 1];
                                    vector3.add(new Line2D.Float(new Point(n13, n12), new Point(n10, n17)));
                                    n13 = n10;
                                    n12 = n17;
                                    n11 += 2;
                                }
                                vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), n13 + 10, n12 + -10));
                            } else if (string3.equals("ELLIPSE") && fArray.length == 8) {
                                int n18;
                                int n19;
                                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding ELLIPSE");
                                n13 = (int)fArray[0];
                                n12 = (int)fArray[1];
                                n11 = (int)fArray[2];
                                n10 = (int)fArray[3];
                                int n20 = (int)fArray[4];
                                int n21 = (int)fArray[5];
                                int n22 = (int)fArray[6];
                                int n23 = (int)fArray[7];
                                if (n12 == n10 && n20 == n22) {
                                    slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): have an ellipse with major axis along x axis without rotation");
                                    int n24 = n13;
                                    int n25 = n21;
                                    n19 = n11 - n13;
                                    n18 = n23 - n21;
                                    slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding ellipse ({},{},{},{})", n24, n25, n19, n18);
                                    if (n19 < 0) {
                                        n19 = -n19;
                                        n24 -= n19;
                                        slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): width was negative so making positive and changing top left start");
                                    }
                                    if (n18 < 0) {
                                        n18 = -n18;
                                        n25 -= n18;
                                        slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): height was negative so making positive and changing top left start");
                                    }
                                    slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding Ellipse2D.Float({},{},{},{})", n24, n25, n19, n18);
                                    vector3.add(new Ellipse2D.Float(n24, n25, n19, n18));
                                    vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), n24 + 10, n25 + -10));
                                } else if (n13 == n11 && n21 == n23) {
                                    slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): have an ellipse with major axis along y axis without rotation");
                                    int n26 = n20;
                                    int n27 = n12;
                                    n19 = n22 - n20;
                                    n18 = n10 - n12;
                                    slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding ellipse ({},{},{},{})", n26, n27, n19, n18);
                                    if (n19 < 0) {
                                        n19 = -n19;
                                        n26 -= n19;
                                        slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): width was negative so making positive and changing top left start");
                                    }
                                    if (n18 < 0) {
                                        n18 = -n18;
                                        n27 -= n18;
                                        slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): height was negative so making positive and changing top left start");
                                    }
                                    slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding Ellipse2D.Float({},{},{},{})", n26, n27, n19, n18);
                                    vector3.add(new Ellipse2D.Float(n26, n27, n19, n18));
                                    vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), n26 + 10, n27 + -10));
                                } else {
                                    slf4jlogger.info("loadAndDisplayImagesFromSOPInstances(): NOT adding ELLIPSE that is not parallel to row");
                                }
                            } else if (string3.equals("CIRCLE") && fArray.length == 4) {
                                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): adding CIRCLE");
                                n13 = (int)fArray[0];
                                n12 = (int)fArray[1];
                                n11 = (int)fArray[2];
                                n10 = (int)fArray[3];
                                float f = n13 - n11;
                                float f2 = n12 - n10;
                                float f3 = (float)Math.sqrt(f * f + f2 * f2);
                                float f4 = (float)n13 - f3;
                                float f5 = (float)n12 - f3;
                                float f6 = 2.0f * f3;
                                vector3.add(new Ellipse2D.Float(f4, f5, f6, f6));
                                vector4.add(new TextAnnotation(((SpatialCoordinateAndImageReference)object3).getAnnotation(), (int)(f4 + 10.0f), (int)(f5 + -10.0f)));
                            } else {
                                slf4jlogger.info("loadAndDisplayImagesFromSOPInstances(): NOT adding unsupported or unrecognized {} with {} coordinates", string3, fArray.length / 2);
                            }
                        }
                    }
                }
                slf4jlogger.debug("loadAndDisplayImagesFromSOPInstances(): pre-defined shapes passed to SingleImagePanel constructor");
                if (slf4jlogger.isDebugEnabled()) {
                    LocalizerPosterFactory.dumpShapes(vector3);
                }
                object3 = new SingleImagePanel((SourceImage)object2, null, null, vector3, vector4, null);
                ((JComponent)object3).setPreferredSize(new Dimension(((SourceImage)object2).getWidth(), ((SourceImage)object2).getHeight()));
                ((Container)object).add((Component)object3);
                singleImagePanelArray[i] = object3;
            }
            JScrollPane jScrollPane = new JScrollPane((Component)object);
            object2 = ((JFrame)serializable).getContentPane();
            ((Container)object2).setLayout(new GridLayout(1, 1));
            ((Container)object2).add(jScrollPane);
            ((Window)serializable).pack();
            int n28 = jScrollPane.getHeight() + 30;
            if (n28 > n2) {
                n28 = n2;
            }
            if ((n6 = jScrollPane.getWidth() + 24) > n) {
                n6 = n;
            }
            ((Window)serializable).setSize(n6, n28);
            ((Window)serializable).setVisible(true);
        }
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            int n;
            int n2;
            if (stringArray.length == 2) {
                n2 = Integer.valueOf(stringArray[0]);
                n = Integer.valueOf(stringArray[1]);
            }
            if (stringArray.length == 3) {
                n2 = Integer.valueOf(stringArray[1]);
                n = Integer.valueOf(stringArray[2]);
            } else {
                n2 = 1024;
                n = 768;
            }
            String string = null;
            if (stringArray.length == 1 || stringArray.length == 3) {
                string = stringArray[0];
            } else if (stringArray.length == 0 || stringArray.length == 2) {
                object = new SafeFileChooser.SafeFileChooserThread();
                EventQueue.invokeAndWait((Runnable)object);
                string = ((SafeFileChooser.SafeFileChooserThread)object).getSelectedFileName();
            } else {
                System.err.println("Usage: DicomBrowser [dicomdir] [frameWidthWanted frameHeightWanted]");
                System.exit(-1);
            }
            slf4jlogger.debug("Using: {}", string);
            object = new AttributeList();
            String string2 = new File(string).getParent();
            slf4jlogger.debug("parentFilePath: {}", string2);
            slf4jlogger.debug("reading DICOMDIR");
            ((AttributeList)object).read(string);
            slf4jlogger.debug("building tree");
            ApplicationFrame applicationFrame = new ApplicationFrame("DICOMDIR", null, 400, 800);
            DisplayDicomDirectoryBrowser displayDicomDirectoryBrowser = new DisplayDicomDirectoryBrowser((AttributeList)object, string2, applicationFrame, n2, n);
            slf4jlogger.debug("displaying tree");
            applicationFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

