/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.LocalizerManager;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.FrameSortOrderChangeEvent;
import com.pixelmed.display.event.SourceImageSelectionChangeEvent;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.util.Vector;

class ImageLocalizerManager
extends LocalizerManager {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/ImageLocalizerManager.java,v 1.17 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ImageLocalizerManager.class);
    protected GeometryOfVolume mainImageGeometry;
    protected int mainIndex;
    protected int[] mainImageSortOrder;
    private OurMainSourceImageSelectionChangeListener mainSourceImageSelectionChangeListener;
    private OurMainImageFrameSelectionChangeListener mainImageFrameSelectionChangeListener;
    private OurMainImageFrameSortOrderChangeListener mainImageFrameSortOrderChangeListener;

    ImageLocalizerManager() {
    }

    @Override
    protected void drawOutlineOnLocalizerReferenceImagePanel() {
        if (this.referencedImagePanel != null && this.mainImageGeometry != null) {
            slf4jlogger.debug("drawOutlineOnLocalizer(): setting shape and requesting repaint of reference image panel; mainIndex={}", this.mainIndex);
            this.localizerPoster.setLocalizerGeometry(this.referenceImageGeometry.getGeometryOfSlices()[this.referenceIndex]);
            Vector vector = this.localizerPoster.getOutlineOnLocalizerForThisGeometry(this.mainImageGeometry.getGeometryOfSlices()[this.mainIndex]);
            this.referencedImagePanel.setLocalizerShapes(vector);
            this.referencedImagePanel.getParent().validate();
            this.referencedImagePanel.repaint();
        }
    }

    public void setMainSourceImageSelectionContext(EventContext eventContext) {
        if (this.mainSourceImageSelectionChangeListener == null) {
            this.mainSourceImageSelectionChangeListener = new OurMainSourceImageSelectionChangeListener(eventContext);
        } else {
            this.mainSourceImageSelectionChangeListener.setEventContext(eventContext);
        }
    }

    public void setMainImageFrameSelectionContext(EventContext eventContext) {
        if (this.mainImageFrameSelectionChangeListener == null) {
            this.mainImageFrameSelectionChangeListener = new OurMainImageFrameSelectionChangeListener(eventContext);
        } else {
            this.mainImageFrameSelectionChangeListener.setEventContext(eventContext);
        }
    }

    public void setMainImageFrameSortOrderContext(EventContext eventContext) {
        if (this.mainImageFrameSortOrderChangeListener == null) {
            this.mainImageFrameSortOrderChangeListener = new OurMainImageFrameSortOrderChangeListener(eventContext);
        } else {
            this.mainImageFrameSortOrderChangeListener.setEventContext(eventContext);
        }
    }

    @Override
    public void reset() {
        slf4jlogger.debug("reset():");
        super.reset();
        this.mainIndex = 0;
        this.mainImageSortOrder = null;
        this.mainImageGeometry = null;
    }

    class OurMainImageFrameSortOrderChangeListener
    extends SelfRegisteringListener {
        public OurMainImageFrameSortOrderChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSortOrderChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            slf4jlogger.debug("OurMainImageFrameSortOrderChangeListener.changed():");
            FrameSortOrderChangeEvent frameSortOrderChangeEvent = (FrameSortOrderChangeEvent)event;
            ImageLocalizerManager.this.mainImageSortOrder = frameSortOrderChangeEvent.getSortOrder();
            ImageLocalizerManager.this.mainIndex = frameSortOrderChangeEvent.getIndex();
            if (ImageLocalizerManager.this.mainImageSortOrder != null) {
                ImageLocalizerManager.this.mainIndex = ImageLocalizerManager.this.mainImageSortOrder[ImageLocalizerManager.this.mainIndex];
            }
            if (ImageLocalizerManager.this.referenceImageGeometry != null && ImageLocalizerManager.this.mainImageGeometry != null) {
                slf4jlogger.debug("OurMainImageFrameSortOrderChangeListener.changed(): updating localizer outline");
                ImageLocalizerManager.this.drawOutlineOnLocalizerReferenceImagePanel();
            }
        }
    }

    class OurMainImageFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurMainImageFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            slf4jlogger.debug("OurMainImageFrameSelectionChangeListener.changed():");
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            ImageLocalizerManager.this.mainIndex = frameSelectionChangeEvent.getIndex();
            if (ImageLocalizerManager.this.mainImageSortOrder != null) {
                ImageLocalizerManager.this.mainIndex = ImageLocalizerManager.this.mainImageSortOrder[ImageLocalizerManager.this.mainIndex];
            }
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("OurMainImageFrameSelectionChangeListener.changed(): referenceImageGeometry {}", ImageLocalizerManager.this.referenceImageGeometry.toString());
            }
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("OurMainImageFrameSelectionChangeListener.changed(): mainImageGeometry {}", ImageLocalizerManager.this.mainImageGeometry.toString());
            }
            if (ImageLocalizerManager.this.referenceImageGeometry != null && ImageLocalizerManager.this.mainImageGeometry != null) {
                slf4jlogger.debug("OurMainImageFrameSelectionChangeListener.changed(): updating localizer outline");
                ImageLocalizerManager.this.drawOutlineOnLocalizerReferenceImagePanel();
            }
        }
    }

    class OurMainSourceImageSelectionChangeListener
    extends SelfRegisteringListener {
        public OurMainSourceImageSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.SourceImageSelectionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            SourceImageSelectionChangeEvent sourceImageSelectionChangeEvent = (SourceImageSelectionChangeEvent)event;
            ImageLocalizerManager.this.mainImageSortOrder = sourceImageSelectionChangeEvent.getSortOrder();
            ImageLocalizerManager.this.mainIndex = sourceImageSelectionChangeEvent.getIndex();
            if (ImageLocalizerManager.this.mainImageSortOrder != null) {
                ImageLocalizerManager.this.mainIndex = ImageLocalizerManager.this.mainImageSortOrder[ImageLocalizerManager.this.mainIndex];
            }
            ImageLocalizerManager.this.mainImageGeometry = sourceImageSelectionChangeEvent.getGeometryOfVolume();
            if (ImageLocalizerManager.this.mainImageGeometry != null && ImageLocalizerManager.this.mainImageGeometry.getGeometryOfSlices() == null) {
                slf4jlogger.debug("OurMainSourceImageSelectionChangeListener.changed(): getGeometryOfSlices() is null, so not using mainImageGeometry");
                ImageLocalizerManager.this.mainImageGeometry = null;
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Selected image does not contain necessary geometry for localization."));
            }
        }
    }
}

