/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.FrameSortOrderChangeEvent;
import com.pixelmed.display.event.SourceImageSelectionChangeEvent;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.geometry.LocalizerPoster;
import com.pixelmed.geometry.LocalizerPosterFactory;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;

abstract class LocalizerManager {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/LocalizerManager.java,v 1.17 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(LocalizerManager.class);
    protected LocalizerPoster localizerPoster;
    protected GeometryOfVolume referenceImageGeometry;
    protected SingleImagePanel referencedImagePanel;
    protected int referenceIndex;
    protected int[] referenceImageSortOrder;
    protected OurReferenceSourceImageSelectionChangeListener referenceSourceImageSelectionChangeListener;
    protected OurReferenceImageFrameSelectionChangeListener referenceImageFrameSelectionChangeListener;
    protected OurReferenceImageFrameSortOrderChangeListener referenceImageFrameSortOrderChangeListener;

    public LocalizerManager() {
        try {
            this.localizerPoster = LocalizerPosterFactory.getLocalizerPoster(false, false);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            slf4jlogger.error("", noClassDefFoundError);
        }
    }

    protected abstract void drawOutlineOnLocalizerReferenceImagePanel();

    public void setReferenceSourceImageSelectionContext(EventContext eventContext) {
        if (this.referenceSourceImageSelectionChangeListener == null) {
            this.referenceSourceImageSelectionChangeListener = new OurReferenceSourceImageSelectionChangeListener(eventContext);
        } else {
            this.referenceSourceImageSelectionChangeListener.setEventContext(eventContext);
        }
    }

    public void setReferenceImageFrameSelectionContext(EventContext eventContext) {
        if (this.referenceImageFrameSelectionChangeListener == null) {
            this.referenceImageFrameSelectionChangeListener = new OurReferenceImageFrameSelectionChangeListener(eventContext);
        } else {
            this.referenceImageFrameSelectionChangeListener.setEventContext(eventContext);
        }
    }

    public void setReferenceImageFrameSortOrderContext(EventContext eventContext) {
        if (this.referenceImageFrameSortOrderChangeListener == null) {
            this.referenceImageFrameSortOrderChangeListener = new OurReferenceImageFrameSortOrderChangeListener(eventContext);
        } else {
            this.referenceImageFrameSortOrderChangeListener.setEventContext(eventContext);
        }
    }

    public void setReferenceImagePanel(SingleImagePanel singleImagePanel) {
        slf4jlogger.debug("setReferenceImagePanel():");
        this.referencedImagePanel = singleImagePanel;
    }

    public void reset() {
        slf4jlogger.debug("reset():");
        this.referenceImageGeometry = null;
        this.referencedImagePanel = null;
        this.referenceIndex = 0;
        this.referenceImageSortOrder = null;
    }

    class OurReferenceImageFrameSortOrderChangeListener
    extends SelfRegisteringListener {
        public OurReferenceImageFrameSortOrderChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSortOrderChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            slf4jlogger.debug("OurReferenceImageFrameSortOrderChangeListener.changed():");
            FrameSortOrderChangeEvent frameSortOrderChangeEvent = (FrameSortOrderChangeEvent)event;
            LocalizerManager.this.referenceImageSortOrder = frameSortOrderChangeEvent.getSortOrder();
            LocalizerManager.this.referenceIndex = frameSortOrderChangeEvent.getIndex();
            if (LocalizerManager.this.referenceImageSortOrder != null) {
                LocalizerManager.this.referenceIndex = LocalizerManager.this.referenceImageSortOrder[LocalizerManager.this.referenceIndex];
            }
            if (LocalizerManager.this.referenceImageGeometry != null) {
                LocalizerManager.this.drawOutlineOnLocalizerReferenceImagePanel();
            }
        }
    }

    class OurReferenceImageFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurReferenceImageFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("OurReferenceImageFrameSelectionChangeListener.changed(): event {}", frameSelectionChangeEvent.toString());
            }
            LocalizerManager.this.referenceIndex = frameSelectionChangeEvent.getIndex();
            if (LocalizerManager.this.referenceImageSortOrder != null) {
                LocalizerManager.this.referenceIndex = LocalizerManager.this.referenceImageSortOrder[LocalizerManager.this.referenceIndex];
            }
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("OurReferenceImageFrameSelectionChangeListener.changed(): referenceImageGeometry {}", LocalizerManager.this.referenceImageGeometry.toString());
            }
            if (LocalizerManager.this.referenceImageGeometry != null) {
                LocalizerManager.this.drawOutlineOnLocalizerReferenceImagePanel();
            }
        }
    }

    class OurReferenceSourceImageSelectionChangeListener
    extends SelfRegisteringListener {
        public OurReferenceSourceImageSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.SourceImageSelectionChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            SourceImageSelectionChangeEvent sourceImageSelectionChangeEvent = (SourceImageSelectionChangeEvent)event;
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("OurReferenceSourceImageSelectionChangeListener.changed(): event {}", sourceImageSelectionChangeEvent.toString());
            }
            LocalizerManager.this.referenceImageSortOrder = sourceImageSelectionChangeEvent.getSortOrder();
            LocalizerManager.this.referenceIndex = sourceImageSelectionChangeEvent.getIndex();
            if (LocalizerManager.this.referenceImageSortOrder != null) {
                LocalizerManager.this.referenceIndex = LocalizerManager.this.referenceImageSortOrder[LocalizerManager.this.referenceIndex];
            }
            LocalizerManager.this.referenceImageGeometry = sourceImageSelectionChangeEvent.getGeometryOfVolume();
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("OurReferenceSourceImageSelectionChangeListener.changed(): referenceImageGeometry {}", LocalizerManager.this.referenceImageGeometry.toString());
            }
            if (LocalizerManager.this.referenceImageGeometry != null && LocalizerManager.this.referenceImageGeometry.getGeometryOfSlices() == null) {
                slf4jlogger.debug("OurReferenceSourceImageSelectionChangeListener.changed(): getGeometryOfSlices() is null, so not using referenceImageGeometry");
                LocalizerManager.this.referenceImageGeometry = null;
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Selected reference image does not contain necessary geometry for localization."));
            }
        }
    }
}

