/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import java.awt.EventQueue;
import javax.swing.JProgressBar;

public class SafeProgressBarUpdaterThread
implements Runnable {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SafeProgressBarUpdaterThread.java,v 1.12 2025/01/29 10:58:07 dclunie Exp $";
    protected JProgressBar progressBar;
    protected int value;
    protected int maximum;
    protected boolean stringPainted;

    public SafeProgressBarUpdaterThread(JProgressBar jProgressBar) {
        this.progressBar = jProgressBar;
        this.value = 0;
        this.maximum = 0;
    }

    @Override
    public void run() {
        this.progressBar.setValue(this.value);
        this.progressBar.setMaximum(this.maximum);
        this.progressBar.setStringPainted(this.stringPainted);
        this.progressBar.repaint();
    }

    public void setValue(int n) {
        this.value = n;
    }

    public void setMaximum(int n) {
        this.maximum = n;
    }

    public void setStringPainted(boolean bl) {
        this.stringPainted = bl;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public void startProgressBar(int n) {
        if (EventQueue.isDispatchThread()) {
            this.progressBar.setValue(0);
            this.progressBar.setMaximum(n);
            this.progressBar.setStringPainted(true);
            this.progressBar.repaint();
        } else {
            this.setValue(0);
            this.setMaximum(n);
            this.setStringPainted(true);
            EventQueue.invokeLater(this);
        }
    }

    public void startProgressBar() {
        this.startProgressBar(100);
    }

    public void updateProgressBar(int n) {
        if (EventQueue.isDispatchThread()) {
            this.progressBar.setValue(n);
            this.progressBar.setStringPainted(true);
            this.progressBar.repaint();
        } else {
            this.setValue(n);
            this.setStringPainted(true);
            EventQueue.invokeLater(this);
        }
    }

    public void updateProgressBar(int n, int n2) {
        if (EventQueue.isDispatchThread()) {
            this.progressBar.setValue(n);
            this.progressBar.setMaximum(n2);
            this.progressBar.setStringPainted(true);
            this.progressBar.repaint();
        } else {
            this.setValue(n);
            this.setMaximum(n2);
            this.setStringPainted(true);
            EventQueue.invokeLater(this);
        }
    }

    public void endProgressBar() {
        if (EventQueue.isDispatchThread()) {
            this.progressBar.setValue(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setStringPainted(false);
            this.progressBar.repaint();
        } else {
            this.setValue(0);
            this.setMaximum(100);
            this.setStringPainted(false);
            EventQueue.invokeLater(this);
        }
    }

    public static void startProgressBar(SafeProgressBarUpdaterThread safeProgressBarUpdaterThread, int n) {
        if (safeProgressBarUpdaterThread != null) {
            safeProgressBarUpdaterThread.startProgressBar(n);
        }
    }

    public static void startProgressBar(SafeProgressBarUpdaterThread safeProgressBarUpdaterThread) {
        if (safeProgressBarUpdaterThread != null) {
            safeProgressBarUpdaterThread.startProgressBar();
        }
    }

    public static void updateProgressBar(SafeProgressBarUpdaterThread safeProgressBarUpdaterThread, int n) {
        if (safeProgressBarUpdaterThread != null) {
            safeProgressBarUpdaterThread.updateProgressBar(n);
        }
    }

    public static void updateProgressBar(SafeProgressBarUpdaterThread safeProgressBarUpdaterThread, int n, int n2) {
        if (safeProgressBarUpdaterThread != null) {
            safeProgressBarUpdaterThread.updateProgressBar(n, n2);
        }
    }

    public static void endProgressBar(SafeProgressBarUpdaterThread safeProgressBarUpdaterThread) {
        if (safeProgressBarUpdaterThread != null) {
            safeProgressBarUpdaterThread.endProgressBar();
        }
    }
}

