/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.ByteFrameSource;
import com.pixelmed.dicom.CompressedFrameDecoder;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DisplayShutter;
import com.pixelmed.dicom.ModalityTransform;
import com.pixelmed.dicom.OtherAttributeOnDisk;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherByteAttributeCompressedSeparateFramesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleCompressedFrames;
import com.pixelmed.dicom.OtherByteAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.OtherByteAttributeMultipleFrameArrays;
import com.pixelmed.dicom.OtherByteAttributeOnDisk;
import com.pixelmed.dicom.OtherDoubleAttribute;
import com.pixelmed.dicom.OtherFloatAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.OtherWordAttributeMultipleFilesOnDisk;
import com.pixelmed.dicom.OtherWordAttributeMultipleFrameArrays;
import com.pixelmed.dicom.OtherWordAttributeOnDisk;
import com.pixelmed.dicom.Overlay;
import com.pixelmed.dicom.RealWorldValueTransform;
import com.pixelmed.dicom.SUVTransform;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.VOITransform;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.HexDump;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Cleaner;

public class SourceImage {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SourceImage.java,v 1.140 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SourceImage.class);
    protected static boolean allowMemoryMapping = true;
    protected static boolean allowMemoryMappingFromMultiplePerFrameFiles = false;
    protected static boolean allowDeferredReadFromFileIfNotMemoryMapped = true;
    protected boolean applyICCProfileIfPresent = true;
    BufferedImage[] imgs;
    int width;
    int height;
    int nframes;
    double imgMin;
    double imgMax;
    double imgMean;
    double imgStandardDeviation;
    boolean signed;
    boolean inverted;
    int mask;
    boolean isGrayscale;
    boolean isPaletteColor;
    boolean isYBR;
    boolean codecConvertsYBRtoRGB;
    boolean isChrominanceHorizontallyDownsampledBy2;
    int pad;
    int padRangeLimit;
    boolean hasPad;
    boolean useMaskedPadRange;
    int useMaskedPadRangeStart;
    int useMaskedPadRangeEnd;
    boolean useNonMaskedSinglePadValue;
    int nonMaskedSinglePadValue;
    int backgroundValue;
    String title;
    private int largestGray;
    private int firstValueMapped;
    private int numberOfEntries;
    private int bitsPerEntry;
    private short[] redTable;
    private short[] greenTable;
    private short[] blueTable;
    private SUVTransform suvTransform;
    private RealWorldValueTransform realWorldValueTransform;
    private ModalityTransform modalityTransform;
    private VOITransform voiTransform;
    private DisplayShutter displayShutter;
    private Overlay overlay;
    private ColorSpace srcColorSpace;
    private ColorSpace dstColorSpace;
    private Rectangle[] clipRects;
    protected BufferedImageSource bufferedImageSource = null;
    protected FileInputStream memoryMappedFileInputStream = null;
    protected FileChannel memoryMappedFileChannel = null;
    protected FileInputStream[] memoryMappedFileInputStreams = null;
    protected FileChannel[] memoryMappedFileChannels = null;
    protected MappedByteBuffer[] memoryMappedByteBuffers = null;
    protected static int memoryMapperNumberOfRetries = 100;
    protected static int memoryMapperSleepTimeBetweenRetries = 1000;
    protected static int memoryMapperRetriesBeforeSleeping = 10;

    public static void setAllowMemoryMapping(boolean bl) {
        allowMemoryMapping = bl;
    }

    public static void setAllowMemoryMappingFromMultiplePerFrameFiles(boolean bl) {
        allowMemoryMappingFromMultiplePerFrameFiles = bl;
    }

    public static void setAllowDeferredReadFromFileIfNotMemoryMapped(boolean bl) {
        allowDeferredReadFromFileIfNotMemoryMapped = bl;
    }

    public void setClipRect(int n, Rectangle rectangle) {
        if (this.clipRects == null) {
            slf4jlogger.trace("setClipRect(): lazy allocation of clipRects array length = {}", this.nframes);
            this.clipRects = new Rectangle[this.nframes];
        }
        slf4jlogger.trace("setClipRect(): setting clipRect for frame = {}", n);
        this.clipRects[n] = rectangle;
    }

    public static BufferedImage createUnsignedShortGrayscaleImage(int n, int n2, short[] sArray, int n3) {
        slf4jlogger.debug("createUnsignedShortGrayscaleImage");
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n, n2, 1, n, new int[]{0});
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    public static BufferedImage createSignedShortGrayscaleImage(int n, int n2, short[] sArray, int n3) {
        slf4jlogger.debug("createSignedShortGrayscaleImage");
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n, n2, 1, n, new int[]{0});
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    public static BufferedImage createByteGrayscaleImage(int n, int n2, byte[] byArray, int n3) {
        slf4jlogger.debug("createByteGrayscaleImage");
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, 1, n, new int[]{0});
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    private static byte[] upsamplePixelInterleavedByteHorizontallyDownsampledBy2ChrominanceChannels(int n, int n2, byte[] byArray, int n3) {
        slf4jlogger.debug("upsamplePixelInterleavedByteHorizontallyDownsampledBy2ChrominanceChannels(): data.length = {}", byArray.length);
        slf4jlogger.debug("upsamplePixelInterleavedByteHorizontallyDownsampledBy2ChrominanceChannels(): offset = {}", n3);
        int n4 = n + n / 2 + n / 2;
        slf4jlogger.debug("upsamplePixelInterleavedByteHorizontallyDownsampledBy2ChrominanceChannels(): widthOfSrcRowInBytes = {}", n4);
        int n5 = n * 3;
        slf4jlogger.debug("upsamplePixelInterleavedByteHorizontallyDownsampledBy2ChrominanceChannels(): widthOfDstRowInBytes = {}", n5);
        byte[] byArray2 = new byte[n * n2 * 3];
        slf4jlogger.debug("upsamplePixelInterleavedByteHorizontallyDownsampledBy2ChrominanceChannels(): newData.length = {}", byArray2.length);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; j += 2) {
                int n6 = n3 + i * n4 + j * 2;
                int n7 = i * n5 + j * 3;
                slf4jlogger.trace("upsamplePixelInterleavedByteHorizontallyDownsampledBy2ChrominanceChannels(): row = {} col = {} startByteOfSrc4ByteGroup = {} startByteOfDst6ByteGroup = {}", i, j, n6, n7);
                byArray2[n7] = byArray[n6];
                byArray2[n7 + 1] = byArray[n6 + 2];
                byArray2[n7 + 2] = byArray[n6 + 3];
                byArray2[n7 + 3] = byArray[n6 + 1];
                byArray2[n7 + 4] = byArray[n6 + 2];
                byArray2[n7 + 5] = byArray[n6 + 3];
            }
        }
        return byArray2;
    }

    public static BufferedImage createPixelInterleavedByteThreeComponentColorImage(int n, int n2, byte[] byArray, int n3, ColorSpace colorSpace, boolean bl) {
        slf4jlogger.debug("createPixelInterleavedByteThreeComponentColorImage():");
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8}, false, false, 1, 0);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, 3, n * 3, new int[]{0, 1, 2});
        if (bl) {
            byArray = SourceImage.upsamplePixelInterleavedByteHorizontallyDownsampledBy2ChrominanceChannels(n, n2, byArray, n3);
            n3 = 0;
        }
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    public static BufferedImage createBandInterleavedByteThreeComponentColorImage(int n, int n2, byte[] byArray, int n3, ColorSpace colorSpace) {
        slf4jlogger.debug("createBandInterleavedByteThreeComponentColorImage():");
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{8, 8, 8}, false, false, 1, 0);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(0, n, n2, 1, n, new int[]{0, n * n2, n * n2 * 2});
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    public static BufferedImage createPixelInterleavedShortThreeComponentColorImage(int n, int n2, short[] sArray, int n3, ColorSpace colorSpace) {
        slf4jlogger.debug("createPixelInterleavedShortThreeComponentColorImage():");
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{16, 16, 16}, false, false, 1, 1);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n, n2, 3, n * 3, new int[]{0, 1, 2});
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    public static BufferedImage createBandInterleavedShortThreeComponentColorImage(int n, int n2, short[] sArray, int n3, ColorSpace colorSpace) {
        slf4jlogger.debug("createBandInterleavedShortThreeComponentColorImage():");
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, new int[]{16, 16, 16}, false, false, 1, 1);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n, n2, 1, n, new int[]{0, n * n2, n * n2 * 2});
        DataBufferUShort dataBufferUShort = new DataBufferUShort(sArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    public static BufferedImage createFloatGrayscaleImage(int n, int n2, float[] fArray, int n3) {
        slf4jlogger.debug("createFloatGrayscaleImage():");
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 4);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(4, n, n2, 1, n, new int[]{0});
        DataBufferFloat dataBufferFloat = new DataBufferFloat(fArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferFloat, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    public static BufferedImage createDoubleGrayscaleImage(int n, int n2, double[] dArray, int n3) {
        slf4jlogger.debug("createDoubleGrayscaleImage():");
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 5);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(5, n, n2, 1, n, new int[]{0});
        DataBufferDouble dataBufferDouble = new DataBufferDouble(dArray, n, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferDouble, new Point(0, 0));
        return new BufferedImage(componentColorModel, writableRaster, true, null);
    }

    protected SourceImage() {
    }

    public SourceImage(InputStream inputStream, int n, int n2, int n3) throws IOException {
        this.constructSourceImage(inputStream, n, n2, n3, 1);
    }

    public SourceImage(InputStream inputStream, int n, int n2, int n3, int n4) throws IOException {
        this.constructSourceImage(inputStream, n, n2, n3, n4);
    }

    private void constructSourceImage(InputStream inputStream, int n, int n2, int n3, int n4) throws IOException {
        this.width = n;
        this.height = n2;
        this.nframes = n4;
        if (this.nframes < 1) {
            return;
        }
        this.imgs = new BufferedImage[this.nframes];
        this.imgMin = 65536.0;
        this.imgMax = 0.0;
        for (int i = 0; i < this.nframes; ++i) {
            int n5;
            int n6;
            int n7;
            Object[] objectArray;
            if (n3 > 8) {
                this.largestGray = 65535;
                objectArray = new short[this.width * this.height];
                byte[] byArray = new byte[this.width * this.height * 2];
                inputStream.read(byArray, 0, this.width * this.height * 2);
                n7 = 0;
                for (n6 = 0; n6 < this.height; ++n6) {
                    for (n5 = 0; n5 < this.width; ++n5) {
                        short s;
                        int n8 = byArray[n7++] & 0xFF;
                        int n9 = byArray[n7++] & 0xFF;
                        objectArray[n6 * n + n5] = s = (short)((n9 << 8) + n8);
                        if ((double)s > this.imgMax && s <= this.largestGray) {
                            this.imgMax = s;
                        }
                        if (!((double)s < this.imgMin)) continue;
                        this.imgMin = s;
                    }
                }
                this.imgs[i] = SourceImage.createUnsignedShortGrayscaleImage(this.width, this.height, objectArray, 0);
                continue;
            }
            this.largestGray = 255;
            objectArray = new byte[this.width * this.height];
            inputStream.read((byte[])objectArray, 0, this.width * this.height);
            int n10 = 0;
            for (n7 = 0; n7 < this.height; ++n7) {
                for (n6 = 0; n6 < this.width; ++n6) {
                    int n11 = n10++;
                    n5 = objectArray[n11] & 0xFF;
                    if ((double)n5 > this.imgMax && n5 <= this.largestGray) {
                        this.imgMax = n5;
                    }
                    if (!((double)n5 < this.imgMin)) continue;
                    this.imgMin = n5;
                }
            }
            this.imgs[i] = SourceImage.createByteGrayscaleImage(this.width, this.height, (byte[])objectArray, 0);
        }
        slf4jlogger.debug("constructSourceImage(): imgMin = {}", this.imgMin);
        slf4jlogger.debug("constructSourceImage(): imgMax = {}", this.imgMax);
    }

    public SourceImage(String string, boolean bl) throws IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string);
        this.applyICCProfileIfPresent = bl;
        if (attributeList.getPixelData() != null) {
            this.constructSourceImage(attributeList);
        }
    }

    public SourceImage(String string) throws IOException, DicomException {
        this(string, true);
    }

    public SourceImage(DicomInputStream dicomInputStream, boolean bl) throws IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(dicomInputStream);
        this.applyICCProfileIfPresent = bl;
        if (attributeList.getPixelData() != null) {
            this.constructSourceImage(attributeList);
        }
    }

    public SourceImage(DicomInputStream dicomInputStream) throws IOException, DicomException {
        this(dicomInputStream, true);
    }

    public SourceImage(AttributeList attributeList, boolean bl) throws DicomException {
        this.applyICCProfileIfPresent = bl;
        if (attributeList.getPixelData() != null) {
            this.constructSourceImage(attributeList);
        }
    }

    public SourceImage(AttributeList attributeList) throws DicomException {
        this(attributeList, true);
    }

    private static byte[] getByteArrayForFrameFromMultiFrameShortArray(int n, short[] sArray, int n2) {
        slf4jlogger.debug("getByteArrayForFrameFromMultiFrameShortArray(): getting frame {} as byte array from contiguous short allocated memory for all frames", n);
        byte[] byArray = new byte[n2];
        int n3 = n2 / 2;
        int n4 = n3 * n;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            int n6 = sArray[n4++] & 0xFFFF;
            int n7 = n6 & 0xFF;
            byArray[n5++] = (byte)n7;
            int n8 = n6 >> 8 & 0xFF;
            byArray[n5++] = (byte)n8;
        }
        return byArray;
    }

    private static byte[] getByteArrayForFrameFromSingleFrameShortArray(short[] sArray, int n) {
        slf4jlogger.debug("getByteArrayForFrameFromMultiFrameShortArray(): byte array from short array for individual frame");
        byte[] byArray = new byte[n];
        int n2 = n / 2;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            int n5 = sArray[n3++] & 0xFFFF;
            int n6 = n5 & 0xFF;
            byArray[n4++] = (byte)n6;
            int n7 = n5 >> 8 & 0xFF;
            byArray[n4++] = (byte)n7;
        }
        return byArray;
    }

    protected static void clean(final Object object) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                slf4jlogger.debug("clean.run()");
                try {
                    Method method = object.getClass().getMethod("cleaner", new Class[0]);
                    method.setAccessible(true);
                    Cleaner cleaner = (Cleaner)method.invoke(object, new Object[0]);
                    cleaner.clean();
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
                return null;
            }
        });
    }

    public void close() throws Throwable {
        int n;
        slf4jlogger.debug("close()");
        this.bufferedImageSource = null;
        if (this.memoryMappedByteBuffers != null) {
            for (n = 0; n < this.memoryMappedByteBuffers.length; ++n) {
                MappedByteBuffer mappedByteBuffer = this.memoryMappedByteBuffers[n];
                if (mappedByteBuffer == null) continue;
                SourceImage.clean(mappedByteBuffer);
                this.memoryMappedByteBuffers[n] = null;
            }
            this.memoryMappedByteBuffers = null;
        }
        if (this.memoryMappedFileChannels != null) {
            for (n = 0; n < this.memoryMappedFileChannels.length; ++n) {
                this.memoryMappedFileChannels[n].close();
                this.memoryMappedFileChannels[n] = null;
            }
            this.memoryMappedFileChannels = null;
        }
        if (this.memoryMappedFileInputStreams != null) {
            for (n = 0; n < this.memoryMappedFileInputStreams.length; ++n) {
                this.memoryMappedFileInputStreams[n].close();
                this.memoryMappedFileInputStreams[n] = null;
            }
            this.memoryMappedFileInputStreams = null;
        }
        if (this.memoryMappedFileChannel != null) {
            this.memoryMappedFileChannel.close();
            this.memoryMappedFileChannel = null;
        }
        if (this.memoryMappedFileInputStream != null) {
            this.memoryMappedFileInputStream.close();
            this.memoryMappedFileInputStream = null;
        }
    }

    protected void finalize() throws Throwable {
        slf4jlogger.debug("finalize()");
        this.close();
        super.finalize();
    }

    protected ByteBuffer[] getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(OtherByteAttributeMultipleFilesOnDisk otherByteAttributeMultipleFilesOnDisk, int n) throws DicomException, IOException, Throwable {
        this.memoryMappedFileInputStreams = new FileInputStream[n];
        this.memoryMappedFileChannels = new FileChannel[n];
        this.memoryMappedByteBuffers = new MappedByteBuffer[n];
        boolean bl = true;
        File[] fileArray = otherByteAttributeMultipleFilesOnDisk.getFiles();
        long[] lArray = otherByteAttributeMultipleFilesOnDisk.getByteOffsets();
        long[] lArray2 = otherByteAttributeMultipleFilesOnDisk.getLengths();
        Exception exception = null;
        for (int i = 0; i < n; ++i) {
            MappedByteBuffer mappedByteBuffer = null;
            File file = fileArray[i];
            slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): File {}", file);
            FileInputStream fileInputStream = null;
            FileChannel fileChannel = null;
            try {
                fileInputStream = new FileInputStream(file);
                fileChannel = this.memoryMappedFileInputStream.getChannel();
                if (fileChannel == null) {
                    slf4jlogger.warn("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): memoryMappedFileInputStream.getChannel() returned null ! - try again");
                    fileChannel = this.memoryMappedFileInputStream.getChannel();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new DicomException("Cannot find file to memory map " + file + " " + fileNotFoundException);
            }
            int n2 = 0;
            int n3 = 0;
            while (mappedByteBuffer == null && n2 < memoryMapperNumberOfRetries) {
                long l = lArray[i];
                slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): Byte offset for frame {} is {}", i, l);
                long l2 = lArray2[i];
                slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): Frame size for frame {} is {}", i, l2);
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, l, l2);
                if (mappedByteBuffer != null) continue;
                slf4jlogger.warn("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): Attempt to memory map frame {} failed", i);
                if (n3 >= memoryMapperRetriesBeforeSleeping) {
                    n3 = 0;
                    try {
                        slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): sleeping");
                        Thread.currentThread();
                        Thread.sleep(memoryMapperSleepTimeBetweenRetries);
                        slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): back from sleep");
                    }
                    catch (InterruptedException interruptedException) {
                        slf4jlogger.error("", interruptedException);
                    }
                }
                slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): retrycount = {}", n2);
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): free  memory = {}", Runtime.getRuntime().freeMemory());
                }
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): max   memory = {}", Runtime.getRuntime().maxMemory());
                }
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): total memory = {}", Runtime.getRuntime().totalMemory());
                }
                try {
                    slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): requesting gc and runFinalization");
                    System.gc();
                    System.runFinalization();
                    slf4jlogger.debug("getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk(): back from gc and runFinalization");
                }
                catch (Exception exception2) {
                    slf4jlogger.error("", exception2);
                    exception = exception2;
                }
                ++n2;
                ++n3;
            }
            if (mappedByteBuffer == null) {
                bl = false;
                break;
            }
            this.memoryMappedByteBuffers[i] = mappedByteBuffer;
        }
        if (!bl) {
            this.close();
            throw new DicomException("Cannot memory map files" + exception);
        }
        return this.memoryMappedByteBuffers;
    }

    protected ByteBuffer[] getByteBuffersFromOtherAttributeOnDisk(OtherAttributeOnDisk otherAttributeOnDisk, int n) throws DicomException, IOException, Throwable {
        slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): File " + otherAttributeOnDisk.getFile());
        this.memoryMappedFileInputStream = null;
        this.memoryMappedFileChannel = null;
        try {
            this.memoryMappedFileInputStream = new FileInputStream(otherAttributeOnDisk.getFile());
            this.memoryMappedFileChannel = this.memoryMappedFileInputStream.getChannel();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DicomException("Cannot find file to memory map " + otherAttributeOnDisk.getFile() + " " + fileNotFoundException);
        }
        this.memoryMappedByteBuffers = new MappedByteBuffer[n];
        boolean bl = true;
        long l = otherAttributeOnDisk.getVL() / (long)n;
        slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): framesizebytes {}", l);
        Exception exception = null;
        for (int i = 0; i < n; ++i) {
            MappedByteBuffer mappedByteBuffer = null;
            int n2 = 0;
            int n3 = 0;
            try {
                while (mappedByteBuffer == null && n2 < memoryMapperNumberOfRetries) {
                    long l2 = otherAttributeOnDisk.getByteOffset() + (long)i * l;
                    slf4jlogger.debug("constructSourceImage(): Byte offset for frame {} is {} and frame size is {} bytes", i, l2, l);
                    mappedByteBuffer = this.memoryMappedFileChannel.map(FileChannel.MapMode.READ_ONLY, l2, l);
                    if (mappedByteBuffer != null) continue;
                    slf4jlogger.warn("getByteBuffersFromOtherAttributeOnDisk(): Attempt to memory map frame {} failed", i);
                    if (n3 >= memoryMapperRetriesBeforeSleeping) {
                        n3 = 0;
                        try {
                            slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): sleeping");
                            Thread.currentThread();
                            Thread.sleep(memoryMapperSleepTimeBetweenRetries);
                            slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): back from sleep");
                        }
                        catch (InterruptedException interruptedException) {
                            slf4jlogger.error("", interruptedException);
                        }
                    }
                    slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): retrycount = {}", n2);
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): free  memory = {}", Runtime.getRuntime().freeMemory());
                    }
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): max   memory = {}", Runtime.getRuntime().maxMemory());
                    }
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): total memory = {}", Runtime.getRuntime().totalMemory());
                    }
                    try {
                        slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): requesting gc and runFinalization");
                        System.gc();
                        System.runFinalization();
                        slf4jlogger.debug("getByteBuffersFromOtherAttributeOnDisk(): back from gc and runFinalization");
                    }
                    catch (Exception exception2) {
                        slf4jlogger.error("", exception2);
                        exception = exception2;
                    }
                    ++n2;
                    ++n3;
                }
            }
            catch (Exception exception3) {
                slf4jlogger.error("", exception3.toString());
                mappedByteBuffer = null;
            }
            if (mappedByteBuffer == null) {
                bl = false;
                break;
            }
            this.memoryMappedByteBuffers[i] = mappedByteBuffer;
        }
        if (!bl) {
            this.close();
            throw new DicomException("Cannot memory map file " + otherAttributeOnDisk.getFile() + " " + exception);
        }
        return this.memoryMappedByteBuffers;
    }

    protected ShortBuffer[] getShortBuffersFromOtherWordAttributeOnDisk(OtherWordAttributeOnDisk otherWordAttributeOnDisk, int n) throws DicomException, IOException, Throwable {
        slf4jlogger.debug("getShortBuffersFromOtherWordAttributeOnDisk(): nframes = {}", n);
        ShortBuffer[] shortBufferArray = new ShortBuffer[n];
        ByteBuffer[] byteBufferArray = this.getByteBuffersFromOtherAttributeOnDisk(otherWordAttributeOnDisk, n);
        for (int i = 0; i < n; ++i) {
            ShortBuffer shortBuffer;
            ByteBuffer byteBuffer = byteBufferArray[i];
            byteBuffer.order(otherWordAttributeOnDisk.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
            shortBufferArray[i] = shortBuffer = byteBuffer.asShortBuffer();
        }
        return shortBufferArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void constructSourceImage(AttributeList attributeList) throws DicomException {
        Object object;
        slf4jlogger.debug("constructSourceImage(): start");
        this.title = AttributeList.buildInstanceTitleFromAttributeList(attributeList);
        this.width = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        slf4jlogger.debug("constructSourceImage(): width={}", this.width);
        this.height = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        slf4jlogger.debug("constructSourceImage(): height={}", this.height);
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
        slf4jlogger.debug("constructSourceImage(): depth={}", n);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        slf4jlogger.debug("constructSourceImage(): samples={}", n2);
        boolean bl = n2 > 1 && Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PlanarConfiguration, 0) == 1;
        slf4jlogger.debug("constructSourceImage(): byplane={}", bl);
        this.nframes = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        slf4jlogger.debug("constructSourceImage(): nframes={}", this.nframes);
        this.mask = 0;
        int n3 = 0;
        int n4 = 1;
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, n);
        slf4jlogger.debug("constructSourceImage(): stored={}", n5);
        if (n < n5) {
            throw new DicomException("Unsupported Bits Allocated " + n + "\" less then Bits Stored " + n5);
        }
        int n6 = n5;
        while (n6-- > 0) {
            this.mask = this.mask << 1 | 1;
            n4 <<= 1;
        }
        n4 >>= 1;
        n3 = ~this.mask;
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("constructSourceImage(): mask=0x{}", Integer.toHexString(this.mask));
        }
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("constructSourceImage(): extend=0x{}", Integer.toHexString(n3));
        }
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("constructSourceImage(): signbit=0x{}", Integer.toHexString(n4));
        }
        this.signed = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, 0) == 1;
        this.imgMin = this.signed ? 32767.0 : 65535.0;
        this.imgMax = this.signed ? -32768.0 : 0.0;
        slf4jlogger.debug("constructSourceImage(): signed={}", this.signed);
        this.pad = 0;
        this.hasPad = false;
        this.useMaskedPadRange = false;
        this.useNonMaskedSinglePadValue = false;
        Attribute attribute = attributeList.get(TagFromName.PixelPaddingValue);
        if (attribute != null) {
            this.hasPad = true;
            this.pad = attribute.getSingleIntegerValueOrDefault(0);
            this.padRangeLimit = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelPaddingRangeLimit, this.pad);
            slf4jlogger.debug("constructSourceImage(): hasPad={}", this.hasPad);
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("constructSourceImage(): pad=0x{} ({} dec)", Integer.toHexString(this.pad), this.pad);
            }
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("constructSourceImage(): padRangeLimit=0x{} ({} dec)", Integer.toHexString(this.padRangeLimit), this.padRangeLimit);
            }
            this.useMaskedPadRangeStart = this.pad & this.mask;
            this.useMaskedPadRangeEnd = this.padRangeLimit & this.mask;
            if (this.useMaskedPadRangeStart == (this.pad & 0xFFFF) && this.useMaskedPadRangeEnd == (this.padRangeLimit & 0xFFFF)) {
                slf4jlogger.debug("constructSourceImage(): Padding values are within mask range and hence valid");
                this.useMaskedPadRange = true;
                if (this.useMaskedPadRangeStart > this.useMaskedPadRangeEnd) {
                    int n7 = this.useMaskedPadRangeEnd;
                    this.useMaskedPadRangeEnd = this.useMaskedPadRangeStart;
                    this.useMaskedPadRangeStart = n7;
                }
                slf4jlogger.debug("constructSourceImage(): useMaskedPadRangeStart={}", this.useMaskedPadRangeStart);
                slf4jlogger.debug("constructSourceImage(): useMaskedPadRangeEnd={}", this.useMaskedPadRangeEnd);
            } else {
                slf4jlogger.debug("constructSourceImage(): Padding values are outside mask range and theoretically invalid - ignore any range and just use fixed value of PixelPaddingValue");
                this.useNonMaskedSinglePadValue = true;
                this.nonMaskedSinglePadValue = this.pad;
            }
        }
        String string = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.PhotometricInterpretation, "MONOCHROME2");
        this.isGrayscale = false;
        this.isPaletteColor = false;
        this.isYBR = false;
        this.codecConvertsYBRtoRGB = false;
        this.isChrominanceHorizontallyDownsampledBy2 = false;
        this.inverted = false;
        slf4jlogger.debug("constructSourceImage(): vPhotometricInterpretation={}", string);
        if (string.equals("MONOCHROME2")) {
            this.isGrayscale = true;
        } else if (string.equals("MONOCHROME1")) {
            this.isGrayscale = true;
            this.inverted = true;
        } else if (string.equals("PALETTE COLOR")) {
            this.isPaletteColor = true;
        } else if (string.equals("YBR_FULL")) {
            slf4jlogger.debug("constructSourceImage(): PhotometricInterpretation is YBR_FULL so checking whether or not handled by codec");
            if (attributeList.getDecompressedPhotometricInterpretation(string).equals("RGB")) {
                this.codecConvertsYBRtoRGB = true;
            } else {
                slf4jlogger.debug("constructSourceImage(): PhotometricInterpretation is YBR_FULL and not handled by codec (e.g., already uncompressed)");
                this.isYBR = true;
            }
        } else if (string.equals("YBR_FULL_422")) {
            slf4jlogger.debug("constructSourceImage(): PhotometricInterpretation is YBR_FULL_422 so checking whether or not handled by codec");
            if (attributeList.getDecompressedPhotometricInterpretation(string).equals("RGB")) {
                this.codecConvertsYBRtoRGB = true;
            } else {
                slf4jlogger.debug("constructSourceImage(): PhotometricInterpretation is YBR_FULL_422 and not handled by codec (e.g., already uncompressed)");
                this.isYBR = true;
                this.isChrominanceHorizontallyDownsampledBy2 = true;
            }
        }
        slf4jlogger.debug("constructSourceImage(): inverted={}", this.inverted);
        slf4jlogger.debug("constructSourceImage(): isGrayscale={}", this.isGrayscale);
        slf4jlogger.debug("constructSourceImage(): isPaletteColor={}", this.isPaletteColor);
        slf4jlogger.debug("constructSourceImage(): isYBR={}", this.isYBR);
        Attribute attribute2 = attributeList.get(TagFromName.LargestMonochromePixelValue);
        Attribute attribute3 = attributeList.get(TagFromName.RedPaletteColorLookupTableDescriptor);
        Attribute attribute4 = attributeList.get(TagFromName.GreenPaletteColorLookupTableDescriptor);
        Attribute attribute5 = attributeList.get(TagFromName.BluePaletteColorLookupTableDescriptor);
        this.largestGray = this.signed ? Short.MAX_VALUE : 65535;
        boolean bl2 = false;
        if (attribute2 != null && attribute2.getVM() == 1) {
            bl2 = true;
            this.largestGray = attribute2.getIntegerValues()[0];
        }
        boolean bl3 = false;
        if (!bl2 && (object = attributeList.get(TagFromName.LargestImagePixelValue)) != null && ((Attribute)object).getVM() == 1) {
            bl3 = true;
            this.largestGray = ((Attribute)object).getIntegerValues()[0];
        }
        if (attribute3 != null && attribute4 != null && attribute5 != null && attribute3 != null && attribute3.getVM() == 3) {
            this.numberOfEntries = attribute3.getIntegerValues()[0];
            if (this.numberOfEntries == 0) {
                this.numberOfEntries = 65536;
            }
            this.firstValueMapped = attribute3.getIntegerValues()[1];
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PixelPresentation);
            if (!bl2 && !bl3 || attributeList.get(TagFromName.PhotometricInterpretation).getStringValues()[0].equals("PALETTE COLOR") || !((String)object).equals("COLOR") && !((String)object).equals("MIXED")) {
                this.largestGray = this.firstValueMapped - 1;
                slf4jlogger.debug("constructSourceImage(): not treating palette as supplemental, using firstValueMapped {} to set largestGray = {}", this.firstValueMapped, this.largestGray);
            } else {
                slf4jlogger.debug("constructSourceImage(): treating palette as supplemental, largestGray = {}", this.largestGray);
            }
            this.bitsPerEntry = attribute3.getIntegerValues()[2];
            if (this.bitsPerEntry > 0) {
                Attribute attribute6 = attributeList.get(TagFromName.RedPaletteColorLookupTableData);
                slf4jlogger.debug("constructSourceImage(): aRedPaletteColorLookupTableData = {}", attribute6);
                Attribute attribute7 = attributeList.get(TagFromName.GreenPaletteColorLookupTableData);
                Attribute attribute8 = attributeList.get(TagFromName.BluePaletteColorLookupTableData);
                if (attribute6 != null && attribute7 != null && attribute8 != null) {
                    slf4jlogger.debug("constructSourceImage(): setting color palette tables");
                    this.redTable = attribute6.getShortValues();
                    slf4jlogger.debug("constructSourceImage(): redTable = {}", new Object[]{this.redTable});
                    this.greenTable = attribute7.getShortValues();
                    this.blueTable = attribute8.getShortValues();
                    if (this.redTable == null || this.greenTable == null || this.blueTable == null || this.redTable.length == 0 || this.greenTable.length == 0 || this.blueTable.length == 0) {
                        slf4jlogger.warn("constructSourceImage(): bad color palette (empty data), ignoring");
                        this.redTable = null;
                        this.greenTable = null;
                        this.blueTable = null;
                    }
                }
            } else {
                slf4jlogger.warn("constructSourceImage(): bad color palette (zero value for bitsPerEntry), ignoring");
            }
        }
        slf4jlogger.debug("constructSourceImage(): largestGray={}", this.largestGray);
        try {
            for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                for (GraphicsConfiguration graphicsConfiguration : graphicsDevice.getConfigurations()) {
                    this.dstColorSpace = graphicsConfiguration.getColorModel().getColorSpace();
                    if (!slf4jlogger.isDebugEnabled()) continue;
                    slf4jlogger.debug("constructSourceImage(): Using GraphicsEnvironment derived dstColorSpace={} which is {}sRGB", this.dstColorSpace, this.dstColorSpace.isCS_sRGB() ? "" : "not ");
                }
            }
        }
        catch (HeadlessException headlessException) {
            this.dstColorSpace = ColorSpace.getInstance(1000);
            slf4jlogger.debug("constructSourceImage(): Using default sRGB for dstColorSpace because Headless");
        }
        if (this.dstColorSpace == null) {
            this.dstColorSpace = ColorSpace.getInstance(1000);
            slf4jlogger.debug("constructSourceImage(): Using default sRGB for dstColorSpace");
        }
        if (this.applyICCProfileIfPresent) {
            object = attributeList.get(TagFromName.ICCProfile);
            if (object == null) {
                slf4jlogger.debug("constructSourceImage(): No top level ICC Profile so check first item of OpticalPathSequence");
                object = SequenceAttribute.getNamedAttributeFromWithinSelectedItemWithinSequence(attributeList, TagFromName.OpticalPathSequence, 0, TagFromName.ICCProfile);
            }
            if (object != null) {
                byte[] byArray = ((Attribute)object).getByteValues();
                if (byArray == null) {
                    slf4jlogger.error("constructSourceImage(): ICC Profile present but unable to obtain byte values");
                } else if (byArray.length == 0) {
                    slf4jlogger.error("constructSourceImage(): ICC Profile present but zero length");
                } else {
                    slf4jlogger.trace("constructSourceImage(): ICC Profile length = {}", byArray.length);
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("constructSourceImage(): ICC Profile =\n{}\n", HexDump.dump(byArray));
                    }
                    try {
                        ICC_Profile iCC_Profile = ICC_Profile.getInstance(byArray);
                        slf4jlogger.debug("constructSourceImage(): read ICC Profile={}", iCC_Profile);
                        this.srcColorSpace = new ICC_ColorSpace(iCC_Profile);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        slf4jlogger.warn("constructSourceImage(): ", illegalArgumentException);
                        this.srcColorSpace = null;
                    }
                }
            }
            if (this.srcColorSpace == null) {
                slf4jlogger.debug("constructSourceImage(): Using sRGB as source color space since no ICC Profile detected");
                this.srcColorSpace = ColorSpace.getInstance(1000);
            }
        } else {
            slf4jlogger.debug("constructSourceImage(): Using sRGB as source color space and ignoring any ICC Profile");
            this.srcColorSpace = ColorSpace.getInstance(1000);
        }
        this.bufferedImageSource = null;
        this.imgs = null;
        int n8 = this.width * this.height;
        slf4jlogger.debug("constructSourceImage(): isChrominanceHorizontallyDownsampledBy2={}", this.isChrominanceHorizontallyDownsampledBy2);
        int n9 = this.isChrominanceHorizontallyDownsampledBy2 ? this.width * this.height + (n2 - 1) * this.width * this.height / 2 : n8 * n2;
        slf4jlogger.debug("constructSourceImage(): nframesamples={}", n9);
        int n10 = n9 * this.nframes;
        int n11 = n8 * this.nframes;
        slf4jlogger.debug("constructSourceImage(): isGrayscale={}", this.isGrayscale);
        slf4jlogger.debug("constructSourceImage(): samples={}", n2);
        slf4jlogger.debug("constructSourceImage(): depth={}", n);
        slf4jlogger.debug("constructSourceImage(): stored={}", n5);
        if ((this.isGrayscale || this.isPaletteColor) && n2 == 1 && n > 8 && n <= 16) {
            slf4jlogger.debug("constructSourceImage(): grayscale or palette color 9-16 bits");
            Attribute attribute9 = attributeList.getPixelData();
            slf4jlogger.debug("constructSourceImage(): PixelData class is {}", attribute9.getClass().toString());
            if (attribute9 instanceof OtherByteAttributeMultipleCompressedFrames) {
                byte[][] byArray = ((OtherByteAttributeMultipleCompressedFrames)attribute9).getFrames();
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                if (byArray == null) {
                    slf4jlogger.debug("constructSourceImage(): one or more compressed frames on disk");
                    ByteFrameSource byteFrameSource = (ByteFrameSource)((Object)attribute9);
                    this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(byteFrameSource, this.width, this.height, this.mask, n4, n3, this.largestGray, string2) : new UnsignedShortGrayscaleBufferedImageSource(byteFrameSource, this.width, this.height, this.mask, this.largestGray, string2);
                } else {
                    slf4jlogger.debug("constructSourceImage(): one or more compressed frames in memory");
                    this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, n4, n3, this.largestGray, string2) : new UnsignedShortGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, this.largestGray, string2);
                }
            } else if (attribute9 instanceof OtherByteAttributeCompressedSeparateFramesOnDisk) {
                slf4jlogger.debug("constructSourceImage(): one or more compressed frames on disk");
                ByteFrameSource byteFrameSource = (ByteFrameSource)((Object)attribute9);
                String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(byteFrameSource, this.width, this.height, this.mask, n4, n3, this.largestGray, string3) : new UnsignedShortGrayscaleBufferedImageSource(byteFrameSource, this.width, this.height, this.mask, this.largestGray, string3);
            } else if (allowMemoryMapping && attribute9 instanceof OtherWordAttributeOnDisk) {
                slf4jlogger.debug("constructSourceImage(): OW left on disk ... attempting memory mapping");
                try {
                    ShortBuffer[] shortBufferArray = this.getShortBuffersFromOtherWordAttributeOnDisk((OtherWordAttributeOnDisk)attribute9, this.nframes);
                    this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(shortBufferArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedShortGrayscaleBufferedImageSource(shortBufferArray, this.width, this.height, this.mask, this.largestGray);
                }
                catch (Throwable throwable) {
                    slf4jlogger.error("", throwable);
                    this.bufferedImageSource = null;
                }
            }
            if (this.bufferedImageSource == null) {
                if (attribute9 instanceof OtherWordAttributeOnDisk) {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("constructSourceImage(): OW left in single file on disk ... memory mapping {}", allowMemoryMapping ? "failed" : "disabled");
                    }
                    if (allowDeferredReadFromFileIfNotMemoryMapped) {
                        slf4jlogger.debug("constructSourceImage(): OW left in single file on disk ... using deferred read of shorts from multi-frame file");
                        String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                        boolean bl4 = TransferSyntax.isBigEndian(string4);
                        File file = ((OtherWordAttributeOnDisk)attribute9).getFile();
                        long[] lArray = new long[this.nframes];
                        long l = ((OtherWordAttributeOnDisk)attribute9).getByteOffset();
                        for (int i = 0; i < this.nframes; ++i) {
                            lArray[i] = l + (long)i * (long)n9 * 2L;
                        }
                        this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(file, lArray, bl4, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedShortGrayscaleBufferedImageSource(file, lArray, bl4, this.width, this.height, this.mask, this.largestGray);
                    } else {
                        slf4jlogger.debug("constructSourceImage(): OW left in single file on disk ... deferred read disabled, so reading into per frame short arrays rather than contiguous array for all frames");
                        short[][] sArrayArray = new short[this.nframes][];
                        for (int i = 0; i < this.nframes; ++i) {
                            sArrayArray[i] = ((OtherWordAttributeOnDisk)attribute9).getShortValuesForSelectedFrame(i, this.nframes);
                        }
                        this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(sArrayArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedShortGrayscaleBufferedImageSource(sArrayArray, this.width, this.height, this.mask, this.largestGray);
                    }
                } else if (attribute9 instanceof OtherWordAttributeMultipleFilesOnDisk) {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("constructSourceImage(): OW left in multiple files on disk ... memory mapping {}", allowMemoryMapping ? "failed" : "disabled");
                    }
                    if (allowDeferredReadFromFileIfNotMemoryMapped) {
                        slf4jlogger.debug("constructSourceImage(): OW left in multiple files on disk ... using deferred read of shorts from multi-frame file");
                        String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                        boolean bl5 = TransferSyntax.isBigEndian(string5);
                        File[] fileArray = ((OtherWordAttributeMultipleFilesOnDisk)attribute9).getFiles();
                        long[] lArray = ((OtherWordAttributeMultipleFilesOnDisk)attribute9).getByteOffsets();
                        this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(fileArray, lArray, bl5, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedShortGrayscaleBufferedImageSource(fileArray, lArray, bl5, this.width, this.height, this.mask, this.largestGray);
                    } else {
                        slf4jlogger.debug("constructSourceImage(): OW left in multiple files on disk ... deferred read disabled, so reading into per frame short arrays rather than contiguous array for all frames");
                        short[][] sArray = ((OtherWordAttributeMultipleFilesOnDisk)attribute9).getShortValuesPerFrame();
                        this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(sArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedShortGrayscaleBufferedImageSource(sArray, this.width, this.height, this.mask, this.largestGray);
                    }
                } else if (attribute9 instanceof OtherWordAttributeMultipleFrameArrays) {
                    slf4jlogger.debug("constructSourceImage(): data already in separate per frame arrays {}");
                    short[][] sArray = ((OtherWordAttributeMultipleFrameArrays)attribute9).getShortValuesPerFrame();
                    this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(sArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedShortGrayscaleBufferedImageSource(sArray, this.width, this.height, this.mask, this.largestGray);
                } else {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("constructSourceImage(): not deferred decompression, was not left on disk or memory mapping {} so using conventional heap allocated values for class {}", allowMemoryMapping ? "failed" : "disabled", attribute9.getClass());
                    }
                    short[] sArray = attribute9.getShortValues();
                    this.bufferedImageSource = this.signed ? new SignedShortGrayscaleBufferedImageSource(sArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedShortGrayscaleBufferedImageSource(sArray, this.width, this.height, this.mask, this.largestGray);
                }
            }
        } else if ((this.isGrayscale || this.isPaletteColor) && n2 == 1 && n <= 8 && n > 1) {
            Attribute attribute10;
            block214: {
                slf4jlogger.debug("constructSourceImage(): grayscale or palette color <= 8 bits");
                attribute10 = attributeList.getPixelData();
                slf4jlogger.debug("constructSourceImage(): PixelData class is {}", attribute10.getClass().toString());
                if (attribute10 instanceof OtherByteAttributeMultipleCompressedFrames) {
                    byte[][] byArray = ((OtherByteAttributeMultipleCompressedFrames)attribute10).getFrames();
                    String string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                    if (byArray == null) {
                        slf4jlogger.debug("constructSourceImage(): one or more compressed frames on disk");
                        ByteFrameSource byteFrameSource = (ByteFrameSource)((Object)attribute10);
                        this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(byteFrameSource, this.width, this.height, this.mask, n4, n3, this.largestGray, string6) : new UnsignedByteGrayscaleBufferedImageSource(byteFrameSource, this.width, this.height, this.mask, this.largestGray, string6);
                    } else {
                        slf4jlogger.debug("constructSourceImage(): one or more compressed frames in memory");
                        this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, n4, n3, this.largestGray, string6) : new UnsignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, this.largestGray, string6);
                    }
                } else if (attribute10 instanceof OtherByteAttributeCompressedSeparateFramesOnDisk) {
                    slf4jlogger.debug("constructSourceImage(): one or more compressed frames on disk");
                    ByteFrameSource byteFrameSource = (ByteFrameSource)((Object)attribute10);
                    String string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                    this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(byteFrameSource, this.width, this.height, this.mask, n4, n3, this.largestGray, string7) : new UnsignedByteGrayscaleBufferedImageSource(byteFrameSource, this.width, this.height, this.mask, this.largestGray, string7);
                } else if (allowMemoryMapping && attribute10 instanceof OtherWordAttributeOnDisk) {
                    slf4jlogger.debug("constructSourceImage(): OW left on disk ... attempting memory mapping");
                    try {
                        ShortBuffer[] shortBufferArray = this.getShortBuffersFromOtherWordAttributeOnDisk((OtherWordAttributeOnDisk)attribute10, this.nframes);
                        if (this.signed) {
                            this.bufferedImageSource = new SignedByteGrayscaleBufferedImageSource(shortBufferArray, this.width, this.height, this.mask, n4, n3, this.largestGray);
                            break block214;
                        }
                        this.bufferedImageSource = new UnsignedByteGrayscaleBufferedImageSource(shortBufferArray, this.width, this.height, this.mask, this.largestGray);
                    }
                    catch (Throwable throwable) {
                        slf4jlogger.error("", throwable);
                        this.bufferedImageSource = null;
                    }
                } else if (allowMemoryMapping && attribute10 instanceof OtherByteAttributeOnDisk) {
                    slf4jlogger.debug("constructSourceImage(): OB left on disk ... attempting memory mapping");
                    try {
                        ByteBuffer[] byteBufferArray = this.getByteBuffersFromOtherAttributeOnDisk((OtherByteAttributeOnDisk)attribute10, this.nframes);
                        this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(byteBufferArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(byteBufferArray, this.width, this.height, this.mask, this.largestGray);
                    }
                    catch (Throwable throwable) {
                        slf4jlogger.error("", throwable);
                        this.bufferedImageSource = null;
                    }
                }
            }
            if (this.bufferedImageSource == null) {
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("constructSourceImage(): not deferred decompression, was not left on disk or memory mapping {}", allowMemoryMapping ? "failed" : "disabled");
                }
                if (attribute10 instanceof OtherByteAttributeOnDisk) {
                    slf4jlogger.debug("constructSourceImage(): OB left on disk");
                    if (allowDeferredReadFromFileIfNotMemoryMapped) {
                        slf4jlogger.debug("constructSourceImage(): OB left on disk so using deferred read from from multi-frame file");
                        File file = ((OtherByteAttributeOnDisk)attribute10).getFile();
                        long[] lArray = new long[this.nframes];
                        long l = ((OtherByteAttributeOnDisk)attribute10).getByteOffset();
                        for (int i = 0; i < this.nframes; ++i) {
                            lArray[i] = l + (long)i * (long)n9;
                        }
                        this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(file, lArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(file, lArray, this.width, this.height, this.mask, this.largestGray);
                    } else {
                        slf4jlogger.debug("constructSourceImage(): OB left on disk and deferred read disabled so reading into separate per frame byte arrays");
                        byte[][] byArray = ((OtherByteAttributeOnDisk)attribute10).getByteValuesPerFrame(this.nframes);
                        this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, this.largestGray);
                    }
                } else if (attribute10 instanceof OtherByteAttributeMultipleFilesOnDisk) {
                    if (allowDeferredReadFromFileIfNotMemoryMapped) {
                        slf4jlogger.debug("constructSourceImage(): OB left on disk so using deferred read from from multiple files");
                        File[] fileArray = ((OtherByteAttributeMultipleFilesOnDisk)attribute10).getFiles();
                        long[] lArray = ((OtherByteAttributeMultipleFilesOnDisk)attribute10).getByteOffsets();
                        this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(fileArray, lArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(fileArray, lArray, this.width, this.height, this.mask, this.largestGray);
                    } else {
                        slf4jlogger.debug("constructSourceImage(): OB left on disk and deferred read disabled so reading into contiguous byte array");
                        byte[] byArray = ((OtherByteAttributeMultipleFilesOnDisk)attribute10).getByteValues();
                        this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, this.largestGray);
                    }
                } else if (attribute10 instanceof OtherWordAttributeOnDisk) {
                    slf4jlogger.debug("constructSourceImage(): OW left on disk");
                    String string8 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                    if (allowDeferredReadFromFileIfNotMemoryMapped && TransferSyntax.isLittleEndian(string8)) {
                        slf4jlogger.debug("constructSourceImage(): OW left on disk ... little-endian so using deferred read of bytes (i.e., as if OB) from multi-frame file");
                        File file = ((OtherWordAttributeOnDisk)attribute10).getFile();
                        long[] lArray = new long[this.nframes];
                        long l = ((OtherWordAttributeOnDisk)attribute10).getByteOffset();
                        for (int i = 0; i < this.nframes; ++i) {
                            lArray[i] = l + (long)i * (long)n9;
                        }
                        this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(file, lArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(file, lArray, this.width, this.height, this.mask, this.largestGray);
                    } else {
                        void var23_116;
                        slf4jlogger.debug("constructSourceImage(): OW left on disk ... deferred read disabled, so reading into per frame short arrays");
                        short[][] sArrayArray = new short[this.nframes][];
                        boolean bl6 = false;
                        while (var23_116 < this.nframes) {
                            sArrayArray[var23_116] = ((OtherWordAttributeOnDisk)attribute10).getShortValuesForSelectedFrame((int)var23_116, this.nframes);
                            ++var23_116;
                        }
                        this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(sArrayArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(sArrayArray, this.width, this.height, this.mask, this.largestGray);
                    }
                } else if (attribute10 instanceof OtherByteAttributeMultipleFrameArrays) {
                    slf4jlogger.debug("constructSourceImage(): have separate per frame byte arrays");
                    byte[][] byArray = ((OtherByteAttributeMultipleFrameArrays)attribute10).getByteValuesPerFrame();
                    this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, this.largestGray);
                } else if (attribute10 instanceof OtherByteAttribute) {
                    slf4jlogger.debug("constructSourceImage(): contiguous byte array");
                    byte[] byArray = attribute10.getByteValues();
                    this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(byArray, this.width, this.height, this.mask, this.largestGray);
                } else if (attribute10 instanceof OtherWordAttribute) {
                    slf4jlogger.debug("constructSourceImage(): contiguous short array");
                    short[] sArray = attribute10.getShortValues();
                    this.bufferedImageSource = this.signed ? new SignedByteGrayscaleBufferedImageSource(sArray, this.width, this.height, this.mask, n4, n3, this.largestGray) : new UnsignedByteGrayscaleBufferedImageSource(sArray, this.width, this.height, this.mask, this.largestGray);
                } else {
                    slf4jlogger.error("constructSourceImage(): {} is not recognized Attribute class from which to construct SourceImage", attribute10.getClass());
                }
            }
        } else if (this.isGrayscale && n2 == 1 && n == 1) {
            slf4jlogger.debug("constructSourceImage(): single bit");
            this.imgs = new BufferedImage[this.nframes];
            Object var20_37 = null;
            byte[] byArray = new byte[]{0, -1};
            byte[] byArray2 = new byte[]{0, -1};
            byte[] byArray3 = new byte[]{0, -1};
            IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray2, byArray3);
            this.imgMin = 0.0;
            this.imgMax = 1.0;
            Attribute attribute11 = attributeList.getPixelData();
            slf4jlogger.debug("constructSourceImage(): PixelData class is {}", attribute11.getClass().toString());
            int n12 = 0;
            boolean bl7 = false;
            int n13 = 0;
            slf4jlogger.debug("constructSourceImage(): {}", attribute11);
            if (ValueRepresentation.isOtherByteVR(attribute11.getVR())) {
                int n14;
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("constructSourceImage(): single bit from OB with {} bit order", "standard");
                }
                long l = System.currentTimeMillis();
                byte[] byArray4 = attribute11.getByteValues();
                for (int i = 0; i < this.nframes; ++i) {
                    this.imgs[i] = new BufferedImage(this.width, this.height, 12, indexColorModel);
                    Raster raster = this.imgs[i].getData();
                    SampleModel sampleModel = raster.getSampleModel();
                    DataBuffer dataBuffer = raster.getDataBuffer();
                    for (int j = 0; j < this.height; ++j) {
                        for (int k = 0; k < this.width; ++k) {
                            boolean bl8;
                            if (n14 <= 0) {
                                n13 = byArray4[n12++] & 0xFF;
                                n14 = 8;
                            }
                            if (bl8 = n13 & true) {
                                sampleModel.setSample(k, j, 0, 1, dataBuffer);
                            }
                            n13 >>>= 1;
                            --n14;
                        }
                    }
                    this.imgs[i].setData(raster);
                }
                long l2 = System.currentTimeMillis();
                slf4jlogger.info("constructSourceImage(): single bit read from OB = {} ms", l2 - l);
                slf4jlogger.debug("constructSourceImage(): single bit read complete - byte[] length = {}, last index used = {}, bitsRemaining = {}", byArray4.length, n12, n14);
            } else {
                int n15;
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("constructSourceImage(): single bit from OW with {} bit order", "standard");
                }
                long l = System.currentTimeMillis();
                short[] sArray = attribute11.getShortValues();
                for (int i = 0; i < this.nframes; ++i) {
                    this.imgs[i] = new BufferedImage(this.width, this.height, 12, indexColorModel);
                    Raster raster = this.imgs[i].getData();
                    SampleModel sampleModel = raster.getSampleModel();
                    DataBuffer dataBuffer = raster.getDataBuffer();
                    for (int j = 0; j < this.height; ++j) {
                        for (int k = 0; k < this.width; ++k) {
                            boolean bl9;
                            if (n15 <= 0) {
                                n13 = sArray[n12++] & 0xFFFF;
                                n15 = 16;
                            }
                            if (bl9 = n13 & true) {
                                sampleModel.setSample(k, j, 0, 1, dataBuffer);
                            }
                            n13 >>>= 1;
                            --n15;
                        }
                    }
                    this.imgs[i].setData(raster);
                }
                long l3 = System.currentTimeMillis();
                slf4jlogger.info("constructSourceImage(): single bit read from OW = {} ms", l3 - l);
                slf4jlogger.debug("constructSourceImage(): single bit read complete - short[] length = {}, last index used = {}, bitsRemaining = {}", sArray.length, n12, n15);
            }
        } else if (!this.isGrayscale && n2 == 3 && n <= 8 && n > 1) {
            void var20_41;
            void var21_80;
            void var23_124;
            slf4jlogger.debug("constructSourceImage(): not grayscale, is 3 channel and <= 8 bits");
            Object var20_39 = null;
            byte[][] byArray = null;
            ByteBuffer[] byteBufferArray = null;
            Object var23_121 = null;
            File file = null;
            File[] fileArray = null;
            long[] lArray = null;
            byte[][] byArray5 = null;
            ByteFrameSource byteFrameSource = null;
            String string9 = null;
            Attribute attribute12 = attributeList.getPixelData();
            slf4jlogger.debug("constructSourceImage(): PixelData class is {}", attribute12.getClass().toString());
            if (attribute12 instanceof OtherByteAttributeMultipleCompressedFrames) {
                byArray5 = ((OtherByteAttributeMultipleCompressedFrames)attribute12).getFrames();
                if (byArray5 == null) {
                    slf4jlogger.debug("constructSourceImage(): one or more compressed frames on disk");
                    byteFrameSource = (ByteFrameSource)((Object)attribute12);
                } else {
                    slf4jlogger.debug("constructSourceImage(): one or more compressed frames in memory");
                }
                string9 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                slf4jlogger.debug("constructSourceImage(): compressedDataTransferSyntaxUID = {}", string9);
            } else if (attribute12 instanceof OtherByteAttributeCompressedSeparateFramesOnDisk) {
                slf4jlogger.debug("constructSourceImage(): one or more compressed frames on disk");
                byteFrameSource = (ByteFrameSource)((Object)attribute12);
                string9 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                slf4jlogger.debug("constructSourceImage(): compressedDataTransferSyntaxUID = {}", string9);
            } else if (ValueRepresentation.isOtherByteVR(attribute12.getVR())) {
                if (allowMemoryMapping && attribute12 instanceof OtherByteAttributeOnDisk) {
                    slf4jlogger.debug("constructSourceImage(): OB left on disk ... attempting memory mapping from single large file");
                    try {
                        byteBufferArray = this.getByteBuffersFromOtherAttributeOnDisk((OtherByteAttributeOnDisk)attribute12, this.nframes);
                    }
                    catch (Throwable throwable) {
                        slf4jlogger.error("", throwable);
                    }
                } else if (attribute12 instanceof OtherByteAttributeMultipleFilesOnDisk) {
                    if (allowMemoryMapping && allowMemoryMappingFromMultiplePerFrameFiles) {
                        slf4jlogger.debug("constructSourceImage(): OB left on disk ... attempting memory mapping from individual files per frame");
                        try {
                            byteBufferArray = this.getByteBuffersFromOtherByteAttributeMultipleFilesOnDisk((OtherByteAttributeMultipleFilesOnDisk)attribute12, this.nframes);
                        }
                        catch (Throwable throwable) {
                            slf4jlogger.error("", throwable);
                        }
                    }
                    if (byteBufferArray == null) {
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("constructSourceImage(): OB left on disk ... memory mapping {}, using deferred read from individual files per frame", allowMemoryMapping ? "failed" : "disabled");
                        }
                        fileArray = ((OtherByteAttributeMultipleFilesOnDisk)attribute12).getFiles();
                        lArray = ((OtherByteAttributeMultipleFilesOnDisk)attribute12).getByteOffsets();
                    }
                }
                if (byteBufferArray == null && fileArray == null) {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("constructSourceImage(): OB not deferred decompression, was not left on disk or memory mapping {} so using conventional read or heap allocated values", allowMemoryMapping ? "failed" : "disabled");
                    }
                    if (attribute12 instanceof OtherByteAttributeMultipleFrameArrays) {
                        slf4jlogger.debug("constructSourceImage(): have separate per frame byte arrays");
                        byte[][] byArray6 = ((OtherByteAttributeMultipleFrameArrays)attribute12).getByteValuesPerFrame();
                    } else if (attribute12 instanceof OtherByteAttributeOnDisk) {
                        if (allowDeferredReadFromFileIfNotMemoryMapped) {
                            slf4jlogger.debug("constructSourceImage(): OB left on disk so using deferred read from from multi-frame file");
                            file = ((OtherByteAttributeOnDisk)attribute12).getFile();
                            lArray = new long[this.nframes];
                            long l = ((OtherByteAttributeOnDisk)attribute12).getByteOffset();
                            for (int i = 0; i < this.nframes; ++i) {
                                lArray[i] = l + (long)i * (long)n9;
                            }
                        } else {
                            slf4jlogger.debug("constructSourceImage(): OB left on disk and deferred read disabled so reading into separate per frame byte arrays");
                            byte[][] byArray7 = ((OtherByteAttributeOnDisk)attribute12).getByteValuesPerFrame(this.nframes);
                        }
                    } else {
                        slf4jlogger.debug("constructSourceImage(): have contiguous byte array");
                        byte[] byArray8 = attribute12.getByteValues();
                    }
                }
            } else {
                slf4jlogger.debug("constructSourceImage(): OW rather than OB");
                if (attribute12 instanceof OtherWordAttributeOnDisk) {
                    if (allowMemoryMapping) {
                        slf4jlogger.debug("constructSourceImage(): OW left on disk ... attempting memory mapping");
                        try {
                            ShortBuffer[] shortBufferArray = this.getShortBuffersFromOtherWordAttributeOnDisk((OtherWordAttributeOnDisk)attribute12, this.nframes);
                        }
                        catch (Throwable throwable) {
                            slf4jlogger.error("", throwable);
                            Object var23_123 = null;
                        }
                    }
                    if (var23_124 == null) {
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("constructSourceImage(): OW left on disk ... memory mapping {}", allowMemoryMapping ? "failed" : "disabled");
                        }
                        String string10 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                        if (allowDeferredReadFromFileIfNotMemoryMapped && TransferSyntax.isLittleEndian(string10)) {
                            slf4jlogger.debug("constructSourceImage(): OW left on disk ... little-endian so using deferred read of bytes (i.e., as if OB) from multi-frame file");
                            file = ((OtherWordAttributeOnDisk)attribute12).getFile();
                            lArray = new long[this.nframes];
                            long l = ((OtherWordAttributeOnDisk)attribute12).getByteOffset();
                            for (int i = 0; i < this.nframes; ++i) {
                                lArray[i] = l + (long)i * (long)n9;
                            }
                        } else {
                            slf4jlogger.debug("constructSourceImage(): OW left on disk ... not little endian or deferred read disabled, so reading into per frame byte arrays rather than contiguous array for all frames");
                            byte[][] byArrayArray = new byte[this.nframes][];
                            for (int i = 0; i < this.nframes; ++i) {
                                short[] sArray = ((OtherWordAttributeOnDisk)attribute12).getShortValuesForSelectedFrame(i, this.nframes);
                                byArrayArray[i] = SourceImage.getByteArrayForFrameFromSingleFrameShortArray(sArray, n9);
                            }
                        }
                    }
                } else {
                    slf4jlogger.debug("constructSourceImage(): OW was not left on disk ... is contiguous array of shorts but split into per frame byte arrays rather than contiguous array for all frames");
                    short[] sArray = attribute12.getShortValues();
                    byte[][] byArrayArray = new byte[this.nframes][];
                    for (int i = 0; i < this.nframes; ++i) {
                        byArrayArray[i] = SourceImage.getByteArrayForFrameFromMultiFrameShortArray(i, sArray, n9);
                    }
                }
            }
            if (byArray5 != null) {
                CompressedByteThreeComponentColorBufferedImageSource compressedByteThreeComponentColorBufferedImageSource = new CompressedByteThreeComponentColorBufferedImageSource(byArray5, this.width, this.height, this.srcColorSpace, string9, this.codecConvertsYBRtoRGB);
                this.bufferedImageSource = compressedByteThreeComponentColorBufferedImageSource;
            } else if (byteFrameSource != null) {
                CompressedByteThreeComponentColorBufferedImageSource compressedByteThreeComponentColorBufferedImageSource = new CompressedByteThreeComponentColorBufferedImageSource(byteFrameSource, this.width, this.height, this.srcColorSpace, string9, this.codecConvertsYBRtoRGB);
                this.bufferedImageSource = compressedByteThreeComponentColorBufferedImageSource;
            } else if (bl) {
                if (this.isChrominanceHorizontallyDownsampledBy2) {
                    throw new DicomException("Uncompressed YBR_FULL_422 requires pixel not band interleaved PlanarConfiguration");
                }
                this.bufferedImageSource = byteBufferArray != null ? new BandInterleavedByteThreeComponentColorBufferedImageSource(byteBufferArray, this.width, this.height, this.srcColorSpace) : (var23_124 != null ? new BandInterleavedByteThreeComponentColorBufferedImageSource((ShortBuffer[])var23_124, this.width, this.height, this.srcColorSpace) : (var21_80 != null ? new BandInterleavedByteThreeComponentColorBufferedImageSource((byte[][])var21_80, this.width, this.height, this.srcColorSpace) : (fileArray != null ? new BandInterleavedByteThreeComponentColorBufferedImageSource(fileArray, lArray, this.width, this.height, this.srcColorSpace) : (file != null ? new BandInterleavedByteThreeComponentColorBufferedImageSource(file, lArray, this.width, this.height, this.srcColorSpace) : new BandInterleavedByteThreeComponentColorBufferedImageSource((byte[])var20_41, this.width, this.height, this.srcColorSpace)))));
            } else {
                this.bufferedImageSource = byteBufferArray != null ? new PixelInterleavedByteThreeComponentColorBufferedImageSource(byteBufferArray, this.width, this.height, this.srcColorSpace, this.isChrominanceHorizontallyDownsampledBy2) : (var23_124 != null ? new PixelInterleavedByteThreeComponentColorBufferedImageSource((ShortBuffer[])var23_124, this.width, this.height, this.srcColorSpace, this.isChrominanceHorizontallyDownsampledBy2) : (var21_80 != null ? new PixelInterleavedByteThreeComponentColorBufferedImageSource((byte[][])var21_80, this.width, this.height, this.srcColorSpace, this.isChrominanceHorizontallyDownsampledBy2) : (fileArray != null ? new PixelInterleavedByteThreeComponentColorBufferedImageSource(fileArray, lArray, this.width, this.height, this.srcColorSpace, this.isChrominanceHorizontallyDownsampledBy2) : (file != null ? new PixelInterleavedByteThreeComponentColorBufferedImageSource(file, lArray, this.width, this.height, this.srcColorSpace, this.isChrominanceHorizontallyDownsampledBy2) : new PixelInterleavedByteThreeComponentColorBufferedImageSource((byte[])var20_41, this.width, this.height, this.srcColorSpace, this.isChrominanceHorizontallyDownsampledBy2)))));
            }
        } else if (!this.isGrayscale && n2 == 3 && n <= 16 && n > 8) {
            void var20_44;
            void var23_127;
            void var21_86;
            slf4jlogger.debug("constructSourceImage(): not grayscale, is 3 channel and > 8 but <= 16 bits");
            Object var20_42 = null;
            short[][] sArray = null;
            ShortBuffer[] shortBufferArray = null;
            Object var23_125 = null;
            long[] lArray = null;
            Attribute attribute13 = attributeList.getPixelData();
            slf4jlogger.debug("constructSourceImage(): PixelData class is {}", attribute13.getClass().toString());
            if (!ValueRepresentation.isOtherWordVR(attribute13.getVR())) throw new DicomException("Unsupported 16 bit color image encoding");
            slf4jlogger.debug("constructSourceImage(): OW VR");
            if (attribute13 instanceof OtherWordAttributeOnDisk) {
                if (allowMemoryMapping) {
                    slf4jlogger.debug("constructSourceImage(): OW left on disk ... attempting memory mapping");
                    try {
                        shortBufferArray = this.getShortBuffersFromOtherWordAttributeOnDisk((OtherWordAttributeOnDisk)attribute13, this.nframes);
                    }
                    catch (Throwable throwable) {
                        slf4jlogger.error("", throwable);
                        shortBufferArray = null;
                    }
                }
                if (shortBufferArray == null) {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("constructSourceImage(): OW left on disk ... memory mapping {}", allowMemoryMapping ? "failed" : "disabled");
                    }
                    String string11 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                    if (allowDeferredReadFromFileIfNotMemoryMapped && TransferSyntax.isLittleEndian(string11)) {
                        slf4jlogger.debug("constructSourceImage(): OW left on disk ... little-endian so using deferred read of bytes from multi-frame file");
                        File file = ((OtherWordAttributeOnDisk)attribute13).getFile();
                        lArray = new long[this.nframes];
                        long l = ((OtherWordAttributeOnDisk)attribute13).getByteOffset();
                        for (int i = 0; i < this.nframes; ++i) {
                            lArray[i] = l + (long)i * (long)n9;
                        }
                    } else {
                        slf4jlogger.debug("constructSourceImage(): OW left on disk ... not little endian or deferred read disabled, so reading into per frame short arrays rather than contiguous array for all frames");
                        short[][] sArrayArray = new short[this.nframes][];
                        for (int i = 0; i < this.nframes; ++i) {
                            sArrayArray[i] = ((OtherWordAttributeOnDisk)attribute13).getShortValuesForSelectedFrame(i, this.nframes);
                        }
                    }
                }
            } else if (attribute13 instanceof OtherWordAttributeMultipleFrameArrays) {
                slf4jlogger.debug("constructSourceImage(): OW in memory as per frame short arrays rather than contiguous array for all frames");
                for (int i = 0; i < this.nframes; ++i) {
                    short[][] sArray2 = ((OtherWordAttributeMultipleFrameArrays)attribute13).getShortValuesPerFrame();
                }
            } else {
                slf4jlogger.debug("constructSourceImage(): OW was not left on disk ... is contiguous array of shorts");
                short[] sArray3 = attribute13.getShortValues();
            }
            if (bl) {
                if (shortBufferArray != null) {
                    this.bufferedImageSource = new BandInterleavedShortThreeComponentColorBufferedImageSource(shortBufferArray, this.width, this.height, this.srcColorSpace);
                } else if (var21_86 != null) {
                    this.bufferedImageSource = new BandInterleavedShortThreeComponentColorBufferedImageSource((short[][])var21_86, this.width, this.height, this.srcColorSpace);
                } else if (var23_127 != null) {
                    String string12 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                    boolean bl10 = TransferSyntax.isBigEndian(string12);
                    this.bufferedImageSource = new BandInterleavedShortThreeComponentColorBufferedImageSource((File)var23_127, lArray, bl10, this.width, this.height, this.srcColorSpace);
                } else {
                    this.bufferedImageSource = new BandInterleavedShortThreeComponentColorBufferedImageSource((short[])var20_44, this.width, this.height, this.srcColorSpace);
                }
            } else if (shortBufferArray != null) {
                this.bufferedImageSource = new PixelInterleavedShortThreeComponentColorBufferedImageSource(shortBufferArray, this.width, this.height, this.srcColorSpace);
            } else if (var21_86 != null) {
                this.bufferedImageSource = new PixelInterleavedShortThreeComponentColorBufferedImageSource((short[][])var21_86, this.width, this.height, this.srcColorSpace);
            } else if (var23_127 != null) {
                String string13 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID);
                boolean bl11 = TransferSyntax.isBigEndian(string13);
                this.bufferedImageSource = new PixelInterleavedShortThreeComponentColorBufferedImageSource((File)var23_127, lArray, bl11, this.width, this.height, this.srcColorSpace);
            } else {
                this.bufferedImageSource = new PixelInterleavedShortThreeComponentColorBufferedImageSource((short[])var20_44, this.width, this.height, this.srcColorSpace);
            }
        } else if (this.isGrayscale && n2 == 1 && n == 32) {
            slf4jlogger.debug("constructSourceImage(): 32 bit image");
            Attribute attribute14 = attributeList.getPixelData();
            slf4jlogger.debug("constructSourceImage(): PixelData class is {}", attribute14.getClass().toString());
            if (attribute14 == null || !(attribute14 instanceof OtherFloatAttribute)) throw new DicomException("Unsupported 32 bit grayscale image encoding");
            float[] fArray = attribute14.getFloatValues();
            this.bufferedImageSource = new FloatGrayscaleBufferedImageSource(fArray, this.width, this.height);
        } else {
            if (!this.isGrayscale || n2 != 1 || n != 64) throw new DicomException("Unsupported image encoding: Photometric Interpretation = \"" + string + "\", samples = " + n2 + "\", Bits Allocated = " + n + ", Bits Stored = " + n5);
            slf4jlogger.debug("constructSourceImage(): 64 bit image");
            Attribute attribute15 = attributeList.getPixelData();
            slf4jlogger.debug("constructSourceImage(): PixelData class is {}", attribute15.getClass().toString());
            if (attribute15 == null || !(attribute15 instanceof OtherDoubleAttribute)) throw new DicomException("Unsupported 64 bit grayscale image encoding");
            double[] dArray = attribute15.getDoubleValues();
            this.bufferedImageSource = new DoubleGrayscaleBufferedImageSource(dArray, this.width, this.height);
        }
        if (this.bufferedImageSource == null && this.imgs == null) {
            throw new DicomException("Failed to created a BufferedImage source or array of BufferedImage");
        }
        slf4jlogger.debug("constructSourceImage(): imgMin={}", this.imgMin);
        slf4jlogger.debug("constructSourceImage(): imgMax={}", this.imgMax);
        this.suvTransform = new SUVTransform(attributeList);
        this.realWorldValueTransform = new RealWorldValueTransform(attributeList);
        slf4jlogger.debug("constructSourceImage(): realWorldValueTransform={}", this.realWorldValueTransform);
        this.modalityTransform = new ModalityTransform(attributeList);
        this.voiTransform = new VOITransform(attributeList);
        this.displayShutter = new DisplayShutter(attributeList);
        this.overlay = new Overlay(attributeList);
        this.backgroundValue = this.hasPad ? this.pad : (this.isGrayscale ? (this.inverted ? (this.signed ? this.mask >> 1 : this.mask) : (this.signed ? (this.mask >> 1) + 1 | n3 : 0)) : 0);
        slf4jlogger.debug("constructSourceImage(): backgroundValue={}", this.backgroundValue);
        slf4jlogger.debug("constructSourceImage(): constructSourceImage - end");
    }

    public BufferedImage getBufferedImage() {
        return this.getBufferedImage(0);
    }

    public BufferedImage getBufferedImage(boolean bl) {
        return this.getBufferedImage(0, bl);
    }

    public BufferedImage getBufferedImage(int n) {
        return this.getBufferedImage(n, true);
    }

    public BufferedImage getBufferedImage(int n, boolean bl) {
        Object object;
        BufferedImage bufferedImage = null;
        if (this.bufferedImageSource == null) {
            slf4jlogger.debug("getBufferedImage(): from array not source - frame {}", n);
            bufferedImage = this.imgs == null || n < 0 || n >= this.imgs.length ? null : this.imgs[n];
        } else {
            slf4jlogger.debug("getBufferedImage(): from bufferedImageSource - frame {}", n);
            bufferedImage = this.bufferedImageSource.getBufferedImage(n);
            if (bl && bufferedImage.getColorModel().getColorSpace().getType() == 5 && this.srcColorSpace != null && this.dstColorSpace != null && this.srcColorSpace != this.dstColorSpace) {
                slf4jlogger.debug("getBufferedImage(): have color image with different source and destination color spaces - converting");
                try {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("getBufferedImage(): System.getProperty(\"sun.java2d.cmm\") = {}", System.getProperty("sun.java2d.cmm"));
                    }
                    object = new ColorConvertOp(this.srcColorSpace, this.dstColorSpace, new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
                    BufferedImage bufferedImage2 = ((ColorConvertOp)object).filter(bufferedImage, null);
                    slf4jlogger.debug("getBufferedImage(): have converted color image ={}", bufferedImage2);
                    bufferedImage = bufferedImage2;
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
        }
        if (bufferedImage != null && this.clipRects != null && (object = this.clipRects[n]) != null) {
            bufferedImage = BufferedImageUtilities.clipToRectangleWithGraphicsDraw(bufferedImage, (Rectangle)object, Color.BLACK);
        }
        if (bufferedImage != null && this.bufferedImageSource != null) {
            this.imgMin = this.bufferedImageSource.getMinimumPixelValueOfMostRecentBufferedImage(this.imgMin);
            this.imgMax = this.bufferedImageSource.getMaximumPixelValueOfMostRecentBufferedImage(this.imgMax);
        }
        return bufferedImage;
    }

    public int getNumberOfBufferedImages() {
        return this.nframes;
    }

    public boolean isImage() {
        return this.bufferedImageSource != null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public double getMinimum() {
        return this.imgMin;
    }

    public double getMaximum() {
        return this.imgMax;
    }

    public int getMaskValue() {
        return this.mask;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public boolean isPadded() {
        return this.hasPad;
    }

    public int getPadValue() {
        return this.pad;
    }

    public int getPadRangeLimit() {
        return this.padRangeLimit;
    }

    public int getBackgroundValue() {
        return this.backgroundValue;
    }

    public boolean isGrayscale() {
        return this.isGrayscale;
    }

    public boolean isYBR() {
        return this.isYBR;
    }

    public String getTitle() {
        return this.title;
    }

    public int getNumberOfFrames() {
        return this.nframes;
    }

    public int getPaletteColorLargestGray() {
        return this.largestGray;
    }

    public int getPaletteColorFirstValueMapped() {
        return this.firstValueMapped;
    }

    public int getPaletteColorNumberOfEntries() {
        return this.numberOfEntries;
    }

    public int getPaletteColorBitsPerEntry() {
        return this.bitsPerEntry;
    }

    public short[] getPaletteColorRedTable() {
        return this.redTable;
    }

    public short[] getPaletteColorGreenTable() {
        return this.greenTable;
    }

    public short[] getPaletteColorBlueTable() {
        return this.blueTable;
    }

    public SUVTransform getSUVTransform() {
        return this.suvTransform;
    }

    public RealWorldValueTransform getRealWorldValueTransform() {
        return this.realWorldValueTransform;
    }

    public ModalityTransform getModalityTransform() {
        return this.modalityTransform;
    }

    public VOITransform getVOITransform() {
        return this.voiTransform;
    }

    public DisplayShutter getDisplayShutter() {
        return this.displayShutter;
    }

    public Overlay getOverlay() {
        return this.overlay;
    }

    private class DoubleGrayscaleBufferedImageSource
    extends BufferedImageSource {
        protected double[] data;
        protected double imgMin;
        protected double imgMax;
        protected boolean minMaxSet;

        @Override
        public double getMinimumPixelValueOfMostRecentBufferedImage(double d) {
            return this.minMaxSet ? this.imgMin : d;
        }

        @Override
        public double getMaximumPixelValueOfMostRecentBufferedImage(double d) {
            return this.minMaxSet ? this.imgMax : d;
        }

        @Override
        protected void finalize() throws Throwable {
            slf4jlogger.debug("DoubleGrayscaleBufferedImageSource.finalize()");
            this.data = null;
            super.finalize();
        }

        DoubleGrayscaleBufferedImageSource(double[] dArray, int n, int n2) {
            super(n * n2);
            this.data = dArray;
            this.minMaxSet = false;
            this.imgMin = Double.MAX_VALUE;
            this.imgMax = Double.MIN_VALUE;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("DoubleGrayscaleBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            double[] dArray = this.data;
            int n2 = this.nframesamples * n;
            double[] dArray2 = new double[this.nframesamples];
            int n3 = n2;
            for (int i = 0; i < this.nframesamples; ++i) {
                double d;
                dArray2[i] = d = dArray[n3];
                if (d > this.imgMax) {
                    this.imgMax = d;
                }
                if (d < this.imgMin) {
                    this.imgMin = d;
                }
                ++n3;
            }
            this.minMaxSet = true;
            return SourceImage.createDoubleGrayscaleImage(SourceImage.this.width, SourceImage.this.height, dArray2, 0);
        }
    }

    private class FloatGrayscaleBufferedImageSource
    extends BufferedImageSource {
        protected float[] data;
        protected float imgMin;
        protected float imgMax;
        protected boolean minMaxSet;

        @Override
        public double getMinimumPixelValueOfMostRecentBufferedImage(double d) {
            return this.minMaxSet ? (double)this.imgMin : d;
        }

        @Override
        public double getMaximumPixelValueOfMostRecentBufferedImage(double d) {
            return this.minMaxSet ? (double)this.imgMax : d;
        }

        @Override
        protected void finalize() throws Throwable {
            slf4jlogger.debug("FloatGrayscaleBufferedImageSource.finalize()");
            this.data = null;
            super.finalize();
        }

        FloatGrayscaleBufferedImageSource(float[] fArray, int n, int n2) {
            super(n * n2);
            this.data = fArray;
            this.minMaxSet = false;
            this.imgMin = Float.MAX_VALUE;
            this.imgMax = Float.MIN_VALUE;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("FloatGrayscaleBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            float[] fArray = this.data;
            int n2 = this.nframesamples * n;
            float[] fArray2 = new float[this.nframesamples];
            int n3 = n2;
            for (int i = 0; i < this.nframesamples; ++i) {
                float f;
                fArray2[i] = f = fArray[n3];
                if (f > this.imgMax) {
                    this.imgMax = f;
                }
                if (f < this.imgMin) {
                    this.imgMin = f;
                }
                ++n3;
            }
            this.minMaxSet = true;
            return SourceImage.createFloatGrayscaleImage(SourceImage.this.width, SourceImage.this.height, fArray2, 0);
        }
    }

    private class CompressedByteThreeComponentColorBufferedImageSource
    extends BufferedImageSource {
        CompressedFrameDecoder decoder;
        ColorSpace colorSpace;

        CompressedByteThreeComponentColorBufferedImageSource(byte[][] byArray, int n, int n2, ColorSpace colorSpace, String string, boolean bl) {
            super(n * n2 * 3);
            try {
                slf4jlogger.debug("CompressedByteThreeComponentColorBufferedImageSource(): creating CompressedFrameDecoder for in memory compressedData with bytesPerSample = 1");
                this.decoder = new CompressedFrameDecoder(string, byArray, 1, n, n2, 3, colorSpace, bl);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                this.decoder = null;
            }
            this.colorSpace = colorSpace;
        }

        CompressedByteThreeComponentColorBufferedImageSource(ByteFrameSource byteFrameSource, int n, int n2, ColorSpace colorSpace, String string, boolean bl) {
            super(n * n2 * 3);
            try {
                slf4jlogger.debug("CompressedByteThreeComponentColorBufferedImageSource(): creating CompressedFrameDecoder for on disk compressedDataFrameSource with bytesPerSample = 1");
                this.decoder = new CompressedFrameDecoder(string, byteFrameSource, 1, n, n2, 3, colorSpace, bl);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                this.decoder = null;
            }
            this.colorSpace = colorSpace;
        }

        public boolean getColorSpaceConvertedToRGBDuringDecompression() {
            return this.decoder == null ? false : this.decoder.getColorSpaceConvertedToRGBDuringDecompression();
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("CompressedByteThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            BufferedImage bufferedImage = null;
            if (this.decoder != null) {
                try {
                    bufferedImage = this.decoder.getDecompressedFrameAsBufferedImage(n);
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                }
            } else {
                slf4jlogger.debug("CompressedByteThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): could not get decompressed frame {}", n);
            }
            return bufferedImage;
        }

        @Override
        public double getMinimumPixelValueOfMostRecentBufferedImage(double d) {
            return 0.0;
        }

        @Override
        public double getMaximumPixelValueOfMostRecentBufferedImage(double d) {
            return 255.0;
        }

        @Override
        protected void finalize() throws Throwable {
            slf4jlogger.debug("CompressedByteThreeComponentColorBufferedImageSource.finalize()");
            if (this.decoder != null) {
                try {
                    this.decoder.dispose();
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
            super.finalize();
        }
    }

    private class PixelInterleavedShortThreeComponentColorBufferedImageSource
    extends ShortBufferedImageSource {
        ColorSpace colorSpace;

        PixelInterleavedShortThreeComponentColorBufferedImageSource(short[] sArray, int n, int n2, ColorSpace colorSpace) {
            super(sArray, n * n2 * (SourceImage.this.isChrominanceHorizontallyDownsampledBy2 ? 2 : 3));
            this.colorSpace = colorSpace;
        }

        PixelInterleavedShortThreeComponentColorBufferedImageSource(short[][] sArray, int n, int n2, ColorSpace colorSpace) {
            super(sArray, n * n2 * (SourceImage.this.isChrominanceHorizontallyDownsampledBy2 ? 2 : 3));
            this.colorSpace = colorSpace;
        }

        PixelInterleavedShortThreeComponentColorBufferedImageSource(ShortBuffer[] shortBufferArray, int n, int n2, ColorSpace colorSpace) {
            super(shortBufferArray, n * n2 * (SourceImage.this.isChrominanceHorizontallyDownsampledBy2 ? 2 : 3));
            this.colorSpace = colorSpace;
        }

        PixelInterleavedShortThreeComponentColorBufferedImageSource(File file, long[] lArray, boolean bl, int n, int n2, ColorSpace colorSpace) {
            super(file, lArray, bl, n * n2 * (SourceImage.this.isChrominanceHorizontallyDownsampledBy2 ? 2 : 3));
            this.colorSpace = colorSpace;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("PixelInterleavedShortThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            slf4jlogger.debug("PixelInterleavedShortThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): nframesamples = {}", this.nframesamples);
            short[] sArray = this.getDataForFrameIfNotOffsetInContiguousAllocation(n);
            int n2 = 0;
            if (sArray == null) {
                slf4jlogger.debug("PixelInterleavedShortThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous short allocated memory for all frames", n);
                sArray = this.data;
                n2 = this.nframesamples * n;
            }
            return SourceImage.createPixelInterleavedShortThreeComponentColorImage(SourceImage.this.width, SourceImage.this.height, sArray, n2, this.colorSpace);
        }

        @Override
        public double getMinimumPixelValueOfMostRecentBufferedImage(double d) {
            return 0.0;
        }

        @Override
        public double getMaximumPixelValueOfMostRecentBufferedImage(double d) {
            return 65535.0;
        }
    }

    private class BandInterleavedShortThreeComponentColorBufferedImageSource
    extends ShortBufferedImageSource {
        ColorSpace colorSpace;

        BandInterleavedShortThreeComponentColorBufferedImageSource(short[] sArray, int n, int n2, ColorSpace colorSpace) {
            super(sArray, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        BandInterleavedShortThreeComponentColorBufferedImageSource(short[][] sArray, int n, int n2, ColorSpace colorSpace) {
            super(sArray, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        BandInterleavedShortThreeComponentColorBufferedImageSource(ShortBuffer[] shortBufferArray, int n, int n2, ColorSpace colorSpace) {
            super(shortBufferArray, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        BandInterleavedShortThreeComponentColorBufferedImageSource(File file, long[] lArray, boolean bl, int n, int n2, ColorSpace colorSpace) {
            super(file, lArray, bl, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("BandInterleavedShortThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            slf4jlogger.debug("BandInterleavedShortThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): nframesamples = {}", this.nframesamples);
            short[] sArray = this.getDataForFrameIfNotOffsetInContiguousAllocation(n);
            int n2 = 0;
            if (sArray == null) {
                slf4jlogger.debug("BandInterleavedShortThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous allocated memory for all frames", n);
                sArray = this.data;
                n2 = this.nframesamples * n;
            }
            return SourceImage.createBandInterleavedShortThreeComponentColorImage(SourceImage.this.width, SourceImage.this.height, sArray, n2, this.colorSpace);
        }

        @Override
        public double getMinimumPixelValueOfMostRecentBufferedImage(double d) {
            return 0.0;
        }

        @Override
        public double getMaximumPixelValueOfMostRecentBufferedImage(double d) {
            return 65535.0;
        }
    }

    private class PixelInterleavedByteThreeComponentColorBufferedImageSource
    extends ByteBufferedImageSource {
        ColorSpace colorSpace;
        boolean isChrominanceHorizontallyDownsampledBy2;

        PixelInterleavedByteThreeComponentColorBufferedImageSource(byte[] byArray, int n, int n2, ColorSpace colorSpace, boolean bl) {
            super(byArray, n * n2 * (bl ? 2 : 3));
            this.colorSpace = colorSpace;
            this.isChrominanceHorizontallyDownsampledBy2 = bl;
        }

        PixelInterleavedByteThreeComponentColorBufferedImageSource(byte[][] byArray, int n, int n2, ColorSpace colorSpace, boolean bl) {
            super(byArray, n * n2 * (bl ? 2 : 3));
            this.colorSpace = colorSpace;
            this.isChrominanceHorizontallyDownsampledBy2 = bl;
        }

        PixelInterleavedByteThreeComponentColorBufferedImageSource(ByteBuffer[] byteBufferArray, int n, int n2, ColorSpace colorSpace, boolean bl) {
            super(byteBufferArray, n * n2 * (bl ? 2 : 3));
            this.colorSpace = colorSpace;
            this.isChrominanceHorizontallyDownsampledBy2 = bl;
        }

        PixelInterleavedByteThreeComponentColorBufferedImageSource(ShortBuffer[] shortBufferArray, int n, int n2, ColorSpace colorSpace, boolean bl) {
            super(shortBufferArray, n * n2 * (bl ? 2 : 3));
            this.colorSpace = colorSpace;
            this.isChrominanceHorizontallyDownsampledBy2 = bl;
        }

        PixelInterleavedByteThreeComponentColorBufferedImageSource(File[] fileArray, long[] lArray, int n, int n2, ColorSpace colorSpace, boolean bl) {
            super(fileArray, lArray, n * n2 * (bl ? 2 : 3));
            this.colorSpace = colorSpace;
            this.isChrominanceHorizontallyDownsampledBy2 = bl;
        }

        PixelInterleavedByteThreeComponentColorBufferedImageSource(File file, long[] lArray, int n, int n2, ColorSpace colorSpace, boolean bl) {
            super(file, lArray, n * n2 * (bl ? 2 : 3));
            this.colorSpace = colorSpace;
            this.isChrominanceHorizontallyDownsampledBy2 = bl;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("PixelInterleavedByteThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            slf4jlogger.debug("PixelInterleavedByteThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): nframesamples = {}", this.nframesamples);
            slf4jlogger.debug("PixelInterleavedByteThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): isChrominanceHorizontallyDownsampledBy2 = {}", this.isChrominanceHorizontallyDownsampledBy2);
            byte[] byArray = this.getDataForFrameIfNotOffsetInContiguousAllocation(n);
            int n2 = 0;
            if (byArray == null) {
                slf4jlogger.debug("PixelInterleavedByteThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous byte allocated memory for all frames", n);
                byArray = this.byteData;
                n2 = this.nframesamples * n;
            }
            return SourceImage.createPixelInterleavedByteThreeComponentColorImage(SourceImage.this.width, SourceImage.this.height, byArray, n2, this.colorSpace, this.isChrominanceHorizontallyDownsampledBy2);
        }

        @Override
        public double getMinimumPixelValueOfMostRecentBufferedImage(double d) {
            return 0.0;
        }

        @Override
        public double getMaximumPixelValueOfMostRecentBufferedImage(double d) {
            return 255.0;
        }
    }

    private class BandInterleavedByteThreeComponentColorBufferedImageSource
    extends ByteBufferedImageSource {
        ColorSpace colorSpace;

        BandInterleavedByteThreeComponentColorBufferedImageSource(byte[] byArray, int n, int n2, ColorSpace colorSpace) {
            super(byArray, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        BandInterleavedByteThreeComponentColorBufferedImageSource(byte[][] byArray, int n, int n2, ColorSpace colorSpace) {
            super(byArray, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        BandInterleavedByteThreeComponentColorBufferedImageSource(ByteBuffer[] byteBufferArray, int n, int n2, ColorSpace colorSpace) {
            super(byteBufferArray, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        BandInterleavedByteThreeComponentColorBufferedImageSource(ShortBuffer[] shortBufferArray, int n, int n2, ColorSpace colorSpace) {
            super(shortBufferArray, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        BandInterleavedByteThreeComponentColorBufferedImageSource(File[] fileArray, long[] lArray, int n, int n2, ColorSpace colorSpace) {
            super(fileArray, lArray, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        BandInterleavedByteThreeComponentColorBufferedImageSource(File file, long[] lArray, int n, int n2, ColorSpace colorSpace) {
            super(file, lArray, n * n2 * 3);
            this.colorSpace = colorSpace;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("BandInterleavedByteThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            slf4jlogger.debug("BandInterleavedByteThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): nframesamples = {}", this.nframesamples);
            byte[] byArray = this.getDataForFrameIfNotOffsetInContiguousAllocation(n);
            int n2 = 0;
            if (byArray == null) {
                slf4jlogger.debug("BandInterleavedByteThreeComponentColorBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous allocated memory for all frames", n);
                byArray = this.byteData;
                n2 = this.nframesamples * n;
            }
            return SourceImage.createBandInterleavedByteThreeComponentColorImage(SourceImage.this.width, SourceImage.this.height, byArray, n2, this.colorSpace);
        }

        @Override
        public double getMinimumPixelValueOfMostRecentBufferedImage(double d) {
            return 0.0;
        }

        @Override
        public double getMaximumPixelValueOfMostRecentBufferedImage(double d) {
            return 255.0;
        }
    }

    private class ByteGrayscaleBufferedImageSource
    extends ByteBufferedImageSource {
        ByteGrayscaleBufferedImageSource(byte[] byArray, int n, int n2) {
            super(byArray, n * n2 * 1);
        }

        ByteGrayscaleBufferedImageSource(byte[][] byArray, int n, int n2) {
            super(byArray, n * n2 * 1);
        }

        ByteGrayscaleBufferedImageSource(ByteBuffer[] byteBufferArray, int n, int n2) {
            super(byteBufferArray, n * n2 * 1);
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("ByteGrayscaleBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            byte[] byArray = this.getDataForFrameIfNotOffsetInContiguousAllocation(n);
            int n2 = 0;
            if (byArray == null) {
                if (this.shortData != null) {
                    slf4jlogger.debug("ByteGrayscaleBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous short allocated memory for all frames", n);
                    byArray = SourceImage.getByteArrayForFrameFromMultiFrameShortArray(n, this.shortData, this.nframesamples);
                } else if (this.byteData != null) {
                    slf4jlogger.debug("ByteGrayscaleBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous byte allocated memory for all frames", n);
                    byArray = this.byteData;
                    n2 = this.nframesamples * n;
                }
            }
            return SourceImage.createByteGrayscaleImage(SourceImage.this.width, SourceImage.this.height, byArray, n2);
        }
    }

    private class UnsignedShortGrayscaleBufferedImageSource
    extends ShortBufferedImageSource {
        protected int mask;
        protected int largestGray;

        UnsignedShortGrayscaleBufferedImageSource(short[] sArray, int n, int n2, int n3, int n4) {
            super(sArray, n * n2 * 1);
            slf4jlogger.debug("UnsignedShortGrayscaleBufferedImageSource():");
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedShortGrayscaleBufferedImageSource(short[][] sArray, int n, int n2, int n3, int n4) {
            super(sArray, n * n2 * 1);
            slf4jlogger.debug("UnsignedShortGrayscaleBufferedImageSource():");
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedShortGrayscaleBufferedImageSource(ShortBuffer[] shortBufferArray, int n, int n2, int n3, int n4) {
            super(shortBufferArray, n * n2 * 1);
            slf4jlogger.debug("UnsignedShortGrayscaleBufferedImageSource():");
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedShortGrayscaleBufferedImageSource(byte[][] byArray, int n, int n2, int n3, int n4, String string) {
            super(byArray, 2, n, n2, 1, string, ColorSpace.getInstance(1003), false);
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedShortGrayscaleBufferedImageSource(ByteFrameSource byteFrameSource, int n, int n2, int n3, int n4, String string) {
            super(byteFrameSource, 2, n, n2, 1, string, ColorSpace.getInstance(1003), false);
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedShortGrayscaleBufferedImageSource(File file, long[] lArray, boolean bl, int n, int n2, int n3, int n4) {
            super(file, lArray, bl, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedShortGrayscaleBufferedImageSource(File[] fileArray, long[] lArray, boolean bl, int n, int n2, int n3, int n4) {
            super(fileArray, lArray, bl, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4);
        }

        private void doCommonConstructorStuff(int n, int n2) {
            slf4jlogger.debug("UnsignedShortGrayscaleBufferedImageSource.doCommonConstructorStuff():");
            this.mask = n;
            this.largestGray = n2;
            this.imgMin = 65535;
            this.imgMax = 0;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("UnsignedShortGrayscaleBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            short[] sArray = this.getDataForFrameIfNotOffsetInContiguousAllocation(n);
            int n2 = 0;
            if (sArray == null) {
                slf4jlogger.debug("UnsignedShortGrayscaleBufferedImageSource(): getting frame {} from contiguous short allocated memory for all frames", n);
                sArray = this.data;
                n2 = this.nframesamples * n;
            }
            short[] sArray2 = new short[this.nframesamples];
            int n3 = n2;
            for (int i = 0; i < this.nframesamples; ++i) {
                boolean bl = false;
                short s = sArray[n3];
                if (SourceImage.this.useNonMaskedSinglePadValue && s == (short)SourceImage.this.nonMaskedSinglePadValue) {
                    bl = true;
                }
                int n4 = s & this.mask;
                sArray2[i] = (short)n4;
                if (SourceImage.this.useMaskedPadRange && n4 >= SourceImage.this.useMaskedPadRangeStart && n4 <= SourceImage.this.useMaskedPadRangeEnd) {
                    bl = true;
                }
                if (!bl) {
                    if (n4 > this.imgMax && n4 <= this.largestGray) {
                        this.imgMax = n4;
                    }
                    if (n4 < this.imgMin) {
                        this.imgMin = n4;
                    }
                }
                ++n3;
            }
            this.minMaxSet = true;
            return SourceImage.createUnsignedShortGrayscaleImage(SourceImage.this.width, SourceImage.this.height, sArray2, 0);
        }
    }

    private class SignedShortGrayscaleBufferedImageSource
    extends ShortBufferedImageSource {
        protected int mask;
        protected int signbit;
        protected int extend;
        protected int largestGray;

        SignedShortGrayscaleBufferedImageSource(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(sArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedShortGrayscaleBufferedImageSource(short[][] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(sArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedShortGrayscaleBufferedImageSource(ShortBuffer[] shortBufferArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(shortBufferArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedShortGrayscaleBufferedImageSource(byte[][] byArray, int n, int n2, int n3, int n4, int n5, int n6, String string) {
            super(byArray, 2, n, n2, 1, string, ColorSpace.getInstance(1003), false);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedShortGrayscaleBufferedImageSource(ByteFrameSource byteFrameSource, int n, int n2, int n3, int n4, int n5, int n6, String string) {
            super(byteFrameSource, 2, n, n2, 1, string, ColorSpace.getInstance(1003), false);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedShortGrayscaleBufferedImageSource(File file, long[] lArray, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
            super(file, lArray, bl, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedShortGrayscaleBufferedImageSource(File[] fileArray, long[] lArray, boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
            super(fileArray, lArray, bl, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        private void doCommonConstructorStuff(int n, int n2, int n3, int n4) {
            slf4jlogger.debug("SignedShortGrayscaleBufferedImageSource.doCommonConstructorStuff():");
            this.mask = n;
            this.signbit = n2;
            this.extend = n3;
            this.largestGray = n4;
            this.imgMin = Short.MAX_VALUE;
            this.imgMax = Short.MIN_VALUE;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("SignedShortGrayscaleBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            short[] sArray = this.getDataForFrameIfNotOffsetInContiguousAllocation(n);
            int n2 = 0;
            if (sArray == null) {
                slf4jlogger.debug("SignedShortGrayscaleBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous short allocated memory for all frames", n);
                sArray = this.data;
                n2 = this.nframesamples * n;
            }
            short[] sArray2 = new short[this.nframesamples];
            int n3 = n2;
            for (int i = 0; i < this.nframesamples; ++i) {
                int n4;
                boolean bl = false;
                short s = sArray[n3];
                if (SourceImage.this.useNonMaskedSinglePadValue && s == (short)SourceImage.this.nonMaskedSinglePadValue) {
                    bl = true;
                }
                int n5 = n4 = s & this.mask;
                if ((n4 & this.signbit) != 0) {
                    n4 |= this.extend;
                }
                sArray2[i] = (short)n4;
                if (SourceImage.this.useMaskedPadRange && n5 >= SourceImage.this.useMaskedPadRangeStart && n5 <= SourceImage.this.useMaskedPadRangeEnd) {
                    bl = true;
                }
                if (!bl) {
                    if (n4 > this.imgMax && n4 <= this.largestGray) {
                        this.imgMax = n4;
                    }
                    if (n4 < this.imgMin) {
                        this.imgMin = n4;
                    }
                }
                ++n3;
            }
            this.minMaxSet = true;
            return SourceImage.createSignedShortGrayscaleImage(SourceImage.this.width, SourceImage.this.height, sArray2, 0);
        }
    }

    private class UnsignedByteGrayscaleBufferedImageSource
    extends ByteBufferedImageSource {
        protected int mask;
        protected int largestGray;
        protected boolean minMaxSet;

        UnsignedByteGrayscaleBufferedImageSource(byte[] byArray, int n, int n2, int n3, int n4) {
            super(byArray, n * n2 * 1);
            slf4jlogger.debug("UnsignedByteGrayscaleBufferedImageSource():");
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedByteGrayscaleBufferedImageSource(byte[][] byArray, int n, int n2, int n3, int n4) {
            super(byArray, n * n2 * 1);
            slf4jlogger.debug("UnsignedByteGrayscaleBufferedImageSource():");
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedByteGrayscaleBufferedImageSource(short[] sArray, int n, int n2, int n3, int n4) {
            super(sArray, n * n2 * 1);
            slf4jlogger.debug("UnsignedByteGrayscaleBufferedImageSource():");
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedByteGrayscaleBufferedImageSource(short[][] sArray, int n, int n2, int n3, int n4) {
            super(sArray, n * n2 * 1);
            slf4jlogger.debug("UnsignedByteGrayscaleBufferedImageSource():");
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedByteGrayscaleBufferedImageSource(ByteBuffer[] byteBufferArray, int n, int n2, int n3, int n4) {
            super(byteBufferArray, n * n2 * 1);
            slf4jlogger.debug("UnsignedByteGrayscaleBufferedImageSource():");
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedByteGrayscaleBufferedImageSource(ShortBuffer[] shortBufferArray, int n, int n2, int n3, int n4) {
            super(shortBufferArray, n * n2 * 1);
            slf4jlogger.debug("UnsignedByteGrayscaleBufferedImageSource():");
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedByteGrayscaleBufferedImageSource(byte[][] byArray, int n, int n2, int n3, int n4, String string) {
            super(byArray, n, n2, 1, string, ColorSpace.getInstance(1003), false);
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedByteGrayscaleBufferedImageSource(ByteFrameSource byteFrameSource, int n, int n2, int n3, int n4, String string) {
            super(byteFrameSource, n, n2, 1, string, ColorSpace.getInstance(1003), false);
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedByteGrayscaleBufferedImageSource(File[] fileArray, long[] lArray, int n, int n2, int n3, int n4) {
            super(fileArray, lArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4);
        }

        UnsignedByteGrayscaleBufferedImageSource(File file, long[] lArray, int n, int n2, int n3, int n4) {
            super(file, lArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4);
        }

        private void doCommonConstructorStuff(int n, int n2) {
            this.mask = n;
            this.largestGray = n2;
            SourceImage.this.imgMin = 255.0;
            SourceImage.this.imgMax = 0.0;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("UnsignedByteGrayscaleBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            byte[] byArray = this.getDataForFrameIfNotOffsetInContiguousAllocation(n);
            int n2 = 0;
            if (byArray == null) {
                if (this.shortData != null) {
                    slf4jlogger.debug("UnsignedByteGrayscaleBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous short allocated memory for all frames", n);
                    byArray = SourceImage.getByteArrayForFrameFromMultiFrameShortArray(n, this.shortData, this.nframesamples);
                } else if (this.byteData != null) {
                    slf4jlogger.debug("UnsignedByteGrayscaleBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous byte allocated memory for all frames", n);
                    byArray = this.byteData;
                    n2 = this.nframesamples * n;
                }
            }
            byte[] byArray2 = new byte[this.nframesamples];
            int n3 = n2;
            for (int i = 0; i < this.nframesamples; ++i) {
                boolean bl = false;
                short s = byArray[n3];
                if (SourceImage.this.useNonMaskedSinglePadValue && s == (byte)SourceImage.this.nonMaskedSinglePadValue) {
                    bl = true;
                }
                int n4 = s & this.mask;
                byArray2[i] = (byte)n4;
                if (SourceImage.this.useMaskedPadRange && n4 >= SourceImage.this.useMaskedPadRangeStart && n4 <= SourceImage.this.useMaskedPadRangeEnd) {
                    bl = true;
                }
                if (!bl) {
                    if ((double)n4 > SourceImage.this.imgMax && n4 <= this.largestGray) {
                        SourceImage.this.imgMax = n4;
                    }
                    if ((double)n4 < SourceImage.this.imgMin) {
                        SourceImage.this.imgMin = n4;
                    }
                }
                ++n3;
            }
            this.minMaxSet = true;
            return SourceImage.createByteGrayscaleImage(SourceImage.this.width, SourceImage.this.height, byArray2, 0);
        }
    }

    private class SignedByteGrayscaleBufferedImageSource
    extends ByteBufferedImageSource {
        protected int mask;
        protected int signbit;
        protected int extend;
        protected int largestGray;
        protected boolean minMaxSet;

        SignedByteGrayscaleBufferedImageSource(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(byArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedByteGrayscaleBufferedImageSource(byte[][] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(byArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedByteGrayscaleBufferedImageSource(short[] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(sArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedByteGrayscaleBufferedImageSource(short[][] sArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(sArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedByteGrayscaleBufferedImageSource(ShortBuffer[] shortBufferArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(shortBufferArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedByteGrayscaleBufferedImageSource(ByteBuffer[] byteBufferArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(byteBufferArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedByteGrayscaleBufferedImageSource(byte[][] byArray, int n, int n2, int n3, int n4, int n5, int n6, String string) {
            super(byArray, n, n2, 1, string, ColorSpace.getInstance(1003), false);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedByteGrayscaleBufferedImageSource(ByteFrameSource byteFrameSource, int n, int n2, int n3, int n4, int n5, int n6, String string) {
            super(byteFrameSource, n, n2, 1, string, ColorSpace.getInstance(1003), false);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedByteGrayscaleBufferedImageSource(File[] fileArray, long[] lArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(fileArray, lArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        SignedByteGrayscaleBufferedImageSource(File file, long[] lArray, int n, int n2, int n3, int n4, int n5, int n6) {
            super(file, lArray, n * n2 * 1);
            this.doCommonConstructorStuff(n3, n4, n5, n6);
        }

        private void doCommonConstructorStuff(int n, int n2, int n3, int n4) {
            this.mask = n;
            this.signbit = n2;
            this.extend = n3;
            this.largestGray = n4;
            SourceImage.this.imgMin = 127.0;
            SourceImage.this.imgMax = -128.0;
        }

        @Override
        public BufferedImage getUncachedBufferedImage(int n) {
            slf4jlogger.debug("SignedByteGrayscaleBufferedImageSource.getUncachedBufferedImage(): index={}", n);
            byte[] byArray = this.getDataForFrameIfNotOffsetInContiguousAllocation(n);
            int n2 = 0;
            if (byArray == null) {
                if (this.shortData != null) {
                    slf4jlogger.debug("ByteGrayscaleBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous short allocated memory for all frames", n);
                    byArray = SourceImage.getByteArrayForFrameFromMultiFrameShortArray(n, this.shortData, this.nframesamples);
                } else if (this.byteData != null) {
                    slf4jlogger.debug("ByteGrayscaleBufferedImageSource.getUncachedBufferedImage(): getting frame {} from contiguous byte allocated memory for all frames", n);
                    byArray = this.byteData;
                    n2 = this.nframesamples * n;
                }
            }
            byte[] byArray2 = new byte[this.nframesamples];
            int n3 = n2;
            for (int i = 0; i < this.nframesamples; ++i) {
                int n4;
                boolean bl = false;
                byte by = byArray[n3];
                if (SourceImage.this.useNonMaskedSinglePadValue && by == (byte)SourceImage.this.nonMaskedSinglePadValue) {
                    bl = true;
                }
                int n5 = n4 = by & this.mask;
                if ((n4 & this.signbit) != 0) {
                    n4 |= this.extend;
                }
                byArray2[i] = (byte)n4;
                if (SourceImage.this.useMaskedPadRange && n5 >= SourceImage.this.useMaskedPadRangeStart && n5 <= SourceImage.this.useMaskedPadRangeEnd) {
                    bl = true;
                }
                if (!bl) {
                    if ((double)n4 > SourceImage.this.imgMax && n4 <= this.largestGray) {
                        SourceImage.this.imgMax = n4;
                    }
                    if ((double)n4 < SourceImage.this.imgMin) {
                        SourceImage.this.imgMin = n4;
                    }
                }
                ++n3;
            }
            this.minMaxSet = true;
            return SourceImage.createByteGrayscaleImage(SourceImage.this.width, SourceImage.this.height, byArray2, 0);
        }
    }

    private abstract class ByteBufferedImageSource
    extends BufferedImageSource {
        protected byte[] byteData;
        protected byte[][] byteDataPerFrame;
        protected short[] shortData;
        protected short[][] shortDataPerFrame;
        protected ByteBuffer[] byteBuffers;
        protected ShortBuffer[] shortBuffers;
        protected File file;
        protected File[] filesPerFrame;
        protected long[] byteOffsets;
        protected CompressedFrameDecoder decoder;

        ByteBufferedImageSource(byte[] byArray, int n) {
            super(n);
            this.byteData = byArray;
        }

        ByteBufferedImageSource(byte[][] byArray, int n) {
            super(n);
            this.byteDataPerFrame = byArray;
        }

        ByteBufferedImageSource(short[] sArray, int n) {
            super(n);
            this.shortData = sArray;
        }

        ByteBufferedImageSource(short[][] sArray, int n) {
            super(n);
            this.shortDataPerFrame = sArray;
        }

        ByteBufferedImageSource(ByteBuffer[] byteBufferArray, int n) {
            super(n);
            this.byteBuffers = byteBufferArray;
        }

        ByteBufferedImageSource(ShortBuffer[] shortBufferArray, int n) {
            super(n);
            this.shortBuffers = shortBufferArray;
        }

        ByteBufferedImageSource(File[] fileArray, long[] lArray, int n) {
            super(n);
            this.filesPerFrame = fileArray;
            this.byteOffsets = lArray;
        }

        ByteBufferedImageSource(File file, long[] lArray, int n) {
            super(n);
            this.file = file;
            this.byteOffsets = lArray;
        }

        ByteBufferedImageSource(byte[][] byArray, int n, int n2, int n3, String string, ColorSpace colorSpace, boolean bl) {
            super(n * n2 * n3);
            try {
                slf4jlogger.debug("ByteBufferedImageSource(): creating CompressedFrameDecoder with bytesPerSample = 1");
                this.decoder = new CompressedFrameDecoder(string, byArray, 1, n, n2, n3, colorSpace, bl);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                this.decoder = null;
            }
        }

        ByteBufferedImageSource(ByteFrameSource byteFrameSource, int n, int n2, int n3, String string, ColorSpace colorSpace, boolean bl) {
            super(n * n2 * n3);
            try {
                slf4jlogger.debug("ByteBufferedImageSource(): creating CompressedFrameDecoder with bytesPerSample = 1");
                this.decoder = new CompressedFrameDecoder(string, byteFrameSource, 1, n, n2, n3, colorSpace, bl);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                this.decoder = null;
            }
        }

        protected byte[] getDataForFrameIfNotOffsetInContiguousAllocation(int n) {
            byte[] byArray = null;
            if (this.decoder != null) {
                try {
                    slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from deferred decompression", n);
                    BufferedImage bufferedImage = this.decoder.getDecompressedFrameAsBufferedImage(n);
                    Raster raster = bufferedImage.getData();
                    int n2 = raster.getTransferType();
                    if (n2 == 0) {
                        slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): have correct TYPE_BYTE transferType");
                        byArray = (byte[])raster.getDataElements(0, 0, SourceImage.this.width, SourceImage.this.height, null);
                    }
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                }
            } else if (this.byteBuffers != null) {
                slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from memory mapped byte buffers", n);
                byArray = new byte[this.nframesamples];
                ByteBuffer byteBuffer = this.byteBuffers[n];
                byteBuffer.position(0);
                byteBuffer.get(byArray);
            } else if (this.shortBuffers != null) {
                slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from memory mapped short buffers", n);
                slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): nframesamples = {} /2 = {}", this.nframesamples, this.nframesamples / 2);
                short[] sArray = new short[this.nframesamples / 2];
                ShortBuffer shortBuffer = this.shortBuffers[n];
                shortBuffer.position(0);
                shortBuffer.get(sArray);
                byArray = SourceImage.getByteArrayForFrameFromSingleFrameShortArray(sArray, this.nframesamples);
            } else if (this.byteDataPerFrame != null) {
                slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from per-frame byte allocated memory", n);
                byArray = this.byteDataPerFrame[n];
            } else if (this.shortDataPerFrame != null) {
                slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from per-frame short allocated memory", n);
                short[] sArray = this.shortDataPerFrame[n];
                byArray = SourceImage.getByteArrayForFrameFromSingleFrameShortArray(sArray, this.nframesamples);
            } else if (this.filesPerFrame != null) {
                slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from per-frame file", n);
                byArray = new byte[this.nframesamples];
                try {
                    BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.filesPerFrame[n]), false);
                    binaryInputStream.skipInsistently(this.byteOffsets[n]);
                    binaryInputStream.readInsistently(byArray, 0, this.nframesamples);
                    binaryInputStream.close();
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): failed to read bytes for frame {} from file {}", n, this.filesPerFrame[n]);
                }
            } else if (this.file != null) {
                slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from single large multi-frame file", n);
                byArray = new byte[this.nframesamples];
                try {
                    BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), false);
                    binaryInputStream.skipInsistently(this.byteOffsets[n]);
                    binaryInputStream.readInsistently(byArray, 0, this.nframesamples);
                    binaryInputStream.close();
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    slf4jlogger.debug("ByteBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): failed to read bytes for frame {} from file {}", n, this.file);
                }
            }
            return byArray;
        }

        @Override
        protected void finalize() throws Throwable {
            int n;
            slf4jlogger.debug("ByteBufferedImageSource.finalize()");
            this.byteData = null;
            if (this.byteDataPerFrame != null) {
                for (n = 0; n < this.byteDataPerFrame.length; ++n) {
                    this.byteDataPerFrame[n] = null;
                }
                this.byteDataPerFrame = null;
            }
            this.shortData = null;
            if (this.shortDataPerFrame != null) {
                for (n = 0; n < this.shortDataPerFrame.length; ++n) {
                    this.shortDataPerFrame[n] = null;
                }
                this.shortDataPerFrame = null;
            }
            if (this.byteBuffers != null) {
                for (n = 0; n < this.byteBuffers.length; ++n) {
                    this.byteBuffers[n] = null;
                }
                this.byteBuffers = null;
            }
            if (this.shortBuffers != null) {
                for (n = 0; n < this.shortBuffers.length; ++n) {
                    this.shortBuffers[n] = null;
                }
                this.shortBuffers = null;
            }
            if (this.decoder != null) {
                this.decoder.dispose();
            }
            this.decoder = null;
            super.finalize();
        }
    }

    private abstract class ShortBufferedImageSource
    extends BufferedImageSource {
        protected short[] data;
        protected short[][] dataPerFrame;
        protected ShortBuffer[] buffers;
        protected File file;
        protected File[] files;
        protected long[] byteOffsets;
        protected boolean bigEndian;
        protected CompressedFrameDecoder decoder;
        protected boolean minMaxSet;
        protected int imgMin;
        protected int imgMax;

        @Override
        public double getMinimumPixelValueOfMostRecentBufferedImage(double d) {
            return this.minMaxSet ? (double)this.imgMin : d;
        }

        @Override
        public double getMaximumPixelValueOfMostRecentBufferedImage(double d) {
            return this.minMaxSet ? (double)this.imgMax : d;
        }

        ShortBufferedImageSource(short[] sArray, int n) {
            super(n);
            this.data = sArray;
            this.minMaxSet = false;
        }

        ShortBufferedImageSource(short[][] sArray, int n) {
            super(n);
            this.dataPerFrame = sArray;
        }

        ShortBufferedImageSource(ShortBuffer[] shortBufferArray, int n) {
            super(n);
            this.buffers = shortBufferArray;
            this.minMaxSet = false;
        }

        ShortBufferedImageSource(File file, long[] lArray, boolean bl, int n) {
            super(n);
            this.file = file;
            this.byteOffsets = lArray;
            this.bigEndian = bl;
            this.minMaxSet = false;
        }

        ShortBufferedImageSource(File[] fileArray, long[] lArray, boolean bl, int n) {
            super(n);
            this.files = fileArray;
            this.byteOffsets = lArray;
            this.bigEndian = bl;
            this.minMaxSet = false;
        }

        ShortBufferedImageSource(byte[][] byArray, int n, int n2, int n3, int n4, String string, ColorSpace colorSpace, boolean bl) {
            super(n2 * n3 * n4);
            try {
                slf4jlogger.debug("ShortBufferedImageSource(): creating CompressedFrameDecoder from in memory source with bytesPerSample = {}", n);
                this.decoder = new CompressedFrameDecoder(string, byArray, n, n2, n3, n4, colorSpace, bl);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                this.decoder = null;
            }
            this.minMaxSet = false;
        }

        ShortBufferedImageSource(ByteFrameSource byteFrameSource, int n, int n2, int n3, int n4, String string, ColorSpace colorSpace, boolean bl) {
            super(n2 * n3 * n4);
            try {
                slf4jlogger.debug("ShortBufferedImageSource(): creating CompressedFrameDecoder  from frame source with bytesPerSample = {}", n);
                this.decoder = new CompressedFrameDecoder(string, byteFrameSource, n, n2, n3, n4, colorSpace, bl);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                this.decoder = null;
            }
            this.minMaxSet = false;
        }

        protected short[] getDataForFrameIfNotOffsetInContiguousAllocation(int n) {
            short[] sArray = null;
            if (this.decoder != null) {
                try {
                    slf4jlogger.debug("ShortBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from deferred decompression", n);
                    BufferedImage bufferedImage = this.decoder.getDecompressedFrameAsBufferedImage(n);
                    Raster raster = bufferedImage.getData();
                    int n2 = raster.getTransferType();
                    if (n2 == 2 || n2 == 1) {
                        slf4jlogger.debug("ShortBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): have correct TYPE_SHORT or TYPE_USHORT transferType");
                        sArray = (short[])raster.getDataElements(0, 0, SourceImage.this.width, SourceImage.this.height, null);
                    }
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                }
            } else if (this.buffers != null) {
                slf4jlogger.debug("ShortBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from  memory mapped file", n);
                slf4jlogger.debug("SignedShortGrayscaleBufferedImageSource.getUncachedBufferedImage(): nframesamples = {}", this.nframesamples);
                sArray = new short[this.nframesamples];
                ShortBuffer shortBuffer = this.buffers[n];
                shortBuffer.position(0);
                shortBuffer.get(sArray);
            } else if (this.dataPerFrame != null) {
                slf4jlogger.debug("ShortBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from per-frame byte allocated memory", n);
                sArray = this.dataPerFrame[n];
            } else if (this.file != null) {
                slf4jlogger.debug("ShortBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from single large multi-frame file", n);
                sArray = new short[this.nframesamples];
                try {
                    BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), this.bigEndian);
                    binaryInputStream.skipInsistently(this.byteOffsets[n]);
                    binaryInputStream.readUnsigned16(sArray, this.nframesamples);
                    binaryInputStream.close();
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    slf4jlogger.error("ShortBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): failed to read bytes for frame {} from file {}", n, this.file);
                }
            } else if (this.files != null) {
                slf4jlogger.debug("ShortBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): getting frame {} from single multiple file for multi-frame", n);
                sArray = new short[this.nframesamples];
                try {
                    BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.files[n]), this.bigEndian);
                    binaryInputStream.skipInsistently(this.byteOffsets[n]);
                    binaryInputStream.readUnsigned16(sArray, this.nframesamples);
                    binaryInputStream.close();
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    slf4jlogger.error("ShortBufferedImageSource.getDataForFrameIfNotOffsetInContiguousAllocation(): failed to read bytes for frame {} from file {}", n, this.files[n]);
                }
            }
            return sArray;
        }

        @Override
        protected void finalize() throws Throwable {
            int n;
            slf4jlogger.debug("ShortBufferedImageSource.finalize()");
            this.data = null;
            if (this.dataPerFrame != null) {
                for (n = 0; n < this.dataPerFrame.length; ++n) {
                    this.dataPerFrame[n] = null;
                }
                this.dataPerFrame = null;
            }
            if (this.buffers != null) {
                for (n = 0; n < this.buffers.length; ++n) {
                    this.buffers[n] = null;
                }
                this.buffers = null;
            }
            if (this.decoder != null) {
                this.decoder.dispose();
            }
            this.decoder = null;
            super.finalize();
        }
    }

    private abstract class BufferedImageSource {
        protected int nframesamples;
        private int cachedIndex;
        BufferedImage cachedBufferedImage;

        BufferedImageSource(int n) {
            this.nframesamples = n;
            this.cachedIndex = -1;
            this.cachedBufferedImage = null;
        }

        protected void finalize() throws Throwable {
            slf4jlogger.debug("finalize()");
            this.cachedBufferedImage = null;
            super.finalize();
        }

        public BufferedImage getBufferedImage(int n) {
            slf4jlogger.debug("BufferedImageSource.getBufferedImage(): index={}", n);
            slf4jlogger.debug("BufferedImageSource.getBufferedImage(): cachedIndex={}", this.cachedIndex);
            if (n != this.cachedIndex) {
                this.cachedBufferedImage = this.getUncachedBufferedImage(n);
                slf4jlogger.debug("BufferedImageSource.getBufferedImage(): getUncachedBufferedImage({}) returns ", n, this.cachedBufferedImage == null ? "null" : "non-null");
                this.cachedIndex = this.cachedBufferedImage != null ? n : -1;
            }
            return this.cachedBufferedImage;
        }

        public abstract BufferedImage getUncachedBufferedImage(int var1);

        public double getMinimumPixelValueOfMostRecentBufferedImage(double d) {
            return d;
        }

        public double getMaximumPixelValueOfMostRecentBufferedImage(double d) {
            return d;
        }
    }
}

