/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.event.WindowingAccelerationValueChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.EventContext;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SourceImageWindowingAccelerationSelectorPanel
extends JPanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SourceImageWindowingAccelerationSelectorPanel.java,v 1.12 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SourceImageWindowingAccelerationSelectorPanel.class);
    private EventContext eventContext;
    private ButtonGroup windowingAccelerationButtons;
    private JRadioButton increaseButton;
    private JRadioButton decreaseButton;

    public void sendEventCorrespondingToCurrentButtonState() {
        double d = Double.parseDouble(this.windowingAccelerationButtons.getSelection().getActionCommand());
        try {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new WindowingAccelerationValueChangeEvent(this.eventContext, d));
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public SourceImageWindowingAccelerationSelectorPanel(EventContext eventContext) {
        this.eventContext = eventContext;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(new JLabel("Windowing acceleration:"));
        this.windowingAccelerationButtons = new ButtonGroup();
        WindowingAccelerationChangeActionListener windowingAccelerationChangeActionListener = new WindowingAccelerationChangeActionListener();
        this.increaseButton = new JRadioButton("50", true);
        this.increaseButton.setActionCommand("50");
        this.increaseButton.setToolTipText("Accelerate effect of mouse movement when SHIFT key depressed during windowing by 50");
        this.increaseButton.addActionListener(windowingAccelerationChangeActionListener);
        this.windowingAccelerationButtons.add(this.increaseButton);
        jPanel.add(this.increaseButton);
        this.decreaseButton = new JRadioButton("0.001", false);
        this.decreaseButton.setActionCommand("0.001");
        this.increaseButton.setToolTipText("Accelerate effect of mouse movement when SHIFT key depressed during windowing by 0.001");
        this.decreaseButton.addActionListener(windowingAccelerationChangeActionListener);
        this.windowingAccelerationButtons.add(this.decreaseButton);
        jPanel.add(this.decreaseButton);
    }

    private class WindowingAccelerationChangeActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceImageWindowingAccelerationSelectorPanel.this.sendEventCorrespondingToCurrentButtonState();
        }
    }
}

