/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.ConsumerFormatImageMaker;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.SuperimposedImage;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;

public class SuperimposedDicomImage
extends SuperimposedImage {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SuperimposedDicomImage.java,v 1.15 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SuperimposedDicomImage.class);

    public SuperimposedDicomImage(AttributeList attributeList) throws DicomException {
        this.doCommonConstructorStuff(attributeList);
    }

    public SuperimposedDicomImage(String string) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string);
        this.doCommonConstructorStuff(attributeList);
    }

    private void doCommonConstructorStuff(AttributeList attributeList) throws DicomException {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
        if (SOPClass.isImageStorage(string)) {
            this.superimposedSourceImage = new SourceImage(attributeList);
            if (this.superimposedSourceImage != null && this.superimposedSourceImage.getNumberOfBufferedImages() > 0) {
                this.superimposedGeometry = new GeometryOfVolumeFromAttributeList(attributeList);
                if (!this.superimposedGeometry.isVolumeSampledRegularlyAlongFrameDimension()) {
                    slf4jlogger.warn("doCommonConstructorStuff(): superimposed geometry is not a single regularly sampled volume");
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            String string2 = stringArray[1];
            SuperimposedDicomImage superimposedDicomImage = new SuperimposedDicomImage(string2);
            Vector<SuperimposedImage> vector = new Vector<SuperimposedImage>();
            vector.add(superimposedDicomImage);
            if (stringArray.length > 2) {
                String string3 = stringArray[2];
                ConsumerFormatImageMaker.convertFileToEightBitImage(string, string3, "jpeg", 0.0, 0.0, 0, 0, 100, "all_color", vector, null);
            } else {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string);
                SourceImage sourceImage = new SourceImage(attributeList);
                GeometryOfVolumeFromAttributeList geometryOfVolumeFromAttributeList = new GeometryOfVolumeFromAttributeList(attributeList);
                SingleImagePanel singleImagePanel = new SingleImagePanel(sourceImage, null, geometryOfVolumeFromAttributeList);
                singleImagePanel.setSuperimposedImages(vector);
                JFrame jFrame = new JFrame();
                jFrame.add(singleImagePanel);
                jFrame.setSize(sourceImage.getWidth(), sourceImage.getHeight());
                jFrame.setVisible(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

