/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.displaywave;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.displaywave.SourceECG;
import com.pixelmed.scpecg.SCPECG;
import com.pixelmed.scpecg.Section3;
import java.io.IOException;

public class SCPSourceECG
extends SourceECG {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/displaywave/SCPSourceECG.java,v 1.18 2025/01/29 10:58:08 dclunie Exp $";

    protected static String buildInstanceTitle(SCPECG sCPECG) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(sCPECG.getNamedField("LastName"));
        stringBuffer.append("^");
        stringBuffer.append(sCPECG.getNamedField("FirstName"));
        stringBuffer.append(" [");
        stringBuffer.append(sCPECG.getNamedField("PatientIdentificationNumber"));
        stringBuffer.append(" ] - ");
        stringBuffer.append(sCPECG.getNamedField("DateOfAcquisition"));
        stringBuffer.append(" ");
        stringBuffer.append(sCPECG.getNamedField("TimeOfAcquisition"));
        stringBuffer.append(" [");
        stringBuffer.append(sCPECG.getNamedField("ECGSequenceNumber"));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static int findLead(int[] nArray, String string) {
        int n = Section3.getLeadNumber(string);
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            return i;
        }
        return -1;
    }

    private void deriveAdditionalUnipolarLeads(int[] nArray) {
        int n = SCPSourceECG.findLead(nArray, "I");
        int n2 = SCPSourceECG.findLead(nArray, "II");
        int n3 = SCPSourceECG.findLead(nArray, "III");
        int n4 = SCPSourceECG.findLead(nArray, "aVR");
        int n5 = SCPSourceECG.findLead(nArray, "aVL");
        int n6 = SCPSourceECG.findLead(nArray, "aVF");
        if (n >= 0 && n2 >= 0 && n3 < 0 && n4 < 0 && n5 < 0 && n6 < 0) {
            int n7 = this.samples[n].length;
            float f = this.amplitudeScalingFactorInMilliVolts[n];
            if (n7 == this.samples[n2].length && f == this.amplitudeScalingFactorInMilliVolts[n2]) {
                int n8;
                int n9 = this.numberOfChannels;
                this.numberOfChannels += 4;
                this.samples = ArrayCopyUtilities.expandArray(this.samples, 4);
                this.amplitudeScalingFactorInMilliVolts = ArrayCopyUtilities.expandArray(this.amplitudeScalingFactorInMilliVolts, 4);
                this.channelNames = ArrayCopyUtilities.expandArray(this.channelNames, 4);
                for (n8 = n9; n8 < this.numberOfChannels; ++n8) {
                    this.amplitudeScalingFactorInMilliVolts[n8] = f;
                    this.samples[n8] = new short[n7];
                }
                n3 = n9++;
                n4 = n9++;
                n5 = n9++;
                n6 = n9;
                this.channelNames[n3] = "III";
                this.channelNames[n4] = "aVR";
                this.channelNames[n5] = "aVL";
                this.channelNames[n6] = "aVF";
                for (n8 = 0; n8 < n7; ++n8) {
                    short s = this.samples[n][n8];
                    short s2 = this.samples[n2][n8];
                    int n10 = s2 - s;
                    this.samples[n3][n8] = (short)n10;
                    this.samples[n4][n8] = (short)(-(s + s2) / 2);
                    this.samples[n5][n8] = (short)((s - n10) / 2);
                    this.samples[n6][n8] = (short)((s2 + n10) / 2);
                }
            }
        }
    }

    public SCPSourceECG(BinaryInputStream binaryInputStream, boolean bl) throws IOException {
        SCPECG sCPECG = new SCPECG(binaryInputStream, false);
        this.doCommonConstructorStuff(sCPECG, bl);
    }

    public SCPSourceECG(SCPECG sCPECG, boolean bl) throws IOException {
        this.doCommonConstructorStuff(sCPECG, bl);
    }

    private void doCommonConstructorStuff(SCPECG sCPECG, boolean bl) {
        this.samples = sCPECG.getDecompressedRhythmData();
        this.numberOfChannels = sCPECG.getNumberOfLeads();
        this.nSamplesPerChannel = (int)sCPECG.getNumbersOfSamples()[0];
        this.samplingIntervalInMilliSeconds = sCPECG.getDecompressedRhythmDataSampleTimeInterval() / 1000;
        this.amplitudeScalingFactorInMilliVolts = new float[this.numberOfChannels];
        for (int i = 0; i < this.numberOfChannels; ++i) {
            this.amplitudeScalingFactorInMilliVolts[i] = 0.001f;
        }
        this.channelNames = sCPECG.getLeadNames();
        if (bl) {
            this.deriveAdditionalUnipolarLeads(sCPECG.getLeadNumbers());
        }
        this.buildPreferredDisplaySequence(this.channelNames);
        this.title = SCPSourceECG.buildInstanceTitle(sCPECG);
    }
}

