/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTDoseCheckDetails;
import com.pixelmed.dose.CTPhantomType;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.dose.ScanRange;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class CTDoseAcquisition {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/CTDoseAcquisition.java,v 1.44 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CTDoseAcquisition.class);
    protected String scopeUID;
    protected boolean seriesOrAcquisitionNumberIsSeries;
    protected String seriesOrAcquisitionNumber;
    protected CTScanType scanType;
    protected ScanRange scanRange;
    protected String CTDIvol;
    protected String DLP;
    protected CTPhantomType phantomType;
    protected CTAcquisitionParameters acquisitionParameters;
    protected CTDoseCheckDetails doseCheckDetails;
    protected ContentItem contentItemFragment;
    protected static CodedSequenceItem entireBodyDefaultAnatomy;

    public CTDoseAcquisition(String string, boolean bl, String string2, CTScanType cTScanType, ScanRange scanRange, String string3, String string4, CTPhantomType cTPhantomType) {
        this.scopeUID = string;
        this.seriesOrAcquisitionNumberIsSeries = bl;
        this.seriesOrAcquisitionNumber = string2;
        this.scanType = cTScanType;
        this.scanRange = scanRange;
        this.CTDIvol = string3;
        this.DLP = string4;
        this.phantomType = cTPhantomType;
        this.acquisitionParameters = null;
        this.contentItemFragment = null;
    }

    public CTDoseAcquisition(String string, ContentItem contentItem) {
        Object object;
        ContentItem contentItem2;
        ContentItem contentItem3;
        this.scopeUID = string;
        ContentItem contentItem4 = contentItem.getNamedChild("DCM", "113820");
        if (contentItem4 != null && contentItem4 instanceof ContentItemFactory.CodeContentItem) {
            this.scanType = CTScanType.selectFromCode(((ContentItemFactory.CodeContentItem)contentItem4).getConceptCode());
        }
        if ((contentItem3 = contentItem.getNamedChild("DCM", "113605")) != null && contentItem3 instanceof ContentItemFactory.TextContentItem) {
            this.seriesOrAcquisitionNumber = ((ContentItemFactory.TextContentItem)contentItem3).getConceptValue();
            contentItem2 = contentItem3.getNamedChild("DCM", "113606");
            if (contentItem2 != null && contentItem2 instanceof ContentItemFactory.CodeContentItem) {
                object = ((ContentItemFactory.CodeContentItem)contentItem2).getConceptCode();
                boolean bl = this.seriesOrAcquisitionNumberIsSeries = object == null || !((CodedSequenceItem)object).getCodingSchemeDesignator().equals("DCM") || !((CodedSequenceItem)object).getCodeValue().equals("113608");
            }
        }
        if ((contentItem2 = contentItem.getNamedChild("DCM", "113822")) != null) {
            this.acquisitionParameters = new CTAcquisitionParameters(contentItem2);
        }
        if ((object = contentItem.getNamedChild("DCM", "113829")) != null) {
            Object object2;
            Object object3;
            ContentItem contentItem5 = ((ContentItem)object).getNamedChild("DCM", "113830");
            if (contentItem5 != null && contentItem5 instanceof ContentItemFactory.NumericContentItem) {
                object3 = ((ContentItemFactory.NumericContentItem)contentItem5).getUnits();
                if (CTDoseAcquisition.checkUnitIs_mGy((CodedSequenceItem)object3)) {
                    this.CTDIvol = ((ContentItemFactory.NumericContentItem)contentItem5).getNumericValue();
                } else {
                    slf4jlogger.warn("CT Dose Acquisition Mean CTDIvol units are not mGy - ignoring value");
                }
            } else {
                slf4jlogger.warn("CT Dose Acquisition Mean CTDIvol not found");
            }
            object3 = ((ContentItem)object).getNamedChild("DCM", "113838");
            if (object3 != null && object3 instanceof ContentItemFactory.NumericContentItem) {
                object2 = ((ContentItemFactory.NumericContentItem)object3).getUnits();
                if (CTDoseAcquisition.checkUnitIs_mGycm((CodedSequenceItem)object2)) {
                    this.DLP = ((ContentItemFactory.NumericContentItem)object3).getNumericValue();
                } else {
                    slf4jlogger.warn("CT Dose Acquisition DLP units are not mGy.cm - ignoring value");
                }
            } else {
                slf4jlogger.warn("CT Dose Acquisition DLP not found");
            }
            object2 = ((ContentItem)object).getNamedChild("DCM", "113835");
            if (object2 != null && object2 instanceof ContentItemFactory.CodeContentItem) {
                this.phantomType = CTPhantomType.selectFromCode(((ContentItemFactory.CodeContentItem)object2).getConceptCode());
            }
            this.doseCheckDetails = ((ContentItem)object).getNamedChild("DCM", "113900") != null || ((ContentItem)object).getNamedChild("DCM", "113908") != null ? new CTDoseCheckDetails((ContentItem)object) : null;
        }
    }

    public static boolean checkUnitIs_mGy(CodedSequenceItem codedSequenceItem) {
        boolean bl = false;
        if (codedSequenceItem != null) {
            String string = codedSequenceItem.getCodeValue();
            String string2 = codedSequenceItem.getCodingSchemeDesignator();
            if (string != null && string.equals("mGy") && string2 != null && string2.equals("UCUM")) {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean checkUnitIs_mGycm(CodedSequenceItem codedSequenceItem) {
        boolean bl = false;
        if (codedSequenceItem != null) {
            String string = codedSequenceItem.getCodeValue();
            String string2 = codedSequenceItem.getCodingSchemeDesignator();
            if (string != null && (string.equals("mGy.cm") || string.equals("mGycm")) && string2 != null && string2.equals("UCUM")) {
                bl = true;
            }
        }
        return bl;
    }

    public String getScopeUID() {
        return this.scopeUID;
    }

    public boolean isSeriesNumberNotAcquisitionNumber() {
        return this.seriesOrAcquisitionNumberIsSeries;
    }

    public String getSeriesOrAcquisitionNumber() {
        return this.seriesOrAcquisitionNumber;
    }

    public CTScanType getScanType() {
        return this.scanType;
    }

    public ScanRange getScanRange() {
        return this.scanRange;
    }

    public String getCTDIvol() {
        return this.CTDIvol;
    }

    public String getDLP() {
        return this.DLP;
    }

    public CTPhantomType getPhantomType() {
        return this.phantomType;
    }

    public void setAcquisitionParameters(CTAcquisitionParameters cTAcquisitionParameters) {
        CTScanType cTScanType;
        this.acquisitionParameters = cTAcquisitionParameters;
        if (this.scanType.equals(CTScanType.UNKNOWN) && cTAcquisitionParameters != null && (cTScanType = cTAcquisitionParameters.getScanType()) != null) {
            this.scanType = cTScanType;
        }
    }

    public CTDoseCheckDetails getDoseCheckDetails() {
        return this.doseCheckDetails;
    }

    public void setDoseCheckDetails(CTDoseCheckDetails cTDoseCheckDetails) {
        this.doseCheckDetails = cTDoseCheckDetails;
    }

    public CTAcquisitionParameters getAcquisitionParameters() {
        return this.acquisitionParameters;
    }

    public void merge(CTDoseAcquisition cTDoseAcquisition) {
        if (cTDoseAcquisition != null) {
            this.contentItemFragment = null;
            CTAcquisitionParameters cTAcquisitionParameters = cTDoseAcquisition.getAcquisitionParameters();
            if (this.acquisitionParameters == null) {
                this.acquisitionParameters = new CTAcquisitionParameters(cTAcquisitionParameters);
            } else {
                this.acquisitionParameters.merge(cTAcquisitionParameters);
            }
        }
    }

    public boolean matchForMerge(CTDoseAcquisition cTDoseAcquisition) {
        boolean bl = false;
        try {
            bl = (cTDoseAcquisition.getScanType() == null && this.getScanType() == null || cTDoseAcquisition.getScanType().equals(this.getScanType()) || (cTDoseAcquisition.getScanType().equals(CTScanType.STATIONARY) || cTDoseAcquisition.getScanType().equals(CTScanType.AXIAL)) && (this.getScanType().equals(CTScanType.STATIONARY) || this.getScanType().equals(CTScanType.AXIAL))) && (cTDoseAcquisition.getCTDIvol() == null && this.getCTDIvol() == null || cTDoseAcquisition.getCTDIvol().equals(this.getCTDIvol()) || Double.parseDouble(cTDoseAcquisition.getCTDIvol()) == Double.parseDouble(this.getCTDIvol())) && (cTDoseAcquisition.getPhantomType() == null && this.getPhantomType() == null || cTDoseAcquisition.getPhantomType().equals(this.getPhantomType()));
        }
        catch (NumberFormatException numberFormatException) {
            slf4jlogger.error("", numberFormatException);
        }
        return bl;
    }

    public boolean equals(Object object) {
        CTDoseAcquisition cTDoseAcquisition;
        boolean bl = false;
        bl = object instanceof CTDoseAcquisition ? (cTDoseAcquisition = (CTDoseAcquisition)object).isSeriesNumberNotAcquisitionNumber() == this.isSeriesNumberNotAcquisitionNumber() && (cTDoseAcquisition.getSeriesOrAcquisitionNumber() == null && this.getSeriesOrAcquisitionNumber() == null || cTDoseAcquisition.getSeriesOrAcquisitionNumber().equals(this.getSeriesOrAcquisitionNumber())) && (cTDoseAcquisition.getScopeUID() == null && this.getScopeUID() == null || cTDoseAcquisition.getScopeUID().equals(this.getScopeUID())) && (cTDoseAcquisition.getScanType() == null && this.getScanType() == null || cTDoseAcquisition.getScanType().equals(this.getScanType())) && (cTDoseAcquisition.getScanRange() == null && this.getScanRange() == null || cTDoseAcquisition.getScanRange().equals(this.getScanRange())) && (cTDoseAcquisition.getCTDIvol() == null && this.getCTDIvol() == null || cTDoseAcquisition.getCTDIvol().equals(this.getCTDIvol())) && (cTDoseAcquisition.getDLP() == null && this.getDLP() == null || cTDoseAcquisition.getDLP().equals(this.getDLP())) && (cTDoseAcquisition.getPhantomType() == null && this.getPhantomType() == null || cTDoseAcquisition.getPhantomType().equals(this.getPhantomType())) : false;
        return bl;
    }

    public int hashCode() {
        return this.getSeriesOrAcquisitionNumber().hashCode() + this.getScopeUID().hashCode() + this.getScanType().hashCode() + this.getScanRange().hashCode();
    }

    public String getScanningLengthFromDLPAndCTDIVol() {
        String string = null;
        if (this.DLP != null && this.DLP.length() > 0 && this.CTDIvol != null && this.CTDIvol.length() > 0) {
            try {
                double d = Double.parseDouble(this.DLP);
                double d2 = Double.parseDouble(this.CTDIvol);
                if (d > 0.0 && d2 > 0.0) {
                    double d3 = d / d2 * 10.0;
                    DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
                    decimalFormat.setMaximumFractionDigits(2);
                    decimalFormat.setMinimumFractionDigits(2);
                    decimalFormat.setDecimalSeparatorAlwaysShown(true);
                    decimalFormat.setGroupingUsed(false);
                    string = decimalFormat.format(d3);
                }
            }
            catch (NumberFormatException numberFormatException) {
                slf4jlogger.error("", numberFormatException);
            }
        }
        return string;
    }

    public String getDLPFromRangeAndCTDIvol() {
        String string = null;
        if (this.scanRange != null && this.CTDIvol != null && this.CTDIvol.length() > 0) {
            try {
                double d = Double.parseDouble(this.scanRange.getAbsoluteRange()) * Double.parseDouble(this.CTDIvol) / 10.0;
                DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
                decimalFormat.setMaximumFractionDigits(2);
                decimalFormat.setMinimumFractionDigits(2);
                decimalFormat.setDecimalSeparatorAlwaysShown(true);
                decimalFormat.setGroupingUsed(false);
                string = decimalFormat.format(d);
            }
            catch (NumberFormatException numberFormatException) {
                slf4jlogger.error("", numberFormatException);
            }
        }
        return string;
    }

    public boolean specifiedDLPMatchesDLPFromRangeAndCTDIvol() {
        String string = this.getDLPFromRangeAndCTDIvol();
        return this.DLP != null && string != null && this.DLP.equals(string);
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t");
        stringBuffer.append(bl && (this.seriesOrAcquisitionNumber == null || this.seriesOrAcquisitionNumber.trim().length() == 0) ? "-" : (this.seriesOrAcquisitionNumberIsSeries ? "Series" : "Acq") + "=" + this.seriesOrAcquisitionNumber);
        stringBuffer.append("\t");
        stringBuffer.append(this.scanType);
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Range=");
        }
        stringBuffer.append(bl && this.scanRange == null ? "-" : this.scanRange + " mm");
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("CTDIvol=");
        }
        stringBuffer.append(bl && (this.CTDIvol == null || this.CTDIvol.trim().length() == 0) ? "-" : this.CTDIvol + " mGy");
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("DLP=");
        }
        stringBuffer.append(bl && (this.DLP == null || this.DLP.trim().length() == 0) ? "-" : this.DLP + " mGy.cm");
        stringBuffer.append("\t");
        if (!bl) {
            stringBuffer.append("Phantom=");
        }
        stringBuffer.append(bl && this.phantomType == null ? "-" : this.phantomType);
        if (this.acquisitionParameters != null) {
            stringBuffer.append("\n\t");
            stringBuffer.append(this.acquisitionParameters.toString(bl));
        } else {
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getHTMLTableHeaderRow() {
        return "<tr><th>Number</th><th>Type</th><th>Range mm</th><th>CTDIvol mGy</th><th>DLP mGy.cm</th><th>Phantom</th>" + (this.acquisitionParameters == null ? "" : CTAcquisitionParameters.getHTMLTableHeaderRowFragment()) + "</tr>\n";
    }

    public String getHTMLTableRow() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<tr>");
        stringBuffer.append("<td>");
        if (this.seriesOrAcquisitionNumber != null && this.seriesOrAcquisitionNumber.trim().length() > 0) {
            stringBuffer.append(this.seriesOrAcquisitionNumberIsSeries ? "Series" : "Acq");
            stringBuffer.append("=");
            stringBuffer.append(this.seriesOrAcquisitionNumber);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.scanType != null) {
            stringBuffer.append(this.scanType);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.scanRange != null) {
            stringBuffer.append(this.scanRange);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.CTDIvol != null && this.CTDIvol.trim().length() > 0) {
            stringBuffer.append(this.CTDIvol);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.DLP != null && this.DLP.trim().length() > 0) {
            stringBuffer.append(this.DLP);
        }
        stringBuffer.append("</td>");
        stringBuffer.append("<td>");
        if (this.phantomType != null) {
            stringBuffer.append(this.phantomType);
        }
        stringBuffer.append("</td>");
        if (this.acquisitionParameters != null) {
            stringBuffer.append(this.acquisitionParameters.getHTMLTableRowFragment());
        }
        stringBuffer.append("</tr>\n");
        return stringBuffer.toString();
    }

    public ContentItem getStructuredReportFragment(ContentItem contentItem) throws DicomException {
        if (entireBodyDefaultAnatomy == null) {
            try {
                entireBodyDefaultAnatomy = new CodedSequenceItem("38266002", "SCT", "Entire body");
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
        }
        return this.getStructuredReportFragment(contentItem, entireBodyDefaultAnatomy);
    }

    public ContentItem getStructuredReportFragment(ContentItem contentItem, CodedSequenceItem codedSequenceItem) throws DicomException {
        if (this.contentItemFragment == null) {
            String string;
            Object object;
            ContentItemFactory contentItemFactory;
            ContentItemFactory contentItemFactory2 = contentItemFactory = new ContentItemFactory();
            contentItemFactory2.getClass();
            this.contentItemFragment = contentItemFactory2.new ContentItemFactory.ContainerContentItem(contentItem, "CONTAINS", new CodedSequenceItem("113819", "DCM", "CT Acquisition"), true, "DCMR", "10013");
            Object object2 = object = this.acquisitionParameters == null ? null : this.acquisitionParameters.getAcquisitionProtocol();
            if (object != null && ((String)object).length() > 0) {
                ContentItemFactory contentItemFactory3 = contentItemFactory;
                contentItemFactory3.getClass();
                contentItemFactory3.new ContentItemFactory.TextContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("125203", "DCM", "Acquisition Protocol"), (String)object);
            }
            Object object3 = object = this.acquisitionParameters == null ? null : this.acquisitionParameters.getAnatomy();
            if (object == null) {
                object = codedSequenceItem;
            }
            if (object == null) {
                object = entireBodyDefaultAnatomy;
            }
            ContentItemFactory contentItemFactory4 = contentItemFactory;
            contentItemFactory4.getClass();
            contentItemFactory4.new ContentItemFactory.CodeContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("123014", "DCM", "Target Region"), (CodedSequenceItem)object);
            object = this.scanType.getCodedSequenceItem();
            if (object != null) {
                ContentItemFactory contentItemFactory5 = contentItemFactory;
                contentItemFactory5.getClass();
                contentItemFactory5.new ContentItemFactory.CodeContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113820", "DCM", "CT Acquisition Type"), (CodedSequenceItem)object);
            }
            object = this.acquisitionParameters == null ? null : this.acquisitionParameters.getIrradiationEventUID();
            ContentItemFactory contentItemFactory6 = contentItemFactory;
            contentItemFactory6.getClass();
            contentItemFactory6.new ContentItemFactory.UIDContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113769", "DCM", "Irradiation Event UID"), (String)(object == null ? new UIDGenerator().getNewUID() : object));
            if (this.seriesOrAcquisitionNumber != null && this.seriesOrAcquisitionNumber.length() > 0) {
                ContentItemFactory contentItemFactory7 = contentItemFactory;
                contentItemFactory7.getClass();
                object = contentItemFactory7.new ContentItemFactory.TextContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113605", "DCM", "Irradiation Event Label"), this.seriesOrAcquisitionNumber);
                ContentItemFactory contentItemFactory8 = contentItemFactory;
                contentItemFactory8.getClass();
                contentItemFactory8.new ContentItemFactory.CodeContentItem((ContentItem)object, "HAS CONCEPT MOD", new CodedSequenceItem("113606", "DCM", "Label Type"), this.seriesOrAcquisitionNumberIsSeries ? new CodedSequenceItem("113607", "DCM", "Series Number") : new CodedSequenceItem("113608", "DCM", "Acquisition Number"));
            }
            if (this.acquisitionParameters != null) {
                this.acquisitionParameters.getStructuredReportFragment(this.contentItemFragment);
            }
            if ((object = this.contentItemFragment.getNamedChild("DCM", "113822")) == null) {
                ContentItemFactory contentItemFactory9 = contentItemFactory;
                contentItemFactory9.getClass();
                object = contentItemFactory9.new ContentItemFactory.ContainerContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113822", "DCM", "CT Acquisition Parameters"), true);
            }
            if ((string = ((ContentItem)object).getSingleStringValueOrNullOfNamedChild("DCM", "113825")) == null || string.length() == 0) {
                String string2;
                String string3 = this.getScanningLengthFromDLPAndCTDIVol();
                String string4 = string2 = this.scanRange == null ? null : this.scanRange.getAbsoluteRange();
                if (string3 == null || string3.length() == 0) {
                    slf4jlogger.info("CTDoseAcquisition.getStructuredReportFragment(): using scanning length from scan range ({}), since cannot derive from DLP and CTDIvol", string2);
                    string = string2;
                } else if (string2 == null || string2.length() == 0) {
                    string = string3;
                } else {
                    try {
                        double d = Double.parseDouble(string3);
                        double d2 = Double.parseDouble(string2);
                        if (d > d2) {
                            string = string3;
                        } else {
                            slf4jlogger.info("CTDoseAcquisition.getStructuredReportFragment(): using scanning length from scan range ({}), since greater than DLP and CTDIvol derived ({})", string2, string3);
                            string = string2;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        slf4jlogger.error("", numberFormatException);
                    }
                }
                if (string != null) {
                    ContentItemFactory contentItemFactory10 = contentItemFactory;
                    contentItemFactory10.getClass();
                    contentItemFactory10.new ContentItemFactory.NumericContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("113825", "DCM", "Scanning Length"), string, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
                }
            }
            if (this.scanRange != null && ((string = ((ContentItem)object).getSingleStringValueOrNullOfNamedChild("DCM", "113893")) == null || string.length() == 0) && (string = this.scanRange.getAbsoluteRange()) != null) {
                ContentItemFactory contentItemFactory11 = contentItemFactory;
                contentItemFactory11.getClass();
                contentItemFactory11.new ContentItemFactory.NumericContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("113893", "DCM", "Length of Reconstructable Volume"), string, new CodedSequenceItem("mm", "UCUM", "1.8", "mm"));
            }
            if (this.CTDIvol != null && this.CTDIvol.trim().length() > 0 || this.phantomType != null || this.DLP != null && this.DLP.trim().length() > 0) {
                ContentItemFactory contentItemFactory12 = contentItemFactory;
                contentItemFactory12.getClass();
                object = contentItemFactory12.new ContentItemFactory.ContainerContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("113829", "DCM", "CT Dose"), true);
                if (this.CTDIvol != null && this.CTDIvol.trim().length() > 0) {
                    ContentItemFactory contentItemFactory13 = contentItemFactory;
                    contentItemFactory13.getClass();
                    contentItemFactory13.new ContentItemFactory.NumericContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("113830", "DCM", "Mean CTDIvol"), this.CTDIvol, new CodedSequenceItem("mGy", "UCUM", "1.8", "mGy"));
                }
                if (this.phantomType != null) {
                    ContentItemFactory contentItemFactory14 = contentItemFactory;
                    contentItemFactory14.getClass();
                    contentItemFactory14.new ContentItemFactory.CodeContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("113835", "DCM", "CTDIw Phantom Type"), this.phantomType.getCodedSequenceItem());
                }
                if (this.DLP != null && this.DLP.trim().length() > 0) {
                    ContentItemFactory contentItemFactory15 = contentItemFactory;
                    contentItemFactory15.getClass();
                    contentItemFactory15.new ContentItemFactory.NumericContentItem((ContentItem)object, "CONTAINS", new CodedSequenceItem("113838", "DCM", "DLP"), this.DLP, new CodedSequenceItem("mGy.cm", "UCUM", "1.8", "mGy.cm"));
                }
                if (this.doseCheckDetails != null) {
                    this.doseCheckDetails.getStructuredReportFragment((ContentItem)object);
                }
            }
            Object object4 = object = this.acquisitionParameters == null ? null : this.acquisitionParameters.getComment();
            if (object != null && ((String)object).length() > 0) {
                ContentItemFactory contentItemFactory16 = contentItemFactory;
                contentItemFactory16.getClass();
                contentItemFactory16.new ContentItemFactory.TextContentItem(this.contentItemFragment, "CONTAINS", new CodedSequenceItem("121106", "DCM", "Comment"), (String)object);
            }
        }
        return this.contentItemFragment;
    }
}

