/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dose;

import com.pixelmed.anatproc.CTAnatomy;
import com.pixelmed.anatproc.CombinedAnatomicConcepts;
import com.pixelmed.anatproc.DisplayableConcept;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DescriptionFactory;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomDirectoryRecord;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomFileUtilities;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dose.CTAcquisitionParameters;
import com.pixelmed.dose.CTScanType;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.OCR;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import com.pixelmed.utils.FloatFormatter;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class CTIrradiationEventDataFromImages {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dose/CTIrradiationEventDataFromImages.java,v 1.52 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CTIrradiationEventDataFromImages.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    private UIDGenerator u = new UIDGenerator();
    private ArrayList<String> doseScreenFilenames = new ArrayList();
    private ArrayList<String> doseStructuredReportFilenames = new ArrayList();
    private ArrayList<Slice> slices = new ArrayList();
    boolean organized = false;
    boolean extracted = false;
    private Map<String, String> generatedIrradiationEventUIDByAcquisitionTimeAndSeriesNumberAndStudyInstanceUID = new TreeMap<String, String>();
    private Map<String, List<Slice>> slicesByIrradiationEventUID = new HashMap<String, List<Slice>>();
    private String timezoneOffsetFromUTC;
    private boolean timezoneOffsetFromUTCIsClean = true;
    private String patientAge;
    private boolean patientAgeIsClean = true;
    private String patientSex;
    private boolean patientSexIsClean = true;
    private String patientWeight;
    private boolean patientWeightIsClean = true;
    private String patientSize;
    private boolean patientSizeIsClean = true;
    private Map<String, String> studyInstanceUIDByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> studyInstanceUIDByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> frameOfReferenceUIDByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> frameOfReferenceUIDByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> imageTypeByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> imageTypeByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> acquisitionNumberByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> acquisitionNumberByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> seriesNumberByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> seriesNumberByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> seriesDescriptionByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> seriesDescriptionByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> protocolNameByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> protocolNameByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> imageTypeValue3ByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> imageTypeValue3ByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> orientationByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> orientationByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> exposureTimeByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> exposureTimeByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> kvpByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> kvpByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> tubeCurrentByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> tubeCurrentByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, Double> tubeCurrentTotalByEvent = new TreeMap<String, Double>();
    private Map<String, Double> tubeCurrentCountByEvent = new TreeMap<String, Double>();
    private Map<String, Double> tubeCurrentMaximumByEvent = new TreeMap<String, Double>();
    private Map<String, Double> midScanTimeCountByEvent = new TreeMap<String, Double>();
    private Map<String, Double> midScanTimeMinimumByEvent = new TreeMap<String, Double>();
    private Map<String, Double> midScanTimeMaximumByEvent = new TreeMap<String, Double>();
    private Map<String, String> exposureTimePerRotationByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> exposureTimePerRotationByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> nominalSingleCollimationWidthInMMByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> nominalSingleCollimationWidthInMMByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> nominalTotalCollimationWidthInMMByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> nominalTotalCollimationWidthInMMByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> sliceThicknessInMMByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> sliceThicknessInMMByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> pitchFactorByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> pitchFactorByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> exposureModulationTypeByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> exposureModulationTypeByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> estimatedDoseSavingByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> estimatedDoseSavingByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> CTDIvolByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> CTDIvolByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> DLPByEvent = new TreeMap<String, String>();
    private Map<String, Boolean> DLPByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, DisplayableConcept> anatomyByEvent = new TreeMap<String, DisplayableConcept>();
    private Map<String, Boolean> anatomyByEventIsClean = new TreeMap<String, Boolean>();
    private Map<String, String> startAcquisitionDateTimeByEvent = new TreeMap<String, String>();
    private Map<String, String> endAcquisitionDateTimeByEvent = new TreeMap<String, String>();
    private Map<String, Double> lowestSliceLocationByEvent = new TreeMap<String, Double>();
    private Map<String, Double> highestSliceLocationByEvent = new TreeMap<String, Double>();
    private Map<String, Double> lowestZLocationByEvent = new TreeMap<String, Double>();
    private Map<String, Double> highestZLocationByEvent = new TreeMap<String, Double>();
    private Map<String, CTAcquisitionParameters> acquisitionParametersBySeriesNumberAndScanRangeAndStudyInstanceUIDKey = null;
    private Map<String, CTAcquisitionParameters> acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey = null;
    private Map<String, String> overallEarliestAcquisitionDateTimeByStudy = new TreeMap<String, String>();
    private Map<String, String> overallLatestAcquisitionDateTimeByStudy = new TreeMap<String, String>();
    private Map<String, DisplayableConcept> combinedAnatomyForStudy = new TreeMap<String, DisplayableConcept>();
    protected Set<File> filesAlreadyDone = new HashSet<File>();

    public ArrayList<String> getDoseScreenFilenames() {
        return this.doseScreenFilenames;
    }

    public ArrayList<String> getDoseStructuredReportFilenames() {
        return this.doseStructuredReportFilenames;
    }

    public ArrayList<String> getDoseScreenOrStructuredReportFilenames() {
        return this.getDoseScreenOrStructuredReportFilenames(true, true);
    }

    public ArrayList<String> getDoseScreenOrStructuredReportFilenames(boolean bl, boolean bl2) {
        ArrayList<String> arrayList;
        if (bl && bl2) {
            arrayList = new ArrayList<String>(this.doseScreenFilenames);
            arrayList.addAll(this.doseStructuredReportFilenames);
        } else {
            arrayList = bl ? this.doseScreenFilenames : (bl2 ? this.doseStructuredReportFilenames : new ArrayList());
        }
        return arrayList;
    }

    public static double getDoubleValueOrZeroIfEmpty(String string) throws NumberFormatException {
        double d = 0.0;
        if (string != null && (string = string.trim()).length() > 0) {
            d = Double.valueOf(string);
        }
        return d;
    }

    public static double getDoubleValueOrZeroIfEmptyOrInvalid(String string) {
        double d = 0.0;
        try {
            d = CTIrradiationEventDataFromImages.getDoubleValueOrZeroIfEmpty(string);
        }
        catch (NumberFormatException numberFormatException) {
            slf4jlogger.error("", numberFormatException);
        }
        return d;
    }

    private void needEverythingOrganizedAndExtracted() {
        if (!this.organized) {
            this.organizeSlicesIntoIrradiationEvents();
        }
        if (!this.extracted) {
            this.extractConsistentParametersWithinIrradiationEvents();
        }
    }

    public String getTimezoneOffsetFromUTC() {
        return this.timezoneOffsetFromUTCIsClean ? this.timezoneOffsetFromUTC : null;
    }

    public String getPatientAge() {
        return this.patientAgeIsClean ? this.patientAge : null;
    }

    public String getPatientSex() {
        return this.patientSexIsClean ? this.patientSex : null;
    }

    public String getPatientWeight() {
        return this.patientWeightIsClean ? this.patientWeight : null;
    }

    public String getPatientSize() {
        return this.patientSizeIsClean ? this.patientSize : null;
    }

    public String getOverallEarliestAcquisitionDateTimeForStudy(String string) {
        this.needEverythingOrganizedAndExtracted();
        return this.overallEarliestAcquisitionDateTimeByStudy.get(string);
    }

    public String getOverallLatestAcquisitionDateTimeForStudy(String string) {
        this.needEverythingOrganizedAndExtracted();
        return this.overallLatestAcquisitionDateTimeByStudy.get(string);
    }

    public DisplayableConcept getCombinedAnatomyForStudy(String string) {
        this.needEverythingOrganizedAndExtracted();
        return this.combinedAnatomyForStudy.get(string);
    }

    private static void putAnatomyByStringIndexIfNotDifferentOrCanCombineElseSetToWholeBody(Map<String, DisplayableConcept> map, String string, DisplayableConcept displayableConcept) {
        if (displayableConcept != null) {
            DisplayableConcept displayableConcept2 = map.get(string);
            if (displayableConcept2 == null) {
                map.put(string, displayableConcept);
            } else if (!displayableConcept2.equals(displayableConcept)) {
                DisplayableConcept displayableConcept3 = CombinedAnatomicConcepts.getCombinedConcept(displayableConcept2, displayableConcept, CTAnatomy.getAnatomyConcepts());
                if (displayableConcept3 != null) {
                    map.put(string, displayableConcept3);
                } else {
                    map.put(string, CTAnatomy.getAnatomyConcepts().find("38266002"));
                }
            }
        }
    }

    private static void putAnatomyByStringIndexIfNotDifferentOrCanCombineElseFlagAsUnclean(Map<String, DisplayableConcept> map, Map<String, Boolean> map2, String string, DisplayableConcept displayableConcept) {
        if (displayableConcept != null) {
            DisplayableConcept displayableConcept2;
            Boolean bl = map2.get(string);
            if (bl == null) {
                bl = true;
                map2.put(string, bl);
            }
            if ((displayableConcept2 = map.get(string)) == null) {
                map.put(string, displayableConcept);
            } else if (!displayableConcept2.equals(displayableConcept)) {
                DisplayableConcept displayableConcept3 = CombinedAnatomicConcepts.getCombinedConcept(displayableConcept2, displayableConcept, CTAnatomy.getAnatomyConcepts());
                if (displayableConcept3 != null) {
                    map.put(string, displayableConcept3);
                } else {
                    bl = false;
                    map2.put(string, bl);
                }
            }
        }
    }

    private static void putNumericStringValueByStringIndexIfNumericSortIsEarlier(Map<String, Double> map, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                Double d = new Double(string2);
                Double d2 = map.get(string);
                if (d2 == null) {
                    map.put(string, d);
                } else if (d.compareTo(d2) < 0) {
                    map.put(string, d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static void putNumericStringValueByStringIndexIfNumericSortIsLater(Map<String, Double> map, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                Double d = new Double(string2);
                Double d2 = map.get(string);
                if (d2 == null) {
                    map.put(string, d);
                } else if (d.compareTo(d2) > 0) {
                    map.put(string, d);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static void putStringValueByStringIndexIfLexicographicSortIsEarlier(Map<String, String> map, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            String string3 = map.get(string);
            if (string3 == null || string3.equals("")) {
                map.put(string, string2);
            } else if (string2.compareTo(string3) < 0) {
                map.put(string, string2);
            }
        }
    }

    private static void putStringValueByStringIndexIfLexicographicSortIsLater(Map<String, String> map, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            String string3 = map.get(string);
            if (string3 == null || string3.equals("")) {
                map.put(string, string2);
            } else if (string2.compareTo(string3) > 0) {
                map.put(string, string2);
            }
        }
    }

    private static void putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(Map<String, String> map, Map<String, Boolean> map2, String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            String string3;
            Boolean bl = map2.get(string);
            if (bl == null) {
                bl = true;
                map2.put(string, bl);
            }
            if ((string3 = map.get(string)) == null || string3.equals("")) {
                map.put(string, string2);
            } else if (!string3.equals(string2)) {
                bl = false;
                map2.put(string, bl);
            }
        }
    }

    private static boolean booleanExistsInMapAndIsTrue(Map<String, Boolean> map, String string) {
        Boolean bl = map.get(string);
        return bl != null && bl != false;
    }

    public CTAcquisitionParameters getAcquisitionParametersForIrradiationEvent(String string) {
        Object object;
        DisplayableConcept displayableConcept;
        Object object2;
        Object object3;
        Object object4;
        Double d;
        String string2;
        String string3;
        this.needEverythingOrganizedAndExtracted();
        String string4 = string3 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.orientationByEventIsClean, string) ? this.orientationByEvent.get(string) : null;
        if (string3 == null || !string3.equals("AXIAL")) {
            return null;
        }
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        decimalFormat.setMaximumFractionDigits(2);
        decimalFormat.setMinimumFractionDigits(2);
        decimalFormat.setDecimalSeparatorAlwaysShown(true);
        decimalFormat.setGroupingUsed(false);
        CTScanType cTScanType = CTScanType.UNKNOWN;
        if (CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.imageTypeValue3ByEventIsClean, string) && (string2 = this.imageTypeValue3ByEvent.get(string)) != null && string2.toUpperCase(Locale.US).equals("LOCALIZER")) {
            cTScanType = CTScanType.LOCALIZER;
        }
        String string5 = string2 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.pitchFactorByEventIsClean, string) ? this.pitchFactorByEvent.get(string) : null;
        if (!cTScanType.equals(CTScanType.LOCALIZER) && string2 != null && string2.length() > 0) {
            try {
                double d2 = Double.parseDouble(string2);
                if (d2 == 0.0) {
                    cTScanType = CTScanType.STATIONARY;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean bl = cTScanType.equals(CTScanType.LOCALIZER);
        String string6 = null;
        if (bl) {
            if (CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.exposureTimeByEventIsClean, string)) {
                string6 = this.exposureTimeByEvent.get(string);
            }
        } else {
            d = this.midScanTimeCountByEvent.get(string);
            object4 = this.midScanTimeMinimumByEvent.get(string);
            object3 = this.midScanTimeMaximumByEvent.get(string);
            if (d != null && object4 != null && object3 != null) {
                double d3 = d;
                double d4 = (Double)object4;
                double d5 = (Double)object3;
                double d6 = (d5 - d4) * (d3 + 1.0) / d3;
                if (d6 > 0.0) {
                    string6 = decimalFormat.format(d6);
                }
            }
        }
        d = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.kvpByEventIsClean, string) ? this.kvpByEvent.get(string) : null;
        object4 = null;
        object3 = null;
        if (CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.tubeCurrentByEventIsClean, string)) {
            object3 = object4 = this.tubeCurrentByEvent.get(string);
        } else {
            double d7;
            Double d8 = this.tubeCurrentTotalByEvent.get(string);
            object2 = this.tubeCurrentCountByEvent.get(string);
            Double d9 = this.tubeCurrentMaximumByEvent.get(string);
            if (d8 != null && object2 != null && (d7 = ((Double)object2).doubleValue()) > 0.0) {
                double d10 = d8 / d7;
                object4 = decimalFormat.format(d10);
            }
            if (d9 != null) {
                object3 = decimalFormat.format(d9);
            }
        }
        String string7 = null;
        if (!bl) {
            String string8 = string7 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.exposureTimePerRotationByEventIsClean, string) ? this.exposureTimePerRotationByEvent.get(string) : null;
            if ((string7 == null || string7.trim().length() == 0) && CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.exposureTimeByEventIsClean, string)) {
                string7 = this.exposureTimeByEvent.get(string);
            }
        }
        object2 = null;
        try {
            DisplayableConcept displayableConcept2 = displayableConcept = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.anatomyByEventIsClean, string) ? this.anatomyByEvent.get(string) : null;
            if (displayableConcept != null) {
                object2 = displayableConcept.getCodedSequenceItem();
            }
        }
        catch (DicomException dicomException) {
            slf4jlogger.error("", dicomException);
        }
        displayableConcept = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.protocolNameByEventIsClean, string) ? this.protocolNameByEvent.get(string) : null;
        String string9 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.seriesDescriptionByEventIsClean, string) ? this.seriesDescriptionByEvent.get(string) : null;
        String string10 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.nominalSingleCollimationWidthInMMByEventIsClean, string) ? this.nominalSingleCollimationWidthInMMByEvent.get(string) : null;
        String string11 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.nominalTotalCollimationWidthInMMByEventIsClean, string) ? this.nominalTotalCollimationWidthInMMByEvent.get(string) : null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        if (!bl) {
            object = this.lowestZLocationByEvent.get(string);
            Double d11 = this.highestZLocationByEvent.get(string);
            if (object != null && d11 != null) {
                double d12 = 0.0;
                double d13 = 0.0;
                if (CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.sliceThicknessInMMByEventIsClean, string)) {
                    try {
                        d12 = Double.parseDouble(this.sliceThicknessInMMByEvent.get(string));
                        d13 = d12 / 2.0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        slf4jlogger.error("", numberFormatException);
                    }
                }
                double d14 = (Double)object;
                double d15 = d11;
                double d16 = d15 - d14;
                if (d16 < 0.0) {
                    double d17 = d15;
                    d15 = d14;
                    d14 = d17;
                    d16 = -d16;
                }
                string14 = CTIrradiationEventDataFromImages.locationValueToStringSigned(d14 -= d13);
                string13 = CTIrradiationEventDataFromImages.locationValueToStringSigned(d15 += d13);
                string12 = decimalFormat.format(d16 += d12);
            }
        }
        object = null;
        if (CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.frameOfReferenceUIDByEventIsClean, string)) {
            object = this.frameOfReferenceUIDByEvent.get(string);
        }
        return new CTAcquisitionParameters(string, cTScanType, (CodedSequenceItem)object2, (String)((Object)displayableConcept), string9, string6, string12, string12, null, string13, string14, null, null, (String)object, string10, string11, string2, (String)((Object)d), (String)object4, (String)object3, string7);
    }

    public CTAcquisitionParameters getAcquisitionParametersBySeriesNumberScanRangeAndStudyInstanceUID(String string) {
        if (this.acquisitionParametersBySeriesNumberAndScanRangeAndStudyInstanceUIDKey == null) {
            this.needEverythingOrganizedAndExtracted();
            this.acquisitionParametersBySeriesNumberAndScanRangeAndStudyInstanceUIDKey = new TreeMap<String, CTAcquisitionParameters>();
            for (String string2 : this.slicesByIrradiationEventUID.keySet()) {
                CTAcquisitionParameters cTAcquisitionParameters;
                String string3;
                String string4 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.seriesNumberByEventIsClean, string2) ? this.seriesNumberByEvent.get(string2) : "";
                String string5 = CTIrradiationEventDataFromImages.locationValueToStringIS(this.highestSliceLocationByEvent.get(string2));
                String string6 = CTIrradiationEventDataFromImages.locationValueToStringIS(this.lowestSliceLocationByEvent.get(string2));
                String string7 = string3 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.studyInstanceUIDByEventIsClean, string2) ? this.studyInstanceUIDByEvent.get(string2) : "";
                String string8 = string4 + "+" + string5 + "+" + string6 + "+" + string3;
                if (string8.equals("+++") || (cTAcquisitionParameters = this.getAcquisitionParametersForIrradiationEvent(string2)) == null) continue;
                CTAcquisitionParameters cTAcquisitionParameters2 = this.acquisitionParametersBySeriesNumberAndScanRangeAndStudyInstanceUIDKey.get(string8);
                if (cTAcquisitionParameters2 != null) {
                    slf4jlogger.info("CTIrradiationEventDataFromImages.getAcquisitionParametersBySeriesNumberScanRangeAndStudyInstanceUID(): just using the first one encountered - may be non-deterministic :(");
                }
                this.acquisitionParametersBySeriesNumberAndScanRangeAndStudyInstanceUIDKey.put(string8, cTAcquisitionParameters);
            }
        }
        CTAcquisitionParameters cTAcquisitionParameters = this.acquisitionParametersBySeriesNumberAndScanRangeAndStudyInstanceUIDKey.get(string);
        return cTAcquisitionParameters;
    }

    public CTAcquisitionParameters getAcquisitionParametersByAcquisitionNumberAndStudyInstanceUID(String string) {
        if (this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey == null) {
            this.needEverythingOrganizedAndExtracted();
            this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey = new TreeMap<String, CTAcquisitionParameters>();
            for (String string2 : this.slicesByIrradiationEventUID.keySet()) {
                String string3;
                String string4 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.acquisitionNumberByEventIsClean, string2) ? this.acquisitionNumberByEvent.get(string2) : "";
                String string5 = string3 = CTIrradiationEventDataFromImages.booleanExistsInMapAndIsTrue(this.studyInstanceUIDByEventIsClean, string2) ? this.studyInstanceUIDByEvent.get(string2) : "";
                String string6 = string4 + "+" + string3;
                if (string6.equals("+")) continue;
                boolean bl = true;
                CTAcquisitionParameters cTAcquisitionParameters = this.getAcquisitionParametersForIrradiationEvent(string2);
                if (cTAcquisitionParameters == null) {
                    bl = false;
                } else {
                    CTAcquisitionParameters cTAcquisitionParameters2 = this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey.get(string6);
                    if (cTAcquisitionParameters2 != null && !cTAcquisitionParameters2.equalsApartFromIrradiationEventUID(cTAcquisitionParameters)) {
                        bl = false;
                        CTScanType cTScanType = cTAcquisitionParameters.getScanType();
                        CTScanType cTScanType2 = cTAcquisitionParameters2.getScanType();
                        if (cTScanType != null && cTScanType2 != null) {
                            boolean bl2 = cTScanType.equals(CTScanType.LOCALIZER);
                            boolean bl3 = cTScanType2.equals(CTScanType.LOCALIZER);
                            if (bl3 && !bl2) {
                                bl = true;
                            } else if (!bl3 && bl2) {
                                bl = false;
                            } else {
                                double d;
                                double d2 = CTIrradiationEventDataFromImages.getDoubleValueOrZeroIfEmptyOrInvalid(cTAcquisitionParameters.getLengthOfReconstructableVolumeInMM());
                                if (d2 > (d = CTIrradiationEventDataFromImages.getDoubleValueOrZeroIfEmptyOrInvalid(cTAcquisitionParameters2.getLengthOfReconstructableVolumeInMM()))) {
                                    bl = true;
                                } else if (d2 < d) {
                                    bl = false;
                                } else {
                                    slf4jlogger.info("CTIrradiationEventDataFromImages.getAcquisitionParametersByAcquisitionNumber(): same length but not equal :( just using the first one encountered - may be non-deterministic :(");
                                }
                            }
                        }
                    }
                }
                if (!bl) continue;
                this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey.put(string6, cTAcquisitionParameters);
            }
        }
        CTAcquisitionParameters cTAcquisitionParameters = this.acquisitionParametersByAcquisitionNumberAndStudyInstanceUIDKey.get(string);
        return cTAcquisitionParameters;
    }

    public CTIrradiationEventDataFromImages() {
    }

    public CTIrradiationEventDataFromImages(String string) {
        this.add(string);
    }

    public CTIrradiationEventDataFromImages(Vector<String> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            this.add(vector.get(i));
        }
    }

    public void add(String string) {
        this.add(new File(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(File file) {
        if (this.filesAlreadyDone.contains(file)) {
            slf4jlogger.info("CTIrradiationEventDataFromImages.add(): ignoring request to handle path already processed {}", file);
            return;
        } else {
            this.filesAlreadyDone.add(file);
            if (!file.exists()) return;
            if (file.isDirectory()) {
                ArrayList<File> arrayList = FileUtilities.listFilesRecursively(file);
                for (File file2 : arrayList) {
                    this.add(file2);
                }
                return;
            } else if (file.isFile() && file.getName().toUpperCase(Locale.US).equals("DICOMDIR")) {
                try {
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(file.getCanonicalPath());
                    DicomDirectory dicomDirectory = new DicomDirectory(attributeList);
                    HashMap<String, DicomDirectoryRecord> hashMap = dicomDirectory.findAllContainedReferencedFileNamesAndTheirRecords(file.getParentFile().getCanonicalPath());
                    for (String string : hashMap.keySet()) {
                        if (string == null) continue;
                        File file3 = new File(string);
                        if (file3.isDirectory()) {
                            slf4jlogger.info("CTIrradiationEventDataFromImages.add(): ignoring directory (rather than file) referenced from within DICOMDIR {}", string);
                            continue;
                        }
                        if (file3.getName().toUpperCase(Locale.US).equals("DICOMDIR")) {
                            slf4jlogger.info("CTIrradiationEventDataFromImages.add(): ignoring DICOMDIR referenced from within DICOMDIR");
                            continue;
                        }
                        this.add(file3);
                    }
                    return;
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    return;
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                    return;
                }
            } else {
                if (!file.isFile() || !DicomFileUtilities.isDicomOrAcrNemaFile(file)) return;
                try {
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(file.getCanonicalPath(), null, true, true, TagFromName.PixelData);
                    String string = "";
                    CodedSequenceItem codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.ConceptNameCodeSequence);
                    if (OCR.isDoseScreenInstance(attributeList) || ExposureDoseSequence.isPhilipsDoseScreenInstance(attributeList)) {
                        this.doseScreenFilenames.add(file.getCanonicalPath());
                        return;
                    }
                    String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                    if (SOPClass.isStructuredReport(string2) && codedSequenceItem != null && codedSequenceItem.getCodingSchemeDesignator().equals("DCM") && codedSequenceItem.getCodeValue().equals("113701")) {
                        this.doseStructuredReportFilenames.add(file.getCanonicalPath());
                        return;
                    }
                    if (!string2.equals("1.2.840.10008.5.1.4.1.1.2")) return;
                    this.organized = false;
                    this.extracted = false;
                    Slice slice = new Slice(attributeList);
                    this.slices.add(slice);
                    return;
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void organizeSlicesIntoIrradiationEvents() {
        if (!this.slices.isEmpty()) {
            ArrayList<Slice> arrayList = new ArrayList<Slice>();
            for (Slice iterator : this.slices) {
                if (iterator.irradiationEventUID.length() > 0) {
                    void var4_6;
                    List<Slice> list = this.slicesByIrradiationEventUID.get(iterator.irradiationEventUID);
                    if (list == null) {
                        ArrayList arrayList2 = new ArrayList();
                        this.slicesByIrradiationEventUID.put(iterator.irradiationEventUID, arrayList2);
                    }
                    var4_6.add(iterator);
                    continue;
                }
                arrayList.add(iterator);
            }
            if (!arrayList.isEmpty()) {
                List<Slice> list;
                Object object;
                HashMap hashMap = new HashMap();
                for (Slice slice : arrayList) {
                    object = slice.studyInstanceUID + "+" + slice.seriesInstanceUID;
                    list = (List)hashMap.get(object);
                    if (list == null) {
                        list = new ArrayList<Slice>();
                        hashMap.put(object, list);
                    }
                    list.add(slice);
                }
                for (String string : hashMap.keySet()) {
                    Object object2;
                    object = (Collection)hashMap.get(string);
                    list = new TreeMap();
                    Object object3 = object.iterator();
                    while (object3.hasNext()) {
                        object2 = (Slice)object3.next();
                        ArrayList arrayList3 = (ArrayList)list.get(((Slice)object2).acquisitionDateTime);
                        if (arrayList3 == null) {
                            arrayList3 = new ArrayList();
                            list.put(((Slice)object2).acquisitionDateTime, arrayList3);
                        }
                        arrayList3.add(object2);
                    }
                    object3 = new ArrayList();
                    object2 = new ArrayList();
                    object3.add(object2);
                    double d = 0.0;
                    double d2 = 0.0;
                    boolean bl = true;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    boolean bl2 = true;
                    for (List list2 : list.values()) {
                        for (Slice slice : list2) {
                            String string2 = slice.sliceLocation;
                            if (slice.sliceLocation == null || slice.sliceLocation.length() == 0) {
                                string2 = slice.zLocation;
                            }
                            if (string2 == null || string2.length() <= 0) continue;
                            try {
                                double d5 = Double.parseDouble(string2);
                                if (bl) {
                                    bl = false;
                                    d = d5;
                                    d2 = d5;
                                    continue;
                                }
                                if (d5 < d) {
                                    d = d5;
                                    continue;
                                }
                                if (!(d5 > d2)) continue;
                                d2 = d5;
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.err.println("CTIrradiationEventDataFromImages.organizeSlicesIntoIrradiationEvents(): Bad SliceLocation in SOP Instance " + slice.sopInstanceUID);
                                slf4jlogger.error("", numberFormatException);
                            }
                        }
                        if (bl) continue;
                        if (bl2) {
                            object2.addAll(list2);
                            bl = true;
                            bl2 = false;
                            d3 = d;
                            d4 = d2;
                            continue;
                        }
                        if (d4 < d || d2 < d3) {
                            object2.addAll(list2);
                            bl = true;
                            bl2 = false;
                            d3 = d3 < d ? d3 : d;
                            d4 = d4 > d2 ? d4 : d2;
                            continue;
                        }
                        object2 = new ArrayList();
                        object3.add(object2);
                        object2.addAll(list2);
                        bl = true;
                        bl2 = false;
                        d3 = d;
                        d4 = d2;
                    }
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        List list3 = (List)object2.next();
                        if (list3.isEmpty()) {
                            object2.remove();
                            continue;
                        }
                        String string3 = "";
                        try {
                            string3 = this.u.getAnotherNewUID();
                        }
                        catch (DicomException dicomException) {
                            slf4jlogger.error("", dicomException);
                        }
                        this.slicesByIrradiationEventUID.put(string3, list3);
                        for (Slice slice : list3) {
                            slice.irradiationEventUID = string3;
                        }
                    }
                }
            }
        }
        this.organized = true;
    }

    private void extractConsistentParametersWithinIrradiationEvents() {
        for (String string : this.slicesByIrradiationEventUID.keySet()) {
            List<Slice> list = this.slicesByIrradiationEventUID.get(string);
            for (Slice slice : list) {
                double d;
                double d2;
                Double d3;
                double d4;
                Double d5;
                double d6;
                Object object;
                Object object2;
                if (this.timezoneOffsetFromUTCIsClean && !((String)(object2 = slice.timezoneOffsetFromUTC)).equals("")) {
                    if (this.timezoneOffsetFromUTC == null || this.timezoneOffsetFromUTC.equals("")) {
                        this.timezoneOffsetFromUTC = object2;
                    } else if (!this.timezoneOffsetFromUTC.equals(object2)) {
                        this.timezoneOffsetFromUTCIsClean = false;
                    }
                }
                if (this.patientAgeIsClean && !((String)(object2 = slice.patientAge)).equals("")) {
                    if (this.patientAge == null || this.patientAge.equals("")) {
                        this.patientAge = object2;
                    } else if (!this.patientAge.equals(object2)) {
                        this.patientAgeIsClean = false;
                    }
                }
                if (this.patientSexIsClean && !((String)(object2 = slice.patientSex)).equals("")) {
                    if (this.patientSex == null || this.patientSex.equals("")) {
                        this.patientSex = object2;
                    } else if (!this.patientSex.equals(object2)) {
                        this.patientSexIsClean = false;
                    }
                }
                if (this.patientWeightIsClean && !((String)(object2 = slice.patientWeight)).equals("")) {
                    if (this.patientWeight == null || this.patientWeight.equals("")) {
                        this.patientWeight = object2;
                    } else if (!this.patientWeight.equals(object2)) {
                        this.patientWeightIsClean = false;
                    }
                }
                if (this.patientSizeIsClean && !((String)(object2 = slice.patientSize)).equals("")) {
                    if (this.patientSize == null || this.patientSize.equals("")) {
                        this.patientSize = object2;
                    } else if (!this.patientSize.equals(object2)) {
                        this.patientSizeIsClean = false;
                    }
                }
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.studyInstanceUIDByEvent, this.studyInstanceUIDByEventIsClean, string, slice.studyInstanceUID);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.frameOfReferenceUIDByEvent, this.frameOfReferenceUIDByEventIsClean, string, slice.frameOfReferenceUID);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.imageTypeByEvent, this.imageTypeByEventIsClean, string, slice.imageType);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.imageTypeValue3ByEvent, this.imageTypeValue3ByEventIsClean, string, slice.imageTypeValue3);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.orientationByEvent, this.orientationByEventIsClean, string, slice.orientation);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.acquisitionNumberByEvent, this.acquisitionNumberByEventIsClean, string, slice.acquisitionNumber);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.seriesNumberByEvent, this.seriesNumberByEventIsClean, string, slice.seriesNumber);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.seriesDescriptionByEvent, this.seriesDescriptionByEventIsClean, string, slice.seriesDescription);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.protocolNameByEvent, this.protocolNameByEventIsClean, string, slice.protocolName);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.pitchFactorByEvent, this.pitchFactorByEventIsClean, string, slice.pitchFactor);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.exposureTimeByEvent, this.exposureTimeByEventIsClean, string, slice.exposureTimeInSeconds);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.kvpByEvent, this.kvpByEventIsClean, string, slice.kvp);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.exposureTimePerRotationByEvent, this.exposureTimePerRotationByEventIsClean, string, slice.exposureTimePerRotation);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.nominalSingleCollimationWidthInMMByEvent, this.nominalSingleCollimationWidthInMMByEventIsClean, string, slice.nominalSingleCollimationWidth);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.nominalTotalCollimationWidthInMMByEvent, this.nominalTotalCollimationWidthInMMByEventIsClean, string, slice.nominalTotalCollimationWidth);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.sliceThicknessInMMByEvent, this.sliceThicknessInMMByEventIsClean, string, slice.sliceThickness);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.exposureModulationTypeByEvent, this.exposureModulationTypeByEventIsClean, string, slice.exposureModulationType);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.estimatedDoseSavingByEvent, this.estimatedDoseSavingByEventIsClean, string, slice.estimatedDoseSaving);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.CTDIvolByEvent, this.CTDIvolByEventIsClean, string, slice.CTDIvol);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.DLPByEvent, this.DLPByEventIsClean, string, slice.DLP);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfNotDifferentElseFlagAsUnclean(this.tubeCurrentByEvent, this.tubeCurrentByEventIsClean, string, slice.tubeCurrent);
                if (slice.tubeCurrent.length() > 0) {
                    try {
                        object2 = new Double(slice.tubeCurrent);
                        object = this.tubeCurrentCountByEvent.get(string);
                        if (object == null) {
                            this.tubeCurrentCountByEvent.put(string, new Double(1.0));
                            this.tubeCurrentTotalByEvent.put(string, (Double)object2);
                            this.tubeCurrentMaximumByEvent.put(string, (Double)object2);
                        } else {
                            d6 = (Double)object2;
                            d5 = this.tubeCurrentTotalByEvent.get(string);
                            d4 = d5;
                            this.tubeCurrentTotalByEvent.put(string, new Double(d4 += d6));
                            d3 = this.tubeCurrentMaximumByEvent.get(string);
                            d2 = d3;
                            if (d6 > d2) {
                                d2 = d6;
                                this.tubeCurrentMaximumByEvent.put(string, new Double(d2));
                            }
                            d = (Double)object;
                            this.tubeCurrentCountByEvent.put(string, new Double(d += 1.0));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (slice.midScanTime.length() > 0) {
                    object2 = new Double(slice.midScanTime);
                    object = this.midScanTimeCountByEvent.get(string);
                    if (object == null) {
                        this.midScanTimeCountByEvent.put(string, new Double(1.0));
                        this.midScanTimeMinimumByEvent.put(string, (Double)object2);
                        this.midScanTimeMaximumByEvent.put(string, (Double)object2);
                    } else {
                        try {
                            d6 = (Double)object2;
                            d5 = this.midScanTimeMaximumByEvent.get(string);
                            d4 = d5;
                            if (d6 > d4) {
                                d4 = d6;
                                this.midScanTimeMaximumByEvent.put(string, new Double(d4));
                            }
                            if (d6 < (d2 = (d3 = this.midScanTimeMinimumByEvent.get(string)).doubleValue())) {
                                d2 = d6;
                                this.midScanTimeMinimumByEvent.put(string, new Double(d2));
                            }
                            d = (Double)object;
                            this.midScanTimeCountByEvent.put(string, new Double(d += 1.0));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                CTIrradiationEventDataFromImages.putAnatomyByStringIndexIfNotDifferentOrCanCombineElseFlagAsUnclean(this.anatomyByEvent, this.anatomyByEventIsClean, string, slice.anatomy);
                CTIrradiationEventDataFromImages.putAnatomyByStringIndexIfNotDifferentOrCanCombineElseSetToWholeBody(this.combinedAnatomyForStudy, slice.studyInstanceUID, slice.anatomy);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfLexicographicSortIsEarlier(this.startAcquisitionDateTimeByEvent, string, slice.acquisitionDateTime);
                CTIrradiationEventDataFromImages.putStringValueByStringIndexIfLexicographicSortIsLater(this.endAcquisitionDateTimeByEvent, string, slice.acquisitionDateTime);
                object2 = this.overallEarliestAcquisitionDateTimeByStudy.get(slice.studyInstanceUID);
                if (object2 == null || slice.acquisitionDateTime.compareTo((String)object2) < 0) {
                    this.overallEarliestAcquisitionDateTimeByStudy.put(slice.studyInstanceUID, slice.acquisitionDateTime);
                }
                if ((object = this.overallLatestAcquisitionDateTimeByStudy.get(slice.studyInstanceUID)) == null || slice.acquisitionDateTime.compareTo((String)object) > 0) {
                    this.overallLatestAcquisitionDateTimeByStudy.put(slice.studyInstanceUID, slice.acquisitionDateTime);
                }
                CTIrradiationEventDataFromImages.putNumericStringValueByStringIndexIfNumericSortIsEarlier(this.lowestSliceLocationByEvent, string, slice.sliceLocation);
                CTIrradiationEventDataFromImages.putNumericStringValueByStringIndexIfNumericSortIsLater(this.highestSliceLocationByEvent, string, slice.sliceLocation);
                CTIrradiationEventDataFromImages.putNumericStringValueByStringIndexIfNumericSortIsEarlier(this.lowestZLocationByEvent, string, slice.zLocation);
                CTIrradiationEventDataFromImages.putNumericStringValueByStringIndexIfNumericSortIsLater(this.highestZLocationByEvent, string, slice.zLocation);
            }
        }
        this.extracted = true;
    }

    private static String toStringDisplayableConcept(String string, Map<String, DisplayableConcept> map, Map<String, Boolean> map2, String string2) {
        String string3;
        Boolean bl = map2.get(string2);
        if (bl == null) {
            string3 = "-- not found --";
        } else if (bl.booleanValue()) {
            DisplayableConcept displayableConcept = map.get(string2);
            if (displayableConcept == null) {
                string3 = "-- not found --";
            } else {
                try {
                    string3 = displayableConcept.getCodedSequenceItem().toString();
                }
                catch (DicomException dicomException) {
                    string3 = "-- bad  --";
                    slf4jlogger.error("", dicomException);
                }
            }
        } else {
            string3 = "-- inconsistent values for event --";
        }
        return "\t\t" + string + " = " + string3 + "\n";
    }

    private static String toString(String string, String string2, boolean bl) {
        if (bl) {
            if (string2 == null) {
                string2 = "-- not found --";
            }
        } else {
            string2 = "-- inconsistent values for event --";
        }
        return "\t\t" + string + " = " + string2 + "\n";
    }

    private static String toString(String string, Map<String, String> map, Map<String, Boolean> map2, String string2) {
        String string3;
        Boolean bl = map2.get(string2);
        if (bl == null) {
            string3 = "-- not found --";
        } else if (bl.booleanValue()) {
            string3 = map.get(string2);
            if (string3 == null) {
                string3 = "-- not found --";
            }
        } else {
            string3 = "-- inconsistent values for event --";
        }
        return "\t\t" + string + " = " + string3 + "\n";
    }

    private static String stringValueToString(String string, Map<String, String> map, String string2) {
        String string3 = map.get(string2);
        if (string3 == null) {
            string3 = "-- not found --";
        }
        return "\t\t" + string + " = " + string3 + "\n";
    }

    private static String doubleValueToString(String string, Map<String, Double> map, String string2) {
        Double d = map.get(string2);
        String string3 = d == null ? "-- not found --" : d.toString();
        return "\t\t" + string + " = " + string3 + "\n";
    }

    private static String locationValueToStringSigned(double d) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        decimalFormat.setGroupingUsed(false);
        decimalFormat.setMinimumFractionDigits(3);
        decimalFormat.setMaximumFractionDigits(3);
        return decimalFormat.format(d);
    }

    private static String locationValueToStringSigned(Double d) {
        String string = d == null ? "" : CTIrradiationEventDataFromImages.locationValueToStringSigned((double)d);
        return string;
    }

    private static String locationValueToStringIS(Double d) {
        String string;
        string = d == null ? "" : ((string = CTIrradiationEventDataFromImages.locationValueToStringSigned((double)d)).startsWith("-") ? "I" + string.substring(1) : "S" + string);
        return string;
    }

    private static String locationValueToStringIS(String string, Map<String, Double> map, String string2) {
        String string3 = CTIrradiationEventDataFromImages.locationValueToStringIS(map.get(string2));
        if (string3.equals("")) {
            string3 = "-- not found --";
        }
        return "\t\t" + string + " = " + string3 + "\n";
    }

    public String toString() {
        this.needEverythingOrganizedAndExtracted();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tCommon:\n");
        stringBuffer.append(CTIrradiationEventDataFromImages.toString("PatientAge", this.patientAge, this.patientAgeIsClean));
        stringBuffer.append(CTIrradiationEventDataFromImages.toString("PatientSex", this.patientSex, this.patientSexIsClean));
        stringBuffer.append(CTIrradiationEventDataFromImages.toString("PatientWeight", this.patientWeight, this.patientWeightIsClean));
        stringBuffer.append(CTIrradiationEventDataFromImages.toString("PatientSize", this.patientSize, this.patientSizeIsClean));
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (String string : this.slicesByIrradiationEventUID.keySet()) {
            String string2 = CTIrradiationEventDataFromImages.toString("StudyInstanceUID", this.studyInstanceUIDByEvent, this.studyInstanceUIDByEventIsClean, string) + CTIrradiationEventDataFromImages.toString("FrameOfReferenceUID", this.frameOfReferenceUIDByEvent, this.frameOfReferenceUIDByEventIsClean, string) + CTIrradiationEventDataFromImages.toString("AcquisitionNumber", this.acquisitionNumberByEvent, this.acquisitionNumberByEventIsClean, string) + CTIrradiationEventDataFromImages.toString("SeriesNumber", this.seriesNumberByEvent, this.seriesNumberByEventIsClean, string) + string;
            treeMap.put(string2, string);
        }
        if (treeMap.size() != this.slicesByIrradiationEventUID.size()) {
            stringBuffer.append("Warning: Duplicate listing of IrradiationEventUIDs during sorting by key ...\n");
        }
        for (String string : treeMap.values()) {
            stringBuffer.append("\tIrradiationEventUID = " + string + "\n");
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("StudyInstanceUID", this.studyInstanceUIDByEvent, this.studyInstanceUIDByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("FrameOfReferenceUID", this.frameOfReferenceUIDByEvent, this.frameOfReferenceUIDByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("ImageType", this.imageTypeByEvent, this.imageTypeByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("Orientation", this.orientationByEvent, this.orientationByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("AcquisitionNumber", this.acquisitionNumberByEvent, this.acquisitionNumberByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("SeriesNumber", this.seriesNumberByEvent, this.seriesNumberByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("SeriesDescription", this.seriesDescriptionByEvent, this.seriesDescriptionByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toStringDisplayableConcept("Anatomy", this.anatomyByEvent, this.anatomyByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("ProtocolName", this.protocolNameByEvent, this.protocolNameByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.stringValueToString("StartAcquisitionDateTime", this.startAcquisitionDateTimeByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.stringValueToString("EndAcquisitionDateTime", this.endAcquisitionDateTimeByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.locationValueToStringIS("LowestSliceLocation", this.lowestSliceLocationByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.locationValueToStringIS("HighestSliceLocation", this.highestSliceLocationByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.locationValueToStringIS("LowestZLocation", this.lowestZLocationByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.locationValueToStringIS("HighestZLocation", this.highestZLocationByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("ExposureTime", this.exposureTimeByEvent, this.exposureTimeByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("KVP", this.kvpByEvent, this.kvpByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("TubeCurrent", this.tubeCurrentByEvent, this.tubeCurrentByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.doubleValueToString("TubeCurrentTotal", this.tubeCurrentTotalByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.doubleValueToString("TubeCurrentCount", this.tubeCurrentCountByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.doubleValueToString("TubeCurrentMaximum", this.tubeCurrentMaximumByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.doubleValueToString("MidScanTimeCount", this.midScanTimeCountByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.doubleValueToString("MidScanTimeMinimum", this.midScanTimeMinimumByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.doubleValueToString("MidScanTimeMaximum", this.midScanTimeMaximumByEvent, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("ExposureTimePerRotation", this.exposureTimePerRotationByEvent, this.exposureTimePerRotationByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("NominalSingleCollimationWidthInMM", this.nominalSingleCollimationWidthInMMByEvent, this.nominalSingleCollimationWidthInMMByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("NominalTotalCollimationWidthInMM", this.nominalTotalCollimationWidthInMMByEvent, this.nominalTotalCollimationWidthInMMByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("SliceThicknessInMM", this.sliceThicknessInMMByEvent, this.sliceThicknessInMMByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("PitchFactor", this.pitchFactorByEvent, this.pitchFactorByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("ExposureModulationType", this.exposureModulationTypeByEvent, this.exposureModulationTypeByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("EstimatedDoseSaving", this.estimatedDoseSavingByEvent, this.estimatedDoseSavingByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("CTDIvol", this.CTDIvolByEvent, this.CTDIvolByEventIsClean, string));
            stringBuffer.append(CTIrradiationEventDataFromImages.toString("DLP", this.DLPByEvent, this.DLPByEventIsClean, string));
        }
        for (String string : this.overallEarliestAcquisitionDateTimeByStudy.keySet()) {
            stringBuffer.append("\tStudyInstanceUID = " + string + "\n");
            stringBuffer.append("\t\tEarliestAcquisitionDateTime = " + this.overallEarliestAcquisitionDateTimeByStudy.get(string) + "\n");
            stringBuffer.append("\t\tLatestAcquisitionDateTime = " + this.overallLatestAcquisitionDateTimeByStudy.get(string) + "\n");
        }
        return stringBuffer.toString();
    }

    public static final void main(String[] stringArray) {
        try {
            CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages = new CTIrradiationEventDataFromImages(stringArray[0]);
            System.err.print(cTIrradiationEventDataFromImages);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private class Slice {
        String irradiationEventUID;
        String timezoneOffsetFromUTC;
        String patientAge;
        String patientSex;
        String patientWeight;
        String patientSize;
        String studyInstanceUID;
        String seriesInstanceUID;
        String sopInstanceUID;
        String seriesNumber;
        String acquisitionNumber;
        String seriesDescription;
        String protocolName;
        String imageType;
        String imageTypeValue3;
        String orientation;
        String exposureTimeInSeconds;
        String kvp;
        String tubeCurrent;
        String midScanTime;
        String exposureTimePerRotation;
        String nominalSingleCollimationWidth;
        String nominalTotalCollimationWidth;
        String pitchFactor;
        String acquisitionDateTime;
        String sliceLocation;
        String zLocation;
        String sliceThickness;
        String frameOfReferenceUID;
        String exposureModulationType;
        String estimatedDoseSaving;
        String CTDIvol;
        String DLP;
        DisplayableConcept anatomy;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Slice:\n");
            stringBuffer.append("\tIrradiationEventUID = ");
            stringBuffer.append(this.irradiationEventUID);
            stringBuffer.append("\n");
            stringBuffer.append("\tTimezoneOffsetFromUTC = ");
            stringBuffer.append(this.timezoneOffsetFromUTC);
            stringBuffer.append("\n");
            stringBuffer.append("\tPatientAge = ");
            stringBuffer.append(this.patientAge);
            stringBuffer.append("\n");
            stringBuffer.append("\tPatientSex = ");
            stringBuffer.append(this.patientSex);
            stringBuffer.append("\n");
            stringBuffer.append("\tPatientWeight = ");
            stringBuffer.append(this.patientWeight);
            stringBuffer.append("\n");
            stringBuffer.append("\tPatientSize = ");
            stringBuffer.append(this.patientSize);
            stringBuffer.append("\n");
            stringBuffer.append("\tStudyInstanceUID = ");
            stringBuffer.append(this.studyInstanceUID);
            stringBuffer.append("\n");
            stringBuffer.append("\tSeriesInstanceUID = ");
            stringBuffer.append(this.seriesInstanceUID);
            stringBuffer.append("\n");
            stringBuffer.append("\tSOPInstanceUID = ");
            stringBuffer.append(this.sopInstanceUID);
            stringBuffer.append("\n");
            stringBuffer.append("\tSeriesNumber = ");
            stringBuffer.append(this.seriesNumber);
            stringBuffer.append("\n");
            stringBuffer.append("\tAcquisitionNumber = ");
            stringBuffer.append(this.acquisitionNumber);
            stringBuffer.append("\n");
            stringBuffer.append("\tSeriesDescription = ");
            stringBuffer.append(this.seriesDescription);
            stringBuffer.append("\n");
            stringBuffer.append("\tProtocolName = ");
            stringBuffer.append(this.protocolName);
            stringBuffer.append("\n");
            stringBuffer.append("\tImageType = ");
            stringBuffer.append(this.imageType);
            stringBuffer.append("\n");
            stringBuffer.append("\tImageTypeValue3 = ");
            stringBuffer.append(this.imageTypeValue3);
            stringBuffer.append("\n");
            stringBuffer.append("\tOrientation = ");
            stringBuffer.append(this.orientation);
            stringBuffer.append("\n");
            stringBuffer.append("\tExposureTime = ");
            stringBuffer.append(this.exposureTimeInSeconds);
            stringBuffer.append("\n");
            stringBuffer.append("\tKVP = ");
            stringBuffer.append(this.kvp);
            stringBuffer.append("\n");
            stringBuffer.append("\tTubeCurrent = ");
            stringBuffer.append(this.tubeCurrent);
            stringBuffer.append("\n");
            stringBuffer.append("\tMidScanTime = ");
            stringBuffer.append(this.midScanTime);
            stringBuffer.append("\n");
            stringBuffer.append("\tExposureTimePerRotation = ");
            stringBuffer.append(this.exposureTimePerRotation);
            stringBuffer.append("\n");
            stringBuffer.append("\tNominalSingleCollimationWidthInMM = ");
            stringBuffer.append(this.nominalSingleCollimationWidth);
            stringBuffer.append("\n");
            stringBuffer.append("\tNominalTotalCollimationWidthInMM = ");
            stringBuffer.append(this.nominalTotalCollimationWidth);
            stringBuffer.append("\n");
            stringBuffer.append("\tPitchFactor = ");
            stringBuffer.append(this.pitchFactor);
            stringBuffer.append("\n");
            stringBuffer.append("\tAcquisitionDateTime = ");
            stringBuffer.append(this.acquisitionDateTime);
            stringBuffer.append("\n");
            stringBuffer.append("\tSliceLocation = ");
            stringBuffer.append(this.sliceLocation);
            stringBuffer.append("\n");
            stringBuffer.append("\tZLocation = ");
            stringBuffer.append(this.zLocation);
            stringBuffer.append("\n");
            stringBuffer.append("\tSliceThickness = ");
            stringBuffer.append(this.sliceThickness);
            stringBuffer.append("\n");
            stringBuffer.append("\tFrameOfReferenceUID = ");
            stringBuffer.append(this.frameOfReferenceUID);
            stringBuffer.append("\n");
            stringBuffer.append("\tExposureModulationType = ");
            stringBuffer.append(this.exposureModulationType);
            stringBuffer.append("\n");
            stringBuffer.append("\tEstimatedDoseSaving = ");
            stringBuffer.append(this.estimatedDoseSaving);
            stringBuffer.append("\n");
            stringBuffer.append("\tCTDIvol = ");
            stringBuffer.append(this.CTDIvol);
            stringBuffer.append("\n");
            stringBuffer.append("\tDLP = ");
            stringBuffer.append(this.DLP);
            stringBuffer.append("\n");
            stringBuffer.append("\tAnatomy = ");
            stringBuffer.append(this.anatomy);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        Slice(AttributeList attributeList) {
            Attribute attribute;
            double d;
            double d2;
            Object object;
            this.irradiationEventUID = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.IrradiationEventUID);
            this.timezoneOffsetFromUTC = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.TimezoneOffsetFromUTC);
            this.patientAge = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.PatientAge);
            this.patientSex = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.PatientSex);
            this.patientWeight = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.PatientWeight);
            this.patientSize = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.PatientSize);
            this.studyInstanceUID = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
            this.seriesInstanceUID = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
            this.sopInstanceUID = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
            this.seriesNumber = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.SeriesNumber);
            this.acquisitionNumber = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.AcquisitionNumber);
            this.seriesDescription = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.SeriesDescription);
            this.protocolName = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.ProtocolName);
            this.imageType = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.ImageType);
            try {
                this.imageTypeValue3 = "";
                object = attributeList.get(TagFromName.ImageType);
                if (object != null && ((Attribute)object).getVM() >= 3) {
                    String[] stringArray = ((Attribute)object).getStringValues();
                    this.imageTypeValue3 = stringArray[2];
                }
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
            this.orientation = DescriptionFactory.makeImageOrientationLabelFromImageOrientationPatient(attributeList);
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("ExposureTime"));
            if (!((String)object).equals("")) {
                this.exposureTimeInSeconds = "";
                try {
                    this.exposureTimeInSeconds = new Double(new Double((String)object) / 1000.0).toString();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.kvp = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, dictionary.getTagFromName("KVP"));
            this.tubeCurrent = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("XRayTubeCurrent"));
            this.midScanTime = "";
            if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(25, 16)).equals("GEMS_ACQU_01")) {
                this.midScanTime = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(25, 4132));
            }
            this.exposureTimePerRotation = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, dictionary.getTagFromName("RevolutionTime"));
            if (this.exposureTimePerRotation.equals("") && Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(25, 16)).equals("GEMS_ACQU_01")) {
                this.exposureTimePerRotation = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(25, 4135));
            }
            this.nominalSingleCollimationWidth = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, dictionary.getTagFromName("SingleCollimationWidth"));
            if (this.nominalSingleCollimationWidth.equals("")) {
                if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(69, 16)).equals("GEMS_HELIOS_01")) {
                    this.nominalSingleCollimationWidth = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(69, 4098));
                    if (this.nominalSingleCollimationWidth.contains("?")) {
                        this.nominalSingleCollimationWidth = "";
                    }
                } else if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(28677, 16)).equals("TOSHIBA_MEC_CT3")) {
                    this.nominalSingleCollimationWidth = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(28677, 4104));
                }
            }
            this.nominalTotalCollimationWidth = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, dictionary.getTagFromName("TotalCollimationWidth"));
            if (this.nominalTotalCollimationWidth.equals("") && !this.nominalSingleCollimationWidth.equals("")) {
                if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(69, 16)).equals("GEMS_HELIOS_01")) {
                    try {
                        double d3 = Attribute.getSingleDoubleValueOrDefault(attributeList, new AttributeTag(69, 4097), 0.0);
                        d2 = CTIrradiationEventDataFromImages.getDoubleValueOrZeroIfEmptyOrInvalid(this.nominalSingleCollimationWidth);
                        if (d3 > 0.0 && d2 > 0.0) {
                            d = d3 * d2;
                            this.nominalTotalCollimationWidth = Double.toString(d);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        slf4jlogger.error("", numberFormatException);
                    }
                } else if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(28677, 16)).equals("TOSHIBA_MEC_CT3") && ((String)(object = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(28677, 4105)))).contains("1")) {
                    int n = ((String)object).lastIndexOf(49) - ((String)object).indexOf(49) + 1;
                    d2 = CTIrradiationEventDataFromImages.getDoubleValueOrZeroIfEmptyOrInvalid(this.nominalSingleCollimationWidth);
                    d = (double)n * d2;
                    this.nominalTotalCollimationWidth = Double.toString(d);
                }
            }
            this.pitchFactor = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, dictionary.getTagFromName("SpiralPitchFactor"));
            if (this.pitchFactor.equals("")) {
                if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(67, 16)).equals("GEMS_PARM_01")) {
                    this.pitchFactor = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(67, 4135));
                    this.pitchFactor = this.pitchFactor.trim().replace(":1", "");
                } else if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(28677, 16)).equals("TOSHIBA_MEC_CT3")) {
                    this.pitchFactor = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(28677, 4131));
                }
                if (this.pitchFactor.equals("") && !this.nominalTotalCollimationWidth.equals("")) {
                    try {
                        double d4 = Attribute.getSingleDoubleValueOrDefault(attributeList, dictionary.getTagFromName("TableFeedPerRotation"), 0.0);
                        if (d4 == 0.0 && Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(69, 16)).equals("GEMS_ACQU_01")) {
                            d4 = Attribute.getSingleDoubleValueOrDefault(attributeList, new AttributeTag(25, 4131), 0.0);
                        }
                        if (d4 > 0.0 && (d2 = CTIrradiationEventDataFromImages.getDoubleValueOrZeroIfEmptyOrInvalid(this.nominalTotalCollimationWidth)) > 0.0) {
                            d = d4 / d2;
                            this.pitchFactor = Double.toString(d);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        slf4jlogger.error("", numberFormatException);
                    }
                }
            }
            this.acquisitionDateTime = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionDateTime);
            if (this.acquisitionDateTime.equals("")) {
                this.acquisitionDateTime = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionDate) + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionTime);
            }
            this.sliceLocation = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SliceLocation);
            this.anatomy = CTAnatomy.findAnatomicConcept(attributeList);
            try {
                this.zLocation = "";
                attribute = attributeList.get(TagFromName.ImagePositionPatient);
                if (attribute != null && attribute.getVM() == 3) {
                    String[] stringArray = attribute.getStringValues();
                    this.zLocation = stringArray[2];
                }
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
            this.sliceThickness = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SliceThickness);
            this.frameOfReferenceUID = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.FrameOfReferenceUID);
            this.exposureModulationType = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("ExposureModulationType"));
            this.estimatedDoseSaving = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("EstimatedDoseSaving"));
            this.CTDIvol = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("CTDIvol"));
            if (Attribute.getDelimitedStringValuesOrEmptyString(attributeList, new AttributeTag(28677, 16)).equals("TOSHIBA_MEC_CT3") && (attribute = attributeList.get(new AttributeTag(28677, 4160))) != null && attribute.getVL() > 0L) {
                double d5 = attribute.getSingleDoubleValueOrDefault(0.0);
                this.DLP = FloatFormatter.toString(d5, Locale.US);
            }
        }
    }
}

