/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.doseocr;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dose.CTDose;
import com.pixelmed.dose.CTIrradiationEventDataFromImages;
import com.pixelmed.dose.CommonDoseObserverContext;
import com.pixelmed.dose.DeviceParticipant;
import com.pixelmed.dose.DoseCompositeInstanceContext;
import com.pixelmed.doseocr.ExposureDoseSequence;
import com.pixelmed.doseocr.OCR;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

public class GenerateRadiationDoseStructuredReport {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/doseocr/GenerateRadiationDoseStructuredReport.java,v 1.29 2025/01/29 10:58:08 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(GenerateRadiationDoseStructuredReport.class);

    public static CTDose generateDoseReportInformationFromFiles(Vector vector) {
        CTDose cTDose;
        block6: {
            cTDose = null;
            CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages = new CTIrradiationEventDataFromImages(vector);
            ArrayList<String> arrayList = cTIrradiationEventDataFromImages.getDoseScreenFilenames();
            if (arrayList != null && !arrayList.isEmpty()) {
                try {
                    OCR oCR = new OCR(arrayList);
                    cTDose = OCR.getCTDoseFromOCROfDoseScreen(oCR, cTIrradiationEventDataFromImages, true);
                    if (cTDose != null) break block6;
                    for (String string : arrayList) {
                        try {
                            AttributeList attributeList = new AttributeList();
                            attributeList.read(string);
                            if (!ExposureDoseSequence.isPhilipsDoseScreenInstance(attributeList)) continue;
                            cTDose = ExposureDoseSequence.getCTDoseFromExposureDoseSequence(attributeList, cTIrradiationEventDataFromImages, true);
                            break;
                        }
                        catch (Exception exception) {
                            slf4jlogger.error("", exception);
                        }
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("", exception);
                }
            }
        }
        return cTDose;
    }

    public static void createContextForNewRadiationDoseStructuredReportFromExistingInstance(AttributeList attributeList, CTDose cTDose, CTIrradiationEventDataFromImages cTIrradiationEventDataFromImages) {
        if (attributeList != null) {
            Object object;
            cTDose.setSourceSOPInstanceUID(Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID));
            DoseCompositeInstanceContext doseCompositeInstanceContext = new DoseCompositeInstanceContext(attributeList);
            doseCompositeInstanceContext.removeSeries();
            doseCompositeInstanceContext.removeInstance();
            UIDGenerator uIDGenerator = new UIDGenerator();
            try {
                object = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
                ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
                doseCompositeInstanceContext.put((Attribute)object);
                object = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
                ((Attribute)object).addValue(uIDGenerator.getAnotherNewUID());
                doseCompositeInstanceContext.put((Attribute)object);
                object = new IntegerStringAttribute(TagFromName.SeriesNumber);
                ((Attribute)object).addValue("897");
                doseCompositeInstanceContext.put((Attribute)object);
                object = new IntegerStringAttribute(TagFromName.InstanceNumber);
                ((Attribute)object).addValue("1");
                doseCompositeInstanceContext.put((Attribute)object);
                object = new DateAttribute(TagFromName.SeriesDate);
                ((Attribute)object).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDate));
                doseCompositeInstanceContext.put((Attribute)object);
                object = new TimeAttribute(TagFromName.SeriesTime);
                ((Attribute)object).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesTime));
                doseCompositeInstanceContext.put((Attribute)object);
                object = new DateAttribute(TagFromName.ContentDate);
                ((Attribute)object).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ContentDate));
                doseCompositeInstanceContext.put((Attribute)object);
                object = new TimeAttribute(TagFromName.ContentTime);
                ((Attribute)object).addValue(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ContentTime));
                doseCompositeInstanceContext.put((Attribute)object);
                object = new LongStringAttribute(TagFromName.SeriesDescription);
                ((Attribute)object).addValue("Radiation Dose Information");
                doseCompositeInstanceContext.put((Attribute)object);
                object = new CodeStringAttribute(TagFromName.CompletionFlag);
                ((Attribute)object).addValue("COMPLETE");
                doseCompositeInstanceContext.put((Attribute)object);
                object = new CodeStringAttribute(TagFromName.VerificationFlag);
                ((Attribute)object).addValue("UNVERIFIED");
                doseCompositeInstanceContext.put((Attribute)object);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
            object = attributeList.get(TagFromName.ReferencedPerformedProcedureStepSequence);
            if (object == null) {
                object = new SequenceAttribute(TagFromName.ReferencedPerformedProcedureStepSequence);
            }
            doseCompositeInstanceContext.put((Attribute)object);
            object = attributeList.get(TagFromName.TimezoneOffsetFromUTC);
            if (object == null) {
                object = new SequenceAttribute(TagFromName.TimezoneOffsetFromUTC);
            }
            doseCompositeInstanceContext.put((Attribute)object);
            object = doseCompositeInstanceContext.getAttributeList().get(TagFromName.PerformedProcedureCodeSequence);
            if (object == null) {
                object = new SequenceAttribute(TagFromName.PerformedProcedureCodeSequence);
            }
            doseCompositeInstanceContext.put((Attribute)object);
            object = doseCompositeInstanceContext.getAttributeList();
            String string = DeviceParticipant.getDeviceSerialNumberOrSuitableAlternative((AttributeList)object, true);
            doseCompositeInstanceContext.updateFromSource(cTIrradiationEventDataFromImages);
            cTDose.setCompositeInstanceContext(doseCompositeInstanceContext);
            String string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PerformingPhysicianName);
            if (string2 == null) {
                string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhysiciansOfRecord);
            }
            if (string2 == null) {
                string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.NameOfPhysiciansReadingStudy);
            }
            String string3 = DeviceParticipant.getDeviceObserverUIDOrSuitableAlternative((AttributeList)object);
            CommonDoseObserverContext commonDoseObserverContext = new CommonDoseObserverContext(string3, Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StationName), Attribute.getSingleStringValueOrNull(attributeList, TagFromName.Manufacturer), Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ManufacturerModelName), string, "", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.OperatorsName), "", string2, "", "", Attribute.getSingleStringValueOrNull(attributeList, TagFromName.InstitutionName));
            cTDose.setObserverContext(commonDoseObserverContext);
        }
    }

    public static final void main(String[] stringArray) {
        try {
            String string = null;
            int n = stringArray.length;
            if (n > 1) {
                if ((string = stringArray[--n]).equals("-")) {
                    string = null;
                }
                if (new File(string).exists()) {
                    System.err.println("Error: RDSR output file " + string + " already exists - not overwriting");
                    System.exit(1);
                }
            }
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < n; ++i) {
                vector.add(stringArray[i]);
            }
            CTDose cTDose = GenerateRadiationDoseStructuredReport.generateDoseReportInformationFromFiles(vector);
            System.err.println(cTDose);
            if (string != null && cTDose != null) {
                cTDose.write(string, null, GenerateRadiationDoseStructuredReport.class.getCanonicalName());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

