/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.geometry;

import com.pixelmed.dicom.SpectroscopyVolumeLocalization;
import com.pixelmed.geometry.GeometryOfSlice;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public abstract class LocalizerPoster {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/geometry/LocalizerPoster.java,v 1.28 2025/01/29 10:58:08 dclunie Exp $";
    protected Vector3d localizerRow;
    protected Vector3d localizerColumn;
    protected Vector3d localizerNormal;
    protected Point3d localizerTLHC;
    protected Tuple3d localizerVoxelSpacing;
    protected double[] localizerVoxelSpacingArray;
    protected Tuple3d localizerDimensions;
    protected double[] localizerDimensionsArray;
    protected Matrix3d rotateIntoLocalizerSpace;
    private double[] tmpArray3 = new double[3];

    LocalizerPoster() {
    }

    public static void validateDirectionCosines(Vector3d vector3d, Vector3d vector3d2) throws IllegalArgumentException {
        if (Math.abs(vector3d.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Row not a unit vector");
        }
        if (Math.abs(vector3d2.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Column not a unit vector");
        }
        if (vector3d.dot(vector3d2) > 0.001) {
            throw new IllegalArgumentException("Row and column vectors are not orthogonal");
        }
    }

    public static void validateDirectionCosines(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) throws IllegalArgumentException {
        if (Math.abs(vector3d.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Row not a unit vector");
        }
        if (Math.abs(vector3d2.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Column not a unit vector");
        }
        if (Math.abs(vector3d3.lengthSquared() - 1.0) > 0.001) {
            throw new IllegalArgumentException("Normal not a unit vector");
        }
        if (vector3d.dot(vector3d2) > 0.001) {
            throw new IllegalArgumentException("Row and column vectors are not orthogonal = " + vector3d.dot(vector3d2));
        }
        if (vector3d.dot(vector3d3) > 0.001) {
            throw new IllegalArgumentException("Row and normal vectors are not orthogonal = " + vector3d.dot(vector3d3));
        }
        if (vector3d2.dot(vector3d3) > 0.001) {
            throw new IllegalArgumentException("Column and normal vectors are not orthogonal = " + vector3d2.dot(vector3d3));
        }
    }

    public static Point3d[] getCornersOfSourceRectangleInSourceSpace(GeometryOfSlice geometryOfSlice) {
        return LocalizerPoster.getCornersOfSourceRectangleInSourceSpace(geometryOfSlice.getRow(), geometryOfSlice.getColumn(), geometryOfSlice.getTLHC(), geometryOfSlice.getVoxelSpacing(), geometryOfSlice.getDimensions());
    }

    public static Point3d[] getCornersOfSourceRectangleInSourceSpace(Vector3d vector3d, Vector3d vector3d2, Point3d point3d, Tuple3d tuple3d, Tuple3d tuple3d2) {
        LocalizerPoster.validateDirectionCosines(vector3d, vector3d2);
        double[] dArray = new double[3];
        tuple3d.get(dArray);
        double[] dArray2 = new double[3];
        tuple3d2.get(dArray2);
        Vector3d vector3d3 = new Vector3d(vector3d);
        vector3d3.scale(dArray2[1] * dArray[1]);
        Vector3d vector3d4 = new Vector3d(vector3d2);
        vector3d4.scale(dArray2[0] * dArray[0]);
        Point3d point3d2 = new Point3d(point3d);
        Point3d point3d3 = new Point3d(point3d2);
        point3d3.add((Tuple3d)vector3d3);
        Point3d point3d4 = new Point3d(point3d2);
        point3d4.add((Tuple3d)vector3d4);
        Point3d point3d5 = new Point3d(point3d2);
        point3d5.add((Tuple3d)vector3d3);
        point3d5.add((Tuple3d)vector3d4);
        Point3d[] point3dArray = new Point3d[]{point3d2, point3d3, point3d5, point3d4};
        return point3dArray;
    }

    public static Point3d[] getCornersOfSourceCubeInSourceSpace(Vector3d vector3d, Vector3d vector3d2, Point3d point3d, Tuple3d tuple3d, double d, Tuple3d tuple3d2) {
        LocalizerPoster.validateDirectionCosines(vector3d, vector3d2);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        double[] dArray = new double[3];
        tuple3d.get(dArray);
        double[] dArray2 = new double[3];
        tuple3d2.get(dArray2);
        Vector3d vector3d4 = new Vector3d(vector3d);
        vector3d4.scale(dArray2[1] * dArray[1]);
        Vector3d vector3d5 = new Vector3d(vector3d2);
        vector3d5.scale(dArray2[0] * dArray[0]);
        Vector3d vector3d6 = new Vector3d(vector3d3);
        vector3d6.scale(dArray2[2] / 2.0 * d);
        Point3d point3d2 = new Point3d(point3d);
        point3d2.add((Tuple3d)vector3d6);
        Point3d point3d3 = new Point3d(point3d2);
        point3d3.add((Tuple3d)vector3d4);
        Point3d point3d4 = new Point3d(point3d2);
        point3d4.add((Tuple3d)vector3d5);
        Point3d point3d5 = new Point3d(point3d2);
        point3d5.add((Tuple3d)vector3d4);
        point3d5.add((Tuple3d)vector3d5);
        Point3d point3d6 = new Point3d(point3d);
        point3d6.sub((Tuple3d)vector3d6);
        Point3d point3d7 = new Point3d(point3d6);
        point3d7.add((Tuple3d)vector3d4);
        Point3d point3d8 = new Point3d(point3d6);
        point3d8.add((Tuple3d)vector3d5);
        Point3d point3d9 = new Point3d(point3d6);
        point3d9.add((Tuple3d)vector3d4);
        point3d9.add((Tuple3d)vector3d5);
        Point3d[] point3dArray = new Point3d[]{point3d2, point3d3, point3d5, point3d4, point3d6, point3d7, point3d9, point3d8};
        return point3dArray;
    }

    public static Point3d[] getIntersectionOfRectanglesInXYPlane(Point3d[] point3dArray, Point3d[] point3dArray2) {
        Point3d[] point3dArray3 = new Point3d[4];
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        point3dArray[0].get(dArray);
        point3dArray2[0].get(dArray2);
        double d = dArray[0] > dArray2[0] ? dArray[0] : dArray2[0];
        double d2 = dArray[1] > dArray2[1] ? dArray[1] : dArray2[1];
        point3dArray3[0] = new Point3d(d, d2, 0.0);
        point3dArray[1].get(dArray);
        point3dArray2[1].get(dArray2);
        d = dArray[0] < dArray2[0] ? dArray[0] : dArray2[0];
        d2 = dArray[1] > dArray2[1] ? dArray[1] : dArray2[1];
        point3dArray3[1] = new Point3d(d, d2, 0.0);
        point3dArray[2].get(dArray);
        point3dArray2[2].get(dArray2);
        d = dArray[0] < dArray2[0] ? dArray[0] : dArray2[0];
        d2 = dArray[1] < dArray2[1] ? dArray[1] : dArray2[1];
        point3dArray3[2] = new Point3d(d, d2, 0.0);
        point3dArray[3].get(dArray);
        point3dArray2[3].get(dArray2);
        d = dArray[0] > dArray2[0] ? dArray[0] : dArray2[0];
        d2 = dArray[1] < dArray2[1] ? dArray[1] : dArray2[1];
        point3dArray3[3] = new Point3d(d, d2, 0.0);
        return point3dArray3;
    }

    public static Rectangle getBoundsOfContainedRectangle(Point3d[] point3dArray, Point3d[] point3dArray2, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle();
        double[] dArray = new double[3];
        point3dArray2[0].get(dArray);
        double[] dArray2 = new double[3];
        point3dArray2[2].get(dArray2);
        double d = dArray2[1] - dArray[1];
        double d2 = dArray2[0] - dArray[0];
        double[] dArray3 = new double[3];
        point3dArray[0].get(dArray3);
        double[] dArray4 = new double[3];
        point3dArray[2].get(dArray4);
        double d3 = dArray4[1] - dArray3[1];
        double d4 = dArray4[0] - dArray3[0];
        rectangle2.height = (int)(d3 / d * (double)rectangle.height);
        rectangle2.width = (int)(d4 / d2 * (double)rectangle.width);
        rectangle2.x = (int)((dArray3[0] - dArray[0]) / d * (double)rectangle.width);
        rectangle2.y = (int)((dArray3[1] - dArray[1]) / d2 * (double)rectangle.height);
        return rectangle2;
    }

    public static Point3d[] transformPointsFromSourceSpaceIntoSpecifiedSpace(Point3d[] point3dArray, Point3d point3d, Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        vector3d3.normalize();
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.setRow(0, vector3d);
        matrix3d.setRow(1, vector3d2);
        matrix3d.setRow(2, vector3d3);
        Point3d[] point3dArray2 = new Point3d[point3dArray.length];
        for (int i = 0; i < point3dArray.length; ++i) {
            Point3d point3d2 = new Point3d(point3dArray[i]);
            point3d2.sub((Tuple3d)point3d);
            matrix3d.transform((Tuple3d)point3d2);
            point3dArray2[i] = point3d2;
        }
        return point3dArray2;
    }

    public static Point3d transformPointFromSourceSpaceIntoSpecifiedSpace(Point3d point3d, Point3d point3d2, Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        vector3d3.normalize();
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.setRow(0, vector3d);
        matrix3d.setRow(1, vector3d2);
        matrix3d.setRow(2, vector3d3);
        Point3d point3d3 = new Point3d(point3d);
        point3d3.sub((Tuple3d)point3d2);
        matrix3d.transform((Tuple3d)point3d3);
        return point3d3;
    }

    protected Point3d transformPointFromSourceSpaceIntoLocalizerSpace(Point3d point3d) {
        Point3d point3d2 = new Point3d(point3d);
        point3d2.sub((Tuple3d)this.localizerTLHC);
        this.rotateIntoLocalizerSpace.transform((Tuple3d)point3d2);
        return point3d2;
    }

    protected Point2D.Double transformPointInLocalizerPlaneIntoImageSpace(Point3d point3d) {
        point3d.get(this.tmpArray3);
        double d = (this.localizerDimensionsArray[0] - 1.0) / this.localizerDimensionsArray[0];
        double d2 = (this.localizerDimensionsArray[1] - 1.0) / this.localizerDimensionsArray[1];
        Point2D.Double double_ = new Point2D.Double(this.tmpArray3[0] / this.localizerVoxelSpacingArray[1] * d + 0.5, this.tmpArray3[1] / this.localizerVoxelSpacingArray[0] * d2 + 0.5);
        return double_;
    }

    protected Vector drawOutlineOnLocalizer(Vector vector) {
        Vector vector2 = null;
        if (vector != null && vector.size() > 0) {
            Point3d[] point3dArray = new Point3d[vector.size()];
            vector2 = this.drawOutlineOnLocalizer(vector.toArray(point3dArray));
        }
        return vector2;
    }

    protected Vector drawOutlineOnLocalizer(Point3d[] point3dArray) {
        Vector<Line2D.Double> vector = new Vector<Line2D.Double>();
        Point2D.Double double_ = null;
        Point2D.Double double_2 = null;
        Point2D.Double double_3 = null;
        for (int i = 0; i < point3dArray.length; ++i) {
            double_2 = double_3;
            double_3 = this.transformPointInLocalizerPlaneIntoImageSpace(point3dArray[i]);
            if (i == 0) {
                double_ = double_3;
                continue;
            }
            vector.add(new Line2D.Double(double_2, double_3));
        }
        vector.add(new Line2D.Double(double_3, double_));
        return vector;
    }

    protected Point3d intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        dArray3[1] = dArray2[2] == dArray[2] ? dArray[1] : (dArray2[1] - dArray[1]) / (dArray2[2] - dArray[2]) * (0.0 - dArray[2]) + dArray[1];
        dArray3[0] = dArray2[1] == dArray[1] ? dArray[0] : (dArray2[0] - dArray[0]) / (dArray2[1] - dArray[1]) * (dArray3[1] - dArray[1]) + dArray[0];
        dArray3[2] = 0.0;
        return new Point3d(dArray3);
    }

    protected Point3d intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(Point3d point3d, Point3d point3d2) {
        double[] dArray = new double[3];
        point3d.get(dArray);
        double[] dArray2 = new double[3];
        point3d2.get(dArray2);
        return this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(dArray, dArray2);
    }

    protected Vector drawLinesBetweenAnyPointsWhichIntersectPlaneWhereZIsZero(Point3d[] point3dArray) {
        int n = point3dArray.length;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        Vector<Point3d> vector = new Vector<Point3d>();
        for (int i = 0; i < n; ++i) {
            int n2 = i == n - 1 ? 0 : i + 1;
            point3dArray[i].get(dArray);
            double d = dArray[2];
            point3dArray[n2].get(dArray2);
            double d2 = dArray2[2];
            if (!(d <= 0.0 && d2 >= 0.0) && (!(d >= 0.0) || !(d2 <= 0.0))) continue;
            Point3d point3d = this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(dArray, dArray2);
            vector.add(point3d);
        }
        return vector.size() > 0 ? this.drawOutlineOnLocalizer(vector) : null;
    }

    protected static boolean classifyCornersIntoEdgeCrossingZPlane(Point3d point3d, Point3d point3d2) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        boolean bl = false;
        point3d.get(dArray);
        double d = dArray[2];
        point3d2.get(dArray2);
        double d2 = dArray2[2];
        bl = d <= 0.0 && d2 >= 0.0 || d >= 0.0 && d2 <= 0.0;
        return bl;
    }

    protected Vector getIntersectionsOfCubeWithZPlane(Point3d[] point3dArray) {
        Vector<Point3d> vector = new Vector<Point3d>();
        if (LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[0], point3dArray[1]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[2], point3dArray[3]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[4], point3dArray[5]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[6], point3dArray[7])) {
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[0], point3dArray[1]));
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[2], point3dArray[3]));
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[6], point3dArray[7]));
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[4], point3dArray[5]));
        } else if (LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[0], point3dArray[3]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[1], point3dArray[2]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[4], point3dArray[7]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[5], point3dArray[6])) {
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[0], point3dArray[3]));
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[1], point3dArray[2]));
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[5], point3dArray[6]));
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[4], point3dArray[7]));
        } else if (LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[0], point3dArray[4]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[1], point3dArray[5]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[2], point3dArray[6]) && LocalizerPoster.classifyCornersIntoEdgeCrossingZPlane(point3dArray[3], point3dArray[7])) {
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[0], point3dArray[4]));
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[1], point3dArray[5]));
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[2], point3dArray[6]));
            vector.add(this.intersectLineBetweenTwoPointsWithPlaneWhereZIsZero(point3dArray[3], point3dArray[7]));
        }
        return vector;
    }

    protected void doCommonConstructorStuff() {
        LocalizerPoster.validateDirectionCosines(this.localizerRow, this.localizerColumn);
        this.localizerNormal = new Vector3d();
        this.localizerNormal.cross(this.localizerRow, this.localizerColumn);
        this.localizerVoxelSpacingArray = new double[3];
        this.localizerVoxelSpacing.get(this.localizerVoxelSpacingArray);
        this.localizerDimensionsArray = new double[3];
        this.localizerDimensions.get(this.localizerDimensionsArray);
        this.rotateIntoLocalizerSpace = new Matrix3d();
        this.rotateIntoLocalizerSpace.setRow(0, this.localizerRow);
        this.rotateIntoLocalizerSpace.setRow(1, this.localizerColumn);
        this.rotateIntoLocalizerSpace.setRow(2, this.localizerNormal);
    }

    public void setLocalizerGeometry(Vector3d vector3d, Vector3d vector3d2, Point3d point3d, Tuple3d tuple3d, Tuple3d tuple3d2) {
        this.localizerRow = vector3d;
        this.localizerColumn = vector3d2;
        this.localizerTLHC = point3d;
        this.localizerVoxelSpacing = tuple3d;
        this.localizerDimensions = tuple3d2;
        this.doCommonConstructorStuff();
    }

    public void setLocalizerGeometry(GeometryOfSlice geometryOfSlice) {
        this.localizerRow = geometryOfSlice.getRow();
        this.localizerColumn = geometryOfSlice.getColumn();
        this.localizerTLHC = geometryOfSlice.getTLHC();
        this.localizerVoxelSpacing = geometryOfSlice.getVoxelSpacing();
        this.localizerDimensions = geometryOfSlice.getDimensions();
        this.doCommonConstructorStuff();
    }

    public abstract Vector getOutlineOnLocalizerForThisGeometry(Vector3d var1, Vector3d var2, Point3d var3, Tuple3d var4, double var5, Tuple3d var7);

    public final Vector getOutlineOnLocalizerForThisGeometry(GeometryOfSlice geometryOfSlice) {
        return this.getOutlineOnLocalizerForThisGeometry(geometryOfSlice.getRow(), geometryOfSlice.getColumn(), geometryOfSlice.getTLHC(), geometryOfSlice.getVoxelSpacing(), geometryOfSlice.getSliceThickness(), geometryOfSlice.getDimensions());
    }

    private static Vector3d[] getOrthogonalVectors(double d, double d2, double d3) {
        Vector3d vector3d = new Vector3d(d, d2, d3);
        vector3d.normalize();
        Vector3d vector3d2 = Math.abs(d) > 0.0 || Math.abs(d2) > 0.0 ? new Vector3d(-d2, d, 0.0) : new Vector3d(0.0, -d3, d2);
        vector3d2.normalize();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        LocalizerPoster.validateDirectionCosines(vector3d2, vector3d3, vector3d);
        Vector3d[] vector3dArray = new Vector3d[]{vector3d2, vector3d3, vector3d};
        return vector3dArray;
    }

    public final Vector getOutlineOnLocalizerForThisVolumeLocalization(SpectroscopyVolumeLocalization spectroscopyVolumeLocalization) {
        Vector vector = new Vector();
        if (spectroscopyVolumeLocalization != null) {
            int n = spectroscopyVolumeLocalization.getNumberOfSlabs();
            for (int i = 0; i < n; ++i) {
                double d = spectroscopyVolumeLocalization.getSlabThickness(i);
                double[] dArray = spectroscopyVolumeLocalization.getSlabOrientation(i);
                double[] dArray2 = spectroscopyVolumeLocalization.getMidSlabPosition(i);
                Vector3d[] vector3dArray = LocalizerPoster.getOrthogonalVectors(dArray[0], dArray[1], dArray[2]);
                Vector3d vector3d = vector3dArray[0];
                Vector3d vector3d2 = vector3dArray[1];
                Vector3d vector3d3 = new Vector3d(1.0, 1.0, 0.0);
                Vector3d vector3d4 = new Vector3d(100000.0, 100000.0, 1.0);
                Point3d point3d = new Point3d(dArray2);
                Point3d point3d2 = new Point3d(point3d);
                Vector3d vector3d5 = new Vector3d(vector3d);
                vector3d5.scale(50000.0);
                Vector3d vector3d6 = new Vector3d(vector3d2);
                vector3d6.scale(50000.0);
                point3d2.sub((Tuple3d)vector3d5);
                point3d2.sub((Tuple3d)vector3d6);
                Point3d[] point3dArray = LocalizerPoster.getCornersOfSourceCubeInSourceSpace(vector3d, vector3d2, point3d2, (Tuple3d)vector3d3, d, (Tuple3d)vector3d4);
                for (int j = 0; j < 8; ++j) {
                    point3dArray[j] = this.transformPointFromSourceSpaceIntoLocalizerSpace(point3dArray[j]);
                }
                vector.addAll(this.getIntersectionsOfCubeWithZPlane(point3dArray));
            }
        }
        return vector.size() > 0 ? this.drawOutlineOnLocalizer(vector) : null;
    }
}

